/*
 * Decompiled with CFR 0.152.
 */
package zombie.world.logger;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import zombie.world.ItemInfo;

public class Log {

    public static class ModIDChangedItem
    extends BaseItemLog {
        protected final String oldModID;
        protected final String newModID;

        public ModIDChangedItem(ItemInfo itemInfo, String string, String string2) {
            super(itemInfo);
            this.oldModID = string;
            this.newModID = string2;
        }

        @Override
        public void saveAsText(FileWriter fileWriter, String string) throws IOException {
            fileWriter.write(string + "{ type = \"modchange_item\", oldModID = \"" + this.oldModID + "\", " + this.getItemString() + " }" + System.lineSeparator());
        }
    }

    public static class RemovedItem
    extends BaseItemLog {
        protected final boolean isScriptMissing;

        public RemovedItem(ItemInfo itemInfo, boolean bl) {
            super(itemInfo);
            this.isScriptMissing = bl;
        }

        @Override
        public void saveAsText(FileWriter fileWriter, String string) throws IOException {
            fileWriter.write(string + "{ type = \"removed_item\", scriptMissing = " + this.isScriptMissing + ", " + this.getItemString() + " }" + System.lineSeparator());
        }
    }

    public static class ObsoleteItem
    extends BaseItemLog {
        public ObsoleteItem(ItemInfo itemInfo) {
            super(itemInfo);
        }

        @Override
        public void saveAsText(FileWriter fileWriter, String string) throws IOException {
            fileWriter.write(string + "{ type = \"obsolete_item\", " + this.getItemString() + " }" + System.lineSeparator());
        }
    }

    public static class ReinstateItem
    extends BaseItemLog {
        public ReinstateItem(ItemInfo itemInfo) {
            super(itemInfo);
        }

        @Override
        public void saveAsText(FileWriter fileWriter, String string) throws IOException {
            fileWriter.write(string + "{ type = \"reinstate_item\", " + this.getItemString() + " }" + System.lineSeparator());
        }
    }

    public static class RegisterItem
    extends BaseItemLog {
        public RegisterItem(ItemInfo itemInfo) {
            super(itemInfo);
        }

        @Override
        public void saveAsText(FileWriter fileWriter, String string) throws IOException {
            fileWriter.write(string + "{ type = \"reg_item\", " + this.getItemString() + " }" + System.lineSeparator());
        }
    }

    public static abstract class BaseItemLog
    extends BaseLog {
        protected final ItemInfo itemInfo;

        public BaseItemLog(ItemInfo itemInfo) {
            this.itemInfo = itemInfo;
        }

        @Override
        abstract void saveAsText(FileWriter var1, String var2) throws IOException;

        protected String getItemString() {
            return "fulltype = \"" + this.itemInfo.getFullType() + "\", registeryID = " + this.itemInfo.getRegistryID() + ", existsVanilla = " + this.itemInfo.isExistsAsVanilla() + ", isModded = " + this.itemInfo.isModded() + ", modID = \"" + this.itemInfo.getModID() + "\", obsolete = " + this.itemInfo.isObsolete() + ", removed = " + this.itemInfo.isRemoved() + ", isLoaded = " + this.itemInfo.isLoaded();
        }
    }

    public static class RegisterObject
    extends BaseLog {
        protected final String objectName;
        protected final int ID;

        public RegisterObject(String string, int n) {
            this.objectName = string;
            this.ID = n;
        }

        @Override
        public void saveAsText(FileWriter fileWriter, String string) throws IOException {
            fileWriter.write(string + "{ type = \"reg_obj\", id = " + this.ID + ", obj = \"" + this.objectName + "\" }" + System.lineSeparator());
        }
    }

    public static class Comment
    extends BaseLog {
        protected String txt;

        public Comment(String string) {
            this.ignoreSaveCheck = true;
            this.txt = string;
        }

        @Override
        public void saveAsText(FileWriter fileWriter, String string) throws IOException {
            fileWriter.write(string + "-- " + this.txt + System.lineSeparator());
        }
    }

    public static class Info
    extends BaseLog {
        protected final List<String> mods;
        protected final String timeStamp;
        protected final String saveWorld;
        protected final int worldVersion;
        public boolean HasErrored = false;

        public Info(String string, String string2, int n, List<String> list) {
            this.ignoreSaveCheck = true;
            this.timeStamp = string;
            this.saveWorld = string2;
            this.worldVersion = n;
            this.mods = list;
        }

        @Override
        public void saveAsText(FileWriter fileWriter, String string) throws IOException {
            fileWriter.write(string + "{" + System.lineSeparator());
            fileWriter.write(string + "\ttype = \"info\"," + System.lineSeparator());
            fileWriter.write(string + "\ttimeStamp = \"" + this.timeStamp + "\"," + System.lineSeparator());
            fileWriter.write(string + "\tsaveWorld = \"" + this.saveWorld + "\"," + System.lineSeparator());
            fileWriter.write(string + "\tworldVersion = " + this.worldVersion + "," + System.lineSeparator());
            fileWriter.write(string + "\thasErrored = " + this.HasErrored + "," + System.lineSeparator());
            fileWriter.write(string + "\titemMods = {" + System.lineSeparator());
            for (int i = 0; i < this.mods.size(); ++i) {
                fileWriter.write(string + "\t\t\"" + this.mods.get(i) + "\"," + System.lineSeparator());
            }
            fileWriter.write(string + "\t}," + System.lineSeparator());
            fileWriter.write(string + "}," + System.lineSeparator());
        }
    }

    public static abstract class BaseLog {
        protected boolean ignoreSaveCheck = false;

        public boolean isIgnoreSaveCheck() {
            return this.ignoreSaveCheck;
        }

        abstract void saveAsText(FileWriter var1, String var2) throws IOException;
    }
}

