/*
 * Decompiled with CFR 0.152.
 */
package zombie.world;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import zombie.GameWindow;
import zombie.core.Core;
import zombie.debug.DebugLog;
import zombie.erosion.ErosionRegions;
import zombie.erosion.categories.ErosionCategory;
import zombie.gameStates.ChooseGameInfo;
import zombie.inventory.InventoryItem;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.scripting.objects.Item;
import zombie.world.DictionaryData;
import zombie.world.DictionaryDataClient;
import zombie.world.ItemInfo;
import zombie.world.WorldDictionaryException;
import zombie.world.logger.Log;
import zombie.world.logger.WorldDictionaryLogger;

public class WorldDictionary {
    public static final String SAVE_FILE_READABLE = "WorldDictionaryReadable.lua";
    public static final String SAVE_FILE_LOG = "WorldDictionaryLog.lua";
    public static final String SAVE_FILE = "WorldDictionary";
    public static final String SAVE_EXT = ".bin";
    public static final boolean logUnset = false;
    public static final boolean logMissingObjectID = false;
    private static final Map<String, ItemInfo> itemLoadList = new HashMap<String, ItemInfo>();
    private static final List<String> objNameLoadList = new ArrayList<String>();
    private static DictionaryData data;
    private static boolean isNewGame;
    private static boolean allowScriptItemLoading;
    private static final String netValidator = "DICTIONARY_PACKET_END";
    private static byte[] clientRemoteData;

    protected static void log(String string) {
        WorldDictionary.log(string, true);
    }

    protected static void log(String string, boolean bl) {
        if (bl) {
            DebugLog.log("WorldDictionary: " + string);
        }
    }

    public static void setIsNewGame(boolean bl) {
        isNewGame = bl;
    }

    public static boolean isIsNewGame() {
        return isNewGame;
    }

    public static void StartScriptLoading() {
        allowScriptItemLoading = true;
        itemLoadList.clear();
    }

    public static void ScriptsLoaded() {
        allowScriptItemLoading = false;
    }

    public static void onLoadItem(Item item) {
        ItemInfo itemInfo;
        if (GameClient.bClient) {
            return;
        }
        if (!allowScriptItemLoading) {
            WorldDictionary.log("Warning script item loaded after WorldDictionary is initialised");
            if (Core.bDebug) {
                throw new RuntimeException("This shouldn't be happening.");
            }
        }
        if ((itemInfo = itemLoadList.get(item.getFullName())) == null) {
            itemInfo = new ItemInfo();
            itemInfo.itemName = item.getName();
            itemInfo.moduleName = item.getModuleName();
            itemInfo.fullType = item.getFullName();
            itemLoadList.put(item.getFullName(), itemInfo);
        }
        if (itemInfo.modID != null && !item.getModID().equals(itemInfo.modID)) {
            if (itemInfo.modOverrides == null) {
                itemInfo.modOverrides = new ArrayList<String>();
            }
            if (!itemInfo.modOverrides.contains(itemInfo.modID)) {
                itemInfo.modOverrides.add(itemInfo.modID);
            } else {
                WorldDictionary.log("modOverrides for item '" + itemInfo.fullType + "' already contains mod id: " + itemInfo.modID);
            }
        }
        itemInfo.modID = item.getModID();
        if (itemInfo.modID.equals("pz-vanilla")) {
            itemInfo.existsAsVanilla = true;
        }
        itemInfo.isModded = !itemInfo.modID.equals("pz-vanilla");
        itemInfo.obsolete = item.getObsolete();
        itemInfo.scriptItem = item;
    }

    private static void collectObjectNames() {
        objNameLoadList.clear();
        if (GameClient.bClient) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < ErosionRegions.regions.size(); ++i) {
            for (int j = 0; j < ErosionRegions.regions.get((int)i).categories.size(); ++j) {
                ErosionCategory erosionCategory = ErosionRegions.regions.get((int)i).categories.get(j);
                arrayList.clear();
                erosionCategory.getObjectNames(arrayList);
                for (String string : arrayList) {
                    if (objNameLoadList.contains(string)) continue;
                    objNameLoadList.add(string);
                }
            }
        }
    }

    public static void loadDataFromServer(ByteBuffer byteBuffer) throws IOException {
        if (GameClient.bClient) {
            int n = byteBuffer.getInt();
            clientRemoteData = new byte[n];
            byteBuffer.get(clientRemoteData, 0, clientRemoteData.length);
        }
    }

    public static void saveDataForClient(ByteBuffer byteBuffer) throws IOException {
        if (GameServer.bServer) {
            int n = byteBuffer.position();
            byteBuffer.putInt(0);
            int n2 = byteBuffer.position();
            if (WorldDictionary.data.serverDataCache != null) {
                byteBuffer.put(WorldDictionary.data.serverDataCache);
            } else {
                if (Core.bDebug) {
                    throw new RuntimeException("Should be sending data from the serverDataCache here.");
                }
                data.saveToByteBuffer(byteBuffer);
            }
            GameWindow.WriteString(byteBuffer, netValidator);
            int n3 = byteBuffer.position();
            byteBuffer.position(n);
            byteBuffer.putInt(n3 - n2);
            byteBuffer.position(n3);
        }
    }

    public static void init() throws WorldDictionaryException {
        boolean bl;
        block13: {
            bl = true;
            WorldDictionary.collectObjectNames();
            WorldDictionaryLogger.startLogging();
            WorldDictionaryLogger.log("-------------------------------------------------------", false);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            WorldDictionaryLogger.log("Time: " + simpleDateFormat.format(new Date()), false);
            WorldDictionary.log("Checking dictionary...");
            Log.Info info = null;
            try {
                Object object;
                if (!GameClient.bClient) {
                    if (data == null || data.isClient()) {
                        data = new DictionaryData();
                    }
                } else if (data == null || !data.isClient()) {
                    data = new DictionaryDataClient();
                }
                data.reset();
                if (GameClient.bClient) {
                    if (clientRemoteData == null) {
                        throw new WorldDictionaryException("WorldDictionary data not received from server.");
                    }
                    object = ByteBuffer.wrap(clientRemoteData);
                    data.loadFromByteBuffer((ByteBuffer)object);
                    String string = GameWindow.ReadString((ByteBuffer)object);
                    if (!string.equals(netValidator)) {
                        throw new WorldDictionaryException("WorldDictionary data received from server is corrupt.");
                    }
                    clientRemoteData = null;
                }
                data.backupCurrentDataSet();
                data.load();
                object = new ArrayList();
                info = new Log.Info(simpleDateFormat.format(new Date()), Core.GameSaveWorld, 195, (List<String>)object);
                WorldDictionaryLogger.log(info);
                data.parseItemLoadList(itemLoadList);
                data.parseCurrentItemSet();
                itemLoadList.clear();
                data.parseObjectNameLoadList(objNameLoadList);
                objNameLoadList.clear();
                data.getItemMods((List<String>)object);
                data.saveAsText(SAVE_FILE_READABLE);
                data.save();
                data.deleteBackupCurrentDataSet();
            }
            catch (Exception exception) {
                bl = false;
                exception.printStackTrace();
                WorldDictionary.log("Warning: error occurred loading dictionary!");
                if (info != null) {
                    info.HasErrored = true;
                }
                if (data == null) break block13;
                data.createErrorBackups();
            }
        }
        try {
            WorldDictionaryLogger.saveLog(SAVE_FILE_LOG);
            WorldDictionaryLogger.reset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl) {
            throw new WorldDictionaryException("WorldDictionary: Cannot load world due to WorldDictionary error.");
        }
    }

    public static void onWorldLoaded() {
    }

    public static ItemInfo getItemInfoFromType(String string) {
        return data.getItemInfoFromType(string);
    }

    public static ItemInfo getItemInfoFromID(short s) {
        return data.getItemInfoFromID(s);
    }

    public static short getItemRegistryID(String string) {
        return data.getItemRegistryID(string);
    }

    public static String getItemTypeFromID(short s) {
        return data.getItemTypeFromID(s);
    }

    public static String getItemTypeDebugString(short s) {
        return data.getItemTypeDebugString(s);
    }

    public static String getSpriteNameFromID(int n) {
        return data.getSpriteNameFromID(n);
    }

    public static int getIdForSpriteName(String string) {
        return data.getIdForSpriteName(string);
    }

    public static String getObjectNameFromID(byte by) {
        return data.getObjectNameFromID(by);
    }

    public static byte getIdForObjectName(String string) {
        return data.getIdForObjectName(string);
    }

    public static String getItemModID(short s) {
        ItemInfo itemInfo = WorldDictionary.getItemInfoFromID(s);
        if (itemInfo != null) {
            return itemInfo.modID;
        }
        return null;
    }

    public static String getItemModID(String string) {
        ItemInfo itemInfo = WorldDictionary.getItemInfoFromType(string);
        if (itemInfo != null) {
            return itemInfo.modID;
        }
        return null;
    }

    public static String getModNameFromID(String string) {
        if (string != null) {
            if (string.equals("pz-vanilla")) {
                return "Project Zomboid";
            }
            ChooseGameInfo.Mod mod = ChooseGameInfo.getModDetails(string);
            if (mod != null && mod.getName() != null) {
                return mod.getName();
            }
        }
        return "Unknown mod";
    }

    public static void DebugPrintItem(InventoryItem inventoryItem) {
        Item item = inventoryItem.getScriptItem();
        if (item != null) {
            WorldDictionary.DebugPrintItem(item);
        } else {
            String string = inventoryItem.getFullType();
            ItemInfo itemInfo = null;
            if (string != null) {
                itemInfo = WorldDictionary.getItemInfoFromType(string);
            }
            if (itemInfo == null && inventoryItem.getRegistry_id() >= 0) {
                itemInfo = WorldDictionary.getItemInfoFromID(inventoryItem.getRegistry_id());
            }
            if (itemInfo != null) {
                itemInfo.DebugPrint();
            } else {
                DebugLog.log("WorldDictionary: Cannot debug print item: " + (string != null ? string : "unknown"));
            }
        }
    }

    public static void DebugPrintItem(Item item) {
        String string = item.getFullName();
        ItemInfo itemInfo = null;
        if (string != null) {
            itemInfo = WorldDictionary.getItemInfoFromType(string);
        }
        if (itemInfo == null && item.getRegistry_id() >= 0) {
            itemInfo = WorldDictionary.getItemInfoFromID(item.getRegistry_id());
        }
        if (itemInfo != null) {
            itemInfo.DebugPrint();
        } else {
            DebugLog.log("WorldDictionary: Cannot debug print item: " + (string != null ? string : "unknown"));
        }
    }

    public static void DebugPrintItem(String string) {
        ItemInfo itemInfo = WorldDictionary.getItemInfoFromType(string);
        if (itemInfo != null) {
            itemInfo.DebugPrint();
        } else {
            DebugLog.log("WorldDictionary: Cannot debug print item: " + string);
        }
    }

    public static void DebugPrintItem(short s) {
        ItemInfo itemInfo = WorldDictionary.getItemInfoFromID(s);
        if (itemInfo != null) {
            itemInfo.DebugPrint();
        } else {
            DebugLog.log("WorldDictionary: Cannot debug print item id: " + s);
        }
    }

    static {
        isNewGame = true;
        allowScriptItemLoading = false;
    }
}

