/*
 * Decompiled with CFR 0.152.
 */
package zombie.world;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import zombie.scripting.ScriptManager;
import zombie.world.DictionaryData;
import zombie.world.ItemInfo;
import zombie.world.WorldDictionaryException;

public class DictionaryDataClient
extends DictionaryData {
    @Override
    protected boolean isClient() {
        return true;
    }

    @Override
    protected void parseItemLoadList(Map<String, ItemInfo> map) throws WorldDictionaryException {
    }

    @Override
    protected void parseCurrentItemSet() throws WorldDictionaryException {
        for (Map.Entry entry : this.itemTypeToInfoMap.entrySet()) {
            ItemInfo itemInfo = (ItemInfo)entry.getValue();
            if (!itemInfo.removed && itemInfo.scriptItem == null) {
                itemInfo.scriptItem = ScriptManager.instance.getSpecificItem(itemInfo.fullType);
            }
            if (itemInfo.scriptItem != null) {
                itemInfo.scriptItem.setRegistry_id(itemInfo.registryID);
                itemInfo.scriptItem.setModID(itemInfo.modID);
                itemInfo.isLoaded = true;
                continue;
            }
            if (itemInfo.removed) continue;
            throw new WorldDictionaryException("Warning client has no script for item " + itemInfo.fullType);
        }
    }

    @Override
    protected void parseObjectNameLoadList(List<String> list) throws WorldDictionaryException {
    }

    @Override
    protected void backupCurrentDataSet() throws IOException {
    }

    @Override
    protected void deleteBackupCurrentDataSet() throws IOException {
    }

    @Override
    protected void createErrorBackups() {
    }

    @Override
    protected void load() throws IOException, WorldDictionaryException {
    }

    @Override
    protected void save() throws IOException, WorldDictionaryException {
    }

    @Override
    protected void saveToByteBuffer(ByteBuffer byteBuffer) throws IOException {
    }
}

