/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import se.krka.kahlua.j2se.KahluaTableImpl;
import zombie.Lua.LuaManager;
import zombie.core.Rand;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.VehicleScript;
import zombie.util.list.PZArrayUtil;

public final class VehicleType {
    public final ArrayList<VehicleTypeDefinition> vehiclesDefinition = new ArrayList();
    public int chanceToSpawnNormal = 80;
    public int chanceToSpawnBurnt = 0;
    public int spawnRate = 16;
    public int chanceOfOverCar = 0;
    public boolean randomAngle = false;
    public float baseVehicleQuality = 1.0f;
    public String name = "";
    private int chanceToSpawnKey = 70;
    public int chanceToPartDamage = 0;
    public boolean isSpecialCar = false;
    public boolean isBurntCar = false;
    public int chanceToSpawnSpecial = 5;
    public static final HashMap<String, VehicleType> vehicles = new HashMap();
    public static final ArrayList<VehicleType> specialVehicles = new ArrayList();

    public VehicleType(String string) {
        this.name = string;
    }

    public static void init() {
        VehicleType.initNormal();
        VehicleType.validate(vehicles.values());
        VehicleType.validate(specialVehicles);
    }

    private static void validate(Collection<VehicleType> collection) {
    }

    private static void initNormal() {
        boolean bl = DebugLog.isEnabled(DebugType.Lua);
        KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)LuaManager.env.rawget("VehicleZoneDistribution");
        for (Map.Entry<Object, Object> iterator : kahluaTableImpl.delegate.entrySet()) {
            int n;
            String string = iterator.getKey().toString();
            VehicleType vehicleType = new VehicleType(string);
            ArrayList<VehicleTypeDefinition> arrayList = vehicleType.vehiclesDefinition;
            KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)iterator.getValue();
            KahluaTableImpl kahluaTableImpl3 = (KahluaTableImpl)kahluaTableImpl2.rawget("vehicles");
            for (Map.Entry<Object, Object> entry : kahluaTableImpl3.delegate.entrySet()) {
                String string2 = entry.getKey().toString();
                VehicleScript vehicleScript = ScriptManager.instance.getVehicle(string2);
                if (vehicleScript == null) {
                    DebugLog.General.warn("vehicle type \"" + string2 + "\" doesn't exist");
                }
                KahluaTableImpl kahluaTableImpl4 = (KahluaTableImpl)entry.getValue();
                arrayList.add(new VehicleTypeDefinition(string2, kahluaTableImpl4.rawgetInt("index"), kahluaTableImpl4.rawgetFloat("spawnChance")));
            }
            float f = 0.0f;
            for (n = 0; n < arrayList.size(); ++n) {
                f += arrayList.get((int)n).spawnChance;
            }
            f = 100.0f / f;
            if (bl) {
                DebugLog.Lua.println("Vehicle spawn rate:");
            }
            for (n = 0; n < arrayList.size(); ++n) {
                arrayList.get((int)n).spawnChance *= f;
                if (!bl) continue;
                DebugLog.Lua.println(string + ": " + arrayList.get((int)n).vehicleType + " " + arrayList.get((int)n).spawnChance + "%");
            }
            if (kahluaTableImpl2.delegate.containsKey("chanceToPartDamage")) {
                vehicleType.chanceToPartDamage = kahluaTableImpl2.rawgetInt("chanceToPartDamage");
            }
            if (kahluaTableImpl2.delegate.containsKey("chanceToSpawnNormal")) {
                vehicleType.chanceToSpawnNormal = kahluaTableImpl2.rawgetInt("chanceToSpawnNormal");
            }
            if (kahluaTableImpl2.delegate.containsKey("chanceToSpawnSpecial")) {
                vehicleType.chanceToSpawnSpecial = kahluaTableImpl2.rawgetInt("chanceToSpawnSpecial");
            }
            if (kahluaTableImpl2.delegate.containsKey("specialCar")) {
                vehicleType.isSpecialCar = kahluaTableImpl2.rawgetBool("specialCar");
            }
            if (kahluaTableImpl2.delegate.containsKey("burntCar")) {
                vehicleType.isBurntCar = kahluaTableImpl2.rawgetBool("burntCar");
            }
            if (kahluaTableImpl2.delegate.containsKey("baseVehicleQuality")) {
                vehicleType.baseVehicleQuality = kahluaTableImpl2.rawgetFloat("baseVehicleQuality");
            }
            if (kahluaTableImpl2.delegate.containsKey("chanceOfOverCar")) {
                vehicleType.chanceOfOverCar = kahluaTableImpl2.rawgetInt("chanceOfOverCar");
            }
            if (kahluaTableImpl2.delegate.containsKey("randomAngle")) {
                vehicleType.randomAngle = kahluaTableImpl2.rawgetBool("randomAngle");
            }
            if (kahluaTableImpl2.delegate.containsKey("spawnRate")) {
                vehicleType.spawnRate = kahluaTableImpl2.rawgetInt("spawnRate");
            }
            if (kahluaTableImpl2.delegate.containsKey("chanceToSpawnKey")) {
                vehicleType.chanceToSpawnKey = kahluaTableImpl2.rawgetInt("chanceToSpawnKey");
            }
            if (kahluaTableImpl2.delegate.containsKey("chanceToSpawnBurnt")) {
                vehicleType.chanceToSpawnBurnt = kahluaTableImpl2.rawgetInt("chanceToSpawnBurnt");
            }
            vehicles.put(string, vehicleType);
            if (!vehicleType.isSpecialCar) continue;
            specialVehicles.add(vehicleType);
        }
        HashSet hashSet = new HashSet();
        for (VehicleType vehicleType : vehicles.values()) {
            for (VehicleTypeDefinition vehicleTypeDefinition : vehicleType.vehiclesDefinition) {
                hashSet.add(vehicleTypeDefinition.vehicleType);
            }
        }
        for (VehicleScript vehicleScript : ScriptManager.instance.getAllVehicleScripts()) {
            if (hashSet.contains(vehicleScript.getFullName())) continue;
            DebugLog.General.warn("vehicle type \"" + vehicleScript.getFullName() + "\" isn't in VehicleZoneDistribution");
        }
    }

    public static boolean hasTypeForZone(String string) {
        if (vehicles.isEmpty()) {
            VehicleType.init();
        }
        string = string.toLowerCase();
        return vehicles.containsKey(string);
    }

    public static VehicleType getRandomVehicleType(String string) {
        return VehicleType.getRandomVehicleType(string, true);
    }

    public static VehicleType getRandomVehicleType(String string, Boolean bl) {
        VehicleType vehicleType;
        if (vehicles.isEmpty()) {
            VehicleType.init();
        }
        if ((vehicleType = vehicles.get(string = string.toLowerCase())) == null) {
            DebugLog.log(string + " Don't exist in VehicleZoneDistribution");
            return null;
        }
        if (Rand.Next(100) < vehicleType.chanceToSpawnBurnt) {
            vehicleType = Rand.Next(100) < 80 ? vehicles.get("normalburnt") : vehicles.get("specialburnt");
            return vehicleType;
        }
        if (bl.booleanValue() && vehicleType.isSpecialCar && Rand.Next(100) < vehicleType.chanceToSpawnNormal) {
            vehicleType = vehicles.get("parkingstall");
        }
        if (!vehicleType.isBurntCar && !vehicleType.isSpecialCar && Rand.Next(100) < vehicleType.chanceToSpawnSpecial) {
            vehicleType = PZArrayUtil.pickRandom(specialVehicles);
        }
        if (vehicleType.isBurntCar) {
            vehicleType = Rand.Next(100) < 80 ? vehicles.get("normalburnt") : vehicles.get("specialburnt");
        }
        return vehicleType;
    }

    public static VehicleType getTypeFromName(String string) {
        if (vehicles.isEmpty()) {
            VehicleType.init();
        }
        return vehicles.get(string);
    }

    public float getBaseVehicleQuality() {
        return this.baseVehicleQuality;
    }

    public float getRandomBaseVehicleQuality() {
        return Rand.Next(this.baseVehicleQuality - 0.1f, this.baseVehicleQuality + 0.1f);
    }

    public int getChanceToSpawnKey() {
        return this.chanceToSpawnKey;
    }

    public void setChanceToSpawnKey(int n) {
        this.chanceToSpawnKey = n;
    }

    public static void Reset() {
        vehicles.clear();
        specialVehicles.clear();
    }

    public static class VehicleTypeDefinition {
        public String vehicleType;
        public int index = -1;
        public float spawnChance = 0.0f;

        public VehicleTypeDefinition(String string, int n, float f) {
            this.vehicleType = string;
            this.index = n;
            this.spawnChance = f;
        }
    }
}

