/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatElement;
import zombie.chat.ChatElementOwner;
import zombie.core.Rand;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Drainable;
import zombie.iso.IsoGridSquare;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.radio.devices.DeviceData;
import zombie.radio.devices.WaveSignalDevice;
import zombie.scripting.objects.VehicleScript;
import zombie.ui.UIFont;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleDoor;
import zombie.vehicles.VehicleLight;
import zombie.vehicles.VehicleType;
import zombie.vehicles.VehicleWindow;

public final class VehiclePart
implements ChatElementOwner,
WaveSignalDevice {
    protected BaseVehicle vehicle;
    protected boolean bCreated;
    protected String partId;
    protected VehicleScript.Part scriptPart;
    protected ItemContainer container;
    protected InventoryItem item;
    protected KahluaTable modData;
    protected float lastUpdated = -1.0f;
    protected short updateFlags;
    protected VehiclePart parent;
    protected VehicleDoor door;
    protected VehicleWindow window;
    protected ArrayList<VehiclePart> children;
    protected String category;
    protected int condition = -1;
    protected boolean specificItem = true;
    protected float wheelFriction = 0.0f;
    protected int mechanicSkillInstaller = 0;
    private float suspensionDamping = 0.0f;
    private float suspensionCompression = 0.0f;
    private float engineLoudness = 0.0f;
    protected VehicleLight light;
    protected DeviceData deviceData;
    protected ChatElement chatElement;
    protected boolean hasPlayerInRange;

    public VehiclePart(BaseVehicle baseVehicle) {
        this.vehicle = baseVehicle;
    }

    public BaseVehicle getVehicle() {
        return this.vehicle;
    }

    public void setScriptPart(VehicleScript.Part part) {
        this.scriptPart = part;
    }

    public VehicleScript.Part getScriptPart() {
        return this.scriptPart;
    }

    public ItemContainer getItemContainer() {
        return this.container;
    }

    public void setItemContainer(ItemContainer itemContainer) {
        if (itemContainer != null) {
            itemContainer.parent = this.getVehicle();
            itemContainer.vehiclePart = this;
        }
        this.container = itemContainer;
    }

    public boolean hasModData() {
        return this.modData != null && !this.modData.isEmpty();
    }

    public KahluaTable getModData() {
        if (this.modData == null) {
            this.modData = LuaManager.platform.newTable();
        }
        return this.modData;
    }

    public float getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(float f) {
        this.lastUpdated = f;
    }

    public String getId() {
        if (this.scriptPart == null) {
            return this.partId;
        }
        return this.scriptPart.id;
    }

    public int getIndex() {
        return this.vehicle.parts.indexOf(this);
    }

    public String getArea() {
        if (this.scriptPart == null) {
            return null;
        }
        return this.scriptPart.area;
    }

    public ArrayList<String> getItemType() {
        if (this.scriptPart == null) {
            return null;
        }
        return this.scriptPart.itemType;
    }

    public KahluaTable getTable(String string) {
        if (this.scriptPart == null || this.scriptPart.tables == null) {
            return null;
        }
        KahluaTable kahluaTable = this.scriptPart.tables.get(string);
        if (kahluaTable == null) {
            return null;
        }
        return LuaManager.copyTable(kahluaTable);
    }

    public InventoryItem getInventoryItem() {
        return this.item;
    }

    public void setInventoryItem(InventoryItem inventoryItem, int n) {
        this.item = inventoryItem;
        this.doInventoryItemStats(inventoryItem, n);
        this.getVehicle().updateTotalMass();
        this.getVehicle().bDoDamageOverlay = true;
        if (this.isSetAllModelsVisible()) {
            this.setAllModelsVisible(inventoryItem != null);
        }
        this.getVehicle().updatePartStats();
        if (!GameServer.bServer) {
            this.getVehicle().updateBulletStats();
        }
    }

    public void setInventoryItem(InventoryItem inventoryItem) {
        this.setInventoryItem(inventoryItem, 0);
    }

    public boolean isInventoryItemUninstalled() {
        return this.getItemType() != null && !this.getItemType().isEmpty() && this.getInventoryItem() == null;
    }

    public boolean isSetAllModelsVisible() {
        return this.scriptPart != null && this.scriptPart.bSetAllModelsVisible;
    }

    public void setAllModelsVisible(boolean bl) {
        if (this.scriptPart == null || this.scriptPart.models == null || this.scriptPart.models.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.scriptPart.models.size(); ++i) {
            VehicleScript.Model model = this.scriptPart.models.get(i);
            this.vehicle.setModelVisible(this, model, bl);
        }
    }

    public void doInventoryItemStats(InventoryItem inventoryItem, int n) {
        if (inventoryItem != null) {
            if (this.isContainer()) {
                if (inventoryItem.getMaxCapacity() > 0 && this.getScriptPart().container.conditionAffectsCapacity) {
                    this.setContainerCapacity((int)VehiclePart.getNumberByCondition(inventoryItem.getMaxCapacity(), inventoryItem.getCondition(), 5.0f));
                } else if (inventoryItem.getMaxCapacity() > 0) {
                    this.setContainerCapacity(inventoryItem.getMaxCapacity());
                }
                this.setContainerContentAmount(inventoryItem.getItemCapacity());
            }
            this.setSuspensionCompression(VehiclePart.getNumberByCondition(inventoryItem.getSuspensionCompression(), inventoryItem.getCondition(), 0.6f));
            this.setSuspensionDamping(VehiclePart.getNumberByCondition(inventoryItem.getSuspensionDamping(), inventoryItem.getCondition(), 0.6f));
            if (inventoryItem.getEngineLoudness() > 0.0f) {
                this.setEngineLoudness(VehiclePart.getNumberByCondition(inventoryItem.getEngineLoudness(), inventoryItem.getCondition(), 10.0f));
            }
            this.setCondition(inventoryItem.getCondition());
            this.setMechanicSkillInstaller(n);
        } else {
            if (this.scriptPart != null && this.scriptPart.container != null) {
                if (this.scriptPart.container.capacity > 0) {
                    this.setContainerCapacity(this.scriptPart.container.capacity);
                } else {
                    this.setContainerCapacity(0);
                }
            }
            this.setMechanicSkillInstaller(0);
            this.setContainerContentAmount(0.0f);
            this.setSuspensionCompression(0.0f);
            this.setSuspensionDamping(0.0f);
            this.setWheelFriction(0.0f);
            this.setEngineLoudness(0.0f);
        }
    }

    public void setRandomCondition(InventoryItem inventoryItem) {
        VehicleType vehicleType = VehicleType.getTypeFromName(this.getVehicle().getVehicleType());
        if (this.getVehicle().isGoodCar()) {
            int n = 100;
            if (inventoryItem != null) {
                n = inventoryItem.getConditionMax();
            }
            this.setCondition(Rand.Next(n - n / 3, n));
            if (inventoryItem != null) {
                inventoryItem.setCondition(this.getCondition());
            }
            return;
        }
        int n = 100;
        if (inventoryItem != null) {
            n = inventoryItem.getConditionMax();
        }
        if (vehicleType != null) {
            n = (int)((float)n * vehicleType.getRandomBaseVehicleQuality());
        }
        float f = 100.0f;
        if (inventoryItem != null) {
            int n2 = inventoryItem.getChanceToSpawnDamaged();
            if (vehicleType != null) {
                n2 += vehicleType.chanceToPartDamage;
            }
            if (n2 > 0 && Rand.Next(100) < n2) {
                f = Rand.Next(n - n / 2, n);
            }
        } else {
            int n3 = 30;
            if (vehicleType != null) {
                n3 += vehicleType.chanceToPartDamage;
            }
            if (Rand.Next(100) < n3) {
                f = Rand.Next((float)n * 0.5f, (float)n);
            }
        }
        switch (SandboxOptions.instance.CarGeneralCondition.getValue()) {
            case 1: {
                f -= Rand.Next(f * 0.3f, Rand.Next(f * 0.3f, f * 0.9f));
                break;
            }
            case 2: {
                f -= Rand.Next(f * 0.1f, f * 0.3f);
                break;
            }
            case 4: {
                f += Rand.Next(f * 0.2f, f * 0.4f);
                break;
            }
            case 5: {
                f += Rand.Next(f * 0.5f, f * 0.9f);
            }
        }
        f = Math.max(0.0f, f);
        f = Math.min(100.0f, f);
        this.setCondition((int)f);
        if (inventoryItem != null) {
            inventoryItem.setCondition(this.getCondition());
        }
    }

    public void setGeneralCondition(InventoryItem inventoryItem, float f, float f2) {
        int n = 100;
        n = (int)((float)n * f);
        float f3 = 100.0f;
        if (inventoryItem != null) {
            int n2 = inventoryItem.getChanceToSpawnDamaged();
            if ((n2 = (int)((float)n2 + f2)) > 0 && Rand.Next(100) < n2) {
                f3 = Rand.Next(n - n / 2, n);
            }
        } else {
            int n3 = 30;
            n3 = (int)((float)n3 + f2);
            if (Rand.Next(100) < n3) {
                f3 = Rand.Next((float)n * 0.5f, (float)n);
            }
        }
        switch (SandboxOptions.instance.CarGeneralCondition.getValue()) {
            case 1: {
                f3 -= Rand.Next(f3 * 0.3f, Rand.Next(f3 * 0.3f, f3 * 0.9f));
                break;
            }
            case 2: {
                f3 -= Rand.Next(f3 * 0.1f, f3 * 0.3f);
                break;
            }
            case 4: {
                f3 += Rand.Next(f3 * 0.2f, f3 * 0.4f);
                break;
            }
            case 5: {
                f3 += Rand.Next(f3 * 0.5f, f3 * 0.9f);
            }
        }
        f3 = Math.max(0.0f, f3);
        f3 = Math.min(100.0f, f3);
        this.setCondition((int)f3);
        if (inventoryItem != null) {
            inventoryItem.setCondition(this.getCondition());
        }
    }

    public static float getNumberByCondition(float f, float f2, float f3) {
        f2 += 20.0f * (100.0f - f2) / 100.0f;
        float f4 = f2 / 100.0f;
        return (float)Math.round(Math.max(f3, f * f4) * 100.0f) / 100.0f;
    }

    public boolean isContainer() {
        if (this.scriptPart == null) {
            return false;
        }
        return this.scriptPart.container != null;
    }

    public int getContainerCapacity() {
        return this.getContainerCapacity(null);
    }

    public int getContainerCapacity(IsoGameCharacter isoGameCharacter) {
        if (!this.isContainer()) {
            return 0;
        }
        if (this.getItemContainer() != null) {
            if (isoGameCharacter == null) {
                return this.getItemContainer().getCapacity();
            }
            return this.getItemContainer().getEffectiveCapacity(isoGameCharacter);
        }
        if (this.getInventoryItem() != null) {
            if (this.scriptPart.container.conditionAffectsCapacity) {
                return (int)VehiclePart.getNumberByCondition(this.getInventoryItem().getMaxCapacity(), this.getCondition(), 5.0f);
            }
            return this.getInventoryItem().getMaxCapacity();
        }
        return this.scriptPart.container.capacity;
    }

    public void setContainerCapacity(int n) {
        if (!this.isContainer()) {
            return;
        }
        if (this.getItemContainer() != null) {
            this.getItemContainer().Capacity = n;
        }
    }

    public String getContainerContentType() {
        if (!this.isContainer()) {
            return null;
        }
        return this.scriptPart.container.contentType;
    }

    public float getContainerContentAmount() {
        Object object;
        if (!this.isContainer()) {
            return 0.0f;
        }
        if (this.hasModData() && (object = this.getModData().rawget("contentAmount")) instanceof Double) {
            return ((Double)object).floatValue();
        }
        return 0.0f;
    }

    public void setContainerContentAmount(float f) {
        this.setContainerContentAmount(f, false, false);
    }

    public void setContainerContentAmount(float f, boolean bl, boolean bl2) {
        if (!this.isContainer()) {
            return;
        }
        int n = this.scriptPart.container.capacity;
        if (this.getInventoryItem() != null) {
            n = this.getInventoryItem().getMaxCapacity();
        }
        if (!bl) {
            f = Math.min(f, (float)n);
        }
        f = Math.max(f, 0.0f);
        this.getModData().rawset("contentAmount", (Object)f);
        if (this.getInventoryItem() != null) {
            this.getInventoryItem().setItemCapacity(f);
        }
        if (!bl2) {
            this.getVehicle().updateTotalMass();
        }
    }

    public int getContainerSeatNumber() {
        if (!this.isContainer()) {
            return -1;
        }
        return this.scriptPart.container.seat;
    }

    public String getLuaFunction(String string) {
        if (this.scriptPart == null || this.scriptPart.luaFunctions == null) {
            return null;
        }
        return this.scriptPart.luaFunctions.get(string);
    }

    protected VehicleScript.Model getScriptModelById(String string) {
        if (this.scriptPart == null || this.scriptPart.models == null) {
            return null;
        }
        for (int i = 0; i < this.scriptPart.models.size(); ++i) {
            VehicleScript.Model model = this.scriptPart.models.get(i);
            if (!string.equals(model.id)) continue;
            return model;
        }
        return null;
    }

    public void setModelVisible(String string, boolean bl) {
        VehicleScript.Model model = this.getScriptModelById(string);
        if (model == null) {
            return;
        }
        this.vehicle.setModelVisible(this, model, bl);
    }

    public VehiclePart getParent() {
        return this.parent;
    }

    public void addChild(VehiclePart vehiclePart) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(vehiclePart);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public VehiclePart getChild(int n) {
        if (this.children == null || n < 0 || n >= this.children.size()) {
            return null;
        }
        return this.children.get(n);
    }

    public VehicleDoor getDoor() {
        return this.door;
    }

    public VehicleWindow getWindow() {
        return this.window;
    }

    public VehiclePart getChildWindow() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            VehiclePart vehiclePart = this.getChild(i);
            if (vehiclePart.getWindow() == null) continue;
            return vehiclePart;
        }
        return null;
    }

    public VehicleWindow findWindow() {
        VehiclePart vehiclePart = this.getChildWindow();
        return vehiclePart == null ? null : vehiclePart.getWindow();
    }

    public VehicleScript.Anim getAnimById(String string) {
        if (this.scriptPart == null || this.scriptPart.anims == null) {
            return null;
        }
        for (int i = 0; i < this.scriptPart.anims.size(); ++i) {
            VehicleScript.Anim anim = this.scriptPart.anims.get(i);
            if (!anim.id.equals(string)) continue;
            return anim;
        }
        return null;
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        GameWindow.WriteStringUTF(byteBuffer, this.getId());
        byteBuffer.put((byte)(this.bCreated ? 1 : 0));
        byteBuffer.putFloat(this.lastUpdated);
        if (this.getInventoryItem() == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            this.getInventoryItem().saveWithSize(byteBuffer, false);
        }
        if (this.getItemContainer() == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            this.getItemContainer().save(byteBuffer);
        }
        if (!this.hasModData() || this.getModData().isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            this.getModData().save(byteBuffer);
        }
        if (this.getDeviceData() == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            this.getDeviceData().save(byteBuffer, false);
        }
        if (this.light == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            this.light.save(byteBuffer);
        }
        if (this.door == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            this.door.save(byteBuffer);
        }
        if (this.window == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            this.window.save(byteBuffer);
        }
        byteBuffer.putInt(this.condition);
        byteBuffer.putFloat(this.wheelFriction);
        byteBuffer.putInt(this.mechanicSkillInstaller);
        byteBuffer.putFloat(this.suspensionCompression);
        byteBuffer.putFloat(this.suspensionDamping);
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        this.partId = GameWindow.ReadStringUTF(byteBuffer);
        this.bCreated = byteBuffer.get() == 1;
        this.lastUpdated = byteBuffer.getFloat();
        if (byteBuffer.get() == 1) {
            InventoryItem inventoryItem;
            this.item = inventoryItem = InventoryItem.loadItem(byteBuffer, n);
        }
        if (byteBuffer.get() == 1) {
            if (this.container == null) {
                this.container = new ItemContainer();
                this.container.parent = this.getVehicle();
                this.container.vehiclePart = this;
            }
            this.container.getItems().clear();
            this.container.ID = 0;
            this.container.load(byteBuffer, n);
        }
        if (byteBuffer.get() == 1) {
            this.getModData().load(byteBuffer, n);
        }
        if (byteBuffer.get() == 1) {
            if (this.getDeviceData() == null) {
                this.createSignalDevice();
            }
            this.getDeviceData().load(byteBuffer, n, false);
        }
        if (byteBuffer.get() == 1) {
            if (this.light == null) {
                this.light = new VehicleLight();
            }
            this.light.load(byteBuffer, n);
        }
        if (byteBuffer.get() == 1) {
            if (this.door == null) {
                this.door = new VehicleDoor(this);
            }
            this.door.load(byteBuffer, n);
        }
        if (byteBuffer.get() == 1) {
            if (this.window == null) {
                this.window = new VehicleWindow(this);
            }
            this.window.load(byteBuffer, n);
        }
        if (n >= 116) {
            this.setCondition(byteBuffer.getInt());
        }
        if (n >= 118) {
            this.setWheelFriction(byteBuffer.getFloat());
            this.setMechanicSkillInstaller(byteBuffer.getInt());
        }
        if (n >= 119) {
            this.setSuspensionCompression(byteBuffer.getFloat());
            this.setSuspensionDamping(byteBuffer.getFloat());
        }
    }

    public int getWheelIndex() {
        if (this.scriptPart == null || this.scriptPart.wheel == null) {
            return -1;
        }
        for (int i = 0; i < this.vehicle.script.getWheelCount(); ++i) {
            VehicleScript.Wheel wheel = this.vehicle.script.getWheel(i);
            if (!this.scriptPart.wheel.equals(wheel.id)) continue;
            return i;
        }
        return -1;
    }

    public void createSpotLight(float f, float f2, float f3, float f4, float f5, int n) {
        this.light = this.light == null ? new VehicleLight() : this.light;
        this.light.offset.set(f, f2, 0.0f);
        this.light.dist = f3;
        this.light.intensity = f4;
        this.light.dot = f5;
        this.light.focusing = n;
    }

    public VehicleLight getLight() {
        return this.light;
    }

    public float getLightDistance() {
        return this.light == null ? 0.0f : 8.0f + 16.0f * (float)this.getCondition() / 100.0f;
    }

    public float getLightIntensity() {
        return this.light == null ? 0.0f : 0.5f + 0.25f * (float)this.getCondition() / 100.0f;
    }

    public float getLightFocusing() {
        return this.light == null ? 0.0f : (float)(10 + (int)(90.0f * (1.0f - (float)this.getCondition() / 100.0f)));
    }

    public void setLightActive(boolean bl) {
        if (this.light == null || this.light.active == bl) {
            return;
        }
        this.light.active = bl;
        if (GameServer.bServer) {
            this.vehicle.updateFlags = (short)(this.vehicle.updateFlags | 8);
        }
    }

    public DeviceData createSignalDevice() {
        if (this.deviceData == null) {
            this.deviceData = new DeviceData(this);
        }
        if (this.chatElement == null) {
            this.chatElement = new ChatElement(this, 5, "device");
        }
        return this.deviceData;
    }

    public boolean hasDevicePower() {
        return this.vehicle.getBatteryCharge() > 0.0f;
    }

    @Override
    public DeviceData getDeviceData() {
        return this.deviceData;
    }

    @Override
    public void setDeviceData(DeviceData deviceData) {
        if (deviceData == null) {
            deviceData = new DeviceData(this);
        }
        this.deviceData = deviceData;
        this.deviceData.setParent(this);
    }

    @Override
    public float getDelta() {
        if (this.deviceData != null) {
            return this.deviceData.getPower();
        }
        return 0.0f;
    }

    @Override
    public void setDelta(float f) {
        if (this.deviceData != null) {
            this.deviceData.setPower(f);
        }
    }

    @Override
    public float getX() {
        return this.vehicle.getX();
    }

    @Override
    public float getY() {
        return this.vehicle.getY();
    }

    @Override
    public float getZ() {
        return this.vehicle.getZ();
    }

    @Override
    public IsoGridSquare getSquare() {
        return this.vehicle.getSquare();
    }

    @Override
    public void AddDeviceText(String string, float f, float f2, float f3, String string2, String string3, int n) {
        if (this.deviceData != null && this.deviceData.getIsTurnedOn()) {
            this.deviceData.doReceiveSignal(n);
            if (this.deviceData.getDeviceVolume() > 0.0f) {
                this.chatElement.addChatLine(string, f, f2, f3, UIFont.Medium, this.deviceData.getDeviceVolumeRange(), "default", true, true, true, true, true, true);
                if (string3 != null) {
                    LuaEventManager.triggerEvent("OnDeviceText", string2, string3, Float.valueOf(this.getX()), Float.valueOf(this.getY()), Float.valueOf(this.getZ()), string, this);
                }
            }
        }
    }

    @Override
    public boolean HasPlayerInRange() {
        return this.hasPlayerInRange;
    }

    private boolean playerWithinBounds(IsoPlayer isoPlayer, float f) {
        if (isoPlayer == null || isoPlayer.isDead()) {
            return false;
        }
        return (isoPlayer.getX() > this.getX() - f || this.getX() < this.getX() + f) && (isoPlayer.getY() > this.getY() - f || this.getY() < this.getY() + f);
    }

    public void updateSignalDevice() {
        if (this.deviceData == null) {
            return;
        }
        if (this.deviceData.getIsTurnedOn() && this.isInventoryItemUninstalled()) {
            this.deviceData.setIsTurnedOn(false);
        }
        if (GameClient.bClient) {
            this.deviceData.updateSimple();
        } else {
            this.deviceData.update(true, this.hasPlayerInRange);
        }
        if (!GameServer.bServer) {
            this.hasPlayerInRange = false;
            if (this.deviceData.getIsTurnedOn()) {
                for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                    IsoPlayer isoPlayer = IsoPlayer.players[i];
                    if (!this.playerWithinBounds(isoPlayer, (float)this.deviceData.getDeviceVolumeRange() * 0.6f)) continue;
                    this.hasPlayerInRange = true;
                    break;
                }
            }
            this.chatElement.setHistoryRange((float)this.deviceData.getDeviceVolumeRange() * 0.6f);
            this.chatElement.update();
        } else {
            this.hasPlayerInRange = false;
        }
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public int getCondition() {
        return this.condition;
    }

    public void setCondition(int n) {
        n = Math.min(100, n);
        n = Math.max(0, n);
        if (this.getVehicle().getDriver() != null) {
            if (this.condition > 60 && n < 60 && n > 40) {
                LuaEventManager.triggerEvent("OnVehicleDamageTexture", this.getVehicle().getDriver());
            }
            if (this.condition > 40 && n < 40) {
                LuaEventManager.triggerEvent("OnVehicleDamageTexture", this.getVehicle().getDriver());
            }
        }
        this.condition = n;
        if (this.getInventoryItem() != null) {
            this.getInventoryItem().setCondition(n);
        }
        this.getVehicle().bDoDamageOverlay = true;
        if ("lightbar".equals(this.getId())) {
            this.getVehicle().lightbarLightsMode.set(0);
            this.getVehicle().setLightbarSirenMode(0);
        }
        if (this.scriptPart != null && this.scriptPart.id != null && this.scriptPart.id.equals("TrailerTrunk")) {
            this.getItemContainer().setCapacity(Math.max(80, n));
        }
    }

    public void damage(int n) {
        if (this.getWindow() != null) {
            this.getWindow().damage(n);
            return;
        }
        this.setCondition(this.getCondition() - n);
        this.getVehicle().transmitPartCondition(this);
    }

    public boolean isSpecificItem() {
        return this.specificItem;
    }

    public void setSpecificItem(boolean bl) {
        this.specificItem = bl;
    }

    public float getWheelFriction() {
        return this.wheelFriction;
    }

    public void setWheelFriction(float f) {
        this.wheelFriction = f;
    }

    public int getMechanicSkillInstaller() {
        return this.mechanicSkillInstaller;
    }

    public void setMechanicSkillInstaller(int n) {
        this.mechanicSkillInstaller = n;
    }

    public float getSuspensionDamping() {
        return this.suspensionDamping;
    }

    public void setSuspensionDamping(float f) {
        this.suspensionDamping = f;
    }

    public float getSuspensionCompression() {
        return this.suspensionCompression;
    }

    public void setSuspensionCompression(float f) {
        this.suspensionCompression = f;
    }

    public float getEngineLoudness() {
        return this.engineLoudness;
    }

    public void setEngineLoudness(float f) {
        this.engineLoudness = f;
    }

    public void repair() {
        InventoryItem inventoryItem;
        String string;
        VehicleScript vehicleScript = this.vehicle.getScript();
        float f = this.getContainerContentAmount();
        if (this.isInventoryItemUninstalled() && (string = this.getItemType().get(Rand.Next(this.getItemType().size()))) != null && !string.isEmpty() && (inventoryItem = InventoryItemFactory.CreateItem(string)) != null) {
            this.setInventoryItem(inventoryItem);
            if (inventoryItem.getMaxCapacity() > 0) {
                inventoryItem.setItemCapacity(inventoryItem.getMaxCapacity());
            }
            this.vehicle.transmitPartItem(this);
            this.callLuaVoid(this.getLuaFunction("init"), this.vehicle, this);
        }
        if (this.getDoor() != null && this.getDoor().isLockBroken()) {
            this.getDoor().setLockBroken(false);
            this.vehicle.transmitPartDoor(this);
        }
        if (this.getCondition() != 100) {
            this.setCondition(100);
            if (this.getInventoryItem() != null) {
                this.doInventoryItemStats(this.getInventoryItem(), this.getMechanicSkillInstaller());
            }
            this.vehicle.transmitPartCondition(this);
        }
        if (this.isContainer() && this.getItemContainer() == null && f != (float)this.getContainerCapacity()) {
            this.setContainerContentAmount(this.getContainerCapacity());
            this.vehicle.transmitPartModData(this);
        }
        if (this.getInventoryItem() instanceof Drainable && ((Drainable)((Object)this.getInventoryItem())).getUsedDelta() < 1.0f) {
            ((Drainable)((Object)this.getInventoryItem())).setUsedDelta(1.0f);
            this.vehicle.transmitPartUsedDelta(this);
        }
        if ("Engine".equalsIgnoreCase(this.getId())) {
            int n = 100;
            int n2 = (int)((double)vehicleScript.getEngineLoudness() * SandboxOptions.getInstance().ZombieAttractionMultiplier.getValue());
            int n3 = (int)vehicleScript.getEngineForce();
            this.vehicle.setEngineFeature(n, n2, n3);
            this.vehicle.transmitEngine();
        }
        this.vehicle.updatePartStats();
        this.vehicle.updateBulletStats();
    }

    private void callLuaVoid(String string, Object object, Object object2) {
        Object object3 = LuaManager.getFunctionObject(string);
        if (object3 == null) {
            return;
        }
        LuaManager.caller.protectedCallVoid(LuaManager.thread, object3, object, object2);
    }

    public ChatElement getChatElement() {
        return this.chatElement;
    }
}

