/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.util.ArrayList;
import java.util.Arrays;
import zombie.GameWindow;
import zombie.core.Core;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.vehicles.BaseVehicle;

public final class VehicleIDMap {
    public static final VehicleIDMap instance = new VehicleIDMap();
    private static final int MAX_IDS = Short.MAX_VALUE;
    private static final int RESIZE_COUNT = 256;
    private int capacity = 256;
    private BaseVehicle[] idToVehicle = new BaseVehicle[this.capacity];
    private short[] freeID = new short[this.capacity];
    private short freeIDSize;
    private boolean noise = false;
    private int warnCount = 0;

    VehicleIDMap() {
        for (int i = 0; i < this.capacity; ++i) {
            short s = this.freeIDSize;
            this.freeIDSize = (short)(s + 1);
            this.freeID[s] = (short)i;
        }
    }

    public void put(short s, BaseVehicle baseVehicle) {
        if (Core.bDebug && this.noise) {
            DebugLog.log("VehicleIDMap.put()" + s);
        }
        if (GameClient.bClient && s >= this.capacity) {
            this.resize((s / 256 + 1) * 256);
        }
        if (s < 0 || s >= this.capacity) {
            throw new IllegalArgumentException("invalid vehicle id " + s + " max=" + this.capacity);
        }
        if (this.idToVehicle[s] != null) {
            throw new IllegalArgumentException("duplicate vehicle with id " + s);
        }
        if (baseVehicle == null) {
            throw new IllegalArgumentException("vehicle is null");
        }
        this.idToVehicle[s] = baseVehicle;
    }

    public void remove(short s) {
        if (Core.bDebug && this.noise) {
            DebugLog.log("VehicleIDMap.remove()" + s);
        }
        if (s < 0 || s >= this.capacity) {
            throw new IllegalArgumentException("invalid vehicle id=" + s + " max=" + this.capacity);
        }
        if (this.idToVehicle[s] == null) {
            throw new IllegalArgumentException("no vehicle with id " + s);
        }
        this.idToVehicle[s] = null;
        if (GameClient.bClient || GameWindow.bLoadedAsClient) {
            return;
        }
        short s2 = this.freeIDSize;
        this.freeIDSize = (short)(s2 + 1);
        this.freeID[s2] = s;
    }

    public BaseVehicle get(short s) {
        return s >= 0 && s < this.capacity ? this.idToVehicle[s] : null;
    }

    public boolean containsKey(short s) {
        return s >= 0 && s < this.capacity && this.idToVehicle[s] != null;
    }

    public void toArrayList(ArrayList<BaseVehicle> arrayList) {
        for (int i = 0; i < this.capacity; ++i) {
            if (this.idToVehicle[i] == null) continue;
            arrayList.add(this.idToVehicle[i]);
        }
    }

    public void Reset() {
        Arrays.fill(this.idToVehicle, null);
        this.freeIDSize = (short)this.capacity;
        for (int n = 0; n < this.capacity; n = (int)((short)(n + 1))) {
            this.freeID[n] = n;
        }
    }

    public short allocateID() {
        if (GameClient.bClient) {
            throw new RuntimeException("client must not call this");
        }
        if (this.freeIDSize > 0) {
            this.freeIDSize = (short)(this.freeIDSize - 1);
            return this.freeID[this.freeIDSize];
        }
        if (this.capacity >= Short.MAX_VALUE) {
            if (this.warnCount < 100) {
                DebugLog.log("warning: ran out of unique vehicle ids");
                ++this.warnCount;
            }
            return -1;
        }
        this.resize(this.capacity + 256);
        return this.allocateID();
    }

    private void resize(int n) {
        int n2 = this.capacity;
        this.capacity = Math.min(n, Short.MAX_VALUE);
        this.capacity = Math.min(n, Short.MAX_VALUE);
        this.idToVehicle = Arrays.copyOf(this.idToVehicle, this.capacity);
        this.freeID = Arrays.copyOf(this.freeID, this.capacity);
        for (int i = n2; i < this.capacity; ++i) {
            short s = this.freeIDSize;
            this.freeIDSize = (short)(s + 1);
            this.freeID[s] = (short)i;
        }
    }
}

