/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import zombie.core.math.PZMath;
import zombie.scripting.ScriptParser;
import zombie.scripting.objects.BaseScriptObject;
import zombie.vehicles.EngineRPMData;

public class VehicleEngineRPM
extends BaseScriptObject {
    public static final int MAX_GEARS = 8;
    private static final int VERSION1 = 1;
    private static final int VERSION = 1;
    private String m_name;
    public final EngineRPMData[] m_rpmData = new EngineRPMData[8];

    public String getName() {
        return this.m_name;
    }

    public void Load(String string, String string2) throws RuntimeException {
        this.m_name = string;
        int n = -1;
        ScriptParser.Block block = ScriptParser.parse(string2);
        block = block.children.get(0);
        for (ScriptParser.Value object : block.values) {
            String string3 = object.getKey().trim();
            String string4 = object.getValue().trim();
            if (!"VERSION".equals(string3) || (n = PZMath.tryParseInt(string4, -1)) >= 0 && n <= 1) continue;
            throw new RuntimeException(String.format("unknown vehicleEngineRPM VERSION \"%s\"", string4));
        }
        if (n == -1) {
            throw new RuntimeException(String.format("unknown vehicleEngineRPM VERSION \"%s\"", block.type));
        }
        int n2 = 0;
        for (ScriptParser.Block block2 : block.children) {
            if ("data".equals(block2.type)) {
                if (n2 == 8) {
                    throw new RuntimeException(String.format("too many vehicleEngineRPM.data blocks, max is %d", 8));
                }
                this.m_rpmData[n2] = new EngineRPMData();
                this.LoadData(block2, this.m_rpmData[n2]);
                ++n2;
                continue;
            }
            throw new RuntimeException(String.format("unknown block vehicleEngineRPM.%s", block2.type));
        }
    }

    private void LoadData(ScriptParser.Block block, EngineRPMData engineRPMData) {
        for (ScriptParser.Value blockElement : block.values) {
            String string = blockElement.getKey().trim();
            String string2 = blockElement.getValue().trim();
            if ("afterGearChange".equals(string)) {
                engineRPMData.afterGearChange = PZMath.tryParseFloat(string2, 0.0f);
                continue;
            }
            if ("gearChange".equals(string)) {
                engineRPMData.gearChange = PZMath.tryParseFloat(string2, 0.0f);
                continue;
            }
            throw new RuntimeException(String.format("unknown value vehicleEngineRPM.data.%s", blockElement.string));
        }
        for (ScriptParser.Block block2 : block.children) {
            if ("xxx".equals(block2.type)) continue;
            throw new RuntimeException(String.format("unknown block vehicleEngineRPM.data.%s", block2.type));
        }
    }

    public void reset() {
        for (int i = 0; i < this.m_rpmData.length; ++i) {
            if (this.m_rpmData[i] == null) continue;
            this.m_rpmData[i].reset();
        }
    }
}

