/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Cylinder;
import org.lwjgl.util.vector.Matrix4f;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaUtil;
import zombie.IndieGL;
import zombie.Lua.LuaManager;
import zombie.characters.action.ActionContext;
import zombie.characters.action.ActionGroup;
import zombie.core.BoxedStaticValues;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.VBOLines;
import zombie.core.skinnedmodel.ModelCamera;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.advancedanimation.AnimNode;
import zombie.core.skinnedmodel.advancedanimation.AnimState;
import zombie.core.skinnedmodel.advancedanimation.AnimatedModel;
import zombie.core.skinnedmodel.advancedanimation.AnimationSet;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.animation.AnimationMultiTrack;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.animation.AnimationTrack;
import zombie.core.skinnedmodel.animation.Keyframe;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelInstanceRenderData;
import zombie.core.skinnedmodel.model.SkinningBone;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.core.skinnedmodel.shader.Shader;
import zombie.core.skinnedmodel.shader.ShaderManager;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.input.Mouse;
import zombie.iso.IsoUtils;
import zombie.iso.Vector2;
import zombie.popman.ObjectPool;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.ModelScript;
import zombie.scripting.objects.VehicleScript;
import zombie.ui.UIElement;
import zombie.ui.UIFont;
import zombie.ui.UIManager;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;

public final class UI3DScene
extends UIElement {
    private final ArrayList<SceneObject> m_objects = new ArrayList();
    private View m_view = View.Right;
    private TransformMode m_transformMode = TransformMode.Local;
    private int m_view_x = 0;
    private int m_view_y = 0;
    private final Vector3f m_viewRotation = new Vector3f();
    private int m_zoom = 3;
    private int m_zoomMax = 10;
    private int m_gridDivisions = 1;
    private GridPlane m_gridPlane = GridPlane.YZ;
    private final org.joml.Matrix4f m_projection = new org.joml.Matrix4f();
    private final org.joml.Matrix4f m_modelView = new org.joml.Matrix4f();
    private long VIEW_CHANGE_TIME = 350L;
    private long m_viewChangeTime;
    private final Quaternionf m_modelViewChange = new Quaternionf();
    private boolean m_bDrawGrid = true;
    private boolean m_bDrawGridAxes = false;
    private boolean m_bDrawGridPlane = false;
    private final CharacterSceneModelCamera m_CharacterSceneModelCamera = new CharacterSceneModelCamera();
    private final VehicleSceneModelCamera m_VehicleSceneModelCamera = new VehicleSceneModelCamera();
    private static final ObjectPool<SetModelCamera> s_SetModelCameraPool = new ObjectPool<SetModelCamera>(SetModelCamera::new);
    private final StateData[] m_stateData = new StateData[3];
    private Gizmo m_gizmo;
    private final RotateGizmo m_rotateGizmo = new RotateGizmo();
    private final ScaleGizmo m_scaleGizmo = new ScaleGizmo();
    private final TranslateGizmo m_translateGizmo = new TranslateGizmo();
    private final Vector3f m_gizmoPos = new Vector3f();
    private final Vector3f m_gizmoRotate = new Vector3f();
    private SceneObject m_gizmoParent = null;
    private SceneObject m_gizmoOrigin = null;
    private SceneObject m_gizmoChild = null;
    private final OriginAttachment m_originAttachment = new OriginAttachment(this);
    private final OriginBone m_originBone = new OriginBone(this);
    private final OriginGizmo m_originGizmo = new OriginGizmo(this);
    private float m_gizmoScale = 1.0f;
    private String m_selectedAttachment = null;
    private final ArrayList<PositionRotation> m_axes = new ArrayList();
    private final OriginBone m_highlightBone = new OriginBone(this);
    private static final ObjectPool<PositionRotation> s_posRotPool = new ObjectPool<PositionRotation>(PositionRotation::new);
    private final ArrayList<AABB> m_aabb = new ArrayList();
    private static final ObjectPool<AABB> s_aabbPool = new ObjectPool<AABB>(AABB::new);
    private final ArrayList<Box3D> m_box3D = new ArrayList();
    private static final ObjectPool<Box3D> s_box3DPool = new ObjectPool<Box3D>(Box3D::new);
    final Vector3f tempVector3f = new Vector3f();
    final Vector4f tempVector4f = new Vector4f();
    final int[] m_viewport = new int[]{0, 0, 0, 0};
    private final float GRID_DARK = 0.1f;
    private final float GRID_LIGHT = 0.2f;
    private float GRID_ALPHA = 1.0f;
    private final int HALF_GRID = 5;
    private static final VBOLines vboLines = new VBOLines();
    private static final ThreadLocal<ObjectPool<Ray>> TL_Ray_pool = ThreadLocal.withInitial(RayObjectPool::new);
    private static final ThreadLocal<ObjectPool<Plane>> TL_Plane_pool = ThreadLocal.withInitial(PlaneObjectPool::new);
    static final float SMALL_NUM = 1.0E-8f;

    public UI3DScene(KahluaTable kahluaTable) {
        super(kahluaTable);
        for (int i = 0; i < this.m_stateData.length; ++i) {
            this.m_stateData[i] = new StateData();
            this.m_stateData[i].m_gridPlaneDrawer = new GridPlaneDrawer(this);
            this.m_stateData[i].m_overlaysDrawer = new OverlaysDrawer();
        }
    }

    SceneObject getSceneObjectById(String string, boolean bl) {
        for (int i = 0; i < this.m_objects.size(); ++i) {
            SceneObject sceneObject = this.m_objects.get(i);
            if (!sceneObject.m_id.equalsIgnoreCase(string)) continue;
            return sceneObject;
        }
        if (bl) {
            throw new NullPointerException("scene object \"" + string + "\" not found");
        }
        return null;
    }

    <C> C getSceneObjectById(String string, Class<C> clazz, boolean bl) {
        for (int i = 0; i < this.m_objects.size(); ++i) {
            SceneObject sceneObject = this.m_objects.get(i);
            if (!sceneObject.m_id.equalsIgnoreCase(string)) continue;
            if (sceneObject.getClass() == clazz) {
                return clazz.cast(sceneObject);
            }
            if (!bl) continue;
            throw new ClassCastException("scene object \"" + string + "\" is " + sceneObject.getClass().getSimpleName() + " expected " + clazz.getSimpleName());
        }
        if (bl) {
            throw new NullPointerException("scene object \"" + string + "\" not found");
        }
        return null;
    }

    @Override
    public void render() {
        Vector3f vector3f;
        Object object;
        Object object2;
        if (!this.isVisible().booleanValue()) {
            return;
        }
        super.render();
        IndieGL.glClear(256);
        StateData stateData = this.stateDataMain();
        this.calcMatrices(this.m_projection, this.m_modelView);
        stateData.m_projection.set(this.m_projection);
        long l = System.currentTimeMillis();
        if (this.m_viewChangeTime + this.VIEW_CHANGE_TIME > l) {
            float f = (float)(this.m_viewChangeTime + this.VIEW_CHANGE_TIME - l) / (float)this.VIEW_CHANGE_TIME;
            object2 = UI3DScene.allocQuaternionf().setFromUnnormalized(this.m_modelView);
            stateData.m_modelView.set(this.m_modelViewChange.slerp((Quaternionfc)object2, 1.0f - f));
            UI3DScene.releaseQuaternionf((Quaternionf)object2);
        } else {
            stateData.m_modelView.set(this.m_modelView);
        }
        stateData.m_zoom = this.m_zoom;
        if (this.m_bDrawGridPlane) {
            SpriteRenderer.instance.drawGeneric(stateData.m_gridPlaneDrawer);
        }
        PZArrayUtil.forEach(stateData.m_objectData, SceneObjectRenderData::release);
        stateData.m_objectData.clear();
        for (int i = 0; i < this.m_objects.size(); ++i) {
            object2 = this.m_objects.get(i);
            if (!((SceneObject)object2).m_visible) continue;
            if (((SceneObject)object2).m_autoRotate) {
                ((SceneObject)object2).m_autoRotateAngle = (float)((double)((SceneObject)object2).m_autoRotateAngle + UIManager.getMillisSinceLastRender() / 30.0);
                if (((SceneObject)object2).m_autoRotateAngle > 360.0f) {
                    ((SceneObject)object2).m_autoRotateAngle = 0.0f;
                }
            }
            if ((object = ((SceneObject)object2).renderMain()) == null) continue;
            stateData.m_objectData.add((SceneObjectRenderData)object);
        }
        float f = Mouse.getXA() - this.getAbsoluteX().intValue();
        float f2 = Mouse.getYA() - this.getAbsoluteY().intValue();
        stateData.m_gizmo = this.m_gizmo;
        if (this.m_gizmo != null) {
            stateData.m_gizmoTranslate.set(this.m_gizmoPos);
            stateData.m_gizmoRotate.set(this.m_gizmoRotate);
            stateData.m_gizmoTransform.translation(this.m_gizmoPos);
            stateData.m_gizmoTransform.rotateXYZ(this.m_gizmoRotate.x * ((float)Math.PI / 180), this.m_gizmoRotate.y * ((float)Math.PI / 180), this.m_gizmoRotate.z * ((float)Math.PI / 180));
            stateData.m_gizmoAxis = this.m_gizmo.hitTest(f, f2);
        }
        stateData.m_gizmoChildTransform.identity();
        boolean bl = stateData.m_selectedAttachmentIsChildAttachment = this.m_gizmoChild != null && this.m_gizmoChild.m_attachment != null && this.m_gizmoChild.m_attachment.equals(this.m_selectedAttachment);
        if (this.m_gizmoChild != null) {
            this.m_gizmoChild.getLocalTransform(stateData.m_gizmoChildTransform);
        }
        stateData.m_gizmoOriginTransform.identity();
        boolean bl2 = stateData.m_hasGizmoOrigin = this.m_gizmoOrigin != null;
        if (this.m_gizmoOrigin != null && this.m_gizmoOrigin != this.m_gizmoParent) {
            this.m_gizmoOrigin.getGlobalTransform(stateData.m_gizmoOriginTransform);
        }
        stateData.m_gizmoParentTransform.identity();
        if (this.m_gizmoParent != null) {
            this.m_gizmoParent.getGlobalTransform(stateData.m_gizmoParentTransform);
        }
        stateData.m_overlaysDrawer.init();
        SpriteRenderer.instance.drawGeneric(stateData.m_overlaysDrawer);
        if (this.m_bDrawGrid) {
            object = this.uiToScene(f, f2, 0.0f, this.tempVector3f);
            if (this.m_view == View.UserDefined) {
                vector3f = UI3DScene.allocVector3f();
                switch (this.m_gridPlane) {
                    case XY: {
                        vector3f.set(0.0f, 0.0f, 1.0f);
                        break;
                    }
                    case XZ: {
                        vector3f.set(0.0f, 1.0f, 0.0f);
                        break;
                    }
                    case YZ: {
                        vector3f.set(1.0f, 0.0f, 0.0f);
                    }
                }
                Vector3f vector3f2 = UI3DScene.allocVector3f().set(0.0f);
                Plane plane = UI3DScene.allocPlane().set(vector3f, vector3f2);
                UI3DScene.releaseVector3f(vector3f);
                UI3DScene.releaseVector3f(vector3f2);
                Ray ray = this.getCameraRay(f, (float)this.screenHeight() - f2, UI3DScene.allocRay());
                if (UI3DScene.intersect_ray_plane(plane, ray, (Vector3f)object) != 1) {
                    ((Vector3f)object).set(0.0f);
                }
                UI3DScene.releasePlane(plane);
                UI3DScene.releaseRay(ray);
            }
            ((Vector3f)object).x = (float)Math.round(((Vector3f)object).x * this.gridMult()) / this.gridMult();
            ((Vector3f)object).y = (float)Math.round(((Vector3f)object).y * this.gridMult()) / this.gridMult();
            ((Vector3f)object).z = (float)Math.round(((Vector3f)object).z * this.gridMult()) / this.gridMult();
            this.DrawText(UIFont.Small, String.valueOf(((Vector3f)object).x), this.width - 200.0f, 10.0, 1.0, 0.0, 0.0, 1.0);
            this.DrawText(UIFont.Small, String.valueOf(((Vector3f)object).y), this.width - 150.0f, 10.0, 0.0, 1.0, 0.0, 1.0);
            this.DrawText(UIFont.Small, String.valueOf(((Vector3f)object).z), this.width - 100.0f, 10.0, 0.0, 0.5, 1.0, 1.0);
        }
        if (this.m_gizmo == this.m_rotateGizmo && this.m_rotateGizmo.m_trackAxis != Axis.None) {
            object = this.m_rotateGizmo.m_startXfrm.getTranslation(UI3DScene.allocVector3f());
            float f3 = this.sceneToUIX(((Vector3f)object).x, ((Vector3f)object).y, ((Vector3f)object).z);
            float f4 = this.sceneToUIY(((Vector3f)object).x, ((Vector3f)object).y, ((Vector3f)object).z);
            LineDrawer.drawLine(f3, f4, f, f2, 0.5f, 0.5f, 0.5f, 1.0f, 1);
            UI3DScene.releaseVector3f((Vector3f)object);
        }
        if (this.m_highlightBone.m_boneName != null) {
            object = this.m_highlightBone.getGlobalTransform(UI3DScene.allocMatrix4f());
            this.m_highlightBone.m_character.getGlobalTransform(UI3DScene.allocMatrix4f()).mul((Matrix4fc)object, (org.joml.Matrix4f)object);
            vector3f = ((org.joml.Matrix4f)object).getTranslation(UI3DScene.allocVector3f());
            float f5 = this.sceneToUIX(vector3f.x, vector3f.y, vector3f.z);
            float f6 = this.sceneToUIY(vector3f.x, vector3f.y, vector3f.z);
            LineDrawer.drawCircle(f5, f6, 10.0f, 16, 1.0f, 1.0f, 1.0f);
            UI3DScene.releaseVector3f(vector3f);
            UI3DScene.releaseMatrix4f((org.joml.Matrix4f)object);
        }
    }

    private float gridMult() {
        return 100 * this.m_gridDivisions;
    }

    private float zoomMult() {
        return (float)Math.exp((float)this.m_zoom * 0.2f) * 160.0f / Math.max(1.82f, 1.0f);
    }

    private static org.joml.Matrix4f allocMatrix4f() {
        return (org.joml.Matrix4f)BaseVehicle.TL_matrix4f_pool.get().alloc();
    }

    private static void releaseMatrix4f(org.joml.Matrix4f matrix4f) {
        BaseVehicle.TL_matrix4f_pool.get().release(matrix4f);
    }

    private static Quaternionf allocQuaternionf() {
        return (Quaternionf)BaseVehicle.TL_quaternionf_pool.get().alloc();
    }

    private static void releaseQuaternionf(Quaternionf quaternionf) {
        BaseVehicle.TL_quaternionf_pool.get().release(quaternionf);
    }

    private static Ray allocRay() {
        return TL_Ray_pool.get().alloc();
    }

    private static void releaseRay(Ray ray) {
        TL_Ray_pool.get().release(ray);
    }

    private static Plane allocPlane() {
        return TL_Plane_pool.get().alloc();
    }

    private static void releasePlane(Plane plane) {
        TL_Plane_pool.get().release(plane);
    }

    private static Vector2 allocVector2() {
        return (Vector2)BaseVehicle.TL_vector2_pool.get().alloc();
    }

    private static void releaseVector2(Vector2 vector22) {
        BaseVehicle.TL_vector2_pool.get().release(vector22);
    }

    private static Vector3f allocVector3f() {
        return (Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc();
    }

    private static void releaseVector3f(Vector3f vector3f) {
        BaseVehicle.TL_vector3f_pool.get().release(vector3f);
    }

    public Object fromLua0(String string) {
        switch (string) {
            case "clearAABBs": {
                s_aabbPool.release((List<AABB>)this.m_aabb);
                this.m_aabb.clear();
                return null;
            }
            case "clearAxes": {
                s_posRotPool.release((List<PositionRotation>)this.m_axes);
                this.m_axes.clear();
                return null;
            }
            case "clearBox3Ds": {
                s_box3DPool.release((List<Box3D>)this.m_box3D);
                this.m_box3D.clear();
                return null;
            }
            case "clearGizmoRotate": {
                this.m_gizmoRotate.set(0.0f);
                return null;
            }
            case "clearHighlightBone": {
                this.m_highlightBone.m_boneName = null;
                return null;
            }
            case "getGizmoPos": {
                return this.m_gizmoPos;
            }
            case "getGridMult": {
                return BoxedStaticValues.toDouble(this.gridMult());
            }
            case "getView": {
                return this.m_view.name();
            }
            case "getViewRotation": {
                return this.m_viewRotation;
            }
            case "getModelCount": {
                int n = 0;
                for (int i = 0; i < this.m_objects.size(); ++i) {
                    if (!(this.m_objects.get(i) instanceof SceneModel)) continue;
                    ++n;
                }
                return BoxedStaticValues.toDouble(n);
            }
            case "stopGizmoTracking": {
                if (this.m_gizmo != null) {
                    this.m_gizmo.stopTracking();
                }
                return null;
            }
        }
        throw new IllegalArgumentException("unhandled \"" + string + "\"");
    }

    public Object fromLua1(String string, Object object) {
        switch (string) {
            case "createCharacter": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, false);
                if (sceneObject != null) {
                    throw new IllegalStateException("scene object \"" + object + "\" exists");
                }
                SceneCharacter sceneCharacter = new SceneCharacter(this, (String)object);
                this.m_objects.add(sceneCharacter);
                return sceneCharacter;
            }
            case "createVehicle": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, false);
                if (sceneObject != null) {
                    throw new IllegalStateException("scene object \"" + object + "\" exists");
                }
                SceneVehicle sceneVehicle = new SceneVehicle(this, (String)object);
                this.m_objects.add(sceneVehicle);
                return null;
            }
            case "getCharacterAnimationDuration": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                AnimationPlayer animationPlayer = sceneCharacter.m_animatedModel.getAnimationPlayer();
                if (animationPlayer == null) {
                    return null;
                }
                AnimationMultiTrack animationMultiTrack = animationPlayer.getMultiTrack();
                if (animationMultiTrack == null || animationMultiTrack.getTracks().isEmpty()) {
                    return null;
                }
                return KahluaUtil.toDouble(animationMultiTrack.getTracks().get(0).getDuration());
            }
            case "getCharacterAnimationTime": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                AnimationPlayer animationPlayer = sceneCharacter.m_animatedModel.getAnimationPlayer();
                if (animationPlayer == null) {
                    return null;
                }
                AnimationMultiTrack animationMultiTrack = animationPlayer.getMultiTrack();
                if (animationMultiTrack == null || animationMultiTrack.getTracks().isEmpty()) {
                    return null;
                }
                return KahluaUtil.toDouble(animationMultiTrack.getTracks().get(0).getCurrentTimeValue());
            }
            case "getModelScript": {
                int n = 0;
                for (int i = 0; i < this.m_objects.size(); ++i) {
                    SceneModel sceneModel = Type.tryCastTo(this.m_objects.get(i), SceneModel.class);
                    if (sceneModel == null || n++ != ((Double)object).intValue()) continue;
                    return sceneModel.m_modelScript;
                }
                return null;
            }
            case "getObjectAutoRotate": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, true);
                return sceneObject.m_autoRotate ? Boolean.TRUE : Boolean.FALSE;
            }
            case "getObjectParent": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, true);
                return sceneObject.m_parent == null ? null : sceneObject.m_parent.m_id;
            }
            case "getObjectParentAttachment": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, true);
                return sceneObject.m_parentAttachment;
            }
            case "getObjectRotation": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, true);
                return sceneObject.m_rotate;
            }
            case "getObjectTranslation": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, true);
                return sceneObject.m_translate;
            }
            case "getVehicleScript": {
                SceneVehicle sceneVehicle = this.getSceneObjectById((String)object, SceneVehicle.class, true);
                return sceneVehicle.m_script;
            }
            case "isCharacterFemale": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                return sceneCharacter.m_animatedModel.isFemale();
            }
            case "isObjectVisible": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, true);
                return sceneObject.m_visible ? Boolean.TRUE : Boolean.FALSE;
            }
            case "removeModel": {
                SceneModel sceneModel = this.getSceneObjectById((String)object, SceneModel.class, true);
                this.m_objects.remove(sceneModel);
                for (SceneObject sceneObject : this.m_objects) {
                    if (sceneObject.m_parent != sceneModel) continue;
                    sceneObject.m_attachment = null;
                    sceneObject.m_parent = null;
                    sceneObject.m_parentAttachment = null;
                }
                return null;
            }
            case "setDrawGrid": {
                this.m_bDrawGrid = (Boolean)object;
                return null;
            }
            case "setDrawGridAxes": {
                this.m_bDrawGridAxes = (Boolean)object;
                return null;
            }
            case "setDrawGridPlane": {
                this.m_bDrawGridPlane = (Boolean)object;
                return null;
            }
            case "setGizmoOrigin": {
                String string2;
                switch (string2 = (String)object) {
                    case "none": {
                        this.m_gizmoParent = null;
                        this.m_gizmoOrigin = null;
                        this.m_gizmoChild = null;
                    }
                }
                return null;
            }
            case "setGizmoPos": {
                Vector3f vector3f = (Vector3f)object;
                if (!this.m_gizmoPos.equals(vector3f)) {
                    this.m_gizmoPos.set(vector3f);
                }
                return null;
            }
            case "setGizmoRotate": {
                Vector3f vector3f = (Vector3f)object;
                if (!this.m_gizmoRotate.equals(vector3f)) {
                    this.m_gizmoRotate.set(vector3f);
                }
                return null;
            }
            case "setGizmoScale": {
                this.m_gizmoScale = Math.max(((Double)object).floatValue(), 0.01f);
                return null;
            }
            case "setGizmoVisible": {
                String string3 = (String)object;
                this.m_rotateGizmo.m_visible = "rotate".equalsIgnoreCase(string3);
                this.m_scaleGizmo.m_visible = "scale".equalsIgnoreCase(string3);
                this.m_translateGizmo.m_visible = "translate".equalsIgnoreCase(string3);
                switch (string3) {
                    case "rotate": {
                        this.m_gizmo = this.m_rotateGizmo;
                        break;
                    }
                    case "scale": {
                        this.m_gizmo = this.m_scaleGizmo;
                        break;
                    }
                    case "translate": {
                        this.m_gizmo = this.m_translateGizmo;
                        break;
                    }
                    default: {
                        this.m_gizmo = null;
                    }
                }
                return null;
            }
            case "setGridMult": {
                this.m_gridDivisions = PZMath.clamp(((Double)object).intValue(), 1, 100);
                return null;
            }
            case "setGridPlane": {
                this.m_gridPlane = GridPlane.valueOf((String)object);
                return null;
            }
            case "setMaxZoom": {
                this.m_zoomMax = PZMath.clamp(((Double)object).intValue(), 1, 20);
                return null;
            }
            case "setSelectedAttachment": {
                this.m_selectedAttachment = (String)object;
                return null;
            }
            case "setTransformMode": {
                this.m_transformMode = TransformMode.valueOf((String)object);
                return null;
            }
            case "setZoom": {
                this.m_zoom = PZMath.clamp(((Double)object).intValue(), 1, this.m_zoomMax);
                this.calcMatrices(this.m_projection, this.m_modelView);
                return null;
            }
            case "setView": {
                View view = this.m_view;
                this.m_view = View.valueOf((String)object);
                if (view != this.m_view) {
                    long l = System.currentTimeMillis();
                    if (this.m_viewChangeTime + this.VIEW_CHANGE_TIME < l) {
                        this.m_modelViewChange.setFromUnnormalized(this.m_modelView);
                    }
                    this.m_viewChangeTime = l;
                }
                this.calcMatrices(this.m_projection, this.m_modelView);
                return null;
            }
            case "zoom": {
                int n = -((Double)object).intValue();
                float f = Mouse.getXA() - this.getAbsoluteX().intValue();
                float f2 = Mouse.getYA() - this.getAbsoluteY().intValue();
                float f3 = this.uiToSceneX(f, f2);
                float f4 = this.uiToSceneY(f, f2);
                this.m_zoom = PZMath.clamp(this.m_zoom + n, 1, this.m_zoomMax);
                this.calcMatrices(this.m_projection, this.m_modelView);
                float f5 = this.uiToSceneX(f, f2);
                float f6 = this.uiToSceneY(f, f2);
                this.m_view_x = (int)((float)this.m_view_x - (f5 - f3) * this.zoomMult());
                this.m_view_y = (int)((float)this.m_view_y + (f6 - f4) * this.zoomMult());
                this.calcMatrices(this.m_projection, this.m_modelView);
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\"", string, object));
    }

    public Object fromLua2(String string, Object object, Object arrayList) {
        switch (string) {
            case "addAttachment": {
                SceneModel sceneModel = this.getSceneObjectById((String)object, SceneModel.class, true);
                if (sceneModel.m_modelScript.getAttachmentById((String)((Object)arrayList)) != null) {
                    throw new IllegalArgumentException("model script \"" + object + "\" already has attachment named \"" + arrayList + "\"");
                }
                ModelAttachment modelAttachment = new ModelAttachment((String)((Object)arrayList));
                sceneModel.m_modelScript.addAttachment(modelAttachment);
                return modelAttachment;
            }
            case "addBoneAxis": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                String string2 = (String)((Object)arrayList);
                PositionRotation positionRotation = sceneCharacter.getBoneAxis(string2, s_posRotPool.alloc());
                this.m_axes.add(positionRotation);
                return null;
            }
            case "applyDeltaRotation": {
                Vector3f vector3f = (Vector3f)object;
                Vector3f vector3f2 = (Vector3f)((Object)arrayList);
                Quaternionf quaternionf = UI3DScene.allocQuaternionf().rotationXYZ(vector3f.x * ((float)Math.PI / 180), vector3f.y * ((float)Math.PI / 180), vector3f.z * ((float)Math.PI / 180));
                Quaternionf quaternionf2 = UI3DScene.allocQuaternionf().rotationXYZ(vector3f2.x * ((float)Math.PI / 180), vector3f2.y * ((float)Math.PI / 180), vector3f2.z * ((float)Math.PI / 180));
                quaternionf.mul(quaternionf2);
                quaternionf.getEulerAnglesXYZ(vector3f);
                UI3DScene.releaseQuaternionf(quaternionf);
                UI3DScene.releaseQuaternionf(quaternionf2);
                vector3f.mul(57.295776f);
                vector3f.x = (float)Math.floor(vector3f.x + 0.5f);
                vector3f.y = (float)Math.floor(vector3f.y + 0.5f);
                vector3f.z = (float)Math.floor(vector3f.z + 0.5f);
                return vector3f;
            }
            case "createModel": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, false);
                if (sceneObject != null) {
                    throw new IllegalStateException("scene object \"" + object + "\" exists");
                }
                ModelScript modelScript = ScriptManager.instance.getModelScript((String)((Object)arrayList));
                if (modelScript == null) {
                    throw new NullPointerException("model script \"" + arrayList + "\" not found");
                }
                Model model = ModelManager.instance.getLoadedModel((String)((Object)arrayList));
                if (model == null) {
                    throw new NullPointerException("model \"" + arrayList + "\" not found");
                }
                SceneModel sceneModel = new SceneModel(this, (String)object, modelScript, model);
                this.m_objects.add(sceneModel);
                return null;
            }
            case "dragGizmo": {
                float f = ((Double)object).floatValue();
                float f2 = ((Double)((Object)arrayList)).floatValue();
                if (this.m_gizmo == null) {
                    throw new NullPointerException("gizmo is null");
                }
                this.m_gizmo.updateTracking(f, f2);
                return null;
            }
            case "dragView": {
                int n = ((Double)object).intValue();
                int n2 = ((Double)((Object)arrayList)).intValue();
                this.m_view_x -= n;
                this.m_view_y -= n2;
                this.calcMatrices(this.m_projection, this.m_modelView);
                return null;
            }
            case "getCharacterAnimationKeyframeTimes": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                AnimationPlayer animationPlayer = sceneCharacter.m_animatedModel.getAnimationPlayer();
                if (animationPlayer == null) {
                    return null;
                }
                AnimationMultiTrack animationMultiTrack = animationPlayer.getMultiTrack();
                if (animationMultiTrack == null || animationMultiTrack.getTracks().isEmpty()) {
                    return null;
                }
                AnimationTrack animationTrack = animationMultiTrack.getTracks().get(0);
                AnimationClip animationClip = animationTrack.getClip();
                if (animationClip == null) {
                    return null;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                ArrayList arrayList2 = arrayList;
                arrayList2.clear();
                Keyframe[] keyframeArray = animationClip.getKeyframes();
                for (int i = 0; i < keyframeArray.length; ++i) {
                    Keyframe keyframe = keyframeArray[i];
                    Double d = KahluaUtil.toDouble(keyframe.Time);
                    if (arrayList2.contains(d)) continue;
                    arrayList2.add(d);
                }
                return arrayList2;
            }
            case "removeAttachment": {
                SceneModel sceneModel = this.getSceneObjectById((String)object, SceneModel.class, true);
                ModelAttachment modelAttachment = sceneModel.m_modelScript.getAttachmentById((String)((Object)arrayList));
                if (modelAttachment == null) {
                    throw new IllegalArgumentException("model script \"" + object + "\" attachment \"" + arrayList + "\" not found");
                }
                sceneModel.m_modelScript.removeAttachment(modelAttachment);
                return null;
            }
            case "setCharacterAlpha": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                sceneCharacter.m_animatedModel.setAlpha(((Double)((Object)arrayList)).floatValue());
                return null;
            }
            case "setCharacterAnimate": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                sceneCharacter.m_animatedModel.setAnimate((Boolean)((Object)arrayList));
                return null;
            }
            case "setCharacterAnimationClip": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                AnimationSet animationSet = AnimationSet.GetAnimationSet(sceneCharacter.m_animatedModel.GetAnimSetName(), false);
                if (animationSet == null) {
                    return null;
                }
                AnimState animState = animationSet.GetState(sceneCharacter.m_animatedModel.getState());
                if (animState == null || animState.m_Nodes.isEmpty()) {
                    return null;
                }
                AnimNode animNode = animState.m_Nodes.get(0);
                animNode.m_AnimName = (String)((Object)arrayList);
                sceneCharacter.m_animatedModel.getAdvancedAnimator().OnAnimDataChanged(false);
                sceneCharacter.m_animatedModel.getAdvancedAnimator().SetState(animState.m_Name);
                return null;
            }
            case "setCharacterAnimationSpeed": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                AnimationMultiTrack animationMultiTrack = sceneCharacter.m_animatedModel.getAnimationPlayer().getMultiTrack();
                if (animationMultiTrack.getTracks().isEmpty()) {
                    return null;
                }
                animationMultiTrack.getTracks().get((int)0).SpeedDelta = PZMath.clamp(((Double)((Object)arrayList)).floatValue(), 0.0f, 10.0f);
                return null;
            }
            case "setCharacterAnimationTime": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                sceneCharacter.m_animatedModel.setTrackTime(((Double)((Object)arrayList)).floatValue());
                AnimationPlayer animationPlayer = sceneCharacter.m_animatedModel.getAnimationPlayer();
                if (animationPlayer == null) {
                    return null;
                }
                AnimationMultiTrack animationMultiTrack = animationPlayer.getMultiTrack();
                if (animationMultiTrack == null || animationMultiTrack.getTracks().isEmpty()) {
                    return null;
                }
                animationMultiTrack.getTracks().get(0).setCurrentTimeValue(((Double)((Object)arrayList)).floatValue());
                return null;
            }
            case "setCharacterAnimSet": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                String string3 = (String)((Object)arrayList);
                if (!string3.equals(sceneCharacter.m_animatedModel.GetAnimSetName())) {
                    sceneCharacter.m_animatedModel.setAnimSetName(string3);
                    sceneCharacter.m_animatedModel.getAdvancedAnimator().OnAnimDataChanged(false);
                    ActionGroup actionGroup = ActionGroup.getActionGroup(sceneCharacter.m_animatedModel.GetAnimSetName());
                    ActionContext actionContext = sceneCharacter.m_animatedModel.getActionContext();
                    if (actionGroup != actionContext.getGroup()) {
                        actionContext.setGroup(actionGroup);
                    }
                    sceneCharacter.m_animatedModel.getAdvancedAnimator().SetState(actionContext.getCurrentStateName(), PZArrayUtil.listConvert(actionContext.getChildStates(), actionState -> actionState.name));
                }
                return null;
            }
            case "setCharacterClearDepthBuffer": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                sceneCharacter.m_bClearDepthBuffer = (Boolean)((Object)arrayList);
                return null;
            }
            case "setCharacterFemale": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                boolean bl = (Boolean)((Object)arrayList);
                if (bl != sceneCharacter.m_animatedModel.isFemale()) {
                    sceneCharacter.m_animatedModel.setOutfitName("Naked", bl, false);
                }
                return null;
            }
            case "setCharacterShowBones": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                sceneCharacter.m_bShowBones = (Boolean)((Object)arrayList);
                return null;
            }
            case "setCharacterUseDeferredMovement": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                sceneCharacter.m_bUseDeferredMovement = (Boolean)((Object)arrayList);
                return null;
            }
            case "setGizmoOrigin": {
                String string4;
                switch (string4 = (String)object) {
                    case "centerOfMass": {
                        this.m_gizmoOrigin = this.m_gizmoParent = (SceneObject)this.getSceneObjectById((String)((Object)arrayList), SceneVehicle.class, true);
                        this.m_gizmoChild = null;
                        break;
                    }
                    case "chassis": {
                        SceneVehicle sceneVehicle = this.getSceneObjectById((String)((Object)arrayList), SceneVehicle.class, true);
                        this.m_gizmoParent = sceneVehicle;
                        this.m_originGizmo.m_translate.set(sceneVehicle.m_script.getCenterOfMassOffset());
                        this.m_originGizmo.m_rotate.zero();
                        this.m_gizmoOrigin = this.m_originGizmo;
                        this.m_gizmoChild = null;
                        break;
                    }
                    case "character": {
                        SceneCharacter sceneCharacter = this.getSceneObjectById((String)((Object)arrayList), SceneCharacter.class, true);
                        this.m_gizmoOrigin = this.m_gizmoParent = sceneCharacter;
                        this.m_gizmoChild = null;
                        break;
                    }
                    case "model": {
                        SceneModel sceneModel = this.getSceneObjectById((String)((Object)arrayList), SceneModel.class, true);
                        this.m_gizmoOrigin = this.m_gizmoParent = sceneModel;
                        this.m_gizmoChild = null;
                        break;
                    }
                    case "vehicleModel": {
                        SceneVehicle sceneVehicle = this.getSceneObjectById((String)((Object)arrayList), SceneVehicle.class, true);
                        this.m_gizmoParent = sceneVehicle;
                        this.m_originGizmo.m_translate.set(sceneVehicle.m_script.getModel().getOffset());
                        this.m_originGizmo.m_rotate.zero();
                        this.m_gizmoOrigin = this.m_originGizmo;
                        this.m_gizmoChild = null;
                        break;
                    }
                }
                return null;
            }
            case "setCharacterState": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                sceneCharacter.m_animatedModel.setState((String)((Object)arrayList));
                return null;
            }
            case "setHighlightBone": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                String string5 = (String)((Object)arrayList);
                this.m_highlightBone.m_character = sceneCharacter;
                this.m_highlightBone.m_boneName = string5;
                return null;
            }
            case "setModelUseWorldAttachment": {
                SceneModel sceneModel = this.getSceneObjectById((String)object, SceneModel.class, true);
                sceneModel.m_useWorldAttachment = (Boolean)((Object)arrayList);
                return null;
            }
            case "setModelWeaponRotationHack": {
                SceneModel sceneModel = this.getSceneObjectById((String)object, SceneModel.class, true);
                sceneModel.m_weaponRotationHack = (Boolean)((Object)arrayList);
                return null;
            }
            case "setObjectAutoRotate": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, true);
                sceneObject.m_autoRotate = (Boolean)((Object)arrayList);
                if (!sceneObject.m_autoRotate) {
                    sceneObject.m_autoRotateAngle = 0.0f;
                }
                return null;
            }
            case "setObjectVisible": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, true);
                sceneObject.m_visible = (Boolean)((Object)arrayList);
                return null;
            }
            case "setVehicleScript": {
                SceneVehicle sceneVehicle = this.getSceneObjectById((String)object, SceneVehicle.class, true);
                sceneVehicle.setScriptName((String)((Object)arrayList));
                return null;
            }
            case "testGizmoAxis": {
                int n = ((Double)object).intValue();
                int n3 = ((Double)((Object)arrayList)).intValue();
                if (this.m_gizmo == null) {
                    return "None";
                }
                return this.m_gizmo.hitTest(n, n3).toString();
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\" \"%s\"", string, object, arrayList));
    }

    public Object fromLua3(String string, Object object, Object object2, Object object3) {
        switch (string) {
            case "addAxis": {
                float f = ((Double)object).floatValue();
                float f2 = ((Double)object2).floatValue();
                float f3 = ((Double)object3).floatValue();
                this.m_axes.add(s_posRotPool.alloc().set(f, f2, f3));
                return null;
            }
            case "pickCharacterBone": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                float f = ((Double)object2).floatValue();
                float f4 = ((Double)object3).floatValue();
                return sceneCharacter.pickBone(f, f4);
            }
            case "setGizmoOrigin": {
                String string2;
                switch (string2 = (String)object) {
                    case "bone": {
                        SceneCharacter sceneCharacter = this.getSceneObjectById((String)object2, SceneCharacter.class, true);
                        this.m_gizmoParent = sceneCharacter;
                        this.m_originBone.m_character = sceneCharacter;
                        this.m_originBone.m_boneName = (String)object3;
                        this.m_gizmoOrigin = this.m_originBone;
                        this.m_gizmoChild = null;
                        break;
                    }
                }
                return null;
            }
            case "setGizmoXYZ": {
                float f = ((Double)object).floatValue();
                float f5 = ((Double)object2).floatValue();
                float f6 = ((Double)object3).floatValue();
                this.m_gizmoPos.set(f, f5, f6);
                return null;
            }
            case "startGizmoTracking": {
                float f = ((Double)object).floatValue();
                float f7 = ((Double)object2).floatValue();
                Axis axis = Axis.valueOf((String)object3);
                if (this.m_gizmo != null) {
                    this.m_gizmo.startTracking(f, f7, axis);
                }
                return null;
            }
            case "setViewRotation": {
                float f = ((Double)object).floatValue();
                float f8 = ((Double)object2).floatValue();
                float f9 = ((Double)object3).floatValue();
                this.m_viewRotation.set(f %= 360.0f, f8 %= 360.0f, f9 %= 360.0f);
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\" \"%s\" \"%s\"", string, object, object2, object3));
    }

    public Object fromLua4(String string, Object object, Object object2, Object object3, Object object4) {
        switch (string) {
            case "setGizmoOrigin": {
                String string2;
                switch (string2 = (String)object) {
                    case "attachment": {
                        SceneObject sceneObject = this.getSceneObjectById((String)object2, true);
                        this.m_originAttachment.m_object = this.m_gizmoParent = this.getSceneObjectById((String)object3, true);
                        this.m_originAttachment.m_attachmentName = (String)object4;
                        this.m_gizmoOrigin = this.m_originAttachment;
                        this.m_gizmoChild = sceneObject;
                        break;
                    }
                }
                return null;
            }
            case "setObjectParent": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, true);
                sceneObject.m_translate.zero();
                sceneObject.m_rotate.zero();
                sceneObject.m_attachment = (String)object2;
                sceneObject.m_parent = this.getSceneObjectById((String)object3, false);
                sceneObject.m_parentAttachment = (String)object4;
                if (sceneObject.m_parent != null && sceneObject.m_parent.m_parent == sceneObject) {
                    sceneObject.m_parent.m_parent = null;
                }
                return null;
            }
            case "setObjectPosition": {
                SceneObject sceneObject = this.getSceneObjectById((String)object, true);
                sceneObject.m_translate.set(((Double)object2).floatValue(), ((Double)object3).floatValue(), ((Double)object4).floatValue());
                return null;
            }
            case "setPassengerPosition": {
                SceneCharacter sceneCharacter = this.getSceneObjectById((String)object, SceneCharacter.class, true);
                SceneVehicle sceneVehicle = this.getSceneObjectById((String)object2, SceneVehicle.class, true);
                VehicleScript.Passenger passenger = sceneVehicle.m_script.getPassengerById((String)object3);
                if (passenger == null) {
                    return null;
                }
                VehicleScript.Position position = passenger.getPositionById((String)object4);
                if (position != null) {
                    this.tempVector3f.set(sceneVehicle.m_script.getModel().getOffset());
                    this.tempVector3f.add(position.getOffset());
                    this.tempVector3f.z *= -1.0f;
                    sceneCharacter.m_translate.set(this.tempVector3f);
                    sceneCharacter.m_rotate.set(position.rotate);
                    sceneCharacter.m_parent = sceneVehicle;
                    if (sceneCharacter.m_animatedModel != null) {
                        String string3;
                        String string4 = string3 = "inside".equalsIgnoreCase(position.getId()) ? "player-vehicle" : "player-editor";
                        if (!string3.equals(sceneCharacter.m_animatedModel.GetAnimSetName())) {
                            sceneCharacter.m_animatedModel.setAnimSetName(string3);
                            sceneCharacter.m_animatedModel.getAdvancedAnimator().OnAnimDataChanged(false);
                            ActionGroup actionGroup = ActionGroup.getActionGroup(sceneCharacter.m_animatedModel.GetAnimSetName());
                            ActionContext actionContext = sceneCharacter.m_animatedModel.getActionContext();
                            if (actionGroup != actionContext.getGroup()) {
                                actionContext.setGroup(actionGroup);
                            }
                            sceneCharacter.m_animatedModel.getAdvancedAnimator().SetState(actionContext.getCurrentStateName(), PZArrayUtil.listConvert(actionContext.getChildStates(), actionState -> actionState.name));
                        }
                    }
                }
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\" \"%s\" \"%s\"", string, object, object2, object3));
    }

    public Object fromLua6(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        switch (string) {
            case "addAABB": {
                float f = ((Double)object).floatValue();
                float f2 = ((Double)object2).floatValue();
                float f3 = ((Double)object3).floatValue();
                float f4 = ((Double)object4).floatValue();
                float f5 = ((Double)object5).floatValue();
                float f6 = ((Double)object6).floatValue();
                this.m_aabb.add(s_aabbPool.alloc().set(f, f2, f3, f4, f5, f6, 1.0f, 1.0f, 1.0f));
                return null;
            }
            case "addAxis": {
                float f = ((Double)object).floatValue();
                float f7 = ((Double)object2).floatValue();
                float f8 = ((Double)object3).floatValue();
                float f9 = ((Double)object4).floatValue();
                float f10 = ((Double)object5).floatValue();
                float f11 = ((Double)object6).floatValue();
                this.m_axes.add(s_posRotPool.alloc().set(f, f7, f8, f9, f10, f11));
                return null;
            }
            case "addBox3D": {
                Vector3f vector3f = (Vector3f)object;
                Vector3f vector3f2 = (Vector3f)object2;
                Vector3f vector3f3 = (Vector3f)object3;
                float f = ((Double)object4).floatValue();
                float f12 = ((Double)object5).floatValue();
                float f13 = ((Double)object6).floatValue();
                this.m_box3D.add(s_box3DPool.alloc().set(vector3f.x, vector3f.y, vector3f.z, vector3f2.x, vector3f2.y, vector3f2.z, vector3f3.x, vector3f3.y, vector3f3.z, f, f12, f13));
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\"", string, object, object2, object3, object4, object5, object6));
    }

    public Object fromLua9(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        switch (string) {
            case "addAABB": {
                float f = ((Double)object).floatValue();
                float f2 = ((Double)object2).floatValue();
                float f3 = ((Double)object3).floatValue();
                float f4 = ((Double)object4).floatValue();
                float f5 = ((Double)object5).floatValue();
                float f6 = ((Double)object6).floatValue();
                float f7 = ((Double)object7).floatValue();
                float f8 = ((Double)object8).floatValue();
                float f9 = ((Double)object9).floatValue();
                this.m_aabb.add(s_aabbPool.alloc().set(f, f2, f3, f4, f5, f6, f7, f8, f9));
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\"", string, object, object2, object3, object4, object5, object6, object7, object8, object9));
    }

    private int screenWidth() {
        return (int)this.width;
    }

    private int screenHeight() {
        return (int)this.height;
    }

    public float uiToSceneX(float f, float f2) {
        float f3 = f - (float)this.screenWidth() / 2.0f;
        f3 += (float)this.m_view_x;
        return f3 /= this.zoomMult();
    }

    public float uiToSceneY(float f, float f2) {
        float f3 = f2 - (float)this.screenHeight() / 2.0f;
        f3 *= -1.0f;
        f3 -= (float)this.m_view_y;
        return f3 /= this.zoomMult();
    }

    public Vector3f uiToScene(float f, float f2, float f3, Vector3f vector3f) {
        this.uiToScene(null, f, f2, f3, vector3f);
        switch (this.m_view) {
            case Left: 
            case Right: {
                vector3f.x = 0.0f;
                break;
            }
            case Top: 
            case Bottom: {
                vector3f.y = 0.0f;
                break;
            }
            case Front: 
            case Back: {
                vector3f.z = 0.0f;
            }
        }
        return vector3f;
    }

    public Vector3f uiToScene(org.joml.Matrix4f matrix4f, float f, float f2, float f3, Vector3f vector3f) {
        f2 = (float)this.screenHeight() - f2;
        org.joml.Matrix4f matrix4f2 = UI3DScene.allocMatrix4f();
        matrix4f2.set(this.m_projection);
        matrix4f2.mul(this.m_modelView);
        if (matrix4f != null) {
            matrix4f2.mul(matrix4f);
        }
        matrix4f2.invert();
        this.m_viewport[2] = this.screenWidth();
        this.m_viewport[3] = this.screenHeight();
        matrix4f2.unprojectInv(f, f2, f3, this.m_viewport, vector3f);
        UI3DScene.releaseMatrix4f(matrix4f2);
        return vector3f;
    }

    public float sceneToUIX(float f, float f2, float f3) {
        this.tempVector4f.set(f, f2, f3, 1.0f);
        org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
        matrix4f.set(this.m_projection);
        matrix4f.mul(this.m_modelView);
        this.m_viewport[2] = this.screenWidth();
        this.m_viewport[3] = this.screenHeight();
        matrix4f.project(f, f2, f3, this.m_viewport, this.tempVector3f);
        UI3DScene.releaseMatrix4f(matrix4f);
        return this.tempVector3f.x();
    }

    public float sceneToUIY(float f, float f2, float f3) {
        this.tempVector4f.set(f, f2, f3, 1.0f);
        org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
        matrix4f.set(this.m_projection);
        matrix4f.mul(this.m_modelView);
        int[] nArray = new int[]{0, 0, this.screenWidth(), this.screenHeight()};
        matrix4f.project(f, f2, f3, nArray, this.tempVector3f);
        UI3DScene.releaseMatrix4f(matrix4f);
        return (float)this.screenHeight() - this.tempVector3f.y();
    }

    private void renderGridXY(int n) {
        int n2;
        int n3;
        for (n3 = -5; n3 < 5; ++n3) {
            for (n2 = 1; n2 < n; ++n2) {
                vboLines.addLine((float)n3 + (float)n2 / (float)n, -5.0f, 0.0f, (float)n3 + (float)n2 / (float)n, 5.0f, 0.0f, 0.2f, 0.2f, 0.2f, this.GRID_ALPHA);
            }
        }
        for (n3 = -5; n3 < 5; ++n3) {
            for (n2 = 1; n2 < n; ++n2) {
                vboLines.addLine(-5.0f, (float)n3 + (float)n2 / (float)n, 0.0f, 5.0f, (float)n3 + (float)n2 / (float)n, 0.0f, 0.2f, 0.2f, 0.2f, this.GRID_ALPHA);
            }
        }
        for (n3 = -5; n3 <= 5; ++n3) {
            vboLines.addLine(n3, -5.0f, 0.0f, n3, 5.0f, 0.0f, 0.1f, 0.1f, 0.1f, this.GRID_ALPHA);
        }
        for (n3 = -5; n3 <= 5; ++n3) {
            vboLines.addLine(-5.0f, n3, 0.0f, 5.0f, n3, 0.0f, 0.1f, 0.1f, 0.1f, this.GRID_ALPHA);
        }
        if (this.m_bDrawGridAxes) {
            n3 = 0;
            vboLines.addLine(-5.0f, 0.0f, n3, 5.0f, 0.0f, n3, 1.0f, 0.0f, 0.0f, this.GRID_ALPHA);
            n3 = 0;
            vboLines.addLine(0.0f, -5.0f, n3, 0.0f, 5.0f, n3, 0.0f, 1.0f, 0.0f, this.GRID_ALPHA);
        }
    }

    private void renderGridXZ(int n) {
        int n2;
        int n3;
        for (n3 = -5; n3 < 5; ++n3) {
            for (n2 = 1; n2 < n; ++n2) {
                vboLines.addLine((float)n3 + (float)n2 / (float)n, 0.0f, -5.0f, (float)n3 + (float)n2 / (float)n, 0.0f, 5.0f, 0.2f, 0.2f, 0.2f, this.GRID_ALPHA);
            }
        }
        for (n3 = -5; n3 < 5; ++n3) {
            for (n2 = 1; n2 < n; ++n2) {
                vboLines.addLine(-5.0f, 0.0f, (float)n3 + (float)n2 / (float)n, 5.0f, 0.0f, (float)n3 + (float)n2 / (float)n, 0.2f, 0.2f, 0.2f, this.GRID_ALPHA);
            }
        }
        for (n3 = -5; n3 <= 5; ++n3) {
            vboLines.addLine(n3, 0.0f, -5.0f, n3, 0.0f, 5.0f, 0.1f, 0.1f, 0.1f, this.GRID_ALPHA);
        }
        for (n3 = -5; n3 <= 5; ++n3) {
            vboLines.addLine(-5.0f, 0.0f, n3, 5.0f, 0.0f, n3, 0.1f, 0.1f, 0.1f, this.GRID_ALPHA);
        }
        if (this.m_bDrawGridAxes) {
            n3 = 0;
            vboLines.addLine(-5.0f, 0.0f, n3, 5.0f, 0.0f, n3, 1.0f, 0.0f, 0.0f, this.GRID_ALPHA);
            n3 = 0;
            vboLines.addLine(n3, 0.0f, -5.0f, n3, 0.0f, 5.0f, 0.0f, 0.0f, 1.0f, this.GRID_ALPHA);
        }
    }

    private void renderGridYZ(int n) {
        int n2;
        int n3;
        for (n3 = -5; n3 < 5; ++n3) {
            for (n2 = 1; n2 < n; ++n2) {
                vboLines.addLine(0.0f, (float)n3 + (float)n2 / (float)n, -5.0f, 0.0f, (float)n3 + (float)n2 / (float)n, 5.0f, 0.2f, 0.2f, 0.2f, this.GRID_ALPHA);
            }
        }
        for (n3 = -5; n3 < 5; ++n3) {
            for (n2 = 1; n2 < n; ++n2) {
                vboLines.addLine(0.0f, -5.0f, (float)n3 + (float)n2 / (float)n, 0.0f, 5.0f, (float)n3 + (float)n2 / (float)n, 0.2f, 0.2f, 0.2f, this.GRID_ALPHA);
            }
        }
        for (n3 = -5; n3 <= 5; ++n3) {
            vboLines.addLine(0.0f, n3, -5.0f, 0.0f, n3, 5.0f, 0.1f, 0.1f, 0.1f, this.GRID_ALPHA);
        }
        for (n3 = -5; n3 <= 5; ++n3) {
            vboLines.addLine(0.0f, -5.0f, n3, 0.0f, 5.0f, n3, 0.1f, 0.1f, 0.1f, this.GRID_ALPHA);
        }
        if (this.m_bDrawGridAxes) {
            n3 = 0;
            vboLines.addLine(0.0f, -5.0f, n3, 0.0f, 5.0f, n3, 0.0f, 1.0f, 0.0f, this.GRID_ALPHA);
            n3 = 0;
            vboLines.addLine(n3, 0.0f, -5.0f, n3, 0.0f, 5.0f, 0.0f, 0.0f, 1.0f, this.GRID_ALPHA);
        }
    }

    private void renderGrid() {
        vboLines.setLineWidth(1.0f);
        this.GRID_ALPHA = 1.0f;
        long l = System.currentTimeMillis();
        if (this.m_viewChangeTime + this.VIEW_CHANGE_TIME > l) {
            float f = (float)(this.m_viewChangeTime + this.VIEW_CHANGE_TIME - l) / (float)this.VIEW_CHANGE_TIME;
            this.GRID_ALPHA = 1.0f - f;
            this.GRID_ALPHA *= this.GRID_ALPHA;
        }
        switch (this.m_view) {
            case Left: 
            case Right: {
                this.renderGridYZ(10);
                return;
            }
            case Front: 
            case Back: {
                this.renderGridXY(10);
                return;
            }
            case Top: 
            case Bottom: {
                this.renderGridXZ(10);
                return;
            }
        }
        switch (this.m_gridPlane) {
            case XY: {
                this.renderGridXY(10);
                break;
            }
            case XZ: {
                this.renderGridXZ(10);
                break;
            }
            case YZ: {
                this.renderGridYZ(10);
            }
        }
    }

    void renderAxis(PositionRotation positionRotation) {
        this.renderAxis(positionRotation.pos, positionRotation.rot);
    }

    void renderAxis(Vector3f vector3f, Vector3f vector3f2) {
        StateData stateData = this.stateDataRender();
        vboLines.flush();
        org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
        matrix4f.set(stateData.m_gizmoParentTransform);
        matrix4f.mul(stateData.m_gizmoOriginTransform);
        matrix4f.mul(stateData.m_gizmoChildTransform);
        matrix4f.translate(vector3f);
        matrix4f.rotateXYZ(vector3f2.x * ((float)Math.PI / 180), vector3f2.y * ((float)Math.PI / 180), vector3f2.z * ((float)Math.PI / 180));
        stateData.m_modelView.mul(matrix4f, matrix4f);
        PZGLUtil.pushAndLoadMatrix(5888, matrix4f);
        UI3DScene.releaseMatrix4f(matrix4f);
        float f = 0.1f;
        vboLines.setLineWidth(3.0f);
        vboLines.addLine(0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        vboLines.addLine(0.0f, 0.0f, 0.0f, 0.0f, 0.0f + f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        vboLines.addLine(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f + f, 0.0f, 0.0f, 1.0f, 1.0f);
        vboLines.flush();
        PZGLUtil.popMatrix(5888);
    }

    private void renderAABB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f4 / 2.0f;
        float f11 = f5 / 2.0f;
        float f12 = f6 / 2.0f;
        vboLines.setOffset(f, f2, f3);
        vboLines.setLineWidth(1.0f);
        float f13 = 1.0f;
        vboLines.addLine(f10, f11, f12, -f10, f11, f12, f7, f8, f9, f13);
        vboLines.addLine(f10, f11, f12, f10, -f11, f12, f7, f8, f9, f13);
        vboLines.addLine(f10, f11, f12, f10, f11, -f12, f7, f8, f9, f13);
        vboLines.addLine(-f10, f11, f12, -f10, -f11, f12, f7, f8, f9, f13);
        vboLines.addLine(-f10, f11, f12, -f10, f11, -f12, f7, f8, f9, f13);
        vboLines.addLine(f10, f11, -f12, f10, -f11, -f12, f7, f8, f9, f13);
        vboLines.addLine(f10, f11, -f12, -f10, f11, -f12, f7, f8, f9, f13);
        vboLines.addLine(-f10, f11, -f12, -f10, -f11, -f12, f7, f8, f9, f13);
        vboLines.addLine(f10, -f11, -f12, -f10, -f11, -f12, f7, f8, f9, f13);
        vboLines.addLine(f10, -f11, f12, f10, -f11, -f12, f7, f8, f9, f13);
        vboLines.addLine(-f10, -f11, f12, -f10, -f11, -f12, f7, f8, f9, f13);
        vboLines.addLine(f10, -f11, f12, -f10, -f11, f12, f7, f8, f9, f13);
        vboLines.setOffset(0.0f, 0.0f, 0.0f);
    }

    private void renderAABB(float f, float f2, float f3, Vector3f vector3f, Vector3f vector3f2, float f4, float f5, float f6) {
        vboLines.setOffset(f, f2, f3);
        vboLines.setLineWidth(1.0f);
        float f7 = 1.0f;
        vboLines.addLine(vector3f2.x, vector3f2.y, vector3f2.z, vector3f.x, vector3f2.y, vector3f2.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f2.x, vector3f2.y, vector3f2.z, vector3f2.x, vector3f.y, vector3f2.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f2.x, vector3f2.y, vector3f2.z, vector3f2.x, vector3f2.y, vector3f.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f.x, vector3f2.y, vector3f2.z, vector3f.x, vector3f.y, vector3f2.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f.x, vector3f2.y, vector3f2.z, vector3f.x, vector3f2.y, vector3f.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f2.x, vector3f2.y, vector3f.z, vector3f2.x, vector3f.y, vector3f.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f2.x, vector3f2.y, vector3f.z, vector3f.x, vector3f2.y, vector3f.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f.x, vector3f2.y, vector3f.z, vector3f.x, vector3f.y, vector3f.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f2.x, vector3f.y, vector3f.z, vector3f.x, vector3f.y, vector3f.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f2.x, vector3f.y, vector3f2.z, vector3f2.x, vector3f.y, vector3f.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f.x, vector3f.y, vector3f2.z, vector3f.x, vector3f.y, vector3f.z, f4, f5, f6, f7);
        vboLines.addLine(vector3f2.x, vector3f.y, vector3f2.z, vector3f.x, vector3f.y, vector3f2.z, f4, f5, f6, f7);
        vboLines.setOffset(0.0f, 0.0f, 0.0f);
    }

    private void renderBox3D(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        StateData stateData = this.stateDataRender();
        vboLines.flush();
        org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
        matrix4f.identity();
        matrix4f.translate(f, f2, f3);
        matrix4f.rotateXYZ(f7 * ((float)Math.PI / 180), f8 * ((float)Math.PI / 180), f9 * ((float)Math.PI / 180));
        stateData.m_modelView.mul(matrix4f, matrix4f);
        PZGLUtil.pushAndLoadMatrix(5888, matrix4f);
        UI3DScene.releaseMatrix4f(matrix4f);
        this.renderAABB(f * 0.0f, f2 * 0.0f, f3 * 0.0f, f4, f5, f6, f10, f11, f12);
        vboLines.flush();
        PZGLUtil.popMatrix(5888);
    }

    private void calcMatrices(org.joml.Matrix4f matrix4f, org.joml.Matrix4f matrix4f2) {
        float f = this.screenWidth();
        float f2 = 1366.0f / f;
        float f3 = (float)this.screenHeight() * f2;
        f = 1366.0f;
        matrix4f.setOrtho(-(f /= this.zoomMult()) / 2.0f, f / 2.0f, -(f3 /= this.zoomMult()) / 2.0f, f3 / 2.0f, -10.0f, 10.0f);
        float f4 = (float)this.m_view_x / this.zoomMult() * f2;
        float f5 = (float)this.m_view_y / this.zoomMult() * f2;
        matrix4f.translate(-f4, f5, 0.0f);
        matrix4f2.identity();
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        switch (this.m_view) {
            case Left: {
                f7 = 270.0f;
                break;
            }
            case Right: {
                f7 = 90.0f;
                break;
            }
            case Front: {
                break;
            }
            case Back: {
                f7 = 180.0f;
                break;
            }
            case Top: {
                f7 = 90.0f;
                f8 = 90.0f;
                break;
            }
            case Bottom: {
                f7 = 90.0f;
                f8 = 270.0f;
                break;
            }
            case UserDefined: {
                f6 = this.m_viewRotation.x;
                f7 = this.m_viewRotation.y;
                f8 = this.m_viewRotation.z;
            }
        }
        matrix4f2.rotateXYZ(f6 * ((float)Math.PI / 180), f7 * ((float)Math.PI / 180), f8 * ((float)Math.PI / 180));
    }

    Ray getCameraRay(float f, float f2, Ray ray) {
        return this.getCameraRay(f, f2, this.m_projection, this.m_modelView, ray);
    }

    Ray getCameraRay(float f, float f2, org.joml.Matrix4f matrix4f, org.joml.Matrix4f matrix4f2, Ray ray) {
        org.joml.Matrix4f matrix4f3 = UI3DScene.allocMatrix4f();
        matrix4f3.set(matrix4f);
        matrix4f3.mul(matrix4f2);
        matrix4f3.invert();
        this.m_viewport[2] = this.screenWidth();
        this.m_viewport[3] = this.screenHeight();
        Vector3f vector3f = matrix4f3.unprojectInv(f, f2, 0.0f, this.m_viewport, UI3DScene.allocVector3f());
        Vector3f vector3f2 = matrix4f3.unprojectInv(f, f2, 1.0f, this.m_viewport, UI3DScene.allocVector3f());
        ray.origin.set(vector3f);
        ray.direction.set(vector3f2.sub(vector3f).normalize());
        UI3DScene.releaseVector3f(vector3f2);
        UI3DScene.releaseVector3f(vector3f);
        UI3DScene.releaseMatrix4f(matrix4f3);
        return ray;
    }

    float closest_distance_between_lines(Ray ray, Ray ray2) {
        float f;
        float f2;
        Vector3f vector3f = UI3DScene.allocVector3f().set(ray.direction);
        Vector3f vector3f2 = UI3DScene.allocVector3f().set(ray2.direction);
        Vector3f vector3f3 = UI3DScene.allocVector3f().set(ray.origin).sub(ray2.origin);
        float f3 = vector3f.dot(vector3f);
        float f4 = vector3f.dot(vector3f2);
        float f5 = vector3f2.dot(vector3f2);
        float f6 = vector3f.dot(vector3f3);
        float f7 = vector3f2.dot(vector3f3);
        float f8 = f3 * f5 - f4 * f4;
        if (f8 < 1.0E-8f) {
            f2 = 0.0f;
            f = f4 > f5 ? f6 / f4 : f7 / f5;
        } else {
            f2 = (f4 * f7 - f5 * f6) / f8;
            f = (f3 * f7 - f4 * f6) / f8;
        }
        Vector3f vector3f4 = vector3f3.add(vector3f.mul(f2)).sub(vector3f2.mul(f));
        ray.t = f2;
        ray2.t = f;
        UI3DScene.releaseVector3f(vector3f);
        UI3DScene.releaseVector3f(vector3f2);
        UI3DScene.releaseVector3f(vector3f3);
        return vector3f4.length();
    }

    Vector3f project(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        return vector3f3.set(vector3f2).mul(vector3f.dot(vector3f2) / vector3f2.dot(vector3f2));
    }

    Vector3f reject(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Vector3f vector3f4 = this.project(vector3f, vector3f2, UI3DScene.allocVector3f());
        vector3f3.set(vector3f).sub(vector3f4);
        UI3DScene.releaseVector3f(vector3f4);
        return vector3f3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int intersect_ray_plane(Plane plane, Ray ray, Vector3f vector3f) {
        Vector3f vector3f2 = UI3DScene.allocVector3f().set(ray.direction).mul(100.0f);
        Vector3f vector3f3 = UI3DScene.allocVector3f().set(ray.origin).sub(plane.point);
        try {
            float f = plane.normal.dot(vector3f2);
            float f2 = -plane.normal.dot(vector3f3);
            if (Math.abs(f) < 1.0E-8f) {
                if (f2 == 0.0f) {
                    int n = 2;
                    return n;
                }
                int n = 0;
                return n;
            }
            float f3 = f2 / f;
            if (f3 < 0.0f || f3 > 1.0f) {
                int n = 0;
                return n;
            }
            vector3f.set(ray.origin).add(vector3f2.mul(f3));
            int n = 1;
            return n;
        }
        finally {
            UI3DScene.releaseVector3f(vector3f2);
            UI3DScene.releaseVector3f(vector3f3);
        }
    }

    float distance_between_point_ray(Vector3f vector3f, Ray ray) {
        Vector3f vector3f2 = UI3DScene.allocVector3f().set(ray.direction).mul(100.0f);
        Vector3f vector3f3 = UI3DScene.allocVector3f().set(vector3f).sub(ray.origin);
        float f = vector3f3.dot(vector3f2);
        float f2 = vector3f2.dot(vector3f2);
        float f3 = f / f2;
        Vector3f vector3f4 = vector3f2.mul(f3).add(ray.origin);
        float f4 = vector3f4.sub(vector3f).length();
        UI3DScene.releaseVector3f(vector3f3);
        UI3DScene.releaseVector3f(vector3f2);
        return f4;
    }

    float closest_distance_line_circle(Ray ray, Circle circle, Vector3f vector3f) {
        float f;
        Vector3f vector3f2;
        Plane plane = UI3DScene.allocPlane().set(circle.orientation, circle.center);
        if (UI3DScene.intersect_ray_plane(plane, ray, vector3f2 = UI3DScene.allocVector3f()) == 1) {
            vector3f.set(vector3f2).sub(circle.center).normalize().mul(circle.radius).add(circle.center);
            f = vector3f2.sub(vector3f).length();
        } else {
            Vector3f vector3f3 = UI3DScene.allocVector3f().set(ray.origin).sub(circle.center);
            Vector3f vector3f4 = this.reject(vector3f3, circle.orientation, UI3DScene.allocVector3f());
            vector3f.set(vector3f4.normalize().mul(circle.radius).add(circle.center));
            f = this.distance_between_point_ray(vector3f, ray);
            UI3DScene.releaseVector3f(vector3f4);
            UI3DScene.releaseVector3f(vector3f3);
        }
        UI3DScene.releaseVector3f(vector3f2);
        UI3DScene.releasePlane(plane);
        return f;
    }

    private StateData stateDataMain() {
        return this.m_stateData[SpriteRenderer.instance.getMainStateIndex()];
    }

    private StateData stateDataRender() {
        return this.m_stateData[SpriteRenderer.instance.getRenderStateIndex()];
    }

    private static enum View {
        Left,
        Right,
        Top,
        Bottom,
        Front,
        Back,
        UserDefined;

    }

    private static enum TransformMode {
        Global,
        Local;

    }

    private static enum GridPlane {
        XY,
        XZ,
        YZ;

    }

    private final class CharacterSceneModelCamera
    extends SceneModelCamera {
        private CharacterSceneModelCamera() {
        }

        @Override
        public void Begin() {
            StateData stateData = UI3DScene.this.stateDataRender();
            GL11.glViewport((int)UI3DScene.this.getAbsoluteX().intValue(), (int)(Core.getInstance().getScreenHeight() - UI3DScene.this.getAbsoluteY().intValue() - UI3DScene.this.getHeight().intValue()), (int)UI3DScene.this.getWidth().intValue(), (int)UI3DScene.this.getHeight().intValue());
            PZGLUtil.pushAndLoadMatrix(5889, stateData.m_projection);
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            matrix4f.set(stateData.m_modelView);
            matrix4f.mul(this.m_renderData.m_transform);
            PZGLUtil.pushAndLoadMatrix(5888, matrix4f);
            UI3DScene.releaseMatrix4f(matrix4f);
        }

        @Override
        public void End() {
            PZGLUtil.popMatrix(5889);
            PZGLUtil.popMatrix(5888);
        }
    }

    private final class VehicleSceneModelCamera
    extends SceneModelCamera {
        private VehicleSceneModelCamera() {
        }

        @Override
        public void Begin() {
            StateData stateData = UI3DScene.this.stateDataRender();
            GL11.glViewport((int)UI3DScene.this.getAbsoluteX().intValue(), (int)(Core.getInstance().getScreenHeight() - UI3DScene.this.getAbsoluteY().intValue() - UI3DScene.this.getHeight().intValue()), (int)UI3DScene.this.getWidth().intValue(), (int)UI3DScene.this.getHeight().intValue());
            PZGLUtil.pushAndLoadMatrix(5889, stateData.m_projection);
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            matrix4f.set(stateData.m_modelView);
            matrix4f.mul(this.m_renderData.m_transform);
            PZGLUtil.pushAndLoadMatrix(5888, matrix4f);
            UI3DScene.releaseMatrix4f(matrix4f);
            GL11.glDepthRange((double)0.0, (double)1.0);
            GL11.glDepthMask((boolean)true);
        }

        @Override
        public void End() {
            PZGLUtil.popMatrix(5889);
            PZGLUtil.popMatrix(5888);
        }
    }

    private static final class StateData {
        final org.joml.Matrix4f m_projection = new org.joml.Matrix4f();
        final org.joml.Matrix4f m_modelView = new org.joml.Matrix4f();
        int m_zoom;
        GridPlaneDrawer m_gridPlaneDrawer;
        OverlaysDrawer m_overlaysDrawer;
        final ArrayList<SceneObjectRenderData> m_objectData = new ArrayList();
        Gizmo m_gizmo = null;
        final Vector3f m_gizmoTranslate = new Vector3f();
        final Vector3f m_gizmoRotate = new Vector3f();
        final org.joml.Matrix4f m_gizmoParentTransform = new org.joml.Matrix4f();
        final org.joml.Matrix4f m_gizmoOriginTransform = new org.joml.Matrix4f();
        final org.joml.Matrix4f m_gizmoChildTransform = new org.joml.Matrix4f();
        final org.joml.Matrix4f m_gizmoTransform = new org.joml.Matrix4f();
        boolean m_hasGizmoOrigin;
        boolean m_selectedAttachmentIsChildAttachment;
        Axis m_gizmoAxis = Axis.None;
        final TranslateGizmoRenderData m_translateGizmoRenderData = new TranslateGizmoRenderData();
        final ArrayList<PositionRotation> m_axes = new ArrayList();
        final ArrayList<AABB> m_aabb = new ArrayList();
        final ArrayList<Box3D> m_box3D = new ArrayList();

        private StateData() {
        }

        private float zoomMult() {
            return (float)Math.exp((float)this.m_zoom * 0.2f) * 160.0f / Math.max(1.82f, 1.0f);
        }
    }

    private final class RotateGizmo
    extends Gizmo {
        Axis m_trackAxis;
        final Circle m_trackCircle;
        final org.joml.Matrix4f m_startXfrm;
        final org.joml.Matrix4f m_startInvXfrm;
        final Vector3f m_startPointOnCircle;
        final Vector3f m_currentPointOnCircle;
        final ArrayList<Vector3f> m_circlePointsMain;
        final ArrayList<Vector3f> m_circlePointsRender;

        private RotateGizmo() {
            this.m_trackAxis = Axis.None;
            this.m_trackCircle = new Circle();
            this.m_startXfrm = new org.joml.Matrix4f();
            this.m_startInvXfrm = new org.joml.Matrix4f();
            this.m_startPointOnCircle = new Vector3f();
            this.m_currentPointOnCircle = new Vector3f();
            this.m_circlePointsMain = new ArrayList();
            this.m_circlePointsRender = new ArrayList();
        }

        @Override
        Axis hitTest(float f, float f2) {
            if (!this.m_visible) {
                return Axis.None;
            }
            StateData stateData = UI3DScene.this.stateDataMain();
            f2 = (float)UI3DScene.this.screenHeight() - f2;
            Ray ray = UI3DScene.this.getCameraRay(f, f2, UI3DScene.allocRay());
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            matrix4f.set(stateData.m_gizmoParentTransform);
            matrix4f.mul(stateData.m_gizmoOriginTransform);
            matrix4f.mul(stateData.m_gizmoChildTransform);
            matrix4f.mul(stateData.m_gizmoTransform);
            Vector3f vector3f = matrix4f.getScale(UI3DScene.allocVector3f());
            matrix4f.scale(1.0f / vector3f.x, 1.0f / vector3f.y, 1.0f / vector3f.z);
            UI3DScene.releaseVector3f(vector3f);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                matrix4f.setRotationXYZ(0.0f, 0.0f, 0.0f);
            }
            float f3 = UI3DScene.this.m_gizmoScale / stateData.zoomMult() * 1000.0f;
            float f4 = this.LENGTH * f3;
            Vector3f vector3f2 = matrix4f.transformProject(UI3DScene.allocVector3f().set(0.0f, 0.0f, 0.0f));
            Vector3f vector3f3 = matrix4f.transformDirection(UI3DScene.allocVector3f().set(1.0f, 0.0f, 0.0f)).normalize();
            Vector3f vector3f4 = matrix4f.transformDirection(UI3DScene.allocVector3f().set(0.0f, 1.0f, 0.0f)).normalize();
            Vector3f vector3f5 = matrix4f.transformDirection(UI3DScene.allocVector3f().set(0.0f, 0.0f, 1.0f)).normalize();
            Vector2 vector22 = UI3DScene.allocVector2();
            this.getCircleSegments(vector3f2, f4, vector3f4, vector3f5, this.m_circlePointsMain);
            float f5 = this.hitTestCircle(ray, this.m_circlePointsMain, vector22);
            BaseVehicle.TL_vector3f_pool.get().release(this.m_circlePointsMain);
            this.m_circlePointsMain.clear();
            this.getCircleSegments(vector3f2, f4, vector3f3, vector3f5, this.m_circlePointsMain);
            float f6 = this.hitTestCircle(ray, this.m_circlePointsMain, vector22);
            BaseVehicle.TL_vector3f_pool.get().release(this.m_circlePointsMain);
            this.m_circlePointsMain.clear();
            this.getCircleSegments(vector3f2, f4, vector3f3, vector3f4, this.m_circlePointsMain);
            float f7 = this.hitTestCircle(ray, this.m_circlePointsMain, vector22);
            BaseVehicle.TL_vector3f_pool.get().release(this.m_circlePointsMain);
            this.m_circlePointsMain.clear();
            UI3DScene.releaseVector2(vector22);
            UI3DScene.releaseVector3f(vector3f3);
            UI3DScene.releaseVector3f(vector3f4);
            UI3DScene.releaseVector3f(vector3f5);
            UI3DScene.releaseVector3f(vector3f2);
            UI3DScene.releaseRay(ray);
            UI3DScene.releaseMatrix4f(matrix4f);
            float f8 = 8.0f;
            if (f5 < f6 && f5 < f7) {
                return f5 <= f8 ? Axis.X : Axis.None;
            }
            if (f6 < f5 && f6 < f7) {
                return f6 <= f8 ? Axis.Y : Axis.None;
            }
            if (f7 < f5 && f7 < f6) {
                return f7 <= f8 ? Axis.Z : Axis.None;
            }
            return Axis.None;
        }

        @Override
        void startTracking(float f, float f2, Axis axis) {
            StateData stateData = UI3DScene.this.stateDataMain();
            this.m_startXfrm.set(stateData.m_gizmoParentTransform);
            this.m_startXfrm.mul(stateData.m_gizmoOriginTransform);
            this.m_startXfrm.mul(stateData.m_gizmoChildTransform);
            this.m_startXfrm.mul(stateData.m_gizmoTransform);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                this.m_startXfrm.setRotationXYZ(0.0f, 0.0f, 0.0f);
            }
            this.m_startInvXfrm.set(stateData.m_gizmoParentTransform);
            this.m_startInvXfrm.mul(stateData.m_gizmoOriginTransform);
            this.m_startInvXfrm.mul(stateData.m_gizmoChildTransform);
            this.m_startInvXfrm.mul(stateData.m_gizmoTransform);
            this.m_startInvXfrm.invert();
            this.m_trackAxis = axis;
            this.getPointOnAxis(f, f2, axis, this.m_trackCircle, this.m_startXfrm, this.m_startPointOnCircle);
        }

        @Override
        void updateTracking(float f, float f2) {
            Vector3f vector3f = this.getPointOnAxis(f, f2, this.m_trackAxis, this.m_trackCircle, this.m_startXfrm, UI3DScene.allocVector3f());
            if (this.m_currentPointOnCircle.equals(vector3f)) {
                UI3DScene.releaseVector3f(vector3f);
                return;
            }
            this.m_currentPointOnCircle.set(vector3f);
            UI3DScene.releaseVector3f(vector3f);
            float f3 = this.calculateRotation(this.m_startPointOnCircle, this.m_currentPointOnCircle, this.m_trackCircle);
            switch (this.m_trackAxis) {
                case X: {
                    this.m_trackCircle.orientation.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                case Y: {
                    this.m_trackCircle.orientation.set(0.0f, 1.0f, 0.0f);
                    break;
                }
                case Z: {
                    this.m_trackCircle.orientation.set(0.0f, 0.0f, 1.0f);
                }
            }
            Vector3f vector3f2 = UI3DScene.allocVector3f().set(this.m_trackCircle.orientation);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                this.m_startInvXfrm.transformDirection(vector3f2);
            }
            Object object = UI3DScene.this.getCameraRay(f, f2, UI3DScene.allocRay());
            Vector3f vector3f3 = this.m_startXfrm.transformDirection(UI3DScene.allocVector3f().set(vector3f2)).normalize();
            float f4 = ((Ray)object).direction.dot(vector3f3);
            UI3DScene.releaseVector3f(vector3f3);
            UI3DScene.releaseRay((Ray)object);
            if (UI3DScene.this.m_gizmoParent instanceof SceneCharacter) {
                if (f4 > 0.0f) {
                    f3 *= -1.0f;
                }
            } else if (f4 < 0.0f) {
                f3 *= -1.0f;
            }
            object = UI3DScene.allocQuaternionf().fromAxisAngleDeg(vector3f2, f3);
            UI3DScene.releaseVector3f(vector3f2);
            vector3f3 = ((Quaternionf)object).getEulerAnglesXYZ(new Vector3f());
            UI3DScene.releaseQuaternionf((Quaternionf)object);
            vector3f3.x = (float)Math.floor(vector3f3.x * 57.295776f + 0.5f);
            vector3f3.y = (float)Math.floor(vector3f3.y * 57.295776f + 0.5f);
            vector3f3.z = (float)Math.floor(vector3f3.z * 57.295776f + 0.5f);
            LuaManager.caller.pcall(UIManager.getDefaultThread(), UI3DScene.this.getTable().rawget("onGizmoChanged"), UI3DScene.this.table, vector3f3);
        }

        @Override
        void stopTracking() {
            this.m_trackAxis = Axis.None;
        }

        @Override
        void render() {
            float f;
            float f2;
            float f3;
            Axis axis;
            if (!this.m_visible) {
                return;
            }
            StateData stateData = UI3DScene.this.stateDataRender();
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            matrix4f.set(stateData.m_gizmoParentTransform);
            matrix4f.mul(stateData.m_gizmoOriginTransform);
            matrix4f.mul(stateData.m_gizmoChildTransform);
            matrix4f.mul(stateData.m_gizmoTransform);
            Vector3f vector3f = matrix4f.getScale(UI3DScene.allocVector3f());
            matrix4f.scale(1.0f / vector3f.x, 1.0f / vector3f.y, 1.0f / vector3f.z);
            UI3DScene.releaseVector3f(vector3f);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                matrix4f.setRotationXYZ(0.0f, 0.0f, 0.0f);
            }
            float f4 = Mouse.getXA() - UI3DScene.this.getAbsoluteX().intValue();
            float f5 = Mouse.getYA() - UI3DScene.this.getAbsoluteY().intValue();
            Ray ray = UI3DScene.this.getCameraRay(f4, (float)UI3DScene.this.screenHeight() - f5, stateData.m_projection, stateData.m_modelView, UI3DScene.allocRay());
            float f6 = UI3DScene.this.m_gizmoScale / stateData.zoomMult() * 1000.0f;
            float f7 = this.LENGTH * f6;
            Vector3f vector3f2 = matrix4f.transformProject(UI3DScene.allocVector3f().set(0.0f, 0.0f, 0.0f));
            Vector3f vector3f3 = matrix4f.transformDirection(UI3DScene.allocVector3f().set(1.0f, 0.0f, 0.0f)).normalize();
            Vector3f vector3f4 = matrix4f.transformDirection(UI3DScene.allocVector3f().set(0.0f, 1.0f, 0.0f)).normalize();
            Vector3f vector3f5 = matrix4f.transformDirection(UI3DScene.allocVector3f().set(0.0f, 0.0f, 1.0f)).normalize();
            GL11.glClear((int)256);
            GL11.glEnable((int)2929);
            Axis axis2 = axis = this.m_trackAxis == Axis.None ? stateData.m_gizmoAxis : this.m_trackAxis;
            if (this.m_trackAxis == Axis.None || this.m_trackAxis == Axis.X) {
                f3 = axis == Axis.X ? 1.0f : 0.5f;
                f2 = 0.0f;
                f = 0.0f;
                this.renderAxis(vector3f2, f7, vector3f4, vector3f5, f3, f2, f, ray);
            }
            if (this.m_trackAxis == Axis.None || this.m_trackAxis == Axis.Y) {
                f3 = 0.0f;
                f2 = axis == Axis.Y ? 1.0f : 0.5f;
                f = 0.0f;
                this.renderAxis(vector3f2, f7, vector3f3, vector3f5, f3, f2, f, ray);
            }
            if (this.m_trackAxis == Axis.None || this.m_trackAxis == Axis.Z) {
                f3 = 0.0f;
                f2 = 0.0f;
                f = axis == Axis.Z ? 1.0f : 0.5f;
                this.renderAxis(vector3f2, f7, vector3f3, vector3f4, f3, f2, f, ray);
            }
            UI3DScene.releaseVector3f(vector3f2);
            UI3DScene.releaseVector3f(vector3f3);
            UI3DScene.releaseVector3f(vector3f4);
            UI3DScene.releaseVector3f(vector3f5);
            UI3DScene.releaseRay(ray);
            UI3DScene.releaseMatrix4f(matrix4f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.renderLineToOrigin();
        }

        void getCircleSegments(Vector3f vector3f, float f, Vector3f vector3f2, Vector3f vector3f3, ArrayList<Vector3f> arrayList) {
            Vector3f vector3f4 = UI3DScene.allocVector3f();
            Vector3f vector3f5 = UI3DScene.allocVector3f();
            int n = 32;
            double d = 0.0 / (double)n * 0.01745329238474369;
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            vector3f2.mul((float)d2, vector3f4);
            vector3f3.mul((float)d3, vector3f5);
            vector3f4.add(vector3f5).mul(f);
            arrayList.add(UI3DScene.allocVector3f().set(vector3f).add(vector3f4));
            for (int i = 1; i <= n; ++i) {
                d = (double)i * 360.0 / (double)n * 0.01745329238474369;
                d2 = Math.cos(d);
                d3 = Math.sin(d);
                vector3f2.mul((float)d2, vector3f4);
                vector3f3.mul((float)d3, vector3f5);
                vector3f4.add(vector3f5).mul(f);
                arrayList.add(UI3DScene.allocVector3f().set(vector3f).add(vector3f4));
            }
            UI3DScene.releaseVector3f(vector3f4);
            UI3DScene.releaseVector3f(vector3f5);
        }

        private float hitTestCircle(Ray ray, ArrayList<Vector3f> arrayList, Vector2 vector22) {
            Ray ray2 = UI3DScene.allocRay();
            Vector3f vector3f = UI3DScene.allocVector3f();
            float f = UI3DScene.this.sceneToUIX(ray.origin.x, ray.origin.y, ray.origin.z);
            float f2 = UI3DScene.this.sceneToUIY(ray.origin.x, ray.origin.y, ray.origin.z);
            float f3 = Float.MAX_VALUE;
            Vector3f vector3f2 = arrayList.get(0);
            for (int i = 1; i < arrayList.size(); ++i) {
                Vector3f vector3f3 = arrayList.get(i);
                float f4 = UI3DScene.this.sceneToUIX(vector3f2.x, vector3f2.y, vector3f2.z);
                float f5 = UI3DScene.this.sceneToUIY(vector3f2.x, vector3f2.y, vector3f2.z);
                float f6 = UI3DScene.this.sceneToUIX(vector3f3.x, vector3f3.y, vector3f3.z);
                float f7 = UI3DScene.this.sceneToUIY(vector3f3.x, vector3f3.y, vector3f3.z);
                double d = Math.pow(f6 - f4, 2.0) + Math.pow(f7 - f5, 2.0);
                if (d < 0.001) {
                    vector3f2 = vector3f3;
                    continue;
                }
                double d2 = (double)((f - f4) * (f6 - f4) + (f2 - f5) * (f7 - f5)) / d;
                double d3 = (double)f4 + d2 * (double)(f6 - f4);
                double d4 = (double)f5 + d2 * (double)(f7 - f5);
                if (d2 <= 0.0) {
                    d3 = f4;
                    d4 = f5;
                } else if (d2 >= 1.0) {
                    d3 = f6;
                    d4 = f7;
                }
                float f8 = IsoUtils.DistanceTo2D(f, f2, (float)d3, (float)d4);
                if (f8 < f3) {
                    f3 = f8;
                    vector22.set((float)d3, (float)d4);
                }
                vector3f2 = vector3f3;
            }
            UI3DScene.releaseVector3f(vector3f);
            UI3DScene.releaseRay(ray2);
            return f3;
        }

        void renderAxis(Vector3f vector3f, float f, Vector3f vector3f2, Vector3f vector3f3, float f2, float f3, float f4, Ray ray) {
            vboLines.flush();
            vboLines.setLineWidth(6.0f);
            this.getCircleSegments(vector3f, f, vector3f2, vector3f3, this.m_circlePointsRender);
            Vector3f vector3f4 = UI3DScene.allocVector3f();
            Vector3f vector3f5 = this.m_circlePointsRender.get(0);
            for (int i = 1; i < this.m_circlePointsRender.size(); ++i) {
                Vector3f vector3f6 = this.m_circlePointsRender.get(i);
                vector3f4.set(vector3f6.x - vector3f.x, vector3f6.y - vector3f.y, vector3f6.z - vector3f.z).normalize();
                float f5 = vector3f4.dot(ray.direction);
                if (f5 < 0.1f) {
                    vboLines.addLine(vector3f5.x, vector3f5.y, vector3f5.z, vector3f6.x, vector3f6.y, vector3f6.z, f2, f3, f4, 1.0f);
                } else {
                    vboLines.addLine(vector3f5.x, vector3f5.y, vector3f5.z, vector3f6.x, vector3f6.y, vector3f6.z, f2 / 2.0f, f3 / 2.0f, f4 / 2.0f, 0.25f);
                }
                vector3f5 = vector3f6;
            }
            BaseVehicle.TL_vector3f_pool.get().release(this.m_circlePointsRender);
            this.m_circlePointsRender.clear();
            UI3DScene.releaseVector3f(vector3f4);
            vboLines.flush();
        }

        Vector3f getPointOnAxis(float f, float f2, Axis axis, Circle circle, org.joml.Matrix4f matrix4f, Vector3f vector3f) {
            float f3 = 1.0f;
            circle.radius = this.LENGTH * f3;
            matrix4f.getTranslation(circle.center);
            float f4 = UI3DScene.this.sceneToUIX(circle.center.x, circle.center.y, circle.center.z);
            float f5 = UI3DScene.this.sceneToUIY(circle.center.x, circle.center.y, circle.center.z);
            circle.center.set(f4, f5, 0.0f);
            circle.orientation.set(0.0f, 0.0f, 1.0f);
            Ray ray = UI3DScene.allocRay();
            ray.origin.set(f, f2, 0.0f);
            ray.direction.set(0.0f, 0.0f, -1.0f);
            UI3DScene.this.closest_distance_line_circle(ray, circle, vector3f);
            UI3DScene.releaseRay(ray);
            return vector3f;
        }

        float calculateRotation(Vector3f vector3f, Vector3f vector3f2, Circle circle) {
            if (vector3f.equals(vector3f2)) {
                return 0.0f;
            }
            Vector3f vector3f3 = UI3DScene.allocVector3f().set(vector3f).sub(circle.center).normalize();
            Vector3f vector3f4 = UI3DScene.allocVector3f().set(vector3f2).sub(circle.center).normalize();
            float f = (float)Math.acos(vector3f4.dot(vector3f3));
            Vector3f vector3f5 = vector3f3.cross(vector3f4, UI3DScene.allocVector3f());
            int n = (int)Math.signum(vector3f5.dot(circle.orientation));
            UI3DScene.releaseVector3f(vector3f3);
            UI3DScene.releaseVector3f(vector3f4);
            UI3DScene.releaseVector3f(vector3f5);
            return (float)n * f * 57.295776f;
        }
    }

    private final class ScaleGizmo
    extends Gizmo {
        final org.joml.Matrix4f m_startXfrm;
        final org.joml.Matrix4f m_startInvXfrm;
        final Vector3f m_startPos;
        final Vector3f m_currentPos;
        Axis m_trackAxis;
        boolean m_hideX;
        boolean m_hideY;
        boolean m_hideZ;
        final Cylinder cylinder;

        private ScaleGizmo() {
            this.m_startXfrm = new org.joml.Matrix4f();
            this.m_startInvXfrm = new org.joml.Matrix4f();
            this.m_startPos = new Vector3f();
            this.m_currentPos = new Vector3f();
            this.m_trackAxis = Axis.None;
            this.cylinder = new Cylinder();
        }

        @Override
        Axis hitTest(float f, float f2) {
            float f3;
            float f4;
            float f5;
            if (!this.m_visible) {
                return Axis.None;
            }
            StateData stateData = UI3DScene.this.stateDataMain();
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            matrix4f.set(stateData.m_gizmoParentTransform);
            matrix4f.mul(stateData.m_gizmoOriginTransform);
            matrix4f.mul(stateData.m_gizmoTransform);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                matrix4f.setRotationXYZ(0.0f, 0.0f, 0.0f);
            }
            f2 = (float)UI3DScene.this.screenHeight() - f2;
            Ray ray = UI3DScene.this.getCameraRay(f, f2, UI3DScene.allocRay());
            Ray ray2 = UI3DScene.allocRay();
            matrix4f.transformProject(ray2.origin.set(0.0f, 0.0f, 0.0f));
            float f6 = UI3DScene.this.m_gizmoScale / stateData.zoomMult() * 1000.0f;
            float f7 = this.LENGTH * f6;
            float f8 = this.THICKNESS * f6;
            float f9 = 0.1f * f6;
            matrix4f.transformDirection(ray2.direction.set(1.0f, 0.0f, 0.0f)).normalize();
            float f10 = UI3DScene.this.closest_distance_between_lines(ray2, ray);
            float f11 = ray2.t;
            float f12 = ray.t;
            if (f11 < f9 || f11 >= f9 + f7) {
                f11 = Float.MAX_VALUE;
                f10 = Float.MAX_VALUE;
            }
            this.m_hideX = Math.abs(f5 = ray2.direction.dot(ray.direction)) > 0.9f;
            matrix4f.transformDirection(ray2.direction.set(0.0f, 1.0f, 0.0f)).normalize();
            float f13 = UI3DScene.this.closest_distance_between_lines(ray2, ray);
            float f14 = ray2.t;
            float f15 = ray.t;
            if (f14 < f9 || f14 >= f9 + f7) {
                f14 = Float.MAX_VALUE;
                f13 = Float.MAX_VALUE;
            }
            this.m_hideY = Math.abs(f4 = ray2.direction.dot(ray.direction)) > 0.9f;
            matrix4f.transformDirection(ray2.direction.set(0.0f, 0.0f, 1.0f)).normalize();
            float f16 = UI3DScene.this.closest_distance_between_lines(ray2, ray);
            float f17 = ray2.t;
            float f18 = ray.t;
            if (f17 < f9 || f17 >= f9 + f7) {
                f17 = Float.MAX_VALUE;
                f16 = Float.MAX_VALUE;
            }
            this.m_hideZ = Math.abs(f3 = ray2.direction.dot(ray.direction)) > 0.9f;
            UI3DScene.releaseRay(ray2);
            UI3DScene.releaseRay(ray);
            UI3DScene.releaseMatrix4f(matrix4f);
            if (f11 >= f9 && f11 < f9 + f7 && f10 < f13 && f10 < f16) {
                return f10 <= f8 / 2.0f ? Axis.X : Axis.None;
            }
            if (f14 >= f9 && f14 < f9 + f7 && f13 < f10 && f13 < f16) {
                return f13 <= f8 / 2.0f ? Axis.Y : Axis.None;
            }
            if (f17 >= f9 && f17 < f9 + f7 && f16 < f10 && f16 < f13) {
                return f16 <= f8 / 2.0f ? Axis.Z : Axis.None;
            }
            return Axis.None;
        }

        @Override
        void startTracking(float f, float f2, Axis axis) {
            StateData stateData = UI3DScene.this.stateDataMain();
            this.m_startXfrm.set(stateData.m_gizmoParentTransform);
            this.m_startXfrm.mul(stateData.m_gizmoOriginTransform);
            this.m_startXfrm.mul(stateData.m_gizmoTransform);
            this.m_startXfrm.setRotationXYZ(0.0f, 0.0f, 0.0f);
            this.m_startInvXfrm.set(this.m_startXfrm);
            this.m_startInvXfrm.invert();
            this.m_trackAxis = axis;
            this.getPointOnAxis(f, f2, axis, this.m_startXfrm, this.m_startPos);
        }

        @Override
        void updateTracking(float f, float f2) {
            Vector3f vector3f = this.getPointOnAxis(f, f2, this.m_trackAxis, this.m_startXfrm, UI3DScene.allocVector3f());
            if (this.m_currentPos.equals(vector3f)) {
                UI3DScene.releaseVector3f(vector3f);
                return;
            }
            UI3DScene.releaseVector3f(vector3f);
            this.m_currentPos.set(vector3f);
            StateData stateData = UI3DScene.this.stateDataMain();
            Vector3f vector3f2 = new Vector3f(this.m_currentPos).sub(this.m_startPos);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                Vector3f vector3f3 = this.m_startInvXfrm.transformPosition(this.m_startPos, new Vector3f());
                Vector3f vector3f4 = this.m_startInvXfrm.transformPosition(this.m_currentPos, new Vector3f());
                org.joml.Matrix4f matrix4f = new org.joml.Matrix4f(stateData.m_gizmoParentTransform).invert();
                matrix4f.transformPosition(vector3f3);
                matrix4f.transformPosition(vector3f4);
                vector3f2.set(vector3f4).sub(vector3f3);
            } else {
                Vector3f vector3f5 = this.m_startInvXfrm.transformPosition(this.m_startPos, new Vector3f());
                Vector3f vector3f6 = this.m_startInvXfrm.transformPosition(this.m_currentPos, new Vector3f());
                vector3f2.set(vector3f6).sub(vector3f5);
            }
            vector3f2.x = (float)Math.floor(vector3f2.x * UI3DScene.this.gridMult()) / UI3DScene.this.gridMult();
            vector3f2.y = (float)Math.floor(vector3f2.y * UI3DScene.this.gridMult()) / UI3DScene.this.gridMult();
            vector3f2.z = (float)Math.floor(vector3f2.z * UI3DScene.this.gridMult()) / UI3DScene.this.gridMult();
            LuaManager.caller.pcall(UIManager.getDefaultThread(), UI3DScene.this.getTable().rawget("onGizmoChanged"), UI3DScene.this.table, vector3f2);
        }

        @Override
        void stopTracking() {
            this.m_trackAxis = Axis.None;
        }

        @Override
        void render() {
            if (!this.m_visible) {
                return;
            }
            StateData stateData = UI3DScene.this.stateDataRender();
            float f = UI3DScene.this.m_gizmoScale / stateData.zoomMult() * 1000.0f;
            float f2 = this.LENGTH * f;
            float f3 = this.THICKNESS * f;
            float f4 = 0.1f * f;
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            matrix4f.set(stateData.m_gizmoParentTransform);
            matrix4f.mul(stateData.m_gizmoOriginTransform);
            matrix4f.mul(stateData.m_gizmoChildTransform);
            matrix4f.mul(stateData.m_gizmoTransform);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                matrix4f.setRotationXYZ(0.0f, 0.0f, 0.0f);
            }
            stateData.m_modelView.mul(matrix4f, matrix4f);
            PZGLUtil.pushAndLoadMatrix(5888, matrix4f);
            UI3DScene.releaseMatrix4f(matrix4f);
            if (!this.m_hideX) {
                GL11.glColor3f((float)(stateData.m_gizmoAxis == Axis.X ? 1.0f : 0.5f), (float)0.0f, (float)0.0f);
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f4);
                this.cylinder.draw(f3 / 2.0f, f3 / 2.0f, f2, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f2);
                this.cylinder.draw(f3, f3, 0.1f * f, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-f4 - f2));
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            }
            if (!this.m_hideY) {
                GL11.glColor3f((float)0.0f, (float)(stateData.m_gizmoAxis == Axis.Y ? 1.0f : 0.5f), (float)0.0f);
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f4);
                this.cylinder.draw(f3 / 2.0f, f3 / 2.0f, f2, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f2);
                this.cylinder.draw(f3, f3, 0.1f * f, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-f4 - f2));
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            }
            if (!this.m_hideZ) {
                GL11.glColor3f((float)0.0f, (float)0.0f, (float)(stateData.m_gizmoAxis == Axis.Z ? 1.0f : 0.5f));
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f4);
                this.cylinder.draw(f3 / 2.0f, f3 / 2.0f, f2, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f2);
                this.cylinder.draw(f3, f3, 0.1f * f, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.1f - f2));
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            PZGLUtil.popMatrix(5888);
            this.renderLineToOrigin();
        }
    }

    private final class TranslateGizmo
    extends Gizmo {
        final org.joml.Matrix4f m_startXfrm;
        final org.joml.Matrix4f m_startInvXfrm;
        final Vector3f m_startPos;
        final Vector3f m_currentPos;
        Axis m_trackAxis;
        Cylinder cylinder;

        private TranslateGizmo() {
            this.m_startXfrm = new org.joml.Matrix4f();
            this.m_startInvXfrm = new org.joml.Matrix4f();
            this.m_startPos = new Vector3f();
            this.m_currentPos = new Vector3f();
            this.m_trackAxis = Axis.None;
            this.cylinder = new Cylinder();
        }

        @Override
        Axis hitTest(float f, float f2) {
            if (!this.m_visible) {
                return Axis.None;
            }
            StateData stateData = UI3DScene.this.stateDataMain();
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            matrix4f.set(stateData.m_gizmoParentTransform);
            matrix4f.mul(stateData.m_gizmoOriginTransform);
            matrix4f.mul(stateData.m_gizmoChildTransform);
            matrix4f.mul(stateData.m_gizmoTransform);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                matrix4f.setRotationXYZ(0.0f, 0.0f, 0.0f);
            }
            f2 = (float)UI3DScene.this.screenHeight() - f2;
            Ray ray = UI3DScene.this.getCameraRay(f, f2, UI3DScene.allocRay());
            Ray ray2 = UI3DScene.allocRay();
            matrix4f.transformPosition(ray2.origin.set(0.0f, 0.0f, 0.0f));
            float f3 = UI3DScene.this.m_gizmoScale / stateData.zoomMult() * 1000.0f;
            float f4 = this.LENGTH * f3;
            float f5 = this.THICKNESS * f3;
            float f6 = 0.1f * f3;
            matrix4f.transformDirection(ray2.direction.set(1.0f, 0.0f, 0.0f)).normalize();
            float f7 = UI3DScene.this.closest_distance_between_lines(ray2, ray);
            float f8 = ray2.t;
            float f9 = ray.t;
            if (f8 < f6 || f8 >= f6 + f4) {
                f8 = Float.MAX_VALUE;
                f7 = Float.MAX_VALUE;
            }
            float f10 = ray2.direction.dot(ray.direction);
            stateData.m_translateGizmoRenderData.m_hideX = Math.abs(f10) > 0.9f;
            matrix4f.transformDirection(ray2.direction.set(0.0f, 1.0f, 0.0f)).normalize();
            float f11 = UI3DScene.this.closest_distance_between_lines(ray2, ray);
            float f12 = ray2.t;
            float f13 = ray.t;
            if (f12 < f6 || f12 >= f6 + f4) {
                f12 = Float.MAX_VALUE;
                f11 = Float.MAX_VALUE;
            }
            float f14 = ray2.direction.dot(ray.direction);
            stateData.m_translateGizmoRenderData.m_hideY = Math.abs(f14) > 0.9f;
            matrix4f.transformDirection(ray2.direction.set(0.0f, 0.0f, 1.0f)).normalize();
            float f15 = UI3DScene.this.closest_distance_between_lines(ray2, ray);
            float f16 = ray2.t;
            float f17 = ray.t;
            if (f16 < f6 || f16 >= f6 + f4) {
                f16 = Float.MAX_VALUE;
                f15 = Float.MAX_VALUE;
            }
            float f18 = ray2.direction.dot(ray.direction);
            stateData.m_translateGizmoRenderData.m_hideZ = Math.abs(f18) > 0.9f;
            UI3DScene.releaseRay(ray2);
            UI3DScene.releaseRay(ray);
            UI3DScene.releaseMatrix4f(matrix4f);
            if (f8 >= f6 && f8 < f6 + f4 && f7 < f11 && f7 < f15) {
                return f7 <= f5 / 2.0f ? Axis.X : Axis.None;
            }
            if (f12 >= f6 && f12 < f6 + f4 && f11 < f7 && f11 < f15) {
                return f11 <= f5 / 2.0f ? Axis.Y : Axis.None;
            }
            if (f16 >= f6 && f16 < f6 + f4 && f15 < f7 && f15 < f11) {
                return f15 <= f5 / 2.0f ? Axis.Z : Axis.None;
            }
            return Axis.None;
        }

        @Override
        void startTracking(float f, float f2, Axis axis) {
            StateData stateData = UI3DScene.this.stateDataMain();
            this.m_startXfrm.set(stateData.m_gizmoParentTransform);
            this.m_startXfrm.mul(stateData.m_gizmoOriginTransform);
            this.m_startXfrm.mul(stateData.m_gizmoChildTransform);
            this.m_startXfrm.mul(stateData.m_gizmoTransform);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                this.m_startXfrm.setRotationXYZ(0.0f, 0.0f, 0.0f);
            }
            this.m_startInvXfrm.set(this.m_startXfrm);
            this.m_startInvXfrm.invert();
            this.m_trackAxis = axis;
            this.getPointOnAxis(f, f2, axis, this.m_startXfrm, this.m_startPos);
        }

        @Override
        void updateTracking(float f, float f2) {
            Vector3f vector3f = this.getPointOnAxis(f, f2, this.m_trackAxis, this.m_startXfrm, UI3DScene.allocVector3f());
            if (this.m_currentPos.equals(vector3f)) {
                UI3DScene.releaseVector3f(vector3f);
                return;
            }
            UI3DScene.releaseVector3f(vector3f);
            this.m_currentPos.set(vector3f);
            StateData stateData = UI3DScene.this.stateDataMain();
            Vector3f vector3f2 = new Vector3f(this.m_currentPos).sub(this.m_startPos);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                Vector3f vector3f3 = this.m_startInvXfrm.transformPosition(this.m_startPos, UI3DScene.allocVector3f());
                Vector3f vector3f4 = this.m_startInvXfrm.transformPosition(this.m_currentPos, UI3DScene.allocVector3f());
                org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
                matrix4f.set(stateData.m_gizmoParentTransform);
                matrix4f.mul(stateData.m_gizmoOriginTransform);
                matrix4f.mul(stateData.m_gizmoChildTransform);
                matrix4f.invert();
                matrix4f.transformPosition(vector3f3);
                matrix4f.transformPosition(vector3f4);
                UI3DScene.releaseMatrix4f(matrix4f);
                vector3f2.set(vector3f4).sub(vector3f3);
                UI3DScene.releaseVector3f(vector3f3);
                UI3DScene.releaseVector3f(vector3f4);
            } else {
                Vector3f vector3f5 = this.m_startInvXfrm.transformPosition(this.m_startPos, UI3DScene.allocVector3f());
                Vector3f vector3f6 = this.m_startInvXfrm.transformPosition(this.m_currentPos, UI3DScene.allocVector3f());
                org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
                matrix4f.set(stateData.m_gizmoTransform);
                matrix4f.transformPosition(vector3f5);
                matrix4f.transformPosition(vector3f6);
                UI3DScene.releaseMatrix4f(matrix4f);
                vector3f2.set(vector3f6).sub(vector3f5);
                UI3DScene.releaseVector3f(vector3f5);
                UI3DScene.releaseVector3f(vector3f6);
            }
            vector3f2.x = (float)Math.floor(vector3f2.x * UI3DScene.this.gridMult()) / UI3DScene.this.gridMult();
            vector3f2.y = (float)Math.floor(vector3f2.y * UI3DScene.this.gridMult()) / UI3DScene.this.gridMult();
            vector3f2.z = (float)Math.floor(vector3f2.z * UI3DScene.this.gridMult()) / UI3DScene.this.gridMult();
            if (stateData.m_selectedAttachmentIsChildAttachment) {
                vector3f2.mul(-1.0f);
            }
            LuaManager.caller.pcall(UIManager.getDefaultThread(), UI3DScene.this.getTable().rawget("onGizmoChanged"), UI3DScene.this.table, vector3f2);
        }

        @Override
        void stopTracking() {
            this.m_trackAxis = Axis.None;
        }

        @Override
        void render() {
            if (!this.m_visible) {
                return;
            }
            StateData stateData = UI3DScene.this.stateDataRender();
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            matrix4f.set(stateData.m_gizmoParentTransform);
            matrix4f.mul(stateData.m_gizmoOriginTransform);
            matrix4f.mul(stateData.m_gizmoChildTransform);
            matrix4f.mul(stateData.m_gizmoTransform);
            Vector3f vector3f = matrix4f.getScale(UI3DScene.allocVector3f());
            matrix4f.scale(1.0f / vector3f.x, 1.0f / vector3f.y, 1.0f / vector3f.z);
            UI3DScene.releaseVector3f(vector3f);
            if (UI3DScene.this.m_transformMode == TransformMode.Global) {
                matrix4f.setRotationXYZ(0.0f, 0.0f, 0.0f);
            }
            stateData.m_modelView.mul(matrix4f, matrix4f);
            PZGLUtil.pushAndLoadMatrix(5888, matrix4f);
            UI3DScene.releaseMatrix4f(matrix4f);
            float f = UI3DScene.this.m_gizmoScale / stateData.zoomMult() * 1000.0f;
            float f2 = this.THICKNESS * f;
            float f3 = this.LENGTH * f;
            float f4 = 0.1f * f;
            if (!stateData.m_translateGizmoRenderData.m_hideX) {
                GL11.glColor3f((float)(stateData.m_gizmoAxis == Axis.X ? 1.0f : 0.5f), (float)0.0f, (float)0.0f);
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f4);
                this.cylinder.draw(f2 / 2.0f, f2 / 2.0f, f3, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f3);
                this.cylinder.draw(f2 / 2.0f * 2.0f, 0.0f, 0.1f * f, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-f4 - f3));
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            }
            if (!stateData.m_translateGizmoRenderData.m_hideY) {
                GL11.glColor3f((float)0.0f, (float)(stateData.m_gizmoAxis == Axis.Y ? 1.0f : 0.5f), (float)0.0f);
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f4);
                this.cylinder.draw(f2 / 2.0f, f2 / 2.0f, f3, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f3);
                this.cylinder.draw(f2 / 2.0f * 2.0f, 0.0f, 0.1f * f, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-f4 - f3));
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            }
            if (!stateData.m_translateGizmoRenderData.m_hideZ) {
                GL11.glColor3f((float)0.0f, (float)0.0f, (float)(stateData.m_gizmoAxis == Axis.Z ? 1.0f : 0.5f));
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f4);
                this.cylinder.draw(f2 / 2.0f, f2 / 2.0f, f3, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)f3);
                this.cylinder.draw(f2 / 2.0f * 2.0f, 0.0f, 0.1f * f, 8, 1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-f4 - f3));
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            PZGLUtil.popMatrix(5888);
            this.renderLineToOrigin();
        }
    }

    private static abstract class SceneObject {
        final UI3DScene m_scene;
        final String m_id;
        boolean m_visible = true;
        final Vector3f m_translate = new Vector3f();
        final Vector3f m_rotate = new Vector3f();
        SceneObject m_parent;
        String m_attachment;
        String m_parentAttachment;
        boolean m_autoRotate = false;
        float m_autoRotateAngle = 0.0f;

        SceneObject(UI3DScene uI3DScene, String string) {
            this.m_scene = uI3DScene;
            this.m_id = string;
        }

        abstract SceneObjectRenderData renderMain();

        org.joml.Matrix4f getLocalTransform(org.joml.Matrix4f matrix4f) {
            SceneModel sceneModel = Type.tryCastTo(this, SceneModel.class);
            if (sceneModel == null || !sceneModel.m_useWorldAttachment) {
                matrix4f.translation(this.m_translate);
            } else {
                matrix4f.translation(-this.m_translate.x, this.m_translate.y, this.m_translate.z);
                matrix4f.scale(-1.5f, 1.5f, 1.5f);
            }
            float f = this.m_rotate.y;
            if (this.m_autoRotate) {
                f += this.m_autoRotateAngle;
            }
            matrix4f.rotateXYZ(this.m_rotate.x * ((float)Math.PI / 180), f * ((float)Math.PI / 180), this.m_rotate.z * ((float)Math.PI / 180));
            if (this.m_attachment != null) {
                org.joml.Matrix4f matrix4f2 = this.getAttachmentTransform(this.m_attachment, UI3DScene.allocMatrix4f());
                matrix4f2.invert();
                matrix4f.mul(matrix4f2);
                UI3DScene.releaseMatrix4f(matrix4f2);
            }
            return matrix4f;
        }

        org.joml.Matrix4f getGlobalTransform(org.joml.Matrix4f matrix4f) {
            this.getLocalTransform(matrix4f);
            if (this.m_parent != null) {
                org.joml.Matrix4f matrix4f2;
                if (this.m_parentAttachment != null) {
                    matrix4f2 = this.m_parent.getAttachmentTransform(this.m_parentAttachment, UI3DScene.allocMatrix4f());
                    matrix4f2.mul(matrix4f, matrix4f);
                    UI3DScene.releaseMatrix4f(matrix4f2);
                }
                matrix4f2 = this.m_parent.getGlobalTransform(UI3DScene.allocMatrix4f());
                matrix4f2.mul(matrix4f, matrix4f);
                UI3DScene.releaseMatrix4f(matrix4f2);
            }
            return matrix4f;
        }

        org.joml.Matrix4f getAttachmentTransform(String string, org.joml.Matrix4f matrix4f) {
            matrix4f.identity();
            return matrix4f;
        }
    }

    private static final class OriginAttachment
    extends SceneObject {
        SceneObject m_object;
        String m_attachmentName;

        OriginAttachment(UI3DScene uI3DScene) {
            super(uI3DScene, "OriginAttachment");
        }

        @Override
        SceneObjectRenderData renderMain() {
            return null;
        }

        @Override
        org.joml.Matrix4f getGlobalTransform(org.joml.Matrix4f matrix4f) {
            return this.m_object.getAttachmentTransform(this.m_attachmentName, matrix4f);
        }
    }

    private static final class OriginBone
    extends SceneObject {
        SceneCharacter m_character;
        String m_boneName;

        OriginBone(UI3DScene uI3DScene) {
            super(uI3DScene, "OriginBone");
        }

        @Override
        SceneObjectRenderData renderMain() {
            return null;
        }

        @Override
        org.joml.Matrix4f getGlobalTransform(org.joml.Matrix4f matrix4f) {
            return this.m_character.getBoneMatrix(this.m_boneName, matrix4f);
        }
    }

    private static final class OriginGizmo
    extends SceneObject {
        OriginGizmo(UI3DScene uI3DScene) {
            super(uI3DScene, "OriginGizmo");
        }

        @Override
        SceneObjectRenderData renderMain() {
            return null;
        }
    }

    private final class GridPlaneDrawer
    extends TextureDraw.GenericDrawer {
        final UI3DScene m_scene;

        GridPlaneDrawer(UI3DScene uI3DScene2) {
            this.m_scene = uI3DScene2;
        }

        @Override
        public void render() {
            StateData stateData = UI3DScene.this.stateDataRender();
            PZGLUtil.pushAndLoadMatrix(5889, stateData.m_projection);
            PZGLUtil.pushAndLoadMatrix(5888, stateData.m_modelView);
            GL11.glPushAttrib((int)2048);
            GL11.glViewport((int)UI3DScene.this.getAbsoluteX().intValue(), (int)(Core.getInstance().getScreenHeight() - UI3DScene.this.getAbsoluteY().intValue() - UI3DScene.this.getHeight().intValue()), (int)UI3DScene.this.getWidth().intValue(), (int)UI3DScene.this.getHeight().intValue());
            Objects.requireNonNull(this.m_scene);
            float f = 5.0f;
            vboLines.setMode(4);
            vboLines.setDepthTest(true);
            if (this.m_scene.m_gridPlane == GridPlane.XZ) {
                vboLines.addTriangle(-f, 0.0f, -f, f, 0.0f, -f, -f, 0.0f, f, 0.5f, 0.5f, 0.5f, 1.0f);
                vboLines.addTriangle(f, 0.0f, f, -f, 0.0f, f, f, 0.0f, -f, 0.5f, 0.5f, 0.5f, 1.0f);
            }
            vboLines.setMode(1);
            vboLines.setDepthTest(false);
            GL11.glPopAttrib();
            PZGLUtil.popMatrix(5889);
            PZGLUtil.popMatrix(5888);
        }
    }

    private final class OverlaysDrawer
    extends TextureDraw.GenericDrawer {
        private OverlaysDrawer() {
        }

        void init() {
            Object object;
            int n;
            StateData stateData = UI3DScene.this.stateDataMain();
            s_aabbPool.release((List<AABB>)stateData.m_aabb);
            stateData.m_aabb.clear();
            for (n = 0; n < UI3DScene.this.m_aabb.size(); ++n) {
                object = UI3DScene.this.m_aabb.get(n);
                stateData.m_aabb.add(s_aabbPool.alloc().set((AABB)object));
            }
            s_box3DPool.release((List<Box3D>)stateData.m_box3D);
            stateData.m_box3D.clear();
            for (n = 0; n < UI3DScene.this.m_box3D.size(); ++n) {
                object = UI3DScene.this.m_box3D.get(n);
                stateData.m_box3D.add(s_box3DPool.alloc().set((Box3D)object));
            }
            s_posRotPool.release((List<PositionRotation>)stateData.m_axes);
            stateData.m_axes.clear();
            for (n = 0; n < UI3DScene.this.m_axes.size(); ++n) {
                object = UI3DScene.this.m_axes.get(n);
                stateData.m_axes.add(s_posRotPool.alloc().set((PositionRotation)object));
            }
        }

        @Override
        public void render() {
            Object object;
            int n;
            StateData stateData = UI3DScene.this.stateDataRender();
            PZGLUtil.pushAndLoadMatrix(5889, stateData.m_projection);
            PZGLUtil.pushAndLoadMatrix(5888, stateData.m_modelView);
            GL11.glPushAttrib((int)2048);
            GL11.glViewport((int)UI3DScene.this.getAbsoluteX().intValue(), (int)(Core.getInstance().getScreenHeight() - UI3DScene.this.getAbsoluteY().intValue() - UI3DScene.this.getHeight().intValue()), (int)UI3DScene.this.getWidth().intValue(), (int)UI3DScene.this.getHeight().intValue());
            vboLines.setOffset(0.0f, 0.0f, 0.0f);
            if (UI3DScene.this.m_bDrawGrid) {
                UI3DScene.this.renderGrid();
            }
            for (n = 0; n < stateData.m_aabb.size(); ++n) {
                object = stateData.m_aabb.get(n);
                UI3DScene.this.renderAABB(((AABB)object).x, ((AABB)object).y, ((AABB)object).z, ((AABB)object).w, ((AABB)object).h, ((AABB)object).L, ((AABB)object).r, ((AABB)object).g, ((AABB)object).b);
            }
            for (n = 0; n < stateData.m_box3D.size(); ++n) {
                object = stateData.m_box3D.get(n);
                UI3DScene.this.renderBox3D(((Box3D)object).x, ((Box3D)object).y, ((Box3D)object).z, ((Box3D)object).w, ((Box3D)object).h, ((Box3D)object).L, ((Box3D)object).rx, ((Box3D)object).ry, ((Box3D)object).rz, ((Box3D)object).r, ((Box3D)object).g, ((Box3D)object).b);
            }
            for (n = 0; n < stateData.m_axes.size(); ++n) {
                UI3DScene.this.renderAxis(stateData.m_axes.get(n));
            }
            vboLines.flush();
            if (stateData.m_gizmo != null) {
                stateData.m_gizmo.render();
            }
            vboLines.flush();
            GL11.glPopAttrib();
            PZGLUtil.popMatrix(5889);
            PZGLUtil.popMatrix(5888);
        }
    }

    private static class SceneObjectRenderData {
        SceneObject m_object;
        final org.joml.Matrix4f m_transform = new org.joml.Matrix4f();
        private static final ObjectPool<SceneObjectRenderData> s_pool = new ObjectPool<SceneObjectRenderData>(SceneObjectRenderData::new);

        private SceneObjectRenderData() {
        }

        SceneObjectRenderData init(SceneObject sceneObject) {
            this.m_object = sceneObject;
            sceneObject.getGlobalTransform(this.m_transform);
            return this;
        }

        void release() {
            s_pool.release(this);
        }
    }

    private abstract class Gizmo {
        float LENGTH = 0.5f;
        float THICKNESS = 0.05f;
        boolean m_visible = false;

        private Gizmo() {
        }

        abstract Axis hitTest(float var1, float var2);

        abstract void startTracking(float var1, float var2, Axis var3);

        abstract void updateTracking(float var1, float var2);

        abstract void stopTracking();

        abstract void render();

        Vector3f getPointOnAxis(float f, float f2, Axis axis, org.joml.Matrix4f matrix4f, Vector3f vector3f) {
            StateData stateData = UI3DScene.this.stateDataMain();
            f2 = (float)UI3DScene.this.screenHeight() - f2;
            Ray ray = UI3DScene.this.getCameraRay(f, f2, UI3DScene.allocRay());
            Ray ray2 = UI3DScene.allocRay();
            matrix4f.transformPosition(ray2.origin.set(0.0f, 0.0f, 0.0f));
            switch (axis) {
                case X: {
                    ray2.direction.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                case Y: {
                    ray2.direction.set(0.0f, 1.0f, 0.0f);
                    break;
                }
                case Z: {
                    ray2.direction.set(0.0f, 0.0f, 1.0f);
                }
            }
            matrix4f.transformDirection(ray2.direction).normalize();
            UI3DScene.this.closest_distance_between_lines(ray2, ray);
            UI3DScene.releaseRay(ray);
            vector3f.set(ray2.direction).mul(ray2.t).add(ray2.origin);
            UI3DScene.releaseRay(ray2);
            return vector3f;
        }

        boolean hitTestRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float f9 = UI3DScene.this.sceneToUIX(f3, f4, f5);
            float f10 = UI3DScene.this.sceneToUIY(f3, f4, f5);
            float f11 = UI3DScene.this.sceneToUIX(f6, f7, f8);
            float f12 = UI3DScene.this.sceneToUIY(f6, f7, f8);
            float f13 = this.THICKNESS / 2.0f * UI3DScene.this.zoomMult();
            float f14 = this.THICKNESS / 2.0f * UI3DScene.this.zoomMult();
            float f15 = Math.min(f9 - f13, f11 - f13);
            float f16 = Math.max(f9 + f13, f11 + f13);
            float f17 = Math.min(f10 - f14, f12 - f14);
            float f18 = Math.max(f10 + f14, f12 + f14);
            return f >= f15 && f2 >= f17 && f < f16 && f2 < f18;
        }

        void renderLineToOrigin() {
            StateData stateData = UI3DScene.this.stateDataRender();
            if (!stateData.m_hasGizmoOrigin) {
                return;
            }
            UI3DScene.this.renderAxis(stateData.m_gizmoTranslate, stateData.m_gizmoRotate);
            Vector3f vector3f = stateData.m_gizmoTranslate;
            vboLines.flush();
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            matrix4f.set(stateData.m_modelView);
            matrix4f.mul(stateData.m_gizmoParentTransform);
            matrix4f.mul(stateData.m_gizmoOriginTransform);
            matrix4f.mul(stateData.m_gizmoChildTransform);
            PZGLUtil.pushAndLoadMatrix(5888, matrix4f);
            UI3DScene.releaseMatrix4f(matrix4f);
            vboLines.setLineWidth(1.0f);
            vboLines.addLine(vector3f.x, vector3f.y, vector3f.z, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            vboLines.flush();
            PZGLUtil.popMatrix(5888);
        }
    }

    static enum Axis {
        None,
        X,
        Y,
        Z;

    }

    public static final class Plane {
        public final Vector3f point = new Vector3f();
        public final Vector3f normal = new Vector3f();

        public Plane() {
        }

        public Plane(Vector3f vector3f, Vector3f vector3f2) {
            this.point.set(vector3f2);
            this.normal.set(vector3f);
        }

        public Plane set(Vector3f vector3f, Vector3f vector3f2) {
            this.point.set(vector3f2);
            this.normal.set(vector3f);
            return this;
        }
    }

    public static final class Ray {
        public final Vector3f origin = new Vector3f();
        public final Vector3f direction = new Vector3f();
        public float t;

        public Ray() {
        }

        Ray(Ray ray) {
            this.origin.set(ray.origin);
            this.direction.set(ray.direction);
            this.t = ray.t;
        }
    }

    private static final class SceneCharacter
    extends SceneObject {
        final AnimatedModel m_animatedModel = new AnimatedModel();
        boolean m_bShowBones = false;
        boolean m_bClearDepthBuffer = true;
        boolean m_bUseDeferredMovement = false;

        SceneCharacter(UI3DScene uI3DScene, String string) {
            super(uI3DScene, string);
            this.m_animatedModel.setAnimSetName("player-vehicle");
            this.m_animatedModel.setState("idle");
            this.m_animatedModel.setOutfitName("Naked", false, false);
            this.m_animatedModel.setVisual(new HumanVisual(this.m_animatedModel));
            this.m_animatedModel.getHumanVisual().setHairModel("Bald");
            this.m_animatedModel.getHumanVisual().setBeardModel("");
            this.m_animatedModel.getHumanVisual().setSkinTextureIndex(0);
            this.m_animatedModel.setAlpha(0.5f);
            this.m_animatedModel.setAnimate(false);
        }

        @Override
        SceneObjectRenderData renderMain() {
            this.m_animatedModel.update();
            CharacterRenderData characterRenderData = CharacterRenderData.s_pool.alloc();
            characterRenderData.initCharacter(this);
            SpriteRenderer.instance.drawGeneric(characterRenderData.m_drawer);
            return characterRenderData;
        }

        @Override
        org.joml.Matrix4f getLocalTransform(org.joml.Matrix4f matrix4f) {
            matrix4f.identity();
            matrix4f.rotateY((float)Math.PI);
            matrix4f.translate(-this.m_translate.x, this.m_translate.y, this.m_translate.z);
            matrix4f.scale(-1.5f, 1.5f, 1.5f);
            float f = this.m_rotate.y;
            if (this.m_autoRotate) {
                f += this.m_autoRotateAngle;
            }
            matrix4f.rotateXYZ(this.m_rotate.x * ((float)Math.PI / 180), f * ((float)Math.PI / 180), this.m_rotate.z * ((float)Math.PI / 180));
            if (this.m_animatedModel.getAnimationPlayer().getMultiTrack().getTracks().isEmpty()) {
                return matrix4f;
            }
            if (this.m_bUseDeferredMovement) {
                AnimationMultiTrack animationMultiTrack = this.m_animatedModel.getAnimationPlayer().getMultiTrack();
                float f2 = animationMultiTrack.getTracks().get(0).getCurrentDeferredRotation();
                org.lwjgl.util.vector.Vector3f vector3f = new org.lwjgl.util.vector.Vector3f();
                animationMultiTrack.getTracks().get(0).getCurrentDeferredPosition(vector3f);
                matrix4f.translate(vector3f.x, vector3f.y, vector3f.z);
            }
            return matrix4f;
        }

        @Override
        org.joml.Matrix4f getAttachmentTransform(String string, org.joml.Matrix4f matrix4f) {
            matrix4f.identity();
            boolean bl = this.m_animatedModel.isFemale();
            ModelScript modelScript = ScriptManager.instance.getModelScript(bl ? "FemaleBody" : "MaleBody");
            if (modelScript == null) {
                return matrix4f;
            }
            ModelAttachment modelAttachment = modelScript.getAttachmentById(string);
            if (modelAttachment == null) {
                return matrix4f;
            }
            matrix4f.translation(modelAttachment.getOffset());
            Vector3f vector3f = modelAttachment.getRotate();
            matrix4f.rotateXYZ(vector3f.x * ((float)Math.PI / 180), vector3f.y * ((float)Math.PI / 180), vector3f.z * ((float)Math.PI / 180));
            if (modelAttachment.getBone() != null) {
                org.joml.Matrix4f matrix4f2 = this.getBoneMatrix(modelAttachment.getBone(), UI3DScene.allocMatrix4f());
                matrix4f2.mul(matrix4f, matrix4f);
                UI3DScene.releaseMatrix4f(matrix4f2);
            }
            return matrix4f;
        }

        int hitTestBone(int n, Ray ray, Ray ray2, org.joml.Matrix4f matrix4f) {
            AnimationPlayer animationPlayer = this.m_animatedModel.getAnimationPlayer();
            SkinningData skinningData = animationPlayer.getSkinningData();
            int n2 = skinningData.SkeletonHierarchy.get(n);
            if (n2 == -1) {
                return -1;
            }
            Matrix4f matrix4f2 = animationPlayer.modelTransforms[n2];
            ray.origin.set(matrix4f2.m03, matrix4f2.m13, matrix4f2.m23);
            matrix4f.transformPosition(ray.origin);
            matrix4f2 = animationPlayer.modelTransforms[n];
            Vector3f vector3f = UI3DScene.allocVector3f();
            vector3f.set(matrix4f2.m03, matrix4f2.m13, matrix4f2.m23);
            matrix4f.transformPosition(vector3f);
            ray.direction.set(vector3f).sub(ray.origin);
            float f = ray.direction.length();
            ray.direction.normalize();
            this.m_scene.closest_distance_between_lines(ray2, ray);
            float f2 = this.m_scene.sceneToUIX(ray2.origin.x + ray2.direction.x * ray2.t, ray2.origin.y + ray2.direction.y * ray2.t, ray2.origin.z + ray2.direction.z * ray2.t);
            float f3 = this.m_scene.sceneToUIY(ray2.origin.x + ray2.direction.x * ray2.t, ray2.origin.y + ray2.direction.y * ray2.t, ray2.origin.z + ray2.direction.z * ray2.t);
            float f4 = this.m_scene.sceneToUIX(ray.origin.x + ray.direction.x * ray.t, ray.origin.y + ray.direction.y * ray.t, ray.origin.z + ray.direction.z * ray.t);
            float f5 = this.m_scene.sceneToUIY(ray.origin.x + ray.direction.x * ray.t, ray.origin.y + ray.direction.y * ray.t, ray.origin.z + ray.direction.z * ray.t);
            int n3 = -1;
            float f6 = 10.0f;
            float f7 = (float)Math.sqrt(Math.pow(f4 - f2, 2.0) + Math.pow(f5 - f3, 2.0));
            if (f7 < f6) {
                if (ray.t >= 0.0f && ray.t < f * 0.5f) {
                    n3 = n2;
                } else if (ray.t >= f * 0.5f && ray.t < f) {
                    n3 = n;
                }
            }
            UI3DScene.releaseVector3f(vector3f);
            return n3;
        }

        String pickBone(float f, float f2) {
            if (this.m_animatedModel.getAnimationPlayer().modelTransforms == null) {
                return "";
            }
            f2 = (float)this.m_scene.screenHeight() - f2;
            Ray ray = this.m_scene.getCameraRay(f, f2, UI3DScene.allocRay());
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            this.getLocalTransform(matrix4f);
            Ray ray2 = UI3DScene.allocRay();
            int n = -1;
            for (int i = 0; i < this.m_animatedModel.getAnimationPlayer().modelTransforms.length && (n = this.hitTestBone(i, ray2, ray, matrix4f)) == -1; ++i) {
            }
            UI3DScene.releaseRay(ray2);
            UI3DScene.releaseRay(ray);
            UI3DScene.releaseMatrix4f(matrix4f);
            return n == -1 ? "" : this.m_animatedModel.getAnimationPlayer().getSkinningData().getBoneAt((int)n).Name;
        }

        org.joml.Matrix4f getBoneMatrix(String string, org.joml.Matrix4f matrix4f) {
            matrix4f.identity();
            if (this.m_animatedModel.getAnimationPlayer().modelTransforms == null) {
                return matrix4f;
            }
            SkinningBone skinningBone = this.m_animatedModel.getAnimationPlayer().getSkinningData().getBone(string);
            if (skinningBone == null) {
                return matrix4f;
            }
            matrix4f = PZMath.convertMatrix(this.m_animatedModel.getAnimationPlayer().modelTransforms[skinningBone.Index], matrix4f);
            matrix4f.transpose();
            return matrix4f;
        }

        PositionRotation getBoneAxis(String string, PositionRotation positionRotation) {
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f().identity();
            matrix4f.getTranslation(positionRotation.pos);
            UI3DScene.releaseMatrix4f(matrix4f);
            Quaternionf quaternionf = matrix4f.getUnnormalizedRotation(UI3DScene.allocQuaternionf());
            quaternionf.getEulerAnglesXYZ(positionRotation.rot);
            UI3DScene.releaseQuaternionf(quaternionf);
            return positionRotation;
        }
    }

    private static final class SceneModel
    extends SceneObject {
        ModelScript m_modelScript;
        Model m_model;
        boolean m_useWorldAttachment = false;
        boolean m_weaponRotationHack = false;

        SceneModel(UI3DScene uI3DScene, String string, ModelScript modelScript, Model model) {
            super(uI3DScene, string);
            Objects.requireNonNull(modelScript);
            Objects.requireNonNull(model);
            this.m_modelScript = modelScript;
            this.m_model = model;
        }

        @Override
        SceneObjectRenderData renderMain() {
            if (!this.m_model.isReady()) {
                return null;
            }
            ModelRenderData modelRenderData = ModelRenderData.s_pool.alloc();
            modelRenderData.initModel(this);
            SpriteRenderer.instance.drawGeneric(modelRenderData.m_drawer);
            return modelRenderData;
        }

        @Override
        org.joml.Matrix4f getLocalTransform(org.joml.Matrix4f matrix4f) {
            super.getLocalTransform(matrix4f);
            return matrix4f;
        }

        @Override
        org.joml.Matrix4f getAttachmentTransform(String string, org.joml.Matrix4f matrix4f) {
            matrix4f.identity();
            ModelAttachment modelAttachment = this.m_modelScript.getAttachmentById(string);
            if (modelAttachment == null) {
                return matrix4f;
            }
            matrix4f.translation(modelAttachment.getOffset());
            Vector3f vector3f = modelAttachment.getRotate();
            matrix4f.rotateXYZ(vector3f.x * ((float)Math.PI / 180), vector3f.y * ((float)Math.PI / 180), vector3f.z * ((float)Math.PI / 180));
            return matrix4f;
        }
    }

    private static final class SceneVehicle
    extends SceneObject {
        String m_scriptName = "Base.ModernCar";
        VehicleScript m_script;
        Model m_model;

        SceneVehicle(UI3DScene uI3DScene, String string) {
            super(uI3DScene, string);
            this.setScriptName("Base.ModernCar");
        }

        @Override
        SceneObjectRenderData renderMain() {
            if (this.m_script == null) {
                this.m_model = null;
                return null;
            }
            String string = this.m_script.getModel().file;
            this.m_model = ModelManager.instance.getLoadedModel(string);
            if (this.m_model == null) {
                return null;
            }
            if (this.m_script.getSkinCount() > 0) {
                this.m_model.tex = Texture.getSharedTexture("media/textures/" + this.m_script.getSkin((int)0).texture + ".png");
            }
            VehicleRenderData vehicleRenderData = VehicleRenderData.s_pool.alloc();
            vehicleRenderData.initVehicle(this);
            SetModelCamera setModelCamera = s_SetModelCameraPool.alloc();
            SpriteRenderer.instance.drawGeneric(setModelCamera.init(this.m_scene.m_VehicleSceneModelCamera, vehicleRenderData));
            SpriteRenderer.instance.drawGeneric(vehicleRenderData.m_drawer);
            return vehicleRenderData;
        }

        void setScriptName(String string) {
            this.m_scriptName = string;
            this.m_script = ScriptManager.instance.getVehicle(string);
        }
    }

    private static final class PositionRotation {
        final Vector3f pos = new Vector3f();
        final Vector3f rot = new Vector3f();

        private PositionRotation() {
        }

        PositionRotation set(PositionRotation positionRotation) {
            this.pos.set(positionRotation.pos);
            this.rot.set(positionRotation.rot);
            return this;
        }

        PositionRotation set(float f, float f2, float f3) {
            this.pos.set(f, f2, f3);
            this.rot.set(0.0f, 0.0f, 0.0f);
            return this;
        }

        PositionRotation set(float f, float f2, float f3, float f4, float f5, float f6) {
            this.pos.set(f, f2, f3);
            this.rot.set(f4, f5, f6);
            return this;
        }
    }

    private static final class AABB {
        float x;
        float y;
        float z;
        float w;
        float h;
        float L;
        float r;
        float g;
        float b;

        private AABB() {
        }

        AABB set(AABB aABB) {
            return this.set(aABB.x, aABB.y, aABB.z, aABB.w, aABB.h, aABB.L, aABB.r, aABB.g, aABB.b);
        }

        AABB set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.w = f4;
            this.h = f5;
            this.L = f6;
            this.r = f7;
            this.g = f8;
            this.b = f9;
            return this;
        }
    }

    private static final class Box3D {
        float x;
        float y;
        float z;
        float w;
        float h;
        float L;
        float rx;
        float ry;
        float rz;
        float r;
        float g;
        float b;

        private Box3D() {
        }

        Box3D set(Box3D box3D) {
            return this.set(box3D.x, box3D.y, box3D.z, box3D.w, box3D.h, box3D.L, box3D.rx, box3D.ry, box3D.rz, box3D.r, box3D.g, box3D.b);
        }

        Box3D set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.w = f4;
            this.h = f5;
            this.L = f6;
            this.rx = f7;
            this.ry = f8;
            this.rz = f9;
            this.r = f10;
            this.g = f11;
            this.b = f12;
            return this;
        }
    }

    private static final class Circle {
        final Vector3f center = new Vector3f();
        final Vector3f orientation = new Vector3f();
        float radius = 1.0f;

        private Circle() {
        }
    }

    private static final class VehicleDrawer
    extends TextureDraw.GenericDrawer {
        SceneVehicle m_vehicle;
        VehicleRenderData m_renderData;
        boolean bRendered;
        final float[] fzeroes = new float[16];
        final Vector3f paintColor = new Vector3f(0.0f, 0.5f, 0.5f);
        final org.joml.Matrix4f IDENTITY = new org.joml.Matrix4f();

        private VehicleDrawer() {
        }

        public void init(SceneVehicle sceneVehicle, VehicleRenderData vehicleRenderData) {
            this.m_vehicle = sceneVehicle;
            this.m_renderData = vehicleRenderData;
            this.bRendered = false;
        }

        @Override
        public void render() {
            for (int i = 0; i < this.m_renderData.m_models.size(); ++i) {
                GL11.glPushAttrib((int)1048575);
                GL11.glPushClientAttrib((int)-1);
                this.render(i);
                GL11.glPopAttrib();
                GL11.glPopClientAttrib();
                Texture.lastTextureID = -1;
                SpriteRenderer.ringBuffer.restoreBoundTextures = true;
                SpriteRenderer.ringBuffer.restoreVBOs = true;
            }
        }

        private void render(int n) {
            this.m_renderData.m_transform.set(this.m_renderData.m_transforms.get(n));
            ModelCamera.instance.Begin();
            Model model = this.m_renderData.m_models.get(n);
            boolean bl = model.bStatic;
            if (Core.bDebug && DebugOptions.instance.ModelRenderWireframe.getValue()) {
                GL11.glPolygonMode((int)1032, (int)6913);
                GL11.glEnable((int)2848);
                GL11.glLineWidth((float)0.75f);
                Shader shader = ShaderManager.instance.getOrCreateShader("vehicle_wireframe", bl);
                if (shader != null) {
                    shader.Start();
                    shader.setTransformMatrix(this.IDENTITY.identity(), false);
                    model.Mesh.Draw(shader);
                    shader.End();
                }
                GL11.glDisable((int)2848);
                ModelCamera.instance.End();
                return;
            }
            Shader shader = model.Effect;
            if (shader != null && shader.isVehicleShader()) {
                GL11.glDepthFunc((int)513);
                GL11.glDepthMask((boolean)true);
                GL11.glDepthRange((double)0.0, (double)1.0);
                GL11.glEnable((int)2929);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                shader.Start();
                if (model.tex != null) {
                    shader.setTexture(model.tex, "Texture0", 0);
                    GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                    if (this.m_vehicle.m_script.getSkinCount() > 0 && this.m_vehicle.m_script.getSkin((int)0).textureMask != null) {
                        Texture texture = Texture.getSharedTexture("media/textures/" + this.m_vehicle.m_script.getSkin((int)0).textureMask + ".png");
                        shader.setTexture(texture, "TextureMask", 2);
                        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                    }
                }
                shader.setDepthBias(0.0f);
                shader.setAmbient(1.0f);
                shader.setLightingAmount(1.0f);
                shader.setHueShift(0.0f);
                shader.setTint(1.0f, 1.0f, 1.0f);
                shader.setAlpha(1.0f);
                for (int i = 0; i < 5; ++i) {
                    shader.setLight(i, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, 0.0f, 0.0f, 0.0f, null);
                }
                shader.setTextureUninstall1(this.fzeroes);
                shader.setTextureUninstall2(this.fzeroes);
                shader.setTextureLightsEnables2(this.fzeroes);
                shader.setTextureDamage1Enables1(this.fzeroes);
                shader.setTextureDamage1Enables2(this.fzeroes);
                shader.setTextureDamage2Enables1(this.fzeroes);
                shader.setTextureDamage2Enables2(this.fzeroes);
                shader.setMatrixBlood1(this.fzeroes, this.fzeroes);
                shader.setMatrixBlood2(this.fzeroes, this.fzeroes);
                shader.setTextureRustA(0.0f);
                shader.setTexturePainColor(this.paintColor, 1.0f);
                shader.setTransformMatrix(this.IDENTITY.identity(), false);
                model.Mesh.Draw(shader);
                shader.End();
            } else if (shader != null && model.Mesh != null && model.Mesh.isReady()) {
                GL11.glDepthFunc((int)513);
                GL11.glDepthMask((boolean)true);
                GL11.glDepthRange((double)0.0, (double)1.0);
                GL11.glEnable((int)2929);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                shader.Start();
                if (model.tex != null) {
                    shader.setTexture(model.tex, "Texture", 0);
                }
                shader.setDepthBias(0.0f);
                shader.setAmbient(1.0f);
                shader.setLightingAmount(1.0f);
                shader.setHueShift(0.0f);
                shader.setTint(1.0f, 1.0f, 1.0f);
                shader.setAlpha(1.0f);
                for (int i = 0; i < 5; ++i) {
                    shader.setLight(i, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, 0.0f, 0.0f, 0.0f, null);
                }
                shader.setTransformMatrix(this.IDENTITY.identity(), false);
                model.Mesh.Draw(shader);
                shader.End();
            }
            ModelCamera.instance.End();
            this.bRendered = true;
        }

        @Override
        public void postRender() {
        }
    }

    private static final class ModelDrawer
    extends TextureDraw.GenericDrawer {
        SceneModel m_model;
        ModelRenderData m_renderData;
        boolean bRendered;

        private ModelDrawer() {
        }

        public void init(SceneModel sceneModel, ModelRenderData modelRenderData) {
            this.m_model = sceneModel;
            this.m_renderData = modelRenderData;
            this.bRendered = false;
        }

        @Override
        public void render() {
            StateData stateData = this.m_model.m_scene.stateDataRender();
            PZGLUtil.pushAndLoadMatrix(5889, stateData.m_projection);
            PZGLUtil.pushAndLoadMatrix(5888, stateData.m_modelView);
            Model model = this.m_model.m_model;
            Shader shader = model.Effect;
            if (shader != null && model.Mesh != null && model.Mesh.isReady()) {
                GL11.glPushAttrib((int)1048575);
                GL11.glPushClientAttrib((int)-1);
                UI3DScene uI3DScene = this.m_renderData.m_object.m_scene;
                GL11.glViewport((int)uI3DScene.getAbsoluteX().intValue(), (int)(Core.getInstance().getScreenHeight() - uI3DScene.getAbsoluteY().intValue() - uI3DScene.getHeight().intValue()), (int)uI3DScene.getWidth().intValue(), (int)uI3DScene.getHeight().intValue());
                GL11.glDepthFunc((int)513);
                GL11.glDepthMask((boolean)true);
                GL11.glDepthRange((double)0.0, (double)1.0);
                GL11.glEnable((int)2929);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                shader.Start();
                if (model.tex != null) {
                    shader.setTexture(model.tex, "Texture", 0);
                }
                shader.setDepthBias(0.0f);
                shader.setAmbient(1.0f);
                shader.setLightingAmount(1.0f);
                shader.setHueShift(0.0f);
                shader.setTint(1.0f, 1.0f, 1.0f);
                shader.setAlpha(1.0f);
                for (int i = 0; i < 5; ++i) {
                    shader.setLight(i, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, 0.0f, 0.0f, 0.0f, null);
                }
                shader.setTransformMatrix(this.m_renderData.m_transform, false);
                model.Mesh.Draw(shader);
                shader.End();
                if (Core.bDebug) {
                    // empty if block
                }
                GL11.glPopAttrib();
                GL11.glPopClientAttrib();
                Texture.lastTextureID = -1;
                SpriteRenderer.ringBuffer.restoreBoundTextures = true;
                SpriteRenderer.ringBuffer.restoreVBOs = true;
            }
            PZGLUtil.popMatrix(5889);
            PZGLUtil.popMatrix(5888);
            this.bRendered = true;
        }

        @Override
        public void postRender() {
        }
    }

    private static final class CharacterDrawer
    extends TextureDraw.GenericDrawer {
        SceneCharacter m_character;
        CharacterRenderData m_renderData;
        boolean bRendered;

        private CharacterDrawer() {
        }

        public void init(SceneCharacter sceneCharacter, CharacterRenderData characterRenderData) {
            this.m_character = sceneCharacter;
            this.m_renderData = characterRenderData;
            this.bRendered = false;
            this.m_character.m_animatedModel.renderMain();
        }

        @Override
        public void render() {
            if (this.m_character.m_bClearDepthBuffer) {
                GL11.glClear((int)256);
            }
            boolean bl = DebugOptions.instance.ModelRenderBones.getValue();
            DebugOptions.instance.ModelRenderBones.setValue(this.m_character.m_bShowBones);
            this.m_character.m_scene.m_CharacterSceneModelCamera.m_renderData = this.m_renderData;
            this.m_character.m_animatedModel.DoRender(this.m_character.m_scene.m_CharacterSceneModelCamera);
            DebugOptions.instance.ModelRenderBones.setValue(bl);
            this.bRendered = true;
            GL11.glDepthMask((boolean)true);
        }

        @Override
        public void postRender() {
            this.m_character.m_animatedModel.postRender(this.bRendered);
        }
    }

    private static final class TranslateGizmoRenderData {
        boolean m_hideX;
        boolean m_hideY;
        boolean m_hideZ;

        private TranslateGizmoRenderData() {
        }
    }

    public static final class PlaneObjectPool
    extends ObjectPool<Plane> {
        int allocated = 0;

        public PlaneObjectPool() {
            super(Plane::new);
        }

        @Override
        protected Plane makeObject() {
            ++this.allocated;
            return (Plane)super.makeObject();
        }
    }

    public static final class RayObjectPool
    extends ObjectPool<Ray> {
        int allocated = 0;

        public RayObjectPool() {
            super(Ray::new);
        }

        @Override
        protected Ray makeObject() {
            ++this.allocated;
            return (Ray)super.makeObject();
        }
    }

    private static final class SetModelCamera
    extends TextureDraw.GenericDrawer {
        SceneModelCamera m_camera;
        SceneObjectRenderData m_renderData;

        private SetModelCamera() {
        }

        SetModelCamera init(SceneModelCamera sceneModelCamera, SceneObjectRenderData sceneObjectRenderData) {
            this.m_camera = sceneModelCamera;
            this.m_renderData = sceneObjectRenderData;
            return this;
        }

        @Override
        public void render() {
            this.m_camera.m_renderData = this.m_renderData;
            ModelCamera.instance = this.m_camera;
        }

        @Override
        public void postRender() {
            s_SetModelCameraPool.release(this);
        }
    }

    private abstract class SceneModelCamera
    extends ModelCamera {
        SceneObjectRenderData m_renderData;

        private SceneModelCamera() {
        }
    }

    private static class VehicleRenderData
    extends SceneObjectRenderData {
        final ArrayList<Model> m_models = new ArrayList();
        final ArrayList<org.joml.Matrix4f> m_transforms = new ArrayList();
        final VehicleDrawer m_drawer = new VehicleDrawer();
        private static final ObjectPool<VehicleRenderData> s_pool = new ObjectPool<VehicleRenderData>(VehicleRenderData::new);

        private VehicleRenderData() {
        }

        SceneObjectRenderData initVehicle(SceneVehicle sceneVehicle) {
            super.init(sceneVehicle);
            this.m_models.clear();
            BaseVehicle.Matrix4fObjectPool matrix4fObjectPool = BaseVehicle.TL_matrix4f_pool.get();
            matrix4fObjectPool.release(this.m_transforms);
            this.m_transforms.clear();
            VehicleScript vehicleScript = sceneVehicle.m_script;
            if (vehicleScript.getModel() == null) {
                return null;
            }
            this.initVehicleModel(sceneVehicle);
            float f = vehicleScript.getModelScale();
            Vector3f vector3f = vehicleScript.getModel().getOffset();
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            matrix4f.translationRotateScale(vector3f.x * 1.0f, vector3f.y, vector3f.z, 0.0f, 0.0f, 0.0f, 1.0f, f);
            this.m_transform.mul(matrix4f, matrix4f);
            for (int i = 0; i < vehicleScript.getPartCount(); ++i) {
                VehicleScript.Part part = vehicleScript.getPart(i);
                if (part.wheel == null) continue;
                this.initWheelModel(sceneVehicle, part, matrix4f);
            }
            UI3DScene.releaseMatrix4f(matrix4f);
            this.m_drawer.init(sceneVehicle, this);
            return this;
        }

        private void initVehicleModel(SceneVehicle sceneVehicle) {
            VehicleScript vehicleScript = sceneVehicle.m_script;
            float f = vehicleScript.getModelScale();
            float f2 = 1.0f;
            ModelScript modelScript = ScriptManager.instance.getModelScript(vehicleScript.getModel().file);
            if (modelScript != null && modelScript.scale != 1.0f) {
                f2 = modelScript.scale;
            }
            float f3 = 1.0f;
            if (modelScript != null) {
                f3 = modelScript.invertX ? -1.0f : 1.0f;
            }
            f3 *= -1.0f;
            Quaternionf quaternionf = UI3DScene.allocQuaternionf();
            org.joml.Matrix4f matrix4f = UI3DScene.allocMatrix4f();
            Vector3f vector3f = vehicleScript.getModel().getRotate();
            quaternionf.rotationXYZ(vector3f.x * ((float)Math.PI / 180), vector3f.y * ((float)Math.PI / 180), vector3f.z * ((float)Math.PI / 180));
            Vector3f vector3f2 = vehicleScript.getModel().getOffset();
            matrix4f.translationRotateScale(vector3f2.x * 1.0f, vector3f2.y, vector3f2.z, quaternionf.x, quaternionf.y, quaternionf.z, quaternionf.w, f * f2 * f3, f * f2, f * f2);
            if (sceneVehicle.m_model.Mesh != null && sceneVehicle.m_model.Mesh.isReady() && sceneVehicle.m_model.Mesh.m_transform != null) {
                sceneVehicle.m_model.Mesh.m_transform.transpose();
                matrix4f.mul(sceneVehicle.m_model.Mesh.m_transform);
                sceneVehicle.m_model.Mesh.m_transform.transpose();
            }
            this.m_transform.mul(matrix4f, matrix4f);
            UI3DScene.releaseQuaternionf(quaternionf);
            this.m_models.add(sceneVehicle.m_model);
            this.m_transforms.add(matrix4f);
        }

        private void initWheelModel(SceneVehicle sceneVehicle, VehicleScript.Part part, org.joml.Matrix4f matrix4f) {
            VehicleScript vehicleScript = sceneVehicle.m_script;
            float f = vehicleScript.getModelScale();
            VehicleScript.Wheel wheel = vehicleScript.getWheelById(part.wheel);
            if (wheel == null || part.models.isEmpty()) {
                return;
            }
            VehicleScript.Model model = part.models.get(0);
            Vector3f vector3f = model.getOffset();
            Vector3f vector3f2 = model.getRotate();
            Model model2 = ModelManager.instance.getLoadedModel(model.file);
            if (model2 == null) {
                return;
            }
            float f2 = model.scale;
            float f3 = 1.0f;
            float f4 = 1.0f;
            ModelScript modelScript = ScriptManager.instance.getModelScript(model.file);
            if (modelScript != null) {
                f3 = modelScript.scale;
                f4 = modelScript.invertX ? -1.0f : 1.0f;
            }
            Quaternionf quaternionf = UI3DScene.allocQuaternionf();
            quaternionf.rotationXYZ(vector3f2.x * ((float)Math.PI / 180), vector3f2.y * ((float)Math.PI / 180), vector3f2.z * ((float)Math.PI / 180));
            org.joml.Matrix4f matrix4f2 = UI3DScene.allocMatrix4f();
            matrix4f2.translation(wheel.offset.x / f * 1.0f, wheel.offset.y / f, wheel.offset.z / f);
            org.joml.Matrix4f matrix4f3 = UI3DScene.allocMatrix4f();
            matrix4f3.translationRotateScale(vector3f.x * 1.0f, vector3f.y, vector3f.z, quaternionf.x, quaternionf.y, quaternionf.z, quaternionf.w, f2 * f3 * f4, f2 * f3, f2 * f3);
            matrix4f2.mul(matrix4f3);
            UI3DScene.releaseMatrix4f(matrix4f3);
            matrix4f.mul(matrix4f2, matrix4f2);
            if (model2.Mesh != null && model2.Mesh.isReady() && model2.Mesh.m_transform != null) {
                model2.Mesh.m_transform.transpose();
                matrix4f2.mul(model2.Mesh.m_transform);
                model2.Mesh.m_transform.transpose();
            }
            UI3DScene.releaseQuaternionf(quaternionf);
            this.m_models.add(model2);
            this.m_transforms.add(matrix4f2);
        }

        @Override
        void release() {
            s_pool.release(this);
        }
    }

    private static class ModelRenderData
    extends SceneObjectRenderData {
        final ModelDrawer m_drawer = new ModelDrawer();
        private static final ObjectPool<ModelRenderData> s_pool = new ObjectPool<ModelRenderData>(ModelRenderData::new);

        private ModelRenderData() {
        }

        SceneObjectRenderData initModel(SceneModel sceneModel) {
            super.init(sceneModel);
            if (sceneModel.m_useWorldAttachment) {
                ModelAttachment modelAttachment;
                if (sceneModel.m_weaponRotationHack) {
                    this.m_transform.rotateXYZ(0.0f, (float)Math.PI, 1.5707964f);
                }
                if (sceneModel.m_modelScript != null && (modelAttachment = sceneModel.m_modelScript.getAttachmentById("world")) != null) {
                    org.joml.Matrix4f matrix4f = ModelInstanceRenderData.makeAttachmentTransform(modelAttachment, UI3DScene.allocMatrix4f());
                    matrix4f.invert();
                    this.m_transform.mul(matrix4f);
                    UI3DScene.releaseMatrix4f(matrix4f);
                }
            }
            if (sceneModel.m_model.isReady() && sceneModel.m_model.Mesh.m_transform != null) {
                sceneModel.m_model.Mesh.m_transform.transpose();
                this.m_transform.mul(sceneModel.m_model.Mesh.m_transform);
                sceneModel.m_model.Mesh.m_transform.transpose();
            }
            if (sceneModel.m_modelScript != null && sceneModel.m_modelScript.scale != 1.0f) {
                this.m_transform.scale(sceneModel.m_modelScript.scale);
            }
            this.m_drawer.init(sceneModel, this);
            return this;
        }

        @Override
        void release() {
            s_pool.release(this);
        }
    }

    private static class CharacterRenderData
    extends SceneObjectRenderData {
        final CharacterDrawer m_drawer = new CharacterDrawer();
        private static final ObjectPool<CharacterRenderData> s_pool = new ObjectPool<CharacterRenderData>(CharacterRenderData::new);

        private CharacterRenderData() {
        }

        SceneObjectRenderData initCharacter(SceneCharacter sceneCharacter) {
            this.m_drawer.init(sceneCharacter, this);
            super.init(sceneCharacter);
            return this;
        }

        @Override
        void release() {
            s_pool.release(this);
        }
    }
}

