/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import gnu.trove.TFloatCollection;
import gnu.trove.list.array.TFloatArrayList;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector3f;
import se.krka.kahlua.vm.KahluaTable;
import zombie.SandboxOptions;
import zombie.ai.State;
import zombie.ai.WalkingOnTheSpot;
import zombie.ai.astar.AStarPathFinder;
import zombie.ai.astar.IPathfinder;
import zombie.ai.astar.Mover;
import zombie.ai.states.ClimbOverFenceState;
import zombie.ai.states.ClimbThroughWindowState;
import zombie.ai.states.CollideWithWallState;
import zombie.ai.states.WalkTowardState;
import zombie.ai.states.ZombieGetDownState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.network.GameClient;
import zombie.popman.ObjectPool;
import zombie.scripting.objects.VehicleScript;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.VehiclePart;

public final class PathFindBehavior2
implements PolygonalMap2.IPathfinder {
    private static final Vector2 tempVector2 = new Vector2();
    private static final Vector2f tempVector2f = new Vector2f();
    private static final Vector2 tempVector2_2 = new Vector2();
    private static final Vector3f tempVector3f_1 = new Vector3f();
    private static final PointOnPath pointOnPath = new PointOnPath();
    public boolean pathNextIsSet = false;
    public float pathNextX;
    public float pathNextY;
    public ArrayList<IPathfinder> Listeners = new ArrayList();
    public NPCData NPCData = new NPCData();
    private IsoGameCharacter chr;
    private float startX;
    private float startY;
    private float startZ;
    private float targetX;
    private float targetY;
    private float targetZ;
    private final TFloatArrayList targetXYZ = new TFloatArrayList();
    private final PolygonalMap2.Path path = new PolygonalMap2.Path();
    private int pathIndex;
    private boolean isCancel = true;
    public boolean bStopping = false;
    public final WalkingOnTheSpot walkingOnTheSpot = new WalkingOnTheSpot();
    private final ArrayList<DebugPt> actualPos = new ArrayList();
    private static final ObjectPool<DebugPt> actualPool = new ObjectPool<DebugPt>(DebugPt::new);
    private Goal goal = Goal.None;
    private IsoGameCharacter goalCharacter;
    private BaseVehicle goalVehicle;
    private String goalVehicleArea;
    private int goalVehicleSeat;

    public PathFindBehavior2(IsoGameCharacter isoGameCharacter) {
        this.chr = isoGameCharacter;
    }

    public boolean isGoalNone() {
        return this.goal == Goal.None;
    }

    public boolean isGoalCharacter() {
        return this.goal == Goal.Character;
    }

    public boolean isGoalLocation() {
        return this.goal == Goal.Location;
    }

    public boolean isGoalSound() {
        return this.goal == Goal.Sound;
    }

    public boolean isGoalVehicleAdjacent() {
        return this.goal == Goal.VehicleAdjacent;
    }

    public boolean isGoalVehicleArea() {
        return this.goal == Goal.VehicleArea;
    }

    public boolean isGoalVehicleSeat() {
        return this.goal == Goal.VehicleSeat;
    }

    public void reset() {
        this.startX = this.chr.getX();
        this.startY = this.chr.getY();
        this.startZ = this.chr.getZ();
        this.targetX = this.startX;
        this.targetY = this.startY;
        this.targetZ = this.startZ;
        this.targetXYZ.resetQuick();
        this.pathIndex = 0;
        this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.notrunning;
        this.walkingOnTheSpot.reset(this.startX, this.startY);
    }

    public void pathToCharacter(IsoGameCharacter isoGameCharacter) {
        this.isCancel = false;
        this.goal = Goal.Character;
        this.goalCharacter = isoGameCharacter;
        if (isoGameCharacter.getVehicle() != null) {
            Vector3f vector3f = isoGameCharacter.getVehicle().chooseBestAttackPosition(isoGameCharacter, this.chr, tempVector3f_1);
            if (vector3f != null) {
                this.setData(vector3f.x, vector3f.y, (int)isoGameCharacter.getVehicle().z);
                return;
            }
            this.setData(isoGameCharacter.getVehicle().x, isoGameCharacter.getVehicle().y, (int)isoGameCharacter.getVehicle().z);
            if (this.chr.DistToSquared(isoGameCharacter.getVehicle()) < 100.0f) {
                IsoZombie isoZombie = Type.tryCastTo(this.chr, IsoZombie.class);
                if (isoZombie != null) {
                    isoZombie.AllowRepathDelay = 100.0f;
                }
                this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.failed;
            }
        }
        this.setData(isoGameCharacter.getX(), isoGameCharacter.getY(), isoGameCharacter.getZ());
    }

    public void pathToLocation(int n, int n2, int n3) {
        this.isCancel = false;
        this.goal = Goal.Location;
        this.setData((float)n + 0.5f, (float)n2 + 0.5f, n3);
    }

    public void pathToLocationF(float f, float f2, float f3) {
        this.isCancel = false;
        this.goal = Goal.Location;
        this.setData(f, f2, f3);
    }

    public void pathToSound(int n, int n2, int n3) {
        this.isCancel = false;
        this.goal = Goal.Sound;
        this.setData((float)n + 0.5f, (float)n2 + 0.5f, n3);
    }

    public void pathToNearest(TFloatArrayList tFloatArrayList) {
        if (tFloatArrayList == null || tFloatArrayList.isEmpty()) {
            throw new IllegalArgumentException("locations is null or empty");
        }
        if (tFloatArrayList.size() % 3 != 0) {
            throw new IllegalArgumentException("locations should be multiples of x,y,z");
        }
        this.isCancel = false;
        this.goal = Goal.Location;
        this.setData(tFloatArrayList.get(0), tFloatArrayList.get(1), tFloatArrayList.get(2));
        for (int i = 3; i < tFloatArrayList.size(); i += 3) {
            this.targetXYZ.add(tFloatArrayList.get(i));
            this.targetXYZ.add(tFloatArrayList.get(i + 1));
            this.targetXYZ.add(tFloatArrayList.get(i + 2));
        }
    }

    public void pathToNearestTable(KahluaTable kahluaTable) {
        if (kahluaTable == null || kahluaTable.isEmpty()) {
            throw new IllegalArgumentException("locations table is null or empty");
        }
        if (kahluaTable.len() % 3 != 0) {
            throw new IllegalArgumentException("locations table should be multiples of x,y,z");
        }
        TFloatArrayList tFloatArrayList = new TFloatArrayList(kahluaTable.size());
        int n = kahluaTable.len();
        for (int i = 1; i <= n; i += 3) {
            Double d = Type.tryCastTo(kahluaTable.rawget(i), Double.class);
            Double d2 = Type.tryCastTo(kahluaTable.rawget(i + 1), Double.class);
            Double d3 = Type.tryCastTo(kahluaTable.rawget(i + 2), Double.class);
            if (d == null || d2 == null || d3 == null) {
                throw new IllegalArgumentException("locations table should be multiples of x,y,z");
            }
            tFloatArrayList.add(d.floatValue());
            tFloatArrayList.add(d2.floatValue());
            tFloatArrayList.add(d3.floatValue());
        }
        this.pathToNearest(tFloatArrayList);
    }

    public void pathToVehicleAdjacent(BaseVehicle baseVehicle) {
        this.isCancel = false;
        this.goal = Goal.VehicleAdjacent;
        this.goalVehicle = baseVehicle;
        VehicleScript vehicleScript = baseVehicle.getScript();
        Vector3f vector3f = vehicleScript.getExtents();
        Vector3f vector3f2 = vehicleScript.getCenterOfMassOffset();
        float f = vector3f.x;
        float f2 = vector3f.z;
        float f3 = 0.3f;
        float f4 = vector3f2.x - f / 2.0f - f3;
        float f5 = vector3f2.z - f2 / 2.0f - f3;
        float f6 = vector3f2.x + f / 2.0f + f3;
        float f7 = vector3f2.z + f2 / 2.0f + f3;
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        Vector3f vector3f3 = baseVehicle.getWorldPos(f4, vector3f2.y, vector3f2.z, tempVector3f_1);
        if (PolygonalMap2.instance.canStandAt(vector3f3.x, vector3f3.y, (int)this.targetZ, baseVehicle, false, true)) {
            tFloatArrayList.add(vector3f3.x);
            tFloatArrayList.add(vector3f3.y);
            tFloatArrayList.add(this.targetZ);
        }
        vector3f3 = baseVehicle.getWorldPos(f6, vector3f2.y, vector3f2.z, tempVector3f_1);
        if (PolygonalMap2.instance.canStandAt(vector3f3.x, vector3f3.y, (int)this.targetZ, baseVehicle, false, true)) {
            tFloatArrayList.add(vector3f3.x);
            tFloatArrayList.add(vector3f3.y);
            tFloatArrayList.add(this.targetZ);
        }
        vector3f3 = baseVehicle.getWorldPos(vector3f2.x, vector3f2.y, f5, tempVector3f_1);
        if (PolygonalMap2.instance.canStandAt(vector3f3.x, vector3f3.y, (int)this.targetZ, baseVehicle, false, true)) {
            tFloatArrayList.add(vector3f3.x);
            tFloatArrayList.add(vector3f3.y);
            tFloatArrayList.add(this.targetZ);
        }
        vector3f3 = baseVehicle.getWorldPos(vector3f2.x, vector3f2.y, f7, tempVector3f_1);
        if (PolygonalMap2.instance.canStandAt(vector3f3.x, vector3f3.y, (int)this.targetZ, baseVehicle, false, true)) {
            tFloatArrayList.add(vector3f3.x);
            tFloatArrayList.add(vector3f3.y);
            tFloatArrayList.add(this.targetZ);
        }
        this.setData(tFloatArrayList.get(0), tFloatArrayList.get(1), tFloatArrayList.get(2));
        for (int i = 3; i < tFloatArrayList.size(); i += 3) {
            this.targetXYZ.add(tFloatArrayList.get(i));
            this.targetXYZ.add(tFloatArrayList.get(i + 1));
            this.targetXYZ.add(tFloatArrayList.get(i + 2));
        }
    }

    public void pathToVehicleArea(BaseVehicle baseVehicle, String string) {
        Vector2 vector22 = baseVehicle.getAreaCenter(string);
        if (vector22 == null) {
            this.targetX = this.chr.getX();
            this.targetY = this.chr.getY();
            this.targetZ = this.chr.getZ();
            this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.failed;
            return;
        }
        this.isCancel = false;
        this.goal = Goal.VehicleArea;
        this.goalVehicle = baseVehicle;
        this.goalVehicleArea = string;
        this.setData(vector22.getX(), vector22.getY(), (int)baseVehicle.getZ());
        if (this.chr instanceof IsoPlayer && (int)this.chr.z == (int)this.targetZ && !PolygonalMap2.instance.lineClearCollide(this.chr.x, this.chr.y, this.targetX, this.targetY, (int)this.targetZ, null)) {
            this.path.clear();
            this.path.addNode(this.chr.x, this.chr.y, this.chr.z);
            this.path.addNode(this.targetX, this.targetY, this.targetZ);
            this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.found;
        }
    }

    public void pathToVehicleSeat(BaseVehicle baseVehicle, int n) {
        Vector2 vector22;
        VehicleScript.Area area;
        Vector2 vector23;
        Object object;
        VehicleScript.Position position = baseVehicle.getPassengerPosition(n, "outside2");
        if (position != null) {
            object = (Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc();
            if (position.area == null) {
                baseVehicle.getPassengerPositionWorldPos(position, (Vector3f)object);
            } else {
                vector23 = (Vector2)BaseVehicle.TL_vector2_pool.get().alloc();
                area = baseVehicle.script.getAreaById(position.area);
                vector22 = baseVehicle.areaPositionWorld4PlayerInteract(area, vector23);
                ((Vector3f)object).x = vector22.x;
                ((Vector3f)object).y = vector22.y;
                ((Vector3f)object).z = 0.0f;
                BaseVehicle.TL_vector2_pool.get().release(vector23);
            }
            ((Vector3f)object).sub(this.chr.x, this.chr.y, this.chr.z);
            if (((Vector3f)object).length() < 2.0f) {
                baseVehicle.getPassengerPositionWorldPos(position, (Vector3f)object);
                this.setData(((Vector3f)object).x(), ((Vector3f)object).y(), (int)((Vector3f)object).z());
                if (this.chr instanceof IsoPlayer && (int)this.chr.z == (int)this.targetZ) {
                    BaseVehicle.TL_vector3f_pool.get().release(object);
                    this.path.clear();
                    this.path.addNode(this.chr.x, this.chr.y, this.chr.z);
                    this.path.addNode(this.targetX, this.targetY, this.targetZ);
                    this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.found;
                    return;
                }
            }
            BaseVehicle.TL_vector3f_pool.get().release(object);
        }
        if ((position = baseVehicle.getPassengerPosition(n, "outside")) == null) {
            object = baseVehicle.getPassengerDoor(n);
            if (object == null) {
                this.targetX = this.chr.getX();
                this.targetY = this.chr.getY();
                this.targetZ = this.chr.getZ();
                this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.failed;
                return;
            }
            this.pathToVehicleArea(baseVehicle, ((VehiclePart)object).getArea());
            return;
        }
        this.isCancel = false;
        this.goal = Goal.VehicleSeat;
        this.goalVehicle = baseVehicle;
        object = (Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc();
        if (position.area == null) {
            baseVehicle.getPassengerPositionWorldPos(position, (Vector3f)object);
        } else {
            vector23 = (Vector2)BaseVehicle.TL_vector2_pool.get().alloc();
            area = baseVehicle.script.getAreaById(position.area);
            vector22 = baseVehicle.areaPositionWorld4PlayerInteract(area, vector23);
            ((Vector3f)object).x = vector22.x;
            ((Vector3f)object).y = vector22.y;
            ((Vector3f)object).z = 0.0f;
            BaseVehicle.TL_vector2_pool.get().release(vector23);
        }
        this.setData(((Vector3f)object).x(), ((Vector3f)object).y(), (int)((Vector3f)object).z());
        BaseVehicle.TL_vector3f_pool.get().release(object);
        if (this.chr instanceof IsoPlayer && (int)this.chr.z == (int)this.targetZ && !PolygonalMap2.instance.lineClearCollide(this.chr.x, this.chr.y, this.targetX, this.targetY, (int)this.targetZ, null)) {
            this.path.clear();
            this.path.addNode(this.chr.x, this.chr.y, this.chr.z);
            this.path.addNode(this.targetX, this.targetY, this.targetZ);
            this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.found;
        }
    }

    public void cancel() {
        this.isCancel = true;
    }

    public boolean getIsCancelled() {
        return this.isCancel;
    }

    public void setData(float f, float f2, float f3) {
        this.startX = this.chr.getX();
        this.startY = this.chr.getY();
        this.startZ = this.chr.getZ();
        this.targetX = f;
        this.targetY = f2;
        this.targetZ = f3;
        this.targetXYZ.resetQuick();
        this.pathIndex = 0;
        PolygonalMap2.instance.cancelRequest(this.chr);
        this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.notrunning;
        this.bStopping = false;
        actualPool.release((List<DebugPt>)this.actualPos);
        this.actualPos.clear();
    }

    public float getTargetX() {
        return this.targetX;
    }

    public float getTargetY() {
        return this.targetY;
    }

    public float getTargetZ() {
        return this.targetZ;
    }

    public float getPathLength() {
        if (this.path == null || this.path.nodes.size() == 0) {
            return (float)Math.sqrt((this.chr.x - this.targetX) * (this.chr.x - this.targetX) + (this.chr.y - this.targetY) * (this.chr.y - this.targetY));
        }
        if (this.pathIndex + 1 >= this.path.nodes.size()) {
            return (float)Math.sqrt((this.chr.x - this.targetX) * (this.chr.x - this.targetX) + (this.chr.y - this.targetY) * (this.chr.y - this.targetY));
        }
        float f = (float)Math.sqrt((this.chr.x - this.path.nodes.get((int)(this.pathIndex + 1)).x) * (this.chr.x - this.path.nodes.get((int)(this.pathIndex + 1)).x) + (this.chr.y - this.path.nodes.get((int)(this.pathIndex + 1)).y) * (this.chr.y - this.path.nodes.get((int)(this.pathIndex + 1)).y));
        for (int i = this.pathIndex + 2; i < this.path.nodes.size(); ++i) {
            f += (float)Math.sqrt((this.path.nodes.get((int)(i - 1)).x - this.path.nodes.get((int)i).x) * (this.path.nodes.get((int)(i - 1)).x - this.path.nodes.get((int)i).x) + (this.path.nodes.get((int)(i - 1)).y - this.path.nodes.get((int)i).y) * (this.path.nodes.get((int)(i - 1)).y - this.path.nodes.get((int)i).y));
        }
        return f;
    }

    public IsoGameCharacter getTargetChar() {
        return this.goal == Goal.Character ? this.goalCharacter : null;
    }

    public boolean isTargetLocation(float f, float f2, float f3) {
        return this.goal == Goal.Location && f == this.targetX && f2 == this.targetY && (int)f3 == (int)this.targetZ;
    }

    public BehaviorResult update() {
        float f;
        float f2;
        float f3;
        Object object;
        if (this.chr.getFinder().progress == AStarPathFinder.PathFindProgress.notrunning) {
            PolygonalMap2.PathFindRequest pathFindRequest = PolygonalMap2.instance.addRequest(this, this.chr, this.startX, this.startY, this.startZ, this.targetX, this.targetY, this.targetZ);
            pathFindRequest.targetXYZ.resetQuick();
            pathFindRequest.targetXYZ.addAll((TFloatCollection)this.targetXYZ);
            this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.notyetfound;
            this.walkingOnTheSpot.reset(this.chr.x, this.chr.y);
            this.updateWhileRunningPathfind();
            return BehaviorResult.Working;
        }
        if (this.chr.getFinder().progress == AStarPathFinder.PathFindProgress.notyetfound) {
            this.updateWhileRunningPathfind();
            return BehaviorResult.Working;
        }
        if (this.chr.getFinder().progress == AStarPathFinder.PathFindProgress.failed) {
            return BehaviorResult.Failed;
        }
        State state = this.chr.getCurrentState();
        if (Core.bDebug && DebugOptions.instance.PathfindRenderPath.getValue() && this.chr instanceof IsoPlayer) {
            this.actualPos.add(actualPool.alloc().init(this.chr.x, this.chr.y, this.chr.z, state == ClimbOverFenceState.instance() || state == ClimbThroughWindowState.instance()));
        }
        if (state == ClimbOverFenceState.instance() || state == ClimbThroughWindowState.instance()) {
            if (GameClient.bClient && this.chr instanceof IsoPlayer && !((IsoPlayer)this.chr).isLocalPlayer()) {
                this.chr.getDeferredMovement(tempVector2_2);
                this.chr.MoveUnmodded(tempVector2_2);
            }
            return BehaviorResult.Working;
        }
        if (this.chr.getVehicle() != null) {
            return BehaviorResult.Failed;
        }
        if (this.walkingOnTheSpot.check(this.chr.x, this.chr.y)) {
            return BehaviorResult.Failed;
        }
        this.chr.setMoving(true);
        this.chr.setPath2(this.path);
        IsoZombie isoZombie = Type.tryCastTo(this.chr, IsoZombie.class);
        if (this.goal == Goal.Character && isoZombie != null && this.goalCharacter != null && this.goalCharacter.getVehicle() != null && this.chr.DistToSquared(this.targetX, this.targetY) < 16.0f) {
            object = this.goalCharacter.getVehicle().chooseBestAttackPosition(this.goalCharacter, this.chr, tempVector3f_1);
            if (object == null) {
                return BehaviorResult.Failed;
            }
            if (Math.abs(((Vector3f)object).x - this.targetX) > 0.1f || Math.abs(((Vector3f)object).y - this.targetY) > 0.1f) {
                if (Math.abs(this.goalCharacter.getVehicle().getCurrentSpeedKmHour()) > 0.8f) {
                    if (!PolygonalMap2.instance.lineClearCollide(this.chr.x, this.chr.y, ((Vector3f)object).x, ((Vector3f)object).y, (int)this.targetZ, this.goalCharacter)) {
                        this.path.clear();
                        this.path.addNode(this.chr.x, this.chr.y, this.chr.z);
                        this.path.addNode(((Vector3f)object).x, ((Vector3f)object).y, ((Vector3f)object).z);
                    } else if (IsoUtils.DistanceToSquared(((Vector3f)object).x, ((Vector3f)object).y, this.targetX, this.targetY) > IsoUtils.DistanceToSquared(this.chr.x, this.chr.y, ((Vector3f)object).x, ((Vector3f)object).y)) {
                        return BehaviorResult.Working;
                    }
                } else if (isoZombie.AllowRepathDelay <= 0.0f) {
                    isoZombie.AllowRepathDelay = 6.25f;
                    if (PolygonalMap2.instance.lineClearCollide(this.chr.x, this.chr.y, ((Vector3f)object).x, ((Vector3f)object).y, (int)this.targetZ, null)) {
                        this.setData(((Vector3f)object).x, ((Vector3f)object).y, this.targetZ);
                        return BehaviorResult.Working;
                    }
                    this.path.clear();
                    this.path.addNode(this.chr.x, this.chr.y, this.chr.z);
                    this.path.addNode(((Vector3f)object).x, ((Vector3f)object).y, ((Vector3f)object).z);
                }
            }
        }
        PathFindBehavior2.closestPointOnPath(this.chr.x, this.chr.y, this.chr.z, this.chr, this.path, pointOnPath);
        this.pathIndex = PathFindBehavior2.pointOnPath.pathIndex;
        if (this.pathIndex == this.path.nodes.size() - 2) {
            object = this.path.nodes.get(this.path.nodes.size() - 1);
            if (IsoUtils.DistanceToSquared(this.chr.x, this.chr.y, ((PolygonalMap2.PathNode)object).x, ((PolygonalMap2.PathNode)object).y) <= 0.0025000002f) {
                this.chr.getDeferredMovement(tempVector2);
                if (tempVector2.getLength() > 0.0f) {
                    if (isoZombie != null || this.chr instanceof IsoPlayer) {
                        this.chr.setMoving(false);
                    }
                    this.bStopping = true;
                    return BehaviorResult.Working;
                }
                this.pathNextIsSet = false;
                return BehaviorResult.Succeeded;
            }
        } else if (this.pathIndex < this.path.nodes.size() - 2 && PathFindBehavior2.pointOnPath.dist > 0.999f) {
            ++this.pathIndex;
        }
        object = this.path.nodes.get(this.pathIndex);
        PolygonalMap2.PathNode pathNode = this.path.nodes.get(this.pathIndex + 1);
        this.pathNextX = pathNode.x;
        this.pathNextY = pathNode.y;
        this.pathNextIsSet = true;
        Vector2 vector22 = tempVector2.set(this.pathNextX - this.chr.x, this.pathNextY - this.chr.y);
        vector22.normalize();
        this.chr.getDeferredMovement(tempVector2_2);
        float f4 = tempVector2_2.getLength();
        if (isoZombie != null) {
            isoZombie.bRunning = false;
            if (SandboxOptions.instance.Lore.Speed.getValue() == 1) {
                isoZombie.bRunning = true;
            }
        }
        if ((f3 = f4 * (f2 = 1.0f)) >= (f = IsoUtils.DistanceTo(this.pathNextX, this.pathNextY, this.chr.x, this.chr.y))) {
            f4 *= f / f3;
            ++this.pathIndex;
        }
        if (isoZombie != null) {
            this.checkCrawlingTransition((PolygonalMap2.PathNode)object, pathNode, f);
        }
        if (isoZombie == null && f >= 0.5f) {
            if (this.checkDoorHoppableWindow(this.chr.x + vector22.x * Math.max(0.5f, f4), this.chr.y + vector22.y * Math.max(0.5f, f4), this.chr.z)) {
                return BehaviorResult.Failed;
            }
            if (state != this.chr.getCurrentState()) {
                return BehaviorResult.Working;
            }
        }
        if (f4 <= 0.0f) {
            this.walkingOnTheSpot.reset(this.chr.x, this.chr.y);
            return BehaviorResult.Working;
        }
        tempVector2_2.set(vector22);
        tempVector2_2.setLength(f4);
        this.chr.MoveUnmodded(tempVector2_2);
        if (this.isStrafing()) {
            if ((this.goal == Goal.VehicleAdjacent || this.goal == Goal.VehicleArea || this.goal == Goal.VehicleSeat) && this.goalVehicle != null) {
                this.chr.faceThisObject(this.goalVehicle);
            }
        } else if (!this.chr.isAiming()) {
            this.chr.faceLocationF(this.pathNextX, this.pathNextY);
        }
        return BehaviorResult.Working;
    }

    private void updateWhileRunningPathfind() {
        if (!this.pathNextIsSet) {
            return;
        }
        this.moveToPoint(this.pathNextX, this.pathNextY, 1.0f);
    }

    public void moveToPoint(float f, float f2, float f3) {
        if (this.chr instanceof IsoPlayer && this.chr.getCurrentState() == CollideWithWallState.instance()) {
            return;
        }
        IsoZombie isoZombie = Type.tryCastTo(this.chr, IsoZombie.class);
        Vector2 vector22 = tempVector2.set(f - this.chr.x, f2 - this.chr.y);
        if ((int)f == (int)this.chr.x && (int)f2 == (int)this.chr.y && vector22.getLength() <= 0.1f) {
            return;
        }
        vector22.normalize();
        this.chr.getDeferredMovement(tempVector2_2);
        float f4 = tempVector2_2.getLength();
        f4 *= f3;
        if (isoZombie != null) {
            isoZombie.bRunning = false;
            if (SandboxOptions.instance.Lore.Speed.getValue() == 1) {
                isoZombie.bRunning = true;
            }
        }
        if (f4 <= 0.0f) {
            return;
        }
        tempVector2_2.set(vector22);
        tempVector2_2.setLength(f4);
        this.chr.MoveUnmodded(tempVector2_2);
        this.chr.faceLocation(f - 0.5f, f2 - 0.5f);
        this.chr.getForwardDirection().set(f - this.chr.x, f2 - this.chr.y);
        this.chr.getForwardDirection().normalize();
    }

    public void moveToDir(IsoMovingObject isoMovingObject, float f) {
        Vector2 vector22 = tempVector2.set(isoMovingObject.x - this.chr.x, isoMovingObject.y - this.chr.y);
        if (vector22.getLength() <= 0.1f) {
            return;
        }
        vector22.normalize();
        this.chr.getDeferredMovement(tempVector2_2);
        float f2 = tempVector2_2.getLength();
        f2 *= f;
        if (this.chr instanceof IsoZombie) {
            ((IsoZombie)this.chr).bRunning = false;
            if (SandboxOptions.instance.Lore.Speed.getValue() == 1) {
                ((IsoZombie)this.chr).bRunning = true;
            }
        }
        if (f2 <= 0.0f) {
            return;
        }
        tempVector2_2.set(vector22);
        tempVector2_2.setLength(f2);
        this.chr.MoveUnmodded(tempVector2_2);
        this.chr.faceLocation(isoMovingObject.x - 0.5f, isoMovingObject.y - 0.5f);
        this.chr.getForwardDirection().set(isoMovingObject.x - this.chr.x, isoMovingObject.y - this.chr.y);
        this.chr.getForwardDirection().normalize();
    }

    private boolean checkDoorHoppableWindow(float f, float f2, float f3) {
        IsoObject isoObject;
        IsoGridSquare isoGridSquare = this.chr.getCurrentSquare();
        if (isoGridSquare == null) {
            return false;
        }
        IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(f, f2, f3);
        if (isoGridSquare2 == null || isoGridSquare2 == isoGridSquare) {
            return false;
        }
        int n = isoGridSquare2.x - isoGridSquare.x;
        int n2 = isoGridSquare2.y - isoGridSquare.y;
        if (n != 0 && n2 != 0) {
            return false;
        }
        IsoObject isoObject2 = this.chr.getCurrentSquare().getDoorTo(isoGridSquare2);
        if (isoObject2 instanceof IsoDoor) {
            isoObject = (IsoDoor)isoObject2;
            if (!((IsoDoor)isoObject).open) {
                ((IsoDoor)isoObject).ToggleDoor(this.chr);
                if (!((IsoDoor)isoObject).open) {
                    return true;
                }
            }
        } else if (isoObject2 instanceof IsoThumpable) {
            isoObject = (IsoThumpable)isoObject2;
            if (!((IsoThumpable)isoObject).open) {
                ((IsoThumpable)isoObject).ToggleDoor(this.chr);
                if (!((IsoThumpable)isoObject).open) {
                    return true;
                }
            }
        }
        if ((isoObject = isoGridSquare.getWindowTo(isoGridSquare2)) != null) {
            if (!((IsoWindow)isoObject).canClimbThrough(this.chr) || ((IsoWindow)isoObject).isSmashed() && !((IsoWindow)isoObject).isGlassRemoved()) {
                return true;
            }
            this.chr.climbThroughWindow((IsoWindow)isoObject);
            return false;
        }
        IsoThumpable isoThumpable = isoGridSquare.getWindowThumpableTo(isoGridSquare2);
        if (isoThumpable != null) {
            if (isoThumpable.isBarricaded()) {
                return true;
            }
            this.chr.climbThroughWindow(isoThumpable);
            return false;
        }
        IsoObject isoObject3 = isoGridSquare.getWindowFrameTo(isoGridSquare2);
        if (isoObject3 != null) {
            this.chr.climbThroughWindowFrame(isoObject3);
            return false;
        }
        if (n > 0 && isoGridSquare2.Is(IsoFlagType.HoppableW)) {
            this.chr.climbOverFence(IsoDirections.E);
        } else if (n < 0 && isoGridSquare.Is(IsoFlagType.HoppableW)) {
            this.chr.climbOverFence(IsoDirections.W);
        } else if (n2 < 0 && isoGridSquare.Is(IsoFlagType.HoppableN)) {
            this.chr.climbOverFence(IsoDirections.N);
        } else if (n2 > 0 && isoGridSquare2.Is(IsoFlagType.HoppableN)) {
            this.chr.climbOverFence(IsoDirections.S);
        }
        return false;
    }

    private void checkCrawlingTransition(PolygonalMap2.PathNode pathNode, PolygonalMap2.PathNode pathNode2, float f) {
        IsoZombie isoZombie = (IsoZombie)this.chr;
        if (this.pathIndex < this.path.nodes.size() - 2) {
            pathNode = this.path.nodes.get(this.pathIndex);
            pathNode2 = this.path.nodes.get(this.pathIndex + 1);
            f = IsoUtils.DistanceTo(pathNode2.x, pathNode2.y, this.chr.x, this.chr.y);
        }
        if (isoZombie.isCrawling()) {
            if (!isoZombie.isCanWalk()) {
                return;
            }
            if (isoZombie.isBeingSteppedOn()) {
                // empty if block
            }
            if (isoZombie.getStateMachine().getPrevious() == ZombieGetDownState.instance() && ZombieGetDownState.instance().isNearStartXY(isoZombie)) {
                return;
            }
            this.advanceAlongPath(this.chr.x, this.chr.y, this.chr.z, 0.5f, pointOnPath);
            if (!PolygonalMap2.instance.canStandAt(PathFindBehavior2.pointOnPath.x, PathFindBehavior2.pointOnPath.y, (int)isoZombie.z, null, false, true)) {
                return;
            }
            if (!pathNode2.hasFlag(1) && PolygonalMap2.instance.canStandAt(isoZombie.x, isoZombie.y, (int)isoZombie.z, null, false, true)) {
                isoZombie.setVariable("ShouldStandUp", true);
            }
        } else {
            if (pathNode.hasFlag(1) && pathNode2.hasFlag(1)) {
                isoZombie.setVariable("ShouldBeCrawling", true);
                ZombieGetDownState.instance().setParams(this.chr);
                return;
            }
            if (f < 0.4f && !pathNode.hasFlag(1) && pathNode2.hasFlag(1)) {
                isoZombie.setVariable("ShouldBeCrawling", true);
                ZombieGetDownState.instance().setParams(this.chr);
            }
        }
    }

    public boolean shouldGetUpFromCrawl() {
        return this.chr.getVariableBoolean("ShouldStandUp");
    }

    public boolean isStrafing() {
        if (this.chr.isZombie()) {
            return false;
        }
        return this.path.nodes.size() == 2 && IsoUtils.DistanceToSquared(this.startX, this.startY, this.startZ * 3.0f, this.targetX, this.targetY, this.targetZ * 3.0f) < 0.25f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closestPointOnPath(float f, float f2, float f3, IsoMovingObject isoMovingObject, PolygonalMap2.Path path, PointOnPath pointOnPath) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        pointOnPath.pathIndex = 0;
        float f4 = Float.MAX_VALUE;
        for (int i = 0; i < path.nodes.size() - 1; ++i) {
            float f5;
            IsoGridSquare isoGridSquare;
            int n;
            int n2;
            double d;
            double d2;
            double d3;
            PolygonalMap2.PathNode pathNode;
            PolygonalMap2.PathNode pathNode2;
            block11: {
                pathNode2 = path.nodes.get(i);
                pathNode = path.nodes.get(i + 1);
                if ((int)pathNode2.z != (int)f3 && (int)pathNode.z != (int)f3) continue;
                float f6 = pathNode2.x;
                float f7 = pathNode2.y;
                float f8 = pathNode.x;
                float f9 = pathNode.y;
                d3 = (double)((f - f6) * (f8 - f6) + (f2 - f7) * (f9 - f7)) / (Math.pow(f8 - f6, 2.0) + Math.pow(f9 - f7, 2.0));
                d2 = (double)f6 + d3 * (double)(f8 - f6);
                d = (double)f7 + d3 * (double)(f9 - f7);
                if (d3 <= 0.0) {
                    d2 = f6;
                    d = f7;
                    d3 = 0.0;
                } else if (d3 >= 1.0) {
                    d2 = f8;
                    d = f9;
                    d3 = 1.0;
                }
                n2 = (int)d2 - (int)f;
                n = (int)d - (int)f2;
                if ((n2 != 0 || n != 0) && Math.abs(n2) <= 1 && Math.abs(n) <= 1) {
                    IsoGridSquare isoGridSquare2 = isoCell.getGridSquare((int)f, (int)f2, (int)f3);
                    isoGridSquare = isoCell.getGridSquare((int)d2, (int)d, (int)f3);
                    if (isoMovingObject instanceof IsoZombie) {
                        boolean bl = ((IsoZombie)isoMovingObject).Ghost;
                        ((IsoZombie)isoMovingObject).Ghost = true;
                        try {
                            if (isoGridSquare2 != null && isoGridSquare != null && isoGridSquare2.testCollideAdjacent(isoMovingObject, n2, n, 0)) {
                                continue;
                            }
                            break block11;
                        }
                        finally {
                            ((IsoZombie)isoMovingObject).Ghost = bl;
                        }
                    }
                    if (isoGridSquare2 != null && isoGridSquare != null && isoGridSquare2.testCollideAdjacent(isoMovingObject, n2, n, 0)) continue;
                }
            }
            float f10 = f3;
            if (Math.abs(n2) <= 1 && Math.abs(n) <= 1) {
                isoGridSquare = isoCell.getGridSquare((int)pathNode2.x, (int)pathNode2.y, (int)pathNode2.z);
                IsoGridSquare isoGridSquare3 = isoCell.getGridSquare((int)pathNode.x, (int)pathNode.y, (int)pathNode.z);
                float f11 = isoGridSquare == null ? pathNode2.z : PolygonalMap2.instance.getApparentZ(isoGridSquare);
                float f12 = isoGridSquare3 == null ? pathNode.z : PolygonalMap2.instance.getApparentZ(isoGridSquare3);
                f10 = f11 + (f12 - f11) * (float)d3;
            }
            if (!((f5 = IsoUtils.DistanceToSquared(f, f2, f3, (float)d2, (float)d, f10)) < f4)) continue;
            f4 = f5;
            pointOnPath.pathIndex = i;
            pointOnPath.dist = d3 == 1.0 ? 1.0f : (float)d3;
            pointOnPath.x = (float)d2;
            pointOnPath.y = (float)d;
        }
    }

    void advanceAlongPath(float f, float f2, float f3, float f4, PointOnPath pointOnPath) {
        PathFindBehavior2.closestPointOnPath(f, f2, f3, this.chr, this.path, pointOnPath);
        for (int i = pointOnPath.pathIndex; i < this.path.nodes.size() - 1; ++i) {
            PolygonalMap2.PathNode pathNode = this.path.nodes.get(i);
            PolygonalMap2.PathNode pathNode2 = this.path.nodes.get(i + 1);
            double d = IsoUtils.DistanceTo2D(f, f2, pathNode2.x, pathNode2.y);
            if (!((double)f4 > d)) {
                pointOnPath.pathIndex = i;
                pointOnPath.dist += f4 / IsoUtils.DistanceTo2D(pathNode.x, pathNode.y, pathNode2.x, pathNode2.y);
                pointOnPath.x = pathNode.x + pointOnPath.dist * (pathNode2.x - pathNode.x);
                pointOnPath.y = pathNode.y + pointOnPath.dist * (pathNode2.y - pathNode.y);
                return;
            }
            f = pathNode2.x;
            f2 = pathNode2.y;
            f4 = (float)((double)f4 - d);
            pointOnPath.dist = 0.0f;
        }
        pointOnPath.pathIndex = this.path.nodes.size() - 1;
        pointOnPath.dist = 1.0f;
        pointOnPath.x = this.path.nodes.get((int)pointOnPath.pathIndex).x;
        pointOnPath.y = this.path.nodes.get((int)pointOnPath.pathIndex).y;
    }

    public void render() {
        float f;
        float f2;
        Object object;
        int n;
        if (this.chr.getCurrentState() == WalkTowardState.instance()) {
            WalkTowardState.instance().calculateTargetLocation((IsoZombie)this.chr, tempVector2);
            PathFindBehavior2.tempVector2.x -= this.chr.x;
            PathFindBehavior2.tempVector2.y -= this.chr.y;
            tempVector2.setLength(Math.min(100.0f, tempVector2.getLength()));
            LineDrawer.addLine(this.chr.x, this.chr.y, this.chr.z, this.chr.x + PathFindBehavior2.tempVector2.x, this.chr.y + PathFindBehavior2.tempVector2.y, this.targetZ, 1.0f, 1.0f, 1.0f, null, true);
            return;
        }
        if (this.chr.getPath2() == null) {
            return;
        }
        for (n = 0; n < this.path.nodes.size() - 1; ++n) {
            object = this.path.nodes.get(n);
            PolygonalMap2.PathNode pathNode = this.path.nodes.get(n + 1);
            f2 = 1.0f;
            f = 1.0f;
            if ((int)((PolygonalMap2.PathNode)object).z != (int)pathNode.z) {
                f = 0.0f;
            }
            LineDrawer.addLine(((PolygonalMap2.PathNode)object).x, ((PolygonalMap2.PathNode)object).y, ((PolygonalMap2.PathNode)object).z, pathNode.x, pathNode.y, pathNode.z, f2, f, 0.0f, null, true);
        }
        for (n = 0; n < this.path.nodes.size(); ++n) {
            object = this.path.nodes.get(n);
            float f3 = 1.0f;
            f2 = 1.0f;
            f = 0.0f;
            if (n == 0) {
                f3 = 0.0f;
                f = 1.0f;
            }
            LineDrawer.addLine(((PolygonalMap2.PathNode)object).x - 0.05f, ((PolygonalMap2.PathNode)object).y - 0.05f, ((PolygonalMap2.PathNode)object).z, ((PolygonalMap2.PathNode)object).x + 0.05f, ((PolygonalMap2.PathNode)object).y + 0.05f, ((PolygonalMap2.PathNode)object).z, f3, f2, f, null, false);
        }
        PathFindBehavior2.closestPointOnPath(this.chr.x, this.chr.y, this.chr.z, this.chr, this.path, pointOnPath);
        LineDrawer.addLine(PathFindBehavior2.pointOnPath.x - 0.05f, PathFindBehavior2.pointOnPath.y - 0.05f, this.chr.z, PathFindBehavior2.pointOnPath.x + 0.05f, PathFindBehavior2.pointOnPath.y + 0.05f, this.chr.z, 0.0f, 1.0f, 0.0f, null, false);
        for (n = 0; n < this.actualPos.size() - 1; ++n) {
            object = this.actualPos.get(n);
            DebugPt debugPt = this.actualPos.get(n + 1);
            LineDrawer.addLine(((DebugPt)object).x, ((DebugPt)object).y, this.chr.z, debugPt.x, debugPt.y, this.chr.z, 1.0f, 1.0f, 1.0f, null, true);
            LineDrawer.addLine(((DebugPt)object).x - 0.05f, ((DebugPt)object).y - 0.05f, this.chr.z, ((DebugPt)object).x + 0.05f, ((DebugPt)object).y + 0.05f, this.chr.z, 1.0f, ((DebugPt)object).climbing ? 1.0f : 0.0f, 0.0f, null, false);
        }
    }

    @Override
    public void Succeeded(PolygonalMap2.Path path, Mover mover) {
        this.path.copyFrom(path);
        if (!this.isCancel) {
            this.chr.setPath2(this.path);
        }
        if (!path.isEmpty()) {
            PolygonalMap2.PathNode pathNode = path.nodes.get(path.nodes.size() - 1);
            this.targetX = pathNode.x;
            this.targetY = pathNode.y;
            this.targetZ = pathNode.z;
        }
        this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.found;
    }

    @Override
    public void Failed(Mover mover) {
        this.chr.getFinder().progress = AStarPathFinder.PathFindProgress.failed;
    }

    public boolean isMovingUsingPathFind() {
        return !this.bStopping && !this.isGoalNone() && !this.isCancel;
    }

    public class NPCData {
        public boolean doDirectMovement;
        public int MaxSteps;
        public int nextTileX;
        public int nextTileY;
        public int nextTileZ;
    }

    private static enum Goal {
        None,
        Character,
        Location,
        Sound,
        VehicleAdjacent,
        VehicleArea,
        VehicleSeat;

    }

    public static enum BehaviorResult {
        Working,
        Failed,
        Succeeded;

    }

    private static final class DebugPt {
        float x;
        float y;
        float z;
        boolean climbing;

        private DebugPt() {
        }

        DebugPt init(float f, float f2, float f3, boolean bl) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.climbing = bl;
            return this;
        }
    }

    public static final class PointOnPath {
        int pathIndex;
        float dist;
        float x;
        float y;
    }
}

