/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Externalizable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import org.joml.Vector2f;
import org.joml.Vector3f;
import se.krka.kahlua.converter.KahluaConverterManager;
import se.krka.kahlua.integration.LuaCaller;
import se.krka.kahlua.j2se.J2SEPlatform;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaThread;
import zombie.Lua.LuaManager;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.skinnedmodel.ModelManager;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.input.GameKeyboard;
import zombie.scripting.ScriptManager;
import zombie.scripting.ScriptParser;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.VehicleScript;
import zombie.ui.UIElement;
import zombie.ui.UIManager;
import zombie.util.list.PZArrayUtil;

public final class EditVehicleState
extends GameState {
    public static EditVehicleState instance;
    private LuaEnvironment m_luaEnv;
    private boolean bExit = false;
    private String m_initialScript = null;
    private final ArrayList<UIElement> m_gameUI = new ArrayList();
    private final ArrayList<UIElement> m_selfUI = new ArrayList();
    private boolean m_bSuspendUI;
    private KahluaTable m_table = null;

    public EditVehicleState() {
        instance = this;
    }

    @Override
    public void enter() {
        instance = this;
        if (this.m_luaEnv == null) {
            this.m_luaEnv = new LuaEnvironment(LuaManager.platform, LuaManager.converterManager, LuaManager.env);
        }
        this.saveGameUI();
        if (this.m_selfUI.size() == 0) {
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_luaEnv.env.rawget("EditVehicleState_InitUI"), new Object[0]);
            if (this.m_table != null && this.m_table.getMetatable() != null) {
                this.m_table.getMetatable().rawset("_LUA_RELOADED_CHECK", (Object)Boolean.FALSE);
            }
        } else {
            UIManager.UI.addAll(this.m_selfUI);
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_table.rawget("showUI"), (Object)this.m_table);
        }
        this.bExit = false;
    }

    @Override
    public void yield() {
        this.restoreGameUI();
    }

    @Override
    public void reenter() {
        this.saveGameUI();
    }

    @Override
    public void exit() {
        this.restoreGameUI();
    }

    @Override
    public void render() {
        int n = 0;
        Core.getInstance().StartFrame(n, true);
        this.renderScene();
        Core.getInstance().EndFrame(n);
        Core.getInstance().RenderOffScreenBuffer();
        if (Core.getInstance().StartFrameUI()) {
            this.renderUI();
        }
        Core.getInstance().EndFrameUI();
    }

    @Override
    public GameStateMachine.StateAction update() {
        if (this.bExit || GameKeyboard.isKeyPressed(65)) {
            return GameStateMachine.StateAction.Continue;
        }
        this.updateScene();
        return GameStateMachine.StateAction.Remain;
    }

    public static EditVehicleState checkInstance() {
        if (instance != null) {
            if (EditVehicleState.instance.m_table == null || EditVehicleState.instance.m_table.getMetatable() == null) {
                instance = null;
            } else if (EditVehicleState.instance.m_table.getMetatable().rawget("_LUA_RELOADED_CHECK") == null) {
                instance = null;
            }
        }
        if (instance == null) {
            return new EditVehicleState();
        }
        return instance;
    }

    private void saveGameUI() {
        this.m_gameUI.clear();
        this.m_gameUI.addAll(UIManager.UI);
        UIManager.UI.clear();
        this.m_bSuspendUI = UIManager.bSuspend;
        UIManager.bSuspend = false;
        UIManager.setShowPausedMessage(false);
        UIManager.defaultthread = this.m_luaEnv.thread;
    }

    private void restoreGameUI() {
        this.m_selfUI.clear();
        this.m_selfUI.addAll(UIManager.UI);
        UIManager.UI.clear();
        UIManager.UI.addAll(this.m_gameUI);
        UIManager.bSuspend = this.m_bSuspendUI;
        UIManager.setShowPausedMessage(true);
        UIManager.defaultthread = LuaManager.thread;
    }

    private void updateScene() {
        ModelManager.instance.update();
        if (GameKeyboard.isKeyPressed(17)) {
            DebugOptions.instance.ModelRenderWireframe.setValue(!DebugOptions.instance.ModelRenderWireframe.getValue());
        }
    }

    private void renderScene() {
    }

    private void renderUI() {
        UIManager.render();
    }

    public void setTable(KahluaTable kahluaTable) {
        this.m_table = kahluaTable;
    }

    public void setScript(String string) {
        if (this.m_table == null) {
            this.m_initialScript = string;
        } else {
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_table.rawget("setScript"), this.m_table, string);
        }
    }

    public Object fromLua0(String string) {
        switch (string) {
            case "exit": {
                this.bExit = true;
                return null;
            }
            case "getInitialScript": {
                return this.m_initialScript;
            }
        }
        throw new IllegalArgumentException("unhandled \"" + string + "\"");
    }

    public Object fromLua1(String string, Object object) {
        switch (string) {
            case "writeScript": {
                VehicleScript vehicleScript = ScriptManager.instance.getVehicle((String)object);
                if (vehicleScript == null) {
                    throw new NullPointerException("vehicle script \"" + object + "\" not found");
                }
                ArrayList<String> arrayList = this.readScript(vehicleScript.getFileName());
                if (arrayList != null) {
                    this.updateScript(vehicleScript.getFileName(), arrayList, vehicleScript);
                }
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\"", string, object));
    }

    private ArrayList<String> readScript(String string) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        string = ZomboidFileSystem.instance.getString(string);
        File file = new File(string);
        try {
            object = new FileReader(file);
            try (BufferedReader bufferedReader = new BufferedReader((Reader)object);){
                String string2;
                String string3 = System.lineSeparator();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append(string3);
                }
            }
            finally {
                ((InputStreamReader)object).close();
            }
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
            return null;
        }
        object = ScriptParser.stripComments(stringBuilder.toString());
        return ScriptParser.parseTokens((String)object);
    }

    private void updateScript(String string, ArrayList<String> arrayList, VehicleScript vehicleScript) {
        string = ZomboidFileSystem.instance.getString(string);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            String string2;
            String string3 = arrayList.get(i).trim();
            int n = string3.indexOf("{");
            int n2 = string3.lastIndexOf("}");
            String string4 = string3.substring(0, n);
            if (!string4.startsWith("module")) continue;
            string4 = string3.substring(0, n).trim();
            String[] stringArray = string4.split("\\s+");
            String string5 = string2 = stringArray.length > 1 ? stringArray[1].trim() : "";
            if (!string2.equals(vehicleScript.getModule().getName())) continue;
            String string6 = string3.substring(n + 1, n2).trim();
            ArrayList<String> arrayList2 = ScriptParser.parseTokens(string6);
            for (int j = arrayList2.size() - 1; j >= 0; --j) {
                String string7;
                String string8 = arrayList2.get(j).trim();
                if (!string8.startsWith("vehicle")) continue;
                n = string8.indexOf("{");
                string4 = string8.substring(0, n).trim();
                stringArray = string4.split("\\s+");
                String string9 = string7 = stringArray.length > 1 ? stringArray[1].trim() : "";
                if (!string7.equals(vehicleScript.getName())) continue;
                string8 = this.vehicleScriptToText(vehicleScript, string8).trim();
                arrayList2.set(j, string8);
                String string10 = System.lineSeparator();
                Object object = String.join((CharSequence)(string10 + "\t"), arrayList2);
                object = "module " + string2 + string10 + "{" + string10 + "\t" + (String)object + string10 + "}" + string10;
                arrayList.set(i, (String)object);
                this.writeScript(string, arrayList);
                return;
            }
        }
    }

    private String vehicleScriptToText(VehicleScript vehicleScript, String string) {
        int n;
        int n2;
        Object object;
        float f = vehicleScript.getModelScale();
        ScriptParser.Block block = ScriptParser.parse(string);
        block = block.children.get(0);
        Object object2 = vehicleScript.getModel();
        ScriptParser.Block block2 = block.getBlock("model", null);
        if (object2 != null && block2 != null) {
            float f2 = vehicleScript.getModelScale();
            block2.setValue("scale", String.format(Locale.US, "%.4f", Float.valueOf(f2)));
            object = vehicleScript.getModel().getOffset();
            block2.setValue("offset", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(((Vector3f)object).x / f), Float.valueOf(((Vector3f)object).y / f), Float.valueOf(((Vector3f)object).z / f)));
        }
        object2 = new ArrayList();
        for (n2 = 0; n2 < block.children.size(); ++n2) {
            ScriptParser.Block block3 = block.children.get(n2);
            if (!"physics".equals(block3.type)) continue;
            if (((ArrayList)object2).size() == vehicleScript.getPhysicsShapeCount()) {
                block.elements.remove(block3);
                block.children.remove(n2);
                --n2;
                continue;
            }
            ((ArrayList)object2).add(block3);
        }
        for (n2 = 0; n2 < vehicleScript.getPhysicsShapeCount(); ++n2) {
            VehicleScript.PhysicsShape physicsShape = vehicleScript.getPhysicsShape(n2);
            boolean bl = n2 < ((ArrayList)object2).size();
            ScriptParser.Block block4 = bl ? (ScriptParser.Block)((ArrayList)object2).get(n2) : new ScriptParser.Block();
            block4.type = "physics";
            block4.id = physicsShape.getTypeString();
            if (bl) {
                block4.elements.clear();
                block4.children.clear();
                block4.values.clear();
            }
            block4.setValue("offset", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(physicsShape.getOffset().x() / f), Float.valueOf(physicsShape.getOffset().y() / f), Float.valueOf(physicsShape.getOffset().z() / f)));
            if (physicsShape.type == 1) {
                block4.setValue("extents", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(physicsShape.getExtents().x() / f), Float.valueOf(physicsShape.getExtents().y() / f), Float.valueOf(physicsShape.getExtents().z() / f)));
                block4.setValue("rotate", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(physicsShape.getRotate().x()), Float.valueOf(physicsShape.getRotate().y()), Float.valueOf(physicsShape.getRotate().z())));
            }
            if (physicsShape.type == 2) {
                block4.setValue("radius", String.format(Locale.US, "%.4f", Float.valueOf(physicsShape.getRadius() / f)));
            }
            if (bl) continue;
            block.elements.add(block4);
            block.children.add(block4);
        }
        for (n2 = block.children.size() - 1; n2 >= 0; --n2) {
            ScriptParser.Block block5 = block.children.get(n2);
            if (!"attachment".equals(block5.type)) continue;
            block.elements.remove(block5);
            block.children.remove(n2);
        }
        for (n2 = 0; n2 < vehicleScript.getAttachmentCount(); ++n2) {
            ModelAttachment modelAttachment = vehicleScript.getAttachment(n2);
            object = block.getBlock("attachment", modelAttachment.getId());
            if (object == null) {
                object = new ScriptParser.Block();
                ((ScriptParser.Block)object).type = "attachment";
                ((ScriptParser.Block)object).id = modelAttachment.getId();
                block.elements.add((ScriptParser.BlockElement)object);
                block.children.add((ScriptParser.Block)object);
            }
            ((ScriptParser.Block)object).setValue("offset", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(modelAttachment.getOffset().x() / f), Float.valueOf(modelAttachment.getOffset().y() / f), Float.valueOf(modelAttachment.getOffset().z() / f)));
            ((ScriptParser.Block)object).setValue("rotate", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(modelAttachment.getRotate().x()), Float.valueOf(modelAttachment.getRotate().y()), Float.valueOf(modelAttachment.getRotate().z())));
            if (modelAttachment.getBone() != null) {
                ((ScriptParser.Block)object).setValue("bone", modelAttachment.getBone());
            }
            if (modelAttachment.getCanAttach() != null) {
                ((ScriptParser.Block)object).setValue("canAttach", PZArrayUtil.arrayToString(modelAttachment.getCanAttach(), "", "", ","));
            }
            if (modelAttachment.getZOffset() != 0.0f) {
                ((ScriptParser.Block)object).setValue("zoffset", String.format(Locale.US, "%.4f", Float.valueOf(modelAttachment.getZOffset())));
            }
            if (modelAttachment.isUpdateConstraint()) continue;
            ((ScriptParser.Block)object).setValue("updateconstraint", "false");
        }
        Externalizable externalizable = vehicleScript.getExtents();
        block.setValue("extents", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(externalizable.x / f), Float.valueOf(externalizable.y / f), Float.valueOf(externalizable.z / f)));
        externalizable = vehicleScript.getPhysicsChassisShape();
        block.setValue("physicsChassisShape", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(externalizable.x / f), Float.valueOf(externalizable.y / f), Float.valueOf(externalizable.z / f)));
        externalizable = vehicleScript.getCenterOfMassOffset();
        block.setValue("centerOfMassOffset", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(externalizable.x / f), Float.valueOf(externalizable.y / f), Float.valueOf(externalizable.z / f)));
        externalizable = vehicleScript.getShadowExtents();
        boolean bl = block.getValue("shadowExtents") != null;
        block.setValue("shadowExtents", String.format(Locale.US, "%.4f %.4f", Float.valueOf(((Vector2f)externalizable).x / f), Float.valueOf(((Vector2f)externalizable).y / f)));
        if (!bl) {
            block.moveValueAfter("shadowExtents", "centerOfMassOffset");
        }
        externalizable = vehicleScript.getShadowOffset();
        bl = block.getValue("shadowOffset") != null;
        block.setValue("shadowOffset", String.format(Locale.US, "%.4f %.4f", Float.valueOf(((Vector2f)externalizable).x / f), Float.valueOf(((Vector2f)externalizable).y / f)));
        if (!bl) {
            block.moveValueAfter("shadowOffset", "shadowExtents");
        }
        for (n = 0; n < vehicleScript.getAreaCount(); ++n) {
            VehicleScript.Area area = vehicleScript.getArea(n);
            object = block.getBlock("area", area.getId());
            if (object == null) continue;
            ((ScriptParser.Block)object).setValue("xywh", String.format(Locale.US, "%.4f %.4f %.4f %.4f", area.getX() / (double)f, area.getY() / (double)f, area.getW() / (double)f, area.getH() / (double)f));
        }
        for (n = 0; n < vehicleScript.getPassengerCount(); ++n) {
            VehicleScript.Passenger passenger = vehicleScript.getPassenger(n);
            object = block.getBlock("passenger", passenger.getId());
            if (object == null) continue;
            for (VehicleScript.Position position : passenger.positions) {
                ScriptParser.Block block6 = ((ScriptParser.Block)object).getBlock("position", position.id);
                if (block6 == null) continue;
                block6.setValue("offset", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(position.offset.x / f), Float.valueOf(position.offset.y / f), Float.valueOf(position.offset.z / f)));
                block6.setValue("rotate", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(position.rotate.x / f), Float.valueOf(position.rotate.y / f), Float.valueOf(position.rotate.z / f)));
            }
        }
        for (n = 0; n < vehicleScript.getWheelCount(); ++n) {
            VehicleScript.Wheel wheel = vehicleScript.getWheel(n);
            object = block.getBlock("wheel", wheel.getId());
            if (object == null) continue;
            ((ScriptParser.Block)object).setValue("offset", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(wheel.offset.x / f), Float.valueOf(wheel.offset.y / f), Float.valueOf(wheel.offset.z / f)));
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = System.lineSeparator();
        block.prettyPrint(1, stringBuilder, string2);
        return stringBuilder.toString();
    }

    private void writeScript(String string, ArrayList<String> arrayList) {
        String string2 = ZomboidFileSystem.instance.getString(string);
        File file = new File(string2);
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            DebugLog.General.printf("writing %s\n", string);
            for (String string3 : arrayList) {
                bufferedWriter.write(string3);
            }
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_table.rawget("wroteScript"), this.m_table, string2);
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
    }

    public static final class LuaEnvironment {
        public J2SEPlatform platform;
        public KahluaTable env;
        public KahluaThread thread;
        public LuaCaller caller;

        public LuaEnvironment(J2SEPlatform j2SEPlatform, KahluaConverterManager kahluaConverterManager, KahluaTable kahluaTable) {
            this.platform = j2SEPlatform;
            this.env = kahluaTable;
            this.thread = LuaManager.thread;
            this.caller = LuaManager.caller;
        }
    }
}

