/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import org.joml.Vector2f;
import org.joml.Vector3f;
import zombie.GameWindow;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.popman.ObjectPool;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.Clipper;
import zombie.vehicles.PolygonalMap2;

public class CollideWithObstaclesPoly {
    static final float RADIUS = 0.3f;
    private final ArrayList<CCObstacle> obstacles = new ArrayList();
    private final ArrayList<CCNode> nodes = new ArrayList();
    private final ImmutableRectF moveBounds = new ImmutableRectF();
    private final ImmutableRectF vehicleBounds = new ImmutableRectF();
    private static final Vector2 move = new Vector2();
    private static final Vector2 nodeNormal = new Vector2();
    private static final Vector2 edgeVec = new Vector2();
    private final ArrayList<BaseVehicle> vehicles = new ArrayList();
    private Clipper clipper;
    private final ByteBuffer xyBuffer = ByteBuffer.allocateDirect(8192);
    private final ClosestPointOnEdge closestPointOnEdge = new ClosestPointOnEdge();

    void getVehiclesInRect(float f, float f2, float f3, float f4, int n) {
        this.vehicles.clear();
        int n2 = (int)(f / 10.0f);
        int n3 = (int)(f2 / 10.0f);
        int n4 = (int)Math.ceil(f3 / 10.0f);
        int n5 = (int)Math.ceil(f4 / 10.0f);
        for (int i = n3; i < n5; ++i) {
            for (int j = n2; j < n4; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(j * 10, i * 10, 0);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if (baseVehicle.getScript() == null || (int)baseVehicle.z != n) continue;
                    this.vehicles.add(baseVehicle);
                }
            }
        }
    }

    void getObstaclesInRect(float f, float f2, float f3, float f4, int n, int n2, int n3, boolean bl) {
        if (this.clipper == null) {
            this.clipper = new Clipper();
        }
        this.clipper.clear();
        this.moveBounds.init(f - 2.0f, f2 - 2.0f, f3 - f + 4.0f, f4 - f2 + 4.0f);
        int n4 = (int)(this.moveBounds.x / 10.0f);
        int n5 = (int)(this.moveBounds.y / 10.0f);
        int n6 = (int)Math.ceil(this.moveBounds.right() / 10.0f);
        int n7 = (int)Math.ceil(this.moveBounds.bottom() / 10.0f);
        if (Math.abs(f3 - f) < 2.0f && Math.abs(f4 - f2) < 2.0f) {
            n4 = n / 10;
            n5 = n2 / 10;
            n6 = n4 + 1;
            n7 = n5 + 1;
        }
        for (int i = n5; i < n7; ++i) {
            for (int j = n4; j < n6; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunk(j, i);
                if (isoChunk == null) continue;
                ChunkDataZ chunkDataZ = isoChunk.collision.init(isoChunk, n3, this);
                ArrayList<CCObstacle> arrayList = bl ? chunkDataZ.worldVehicleUnion : chunkDataZ.worldVehicleSeparate;
                for (int k = 0; k < arrayList.size(); ++k) {
                    CCObstacle cCObstacle = arrayList.get(k);
                    if (!cCObstacle.bounds.intersects(this.moveBounds)) continue;
                    this.obstacles.add(cCObstacle);
                }
                this.nodes.addAll(chunkDataZ.nodes);
            }
        }
    }

    public Vector2f resolveCollision(IsoGameCharacter isoGameCharacter, float f, float f2, Vector2f vector2f) {
        Object object;
        float f3;
        Object object2;
        vector2f.set(f, f2);
        boolean bl = Core.bDebug && DebugOptions.instance.CollideWithObstaclesRenderObstacles.getValue();
        float f4 = isoGameCharacter.x;
        float f5 = isoGameCharacter.y;
        float f6 = f;
        float f7 = f2;
        if (bl) {
            LineDrawer.addLine(f4, f5, (int)isoGameCharacter.z, f6, f7, (int)isoGameCharacter.z, 1.0f, 1.0f, 1.0f, null, true);
        }
        if (f4 == f6 && f5 == f7) {
            return vector2f;
        }
        move.set(f - isoGameCharacter.x, f2 - isoGameCharacter.y);
        move.normalize();
        this.nodes.clear();
        this.obstacles.clear();
        this.getObstaclesInRect(Math.min(f4, f6), Math.min(f5, f7), Math.max(f4, f6), Math.max(f5, f7), (int)isoGameCharacter.x, (int)isoGameCharacter.y, (int)isoGameCharacter.z, true);
        this.closestPointOnEdge.edge = null;
        this.closestPointOnEdge.node = null;
        this.closestPointOnEdge.distSq = Double.MAX_VALUE;
        for (int i = 0; i < this.obstacles.size(); ++i) {
            int n;
            object2 = this.obstacles.get(i);
            if (!((CCObstacle)object2).isPointInside(isoGameCharacter.x, isoGameCharacter.y, n = 0)) continue;
            ((CCObstacle)object2).getClosestPointOnEdge(isoGameCharacter.x, isoGameCharacter.y, this.closestPointOnEdge);
        }
        Object object3 = this.closestPointOnEdge.edge;
        object2 = this.closestPointOnEdge.node;
        if (object3 != null && (f3 = ((CCEdge)object3).normal.dot(move)) >= 0.01f) {
            object3 = null;
        }
        if (object2 != null && ((CCNode)object2).getNormalAndEdgeVectors(nodeNormal, edgeVec) && nodeNormal.dot(move) + 0.05f >= nodeNormal.dot(edgeVec)) {
            object2 = null;
            object3 = null;
        }
        if (object3 == null) {
            this.closestPointOnEdge.edge = null;
            this.closestPointOnEdge.node = null;
            this.closestPointOnEdge.distSq = Double.MAX_VALUE;
            for (int i = 0; i < this.obstacles.size(); ++i) {
                object = this.obstacles.get(i);
                ((CCObstacle)object).lineSegmentIntersect(f4, f5, f6, f7, this.closestPointOnEdge, bl);
            }
            object3 = this.closestPointOnEdge.edge;
            object2 = this.closestPointOnEdge.node;
        }
        if (object2 != null) {
            move.set(f - isoGameCharacter.x, f2 - isoGameCharacter.y);
            move.normalize();
            CCEdge cCEdge = object3;
            object = null;
            for (int i = 0; i < ((CCNode)object2).edges.size(); ++i) {
                CCEdge cCEdge2 = ((CCNode)object2).edges.get(i);
                if (cCEdge2 == object3 || cCEdge.node1.x == cCEdge2.node1.x && cCEdge.node1.y == cCEdge2.node1.y && cCEdge.node2.x == cCEdge2.node2.x && cCEdge.node2.y == cCEdge2.node2.y || cCEdge.node1.x == cCEdge2.node2.x && cCEdge.node1.y == cCEdge2.node2.y && cCEdge.node2.x == cCEdge2.node1.x && cCEdge.node2.y == cCEdge2.node1.y || cCEdge.hasNode(cCEdge2.node1) && cCEdge.hasNode(cCEdge2.node2)) continue;
                object = cCEdge2;
            }
            if (cCEdge != null && object != null) {
                if (object3 == cCEdge) {
                    CCNode cCNode = object2 == ((CCEdge)object).node1 ? ((CCEdge)object).node2 : ((CCEdge)object).node1;
                    edgeVec.set(cCNode.x - ((CCNode)object2).x, cCNode.y - ((CCNode)object2).y);
                    edgeVec.normalize();
                    if (move.dot(edgeVec) >= 0.0f) {
                        object3 = object;
                    }
                } else if (object3 == object) {
                    CCNode cCNode = object2 == cCEdge.node1 ? cCEdge.node2 : cCEdge.node1;
                    edgeVec.set(cCNode.x - ((CCNode)object2).x, cCNode.y - ((CCNode)object2).y);
                    edgeVec.normalize();
                    if (move.dot(edgeVec) >= 0.0f) {
                        object3 = cCEdge;
                    }
                }
            }
        }
        if (object3 != null) {
            if (bl) {
                float f8 = ((CCEdge)object3).node1.x;
                float f9 = ((CCEdge)object3).node1.y;
                float f10 = ((CCEdge)object3).node2.x;
                float f11 = ((CCEdge)object3).node2.y;
                LineDrawer.addLine(f8, f9, ((CCEdge)object3).node1.z, f10, f11, ((CCEdge)object3).node1.z, 0.0f, 1.0f, 1.0f, null, true);
            }
            this.closestPointOnEdge.distSq = Double.MAX_VALUE;
            ((CCEdge)object3).getClosestPointOnEdge(f, f2, this.closestPointOnEdge);
            vector2f.set(this.closestPointOnEdge.point.x, this.closestPointOnEdge.point.y);
        }
        return vector2f;
    }

    boolean canStandAt(float f, float f2, float f3, BaseVehicle baseVehicle, int n) {
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        float f4 = f - 0.3f;
        float f5 = f2 - 0.3f;
        float f6 = f + 0.3f;
        float f7 = f2 + 0.3f;
        this.nodes.clear();
        this.obstacles.clear();
        this.getObstaclesInRect(Math.min(f4, f6), Math.min(f5, f7), Math.max(f4, f6), Math.max(f5, f7), (int)f, (int)f2, (int)f3, baseVehicle == null);
        for (int i = 0; i < this.obstacles.size(); ++i) {
            CCObstacle cCObstacle = this.obstacles.get(i);
            if (baseVehicle != null && cCObstacle.vehicle == baseVehicle || !cCObstacle.isPointInside(f, f2, n)) continue;
            return false;
        }
        return true;
    }

    public boolean isNotClear(float f, float f2, float f3, float f4, int n, boolean bl, BaseVehicle baseVehicle, boolean bl2, boolean bl3) {
        int n2;
        double d;
        int n3;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        double d2 = Math.abs((f3 /= 10.0f) - (f /= 10.0f));
        double d3 = Math.abs((f4 /= 10.0f) - (f2 /= 10.0f));
        int n4 = (int)Math.floor(f);
        int n5 = (int)Math.floor(f2);
        int n6 = 1;
        if (d2 == 0.0) {
            n3 = 0;
            d = Double.POSITIVE_INFINITY;
        } else if (f3 > f) {
            n3 = 1;
            n6 += (int)Math.floor(f3) - n4;
            d = (Math.floor(f) + 1.0 - (double)f) * d3;
        } else {
            n3 = -1;
            n6 += n4 - (int)Math.floor(f3);
            d = ((double)f - Math.floor(f)) * d3;
        }
        if (d3 == 0.0) {
            n2 = 0;
            d -= Double.POSITIVE_INFINITY;
        } else if (f4 > f2) {
            n2 = 1;
            n6 += (int)Math.floor(f4) - n5;
            d -= (Math.floor(f2) + 1.0 - (double)f2) * d2;
        } else {
            n2 = -1;
            n6 += n5 - (int)Math.floor(f4);
            d -= ((double)f2 - Math.floor(f2)) * d2;
        }
        while (n6 > 0) {
            IsoChunk isoChunk;
            IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(n4, n5) : IsoWorld.instance.CurrentCell.getChunk(n4, n5);
            if (isoChunk != null) {
                if (bl) {
                    LineDrawer.addRect(n4 * 10, n5 * 10, n, 10.0f, 10.0f, 1.0f, 1.0f, 1.0f);
                }
                ChunkDataZ chunkDataZ = isoChunk.collision.init(isoChunk, n, this);
                ArrayList<CCObstacle> arrayList = baseVehicle == null ? chunkDataZ.worldVehicleUnion : chunkDataZ.worldVehicleSeparate;
                for (int i = 0; i < arrayList.size(); ++i) {
                    CCObstacle cCObstacle = arrayList.get(i);
                    if (baseVehicle != null && cCObstacle.vehicle == baseVehicle || !cCObstacle.lineSegmentIntersects(f5, f6, f7, f8, bl)) continue;
                    return true;
                }
            }
            if (d > 0.0) {
                n5 += n2;
                d -= d2;
            } else {
                n4 += n3;
                d += d3;
            }
            --n6;
        }
        return false;
    }

    private void vehicleMoved(PolygonalMap2.VehiclePoly vehiclePoly) {
        int n = 2;
        int n2 = (int)Math.min(vehiclePoly.x1, Math.min(vehiclePoly.x2, Math.min(vehiclePoly.x3, vehiclePoly.x4)));
        int n3 = (int)Math.min(vehiclePoly.y1, Math.min(vehiclePoly.y2, Math.min(vehiclePoly.y3, vehiclePoly.y4)));
        int n4 = (int)Math.max(vehiclePoly.x1, Math.max(vehiclePoly.x2, Math.max(vehiclePoly.x3, vehiclePoly.x4)));
        int n5 = (int)Math.max(vehiclePoly.y1, Math.max(vehiclePoly.y2, Math.max(vehiclePoly.y3, vehiclePoly.y4)));
        int n6 = (int)vehiclePoly.z;
        int n7 = (n2 - n) / 10;
        int n8 = (n3 - n) / 10;
        int n9 = (int)Math.ceil(((float)(n4 + n) - 1.0f) / 10.0f);
        int n10 = (int)Math.ceil(((float)(n5 + n) - 1.0f) / 10.0f);
        for (int i = n8; i <= n10; ++i) {
            for (int j = n7; j <= n9; ++j) {
                IsoChunk isoChunk = IsoWorld.instance.CurrentCell.getChunk(j, i);
                if (isoChunk == null || isoChunk.collision.data[n6] == null) continue;
                ChunkDataZ chunkDataZ = isoChunk.collision.data[n6];
                isoChunk.collision.data[n6] = null;
                chunkDataZ.clear();
                ChunkDataZ.pool.release(chunkDataZ);
            }
        }
    }

    public void vehicleMoved(PolygonalMap2.VehiclePoly vehiclePoly, PolygonalMap2.VehiclePoly vehiclePoly2) {
        this.vehicleMoved(vehiclePoly);
        this.vehicleMoved(vehiclePoly2);
    }

    public void render() {
        boolean bl;
        boolean bl2 = bl = Core.bDebug && DebugOptions.instance.CollideWithObstaclesRenderObstacles.getValue();
        if (bl) {
            IsoPlayer isoPlayer = IsoPlayer.getInstance();
            if (isoPlayer == null) {
                return;
            }
            this.nodes.clear();
            this.obstacles.clear();
            this.getObstaclesInRect(isoPlayer.x, isoPlayer.y, isoPlayer.x, isoPlayer.y, (int)isoPlayer.x, (int)isoPlayer.y, (int)isoPlayer.z, true);
            if (DebugOptions.instance.CollideWithObstaclesRenderNormals.getValue()) {
                for (CCNode object : this.nodes) {
                    if (!object.getNormalAndEdgeVectors(nodeNormal, edgeVec)) continue;
                    LineDrawer.addLine(object.x, object.y, object.z, object.x + CollideWithObstaclesPoly.nodeNormal.x, object.y + CollideWithObstaclesPoly.nodeNormal.y, object.z, 0.0f, 0.0f, 1.0f, null, true);
                }
            }
            for (CCObstacle cCObstacle : this.obstacles) {
                cCObstacle.render();
            }
        }
    }

    private static final class ImmutableRectF {
        private float x;
        private float y;
        private float w;
        private float h;
        static final ArrayDeque<ImmutableRectF> pool = new ArrayDeque();

        private ImmutableRectF() {
        }

        ImmutableRectF init(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.w = f3;
            this.h = f4;
            return this;
        }

        float left() {
            return this.x;
        }

        float top() {
            return this.y;
        }

        float right() {
            return this.x + this.w;
        }

        float bottom() {
            return this.y + this.h;
        }

        float width() {
            return this.w;
        }

        float height() {
            return this.h;
        }

        boolean containsPoint(float f, float f2) {
            return f >= this.left() && f < this.right() && f2 >= this.top() && f2 < this.bottom();
        }

        boolean intersects(ImmutableRectF immutableRectF) {
            return this.left() < immutableRectF.right() && this.right() > immutableRectF.left() && this.top() < immutableRectF.bottom() && this.bottom() > immutableRectF.top();
        }

        static ImmutableRectF alloc() {
            return pool.isEmpty() ? new ImmutableRectF() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class ClosestPointOnEdge {
        CCEdge edge;
        CCNode node;
        final Vector2f point = new Vector2f();
        double distSq;

        private ClosestPointOnEdge() {
        }
    }

    public static final class ChunkData {
        final ChunkDataZ[] data = new ChunkDataZ[8];
        private boolean bClear = false;

        public ChunkDataZ init(IsoChunk isoChunk, int n, CollideWithObstaclesPoly collideWithObstaclesPoly) {
            assert (Thread.currentThread() == GameWindow.GameThread);
            if (this.bClear) {
                this.bClear = false;
                this.clearInner();
            }
            if (this.data[n] == null) {
                this.data[n] = ChunkDataZ.pool.alloc();
                this.data[n].init(isoChunk, n, collideWithObstaclesPoly);
            }
            return this.data[n];
        }

        private void clearInner() {
            PZArrayUtil.forEach(this.data, chunkDataZ -> {
                if (chunkDataZ != null) {
                    chunkDataZ.clear();
                    ChunkDataZ.pool.release((ChunkDataZ)chunkDataZ);
                }
            });
            Arrays.fill(this.data, null);
        }

        public void clear() {
            this.bClear = true;
        }
    }

    public static final class ChunkDataZ {
        public final ArrayList<CCObstacle> worldVehicleUnion = new ArrayList();
        public final ArrayList<CCObstacle> worldVehicleSeparate = new ArrayList();
        public final ArrayList<CCNode> nodes = new ArrayList();
        public int z;
        public static final ObjectPool<ChunkDataZ> pool = new ObjectPool<ChunkDataZ>(ChunkDataZ::new);

        public void init(IsoChunk isoChunk, int n, CollideWithObstaclesPoly collideWithObstaclesPoly) {
            int n2;
            int n3;
            int n4;
            int n5;
            this.z = n;
            Clipper clipper = collideWithObstaclesPoly.clipper;
            clipper.clear();
            float f = 0.19800001f;
            int n6 = isoChunk.wx * 10;
            int n7 = isoChunk.wy * 10;
            for (int i = n7 - 2; i < n7 + 10 + 2; ++i) {
                for (n5 = n6 - 2; n5 < n6 + 10 + 2; ++n5) {
                    IsoGridSquare isoGridSquare;
                    float f2;
                    boolean bl;
                    IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n5, i, n);
                    if (isoGridSquare2 == null || isoGridSquare2.getObjects().isEmpty()) continue;
                    if (isoGridSquare2.isSolid() || isoGridSquare2.isSolidTrans() && !isoGridSquare2.isAdjacentToWindow()) {
                        clipper.addAABBBevel((float)n5 - 0.3f, (float)i - 0.3f, (float)n5 + 1.0f + 0.3f, (float)i + 1.0f + 0.3f, f);
                    }
                    int n8 = n4 = isoGridSquare2.Is(IsoFlagType.collideW) || isoGridSquare2.hasBlockedDoor(false) || isoGridSquare2.HasStairsNorth() ? 1 : 0;
                    if (isoGridSquare2.Is(IsoFlagType.windowW) || isoGridSquare2.Is(IsoFlagType.WindowW)) {
                        n4 = 1;
                    }
                    if (n4 != 0) {
                        if (!this.isCollideW(n5, i - 1, n)) {
                            // empty if block
                        }
                        n3 = 0;
                        if (!this.isCollideW(n5, i + 1, n)) {
                            // empty if block
                        }
                        bl = false;
                        clipper.addAABBBevel((float)n5 - 0.3f, (float)i - (n3 != 0 ? 0.0f : 0.3f), (float)n5 + 0.3f, (float)i + 1.0f + (bl ? 0.0f : 0.3f), f);
                    }
                    int n9 = n3 = isoGridSquare2.Is(IsoFlagType.collideN) || isoGridSquare2.hasBlockedDoor(true) || isoGridSquare2.HasStairsWest() ? 1 : 0;
                    if (isoGridSquare2.Is(IsoFlagType.windowN) || isoGridSquare2.Is(IsoFlagType.WindowN)) {
                        n3 = 1;
                    }
                    if (n3 != 0) {
                        if (!this.isCollideN(n5 - 1, i, n)) {
                            // empty if block
                        }
                        bl = false;
                        if (!this.isCollideN(n5 + 1, i, n)) {
                            // empty if block
                        }
                        n2 = 0;
                        clipper.addAABBBevel((float)n5 - (bl ? 0.0f : 0.3f), (float)i - 0.3f, (float)n5 + 1.0f + (n2 != 0 ? 0.0f : 0.3f), (float)i + 0.3f, f);
                    }
                    if (isoGridSquare2.HasStairsNorth()) {
                        IsoGridSquare isoGridSquare3;
                        IsoGridSquare isoGridSquare4 = IsoWorld.instance.CurrentCell.getGridSquare(n5 + 1, i, n);
                        if (isoGridSquare4 != null) {
                            clipper.addAABBBevel((float)(n5 + 1) - 0.3f, (float)i - 0.3f, (float)(n5 + 1) + 0.3f, (float)i + 1.0f + 0.3f, f);
                        }
                        if (isoGridSquare2.Has(IsoObjectType.stairsTN) && ((isoGridSquare3 = IsoWorld.instance.CurrentCell.getGridSquare(n5, i, n - 1)) == null || !isoGridSquare3.Has(IsoObjectType.stairsTN))) {
                            clipper.addAABBBevel((float)n5 - 0.3f, (float)i - 0.3f, (float)n5 + 1.0f + 0.3f, (float)i + 0.3f, f);
                            f2 = 0.1f;
                            clipper.clipAABB((float)n5 + 0.3f, (float)i - f2, (float)n5 + 1.0f - 0.3f, (float)i + 0.3f);
                        }
                    }
                    if (!isoGridSquare2.HasStairsWest()) continue;
                    IsoGridSquare isoGridSquare5 = IsoWorld.instance.CurrentCell.getGridSquare(n5, i + 1, n);
                    if (isoGridSquare5 != null) {
                        clipper.addAABBBevel((float)n5 - 0.3f, (float)(i + 1) - 0.3f, (float)n5 + 1.0f + 0.3f, (float)(i + 1) + 0.3f, f);
                    }
                    if (!isoGridSquare2.Has(IsoObjectType.stairsTW) || (isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n5, i, n - 1)) != null && isoGridSquare.Has(IsoObjectType.stairsTW)) continue;
                    clipper.addAABBBevel((float)n5 - 0.3f, (float)i - 0.3f, (float)n5 + 0.3f, (float)i + 1.0f + 0.3f, f);
                    f2 = 0.1f;
                    clipper.clipAABB((float)n5 - f2, (float)i + 0.3f, (float)n5 + 0.3f, (float)i + 1.0f - 0.3f);
                }
            }
            ByteBuffer byteBuffer = collideWithObstaclesPoly.xyBuffer;
            assert (this.worldVehicleSeparate.isEmpty());
            this.clipperToObstacles(clipper, byteBuffer, this.worldVehicleSeparate);
            n5 = isoChunk.wx * 10;
            int n10 = isoChunk.wy * 10;
            n4 = n5 + 10;
            n3 = n10 + 10;
            ImmutableRectF immutableRectF = collideWithObstaclesPoly.moveBounds.init(n5 -= 2, n10 -= 2, (n4 += 2) - n5, (n3 += 2) - n10);
            collideWithObstaclesPoly.getVehiclesInRect(n5 - 5, n10 - 5, n4 + 5, n3 + 5, n);
            for (n2 = 0; n2 < collideWithObstaclesPoly.vehicles.size(); ++n2) {
                BaseVehicle baseVehicle = collideWithObstaclesPoly.vehicles.get(n2);
                PolygonalMap2.VehiclePoly vehiclePoly = baseVehicle.getPolyPlusRadius();
                float f3 = Math.min(vehiclePoly.x1, Math.min(vehiclePoly.x2, Math.min(vehiclePoly.x3, vehiclePoly.x4)));
                float f4 = Math.min(vehiclePoly.y1, Math.min(vehiclePoly.y2, Math.min(vehiclePoly.y3, vehiclePoly.y4)));
                float f5 = Math.max(vehiclePoly.x1, Math.max(vehiclePoly.x2, Math.max(vehiclePoly.x3, vehiclePoly.x4)));
                float f6 = Math.max(vehiclePoly.y1, Math.max(vehiclePoly.y2, Math.max(vehiclePoly.y3, vehiclePoly.y4)));
                collideWithObstaclesPoly.vehicleBounds.init(f3, f4, f5 - f3, f6 - f4);
                if (!immutableRectF.intersects(collideWithObstaclesPoly.vehicleBounds)) continue;
                clipper.addPolygon(vehiclePoly.x1, vehiclePoly.y1, vehiclePoly.x4, vehiclePoly.y4, vehiclePoly.x3, vehiclePoly.y3, vehiclePoly.x2, vehiclePoly.y2);
                CCNode cCNode = CCNode.alloc().init(vehiclePoly.x1, vehiclePoly.y1, n);
                CCNode cCNode2 = CCNode.alloc().init(vehiclePoly.x2, vehiclePoly.y2, n);
                CCNode cCNode3 = CCNode.alloc().init(vehiclePoly.x3, vehiclePoly.y3, n);
                CCNode cCNode4 = CCNode.alloc().init(vehiclePoly.x4, vehiclePoly.y4, n);
                CCObstacle cCObstacle = CCObstacle.alloc().init();
                cCObstacle.vehicle = baseVehicle;
                CCEdge cCEdge = CCEdge.alloc().init(cCNode, cCNode2, cCObstacle);
                CCEdge cCEdge2 = CCEdge.alloc().init(cCNode2, cCNode3, cCObstacle);
                CCEdge cCEdge3 = CCEdge.alloc().init(cCNode3, cCNode4, cCObstacle);
                CCEdge cCEdge4 = CCEdge.alloc().init(cCNode4, cCNode, cCObstacle);
                cCObstacle.outer.add(cCEdge);
                cCObstacle.outer.add(cCEdge2);
                cCObstacle.outer.add(cCEdge3);
                cCObstacle.outer.add(cCEdge4);
                cCObstacle.calcBounds();
                this.worldVehicleSeparate.add(cCObstacle);
                this.nodes.add(cCNode);
                this.nodes.add(cCNode2);
                this.nodes.add(cCNode3);
                this.nodes.add(cCNode4);
            }
            assert (this.worldVehicleUnion.isEmpty());
            this.clipperToObstacles(clipper, byteBuffer, this.worldVehicleUnion);
        }

        private void getEdgesFromBuffer(ByteBuffer byteBuffer, CCObstacle cCObstacle, boolean bl) {
            Object object;
            int n;
            int n2 = byteBuffer.getShort();
            if (n2 < 3) {
                byteBuffer.position(byteBuffer.position() + n2 * 4 * 2);
                return;
            }
            CCEdgeRing cCEdgeRing = cCObstacle.outer;
            if (!bl) {
                cCEdgeRing = CCEdgeRing.pool.alloc();
                cCEdgeRing.clear();
                cCObstacle.inner.add(cCEdgeRing);
            }
            int n3 = this.nodes.size();
            for (n = 0; n < n2; ++n) {
                float f = byteBuffer.getFloat();
                float f2 = byteBuffer.getFloat();
                object = CCNode.alloc().init(f, f2, this.z);
                this.nodes.add(n3, (CCNode)object);
            }
            for (n = n3; n < this.nodes.size() - 1; ++n) {
                CCNode cCNode = this.nodes.get(n);
                CCNode cCNode2 = this.nodes.get(n + 1);
                object = CCEdge.alloc().init(cCNode, cCNode2, cCObstacle);
                cCEdgeRing.add(object);
            }
            CCNode cCNode = this.nodes.get(this.nodes.size() - 1);
            CCNode cCNode3 = this.nodes.get(n3);
            cCEdgeRing.add(CCEdge.alloc().init(cCNode, cCNode3, cCObstacle));
        }

        private void clipperToObstacles(Clipper clipper, ByteBuffer byteBuffer, ArrayList<CCObstacle> arrayList) {
            int n = clipper.generatePolygons();
            for (int i = 0; i < n; ++i) {
                byteBuffer.clear();
                clipper.getPolygon(i, byteBuffer);
                CCObstacle cCObstacle = CCObstacle.alloc().init();
                this.getEdgesFromBuffer(byteBuffer, cCObstacle, true);
                int n2 = byteBuffer.getShort();
                for (int j = 0; j < n2; ++j) {
                    this.getEdgesFromBuffer(byteBuffer, cCObstacle, false);
                }
                cCObstacle.calcBounds();
                arrayList.add(cCObstacle);
            }
        }

        boolean isCollideW(int n, int n2, int n3) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
            return isoGridSquare != null && (isoGridSquare.Is(IsoFlagType.collideW) || isoGridSquare.hasBlockedDoor(false) || isoGridSquare.HasStairsNorth());
        }

        boolean isCollideN(int n, int n2, int n3) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
            return isoGridSquare != null && (isoGridSquare.Is(IsoFlagType.collideN) || isoGridSquare.hasBlockedDoor(true) || isoGridSquare.HasStairsWest());
        }

        boolean isOpenDoorAt(int n, int n2, int n3, boolean bl) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
            return isoGridSquare != null && isoGridSquare.getDoor(bl) != null && !isoGridSquare.hasBlockedDoor(bl);
        }

        public void clear() {
            CCNode.releaseAll(this.nodes);
            this.nodes.clear();
            CCObstacle.releaseAll(this.worldVehicleUnion);
            this.worldVehicleUnion.clear();
            CCObstacle.releaseAll(this.worldVehicleSeparate);
            this.worldVehicleSeparate.clear();
        }
    }

    private static final class CCObstacle {
        final CCEdgeRing outer = new CCEdgeRing();
        final ArrayList<CCEdgeRing> inner = new ArrayList();
        BaseVehicle vehicle = null;
        ImmutableRectF bounds;
        static final ObjectPool<CCObstacle> pool = new ObjectPool<CCObstacle>(CCObstacle::new){

            @Override
            public void release(CCObstacle cCObstacle) {
                CCEdge.releaseAll(cCObstacle.outer);
                CCEdgeRing.releaseAll(cCObstacle.inner);
                cCObstacle.outer.clear();
                cCObstacle.inner.clear();
                cCObstacle.vehicle = null;
                super.release(cCObstacle);
            }
        };

        private CCObstacle() {
        }

        CCObstacle init() {
            this.outer.clear();
            this.inner.clear();
            this.vehicle = null;
            return this;
        }

        boolean isPointInside(float f, float f2, int n) {
            if (this.outer.isPointInPolygon_WindingNumber(f, f2, n) != EdgeRingHit.Inside) {
                return false;
            }
            if (this.inner.isEmpty()) {
                return true;
            }
            for (int i = 0; i < this.inner.size(); ++i) {
                CCEdgeRing cCEdgeRing = this.inner.get(i);
                if (cCEdgeRing.isPointInPolygon_WindingNumber(f, f2, n) == EdgeRingHit.Outside) continue;
                return false;
            }
            return true;
        }

        boolean lineSegmentIntersects(float f, float f2, float f3, float f4, boolean bl) {
            if (this.outer.lineSegmentIntersects(f, f2, f3, f4, bl, true)) {
                return true;
            }
            for (int i = 0; i < this.inner.size(); ++i) {
                CCEdgeRing cCEdgeRing = this.inner.get(i);
                if (!cCEdgeRing.lineSegmentIntersects(f, f2, f3, f4, bl, false)) continue;
                return true;
            }
            return false;
        }

        void lineSegmentIntersect(float f, float f2, float f3, float f4, ClosestPointOnEdge closestPointOnEdge, boolean bl) {
            this.outer.lineSegmentIntersect(f, f2, f3, f4, closestPointOnEdge, bl);
            for (int i = 0; i < this.inner.size(); ++i) {
                CCEdgeRing cCEdgeRing = this.inner.get(i);
                cCEdgeRing.lineSegmentIntersect(f, f2, f3, f4, closestPointOnEdge, bl);
            }
        }

        void getClosestPointOnEdge(float f, float f2, ClosestPointOnEdge closestPointOnEdge) {
            this.outer.getClosestPointOnEdge(f, f2, closestPointOnEdge);
            for (int i = 0; i < this.inner.size(); ++i) {
                CCEdgeRing cCEdgeRing = this.inner.get(i);
                cCEdgeRing.getClosestPointOnEdge(f, f2, closestPointOnEdge);
            }
        }

        void calcBounds() {
            float f = Float.MAX_VALUE;
            float f2 = Float.MAX_VALUE;
            float f3 = Float.MIN_VALUE;
            float f4 = Float.MIN_VALUE;
            for (int i = 0; i < this.outer.size(); ++i) {
                CCEdge cCEdge = (CCEdge)this.outer.get(i);
                f = Math.min(f, cCEdge.node1.x);
                f2 = Math.min(f2, cCEdge.node1.y);
                f3 = Math.max(f3, cCEdge.node1.x);
                f4 = Math.max(f4, cCEdge.node1.y);
            }
            if (this.bounds != null) {
                this.bounds.release();
            }
            float f5 = 0.01f;
            this.bounds = ImmutableRectF.alloc().init(f - f5, f2 - f5, f3 - f + f5 * 2.0f, f4 - f2 + f5 * 2.0f);
        }

        void render() {
            this.outer.render(true);
            for (int i = 0; i < this.inner.size(); ++i) {
                this.inner.get(i).render(false);
            }
        }

        static CCObstacle alloc() {
            return pool.alloc();
        }

        void release() {
            pool.release(this);
        }

        static void releaseAll(ArrayList<CCObstacle> arrayList) {
            pool.releaseAll(arrayList);
        }
    }

    private static final class CCEdge {
        CCNode node1;
        CCNode node2;
        CCObstacle obstacle;
        final Vector2 normal = new Vector2();
        static final ObjectPool<CCEdge> pool = new ObjectPool<CCEdge>(CCEdge::new);

        private CCEdge() {
        }

        CCEdge init(CCNode cCNode, CCNode cCNode2, CCObstacle cCObstacle) {
            if (cCNode.x == cCNode2.x && cCNode.y == cCNode2.y) {
                boolean bl = false;
            }
            this.node1 = cCNode;
            this.node2 = cCNode2;
            cCNode.edges.add(this);
            cCNode2.edges.add(this);
            this.obstacle = cCObstacle;
            this.normal.set(cCNode2.x - cCNode.x, cCNode2.y - cCNode.y);
            this.normal.normalize();
            this.normal.rotate((float)Math.toRadians(90.0));
            return this;
        }

        boolean hasNode(CCNode cCNode) {
            return cCNode == this.node1 || cCNode == this.node2;
        }

        void getClosestPointOnEdge(float f, float f2, ClosestPointOnEdge closestPointOnEdge) {
            float f3 = this.node1.x;
            float f4 = this.node1.y;
            float f5 = this.node2.x;
            float f6 = this.node2.y;
            double d = (double)((f - f3) * (f5 - f3) + (f2 - f4) * (f6 - f4)) / (Math.pow(f5 - f3, 2.0) + Math.pow(f6 - f4, 2.0));
            double d2 = (double)f3 + d * (double)(f5 - f3);
            double d3 = (double)f4 + d * (double)(f6 - f4);
            double d4 = 0.001;
            CCNode cCNode = null;
            if (d <= 0.0 + d4) {
                d2 = f3;
                d3 = f4;
                cCNode = this.node1;
            } else if (d >= 1.0 - d4) {
                d2 = f5;
                d3 = f6;
                cCNode = this.node2;
            }
            double d5 = ((double)f - d2) * ((double)f - d2) + ((double)f2 - d3) * ((double)f2 - d3);
            if (d5 < closestPointOnEdge.distSq) {
                closestPointOnEdge.point.set((float)d2, (float)d3);
                closestPointOnEdge.distSq = d5;
                closestPointOnEdge.edge = this;
                closestPointOnEdge.node = cCNode;
            }
        }

        boolean isPointOn(float f, float f2) {
            float f3 = this.node1.x;
            float f4 = this.node1.y;
            float f5 = this.node2.x;
            float f6 = this.node2.y;
            double d = (double)((f - f3) * (f5 - f3) + (f2 - f4) * (f6 - f4)) / (Math.pow(f5 - f3, 2.0) + Math.pow(f6 - f4, 2.0));
            double d2 = (double)f3 + d * (double)(f5 - f3);
            double d3 = (double)f4 + d * (double)(f6 - f4);
            if (d <= 0.0) {
                d2 = f3;
                d3 = f4;
            } else if (d >= 1.0) {
                d2 = f5;
                d3 = f6;
            }
            double d4 = ((double)f - d2) * ((double)f - d2) + ((double)f2 - d3) * ((double)f2 - d3);
            return d4 < 1.0E-6;
        }

        static CCEdge alloc() {
            return pool.alloc();
        }

        void release() {
            pool.release(this);
        }

        static void releaseAll(ArrayList<CCEdge> arrayList) {
            pool.releaseAll(arrayList);
        }
    }

    private static final class CCNode {
        float x;
        float y;
        int z;
        final ArrayList<CCEdge> edges = new ArrayList();
        static final ObjectPool<CCNode> pool = new ObjectPool<CCNode>(CCNode::new);

        private CCNode() {
        }

        CCNode init(float f, float f2, int n) {
            this.x = f;
            this.y = f2;
            this.z = n;
            this.edges.clear();
            return this;
        }

        CCNode setXY(float f, float f2) {
            this.x = f;
            this.y = f2;
            return this;
        }

        boolean getNormalAndEdgeVectors(Vector2 vector22, Vector2 vector23) {
            CCEdge cCEdge = null;
            CCEdge cCEdge2 = null;
            for (int i = 0; i < this.edges.size(); ++i) {
                CCEdge cCEdge3 = this.edges.get(i);
                if (cCEdge == null) {
                    cCEdge = cCEdge3;
                    continue;
                }
                if (cCEdge.hasNode(cCEdge3.node1) && cCEdge.hasNode(cCEdge3.node2)) continue;
                cCEdge2 = cCEdge3;
            }
            if (cCEdge == null || cCEdge2 == null) {
                return false;
            }
            float f = cCEdge.normal.x + cCEdge2.normal.x;
            float f2 = cCEdge.normal.y + cCEdge2.normal.y;
            vector22.set(f, f2);
            vector22.normalize();
            if (cCEdge.node1 == this) {
                vector23.set(cCEdge.node2.x - cCEdge.node1.x, cCEdge.node2.y - cCEdge.node1.y);
            } else {
                vector23.set(cCEdge.node1.x - cCEdge.node2.x, cCEdge.node1.y - cCEdge.node2.y);
            }
            vector23.normalize();
            return true;
        }

        static CCNode alloc() {
            return pool.alloc();
        }

        void release() {
            pool.release(this);
        }

        static void releaseAll(ArrayList<CCNode> arrayList) {
            pool.releaseAll(arrayList);
        }
    }

    private static final class CCEdgeRing
    extends ArrayList<CCEdge> {
        static final ObjectPool<CCEdgeRing> pool = new ObjectPool<CCEdgeRing>(CCEdgeRing::new){

            @Override
            public void release(CCEdgeRing cCEdgeRing) {
                CCEdge.releaseAll(cCEdgeRing);
                this.clear();
                super.release(cCEdgeRing);
            }
        };

        private CCEdgeRing() {
        }

        float isLeft(float f, float f2, float f3, float f4, float f5, float f6) {
            return (f3 - f) * (f6 - f2) - (f5 - f) * (f4 - f2);
        }

        EdgeRingHit isPointInPolygon_WindingNumber(float f, float f2, int n) {
            int n2 = 0;
            for (int i = 0; i < this.size(); ++i) {
                CCEdge cCEdge = (CCEdge)this.get(i);
                if ((n & 0x10) != 0 && cCEdge.isPointOn(f, f2)) {
                    return EdgeRingHit.OnEdge;
                }
                if (cCEdge.node1.y <= f2) {
                    if (!(cCEdge.node2.y > f2) || !(this.isLeft(cCEdge.node1.x, cCEdge.node1.y, cCEdge.node2.x, cCEdge.node2.y, f, f2) > 0.0f)) continue;
                    ++n2;
                    continue;
                }
                if (!(cCEdge.node2.y <= f2) || !(this.isLeft(cCEdge.node1.x, cCEdge.node1.y, cCEdge.node2.x, cCEdge.node2.y, f, f2) < 0.0f)) continue;
                --n2;
            }
            return n2 == 0 ? EdgeRingHit.Outside : EdgeRingHit.Inside;
        }

        boolean lineSegmentIntersects(float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
            move.set(f3 - f, f4 - f2);
            float f5 = move.getLength();
            move.normalize();
            float f6 = CollideWithObstaclesPoly.move.x;
            float f7 = CollideWithObstaclesPoly.move.y;
            for (int i = 0; i < this.size(); ++i) {
                float f8;
                float f9;
                float f10;
                float f11;
                float f12;
                float f13;
                float f14;
                float f15;
                float f16;
                float f17;
                float f18;
                float f19;
                CCEdge cCEdge = (CCEdge)this.get(i);
                if (cCEdge.isPointOn(f, f2) || cCEdge.isPointOn(f3, f4) || (f19 = cCEdge.normal.dot(move)) >= 0.01f || !((f18 = ((f17 = (f16 = cCEdge.node2.x) - (f15 = cCEdge.node1.x)) * (f14 = f2 - (f13 = cCEdge.node1.y)) - (f12 = (f11 = cCEdge.node2.y) - f13) * (f10 = f - f15)) * (f9 = 1.0f / (f12 * f6 - f17 * f7))) >= 0.0f) || !(f18 <= f5) || !((f8 = (f14 * f6 - f10 * f7) * f9) >= 0.0f) || !(f8 <= 1.0f)) continue;
                float f20 = f + f18 * f6;
                float f21 = f2 + f18 * f7;
                if (bl) {
                    this.render(bl2);
                    LineDrawer.addRect(f20 - 0.05f, f21 - 0.05f, cCEdge.node1.z, 0.1f, 0.1f, 1.0f, 1.0f, 1.0f);
                }
                return true;
            }
            return this.isPointInPolygon_WindingNumber((f + f3) / 2.0f, (f2 + f4) / 2.0f, 0) != EdgeRingHit.Outside;
        }

        void lineSegmentIntersect(float f, float f2, float f3, float f4, ClosestPointOnEdge closestPointOnEdge, boolean bl) {
            move.set(f3 - f, f4 - f2).normalize();
            for (int i = 0; i < this.size(); ++i) {
                float f5;
                float f6;
                double d;
                double d2;
                CCEdge cCEdge = (CCEdge)this.get(i);
                float f7 = cCEdge.normal.dot(move);
                if (f7 >= 0.0f) continue;
                float f8 = cCEdge.node1.x;
                float f9 = cCEdge.node1.y;
                float f10 = cCEdge.node2.x;
                float f11 = cCEdge.node2.y;
                float f12 = f8 + 0.5f * (f10 - f8);
                float f13 = f9 + 0.5f * (f11 - f9);
                if (bl && DebugOptions.instance.CollideWithObstaclesRenderNormals.getValue()) {
                    LineDrawer.addLine(f12, f13, cCEdge.node1.z, f12 + cCEdge.normal.x, f13 + cCEdge.normal.y, cCEdge.node1.z, 0.0f, 0.0f, 1.0f, null, true);
                }
                if ((d2 = (double)((f11 - f9) * (f3 - f) - (f10 - f8) * (f4 - f2))) == 0.0) continue;
                double d3 = (double)((f10 - f8) * (f2 - f9) - (f11 - f9) * (f - f8)) / d2;
                double d4 = (double)((f3 - f) * (f2 - f9) - (f4 - f2) * (f - f8)) / d2;
                if (!(d3 >= 0.0) || !(d3 <= 1.0) || !(d4 >= 0.0) || !(d4 <= 1.0)) continue;
                if (d4 < 0.01 || d4 > 0.99) {
                    CCNode cCNode = d4 < 0.01 ? cCEdge.node1 : cCEdge.node2;
                    double d5 = IsoUtils.DistanceToSquared(f, f2, cCNode.x, cCNode.y);
                    if (d5 >= closestPointOnEdge.distSq) continue;
                    if (cCNode.getNormalAndEdgeVectors(nodeNormal, edgeVec)) {
                        if (nodeNormal.dot(move) + 0.05f >= nodeNormal.dot(edgeVec)) continue;
                        closestPointOnEdge.edge = cCEdge;
                        closestPointOnEdge.node = cCNode;
                        closestPointOnEdge.distSq = d5;
                        continue;
                    }
                }
                if (!((d = (double)IsoUtils.DistanceToSquared(f, f2, f6 = (float)((double)f + d3 * (double)(f3 - f)), f5 = (float)((double)f2 + d3 * (double)(f4 - f2)))) < closestPointOnEdge.distSq)) continue;
                closestPointOnEdge.edge = cCEdge;
                closestPointOnEdge.node = null;
                closestPointOnEdge.distSq = d;
            }
        }

        void getClosestPointOnEdge(float f, float f2, ClosestPointOnEdge closestPointOnEdge) {
            for (int i = 0; i < this.size(); ++i) {
                CCEdge cCEdge = (CCEdge)this.get(i);
                cCEdge.getClosestPointOnEdge(f, f2, closestPointOnEdge);
            }
        }

        void render(boolean bl) {
            if (this.isEmpty()) {
                return;
            }
            float f = 0.0f;
            float f2 = bl ? 1.0f : 0.5f;
            float f3 = bl ? 0.0f : 0.5f;
            BaseVehicle.Vector3fObjectPool vector3fObjectPool = BaseVehicle.TL_vector3f_pool.get();
            for (CCEdge cCEdge : this) {
                CCNode cCNode = cCEdge.node1;
                CCNode cCNode2 = cCEdge.node2;
                LineDrawer.addLine(cCNode.x, cCNode.y, cCNode.z, cCNode2.x, cCNode2.y, cCNode2.z, f, f2, f3, null, true);
                boolean bl2 = false;
                if (!bl2) continue;
                Vector3f vector3f = ((Vector3f)vector3fObjectPool.alloc()).set(cCNode2.x - cCNode.x, cCNode2.y - cCNode.y, cCNode2.z - cCNode.z).normalize();
                Vector3f vector3f2 = ((Vector3f)vector3fObjectPool.alloc()).set(vector3f).cross(0.0f, 0.0f, 1.0f).normalize();
                vector3f.mul(0.9f);
                LineDrawer.addLine(cCNode2.x - vector3f.x * 0.1f - vector3f2.x * 0.1f, cCNode2.y - vector3f.y * 0.1f - vector3f2.y * 0.1f, cCNode2.z, cCNode2.x, cCNode2.y, cCNode2.z, f, f2, f3, null, true);
                LineDrawer.addLine(cCNode2.x - vector3f.x * 0.1f + vector3f2.x * 0.1f, cCNode2.y - vector3f.y * 0.1f + vector3f2.y * 0.1f, cCNode2.z, cCNode2.x, cCNode2.y, cCNode2.z, f, f2, f3, null, true);
                vector3fObjectPool.release(vector3f);
                vector3fObjectPool.release(vector3f2);
            }
            CCNode cCNode = ((CCEdge)this.get((int)0)).node1;
            LineDrawer.addRect(cCNode.x - 0.1f, cCNode.y - 0.1f, cCNode.z, 0.2f, 0.2f, 1.0f, 0.0f, 0.0f);
        }

        static void releaseAll(ArrayList<CCEdgeRing> arrayList) {
            pool.releaseAll(arrayList);
        }
    }

    private static enum EdgeRingHit {
        OnEdge,
        Inside,
        Outside;

    }
}

