/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.joml.Vector2f;
import zombie.characters.IsoGameCharacter;
import zombie.core.Core;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PolygonalMap2;

public final class CollideWithObstacles {
    static final float RADIUS = 0.3f;
    private final ArrayList<CCObstacle> obstacles = new ArrayList();
    private final ArrayList<CCNode> nodes = new ArrayList();
    private final ArrayList<CCIntersection> intersections = new ArrayList();
    private final ImmutableRectF moveBounds = new ImmutableRectF();
    private final ImmutableRectF vehicleBounds = new ImmutableRectF();
    private final Vector2 move = new Vector2();
    private final Vector2 closest = new Vector2();
    private final Vector2 nodeNormal = new Vector2();
    private final Vector2 edgeVec = new Vector2();
    private final ArrayList<BaseVehicle> vehicles = new ArrayList();
    CCObjectOutline[][] oo = new CCObjectOutline[5][5];
    ArrayList<CCNode> obstacleTraceNodes = new ArrayList();
    CompareIntersection comparator = new CompareIntersection();

    void getVehiclesInRect(float f, float f2, float f3, float f4, int n) {
        this.vehicles.clear();
        int n2 = (int)(f / 10.0f);
        int n3 = (int)(f2 / 10.0f);
        int n4 = (int)Math.ceil(f3 / 10.0f);
        int n5 = (int)Math.ceil(f4 / 10.0f);
        for (int i = n3; i < n5; ++i) {
            for (int j = n2; j < n4; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(j * 10, i * 10, 0);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if (baseVehicle.getScript() == null || (int)baseVehicle.z != n) continue;
                    this.vehicles.add(baseVehicle);
                }
            }
        }
    }

    void getObstaclesInRect(float f, float f2, float f3, float f4, int n, int n2, int n3) {
        int n4;
        Object object;
        CCNode cCNode;
        CCNode cCNode2;
        int n5;
        int n6;
        this.nodes.clear();
        this.obstacles.clear();
        this.moveBounds.init(f - 1.0f, f2 - 1.0f, f3 - f + 2.0f, f4 - f2 + 2.0f);
        this.getVehiclesInRect(f - 1.0f - 4.0f, f2 - 1.0f - 4.0f, f3 + 2.0f + 8.0f, f4 + 2.0f + 8.0f, n3);
        for (n6 = 0; n6 < this.vehicles.size(); ++n6) {
            BaseVehicle baseVehicle = this.vehicles.get(n6);
            PolygonalMap2.VehiclePoly vehiclePoly = baseVehicle.getPolyPlusRadius();
            float f5 = Math.min(vehiclePoly.x1, Math.min(vehiclePoly.x2, Math.min(vehiclePoly.x3, vehiclePoly.x4)));
            float f6 = Math.min(vehiclePoly.y1, Math.min(vehiclePoly.y2, Math.min(vehiclePoly.y3, vehiclePoly.y4)));
            float f7 = Math.max(vehiclePoly.x1, Math.max(vehiclePoly.x2, Math.max(vehiclePoly.x3, vehiclePoly.x4)));
            float f8 = Math.max(vehiclePoly.y1, Math.max(vehiclePoly.y2, Math.max(vehiclePoly.y3, vehiclePoly.y4)));
            this.vehicleBounds.init(f5, f6, f7 - f5, f8 - f6);
            if (!this.moveBounds.intersects(this.vehicleBounds)) continue;
            n5 = (int)vehiclePoly.z;
            CCNode cCNode3 = CCNode.alloc().init(vehiclePoly.x1, vehiclePoly.y1, n5);
            CCNode cCNode4 = CCNode.alloc().init(vehiclePoly.x2, vehiclePoly.y2, n5);
            cCNode2 = CCNode.alloc().init(vehiclePoly.x3, vehiclePoly.y3, n5);
            cCNode = CCNode.alloc().init(vehiclePoly.x4, vehiclePoly.y4, n5);
            object = CCObstacle.alloc().init();
            CCEdge cCEdge = CCEdge.alloc().init(cCNode3, cCNode4, (CCObstacle)object);
            CCEdge cCEdge2 = CCEdge.alloc().init(cCNode4, cCNode2, (CCObstacle)object);
            CCEdge cCEdge3 = CCEdge.alloc().init(cCNode2, cCNode, (CCObstacle)object);
            CCEdge cCEdge4 = CCEdge.alloc().init(cCNode, cCNode3, (CCObstacle)object);
            ((CCObstacle)object).edges.add(cCEdge);
            ((CCObstacle)object).edges.add(cCEdge2);
            ((CCObstacle)object).edges.add(cCEdge3);
            ((CCObstacle)object).edges.add(cCEdge4);
            ((CCObstacle)object).calcBounds();
            this.obstacles.add((CCObstacle)object);
            this.nodes.add(cCNode3);
            this.nodes.add(cCNode4);
            this.nodes.add(cCNode2);
            this.nodes.add(cCNode);
        }
        if (this.obstacles.isEmpty()) {
            return;
        }
        n6 = n - 2;
        int n7 = n2 - 2;
        int n8 = n + 2 + 1;
        int n9 = n2 + 2 + 1;
        for (n4 = n7; n4 < n9; ++n4) {
            for (int i = n6; i < n8; ++i) {
                CCObjectOutline.get(i - n6, n4 - n7, n3, this.oo).init(i - n6, n4 - n7, n3);
            }
        }
        for (n4 = n7; n4 < n9 - 1; ++n4) {
            for (int i = n6; i < n8 - 1; ++i) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i, n4, n3);
                if (isoGridSquare == null) continue;
                if (isoGridSquare.isSolid() || isoGridSquare.isSolidTrans() && !isoGridSquare.isAdjacentToWindow() || isoGridSquare.Has(IsoObjectType.stairsMN) || isoGridSquare.Has(IsoObjectType.stairsTN) || isoGridSquare.Has(IsoObjectType.stairsMW) || isoGridSquare.Has(IsoObjectType.stairsTW)) {
                    CCObjectOutline.setSolid(i - n6, n4 - n7, n3, this.oo);
                }
                n5 = isoGridSquare.Is(IsoFlagType.collideW);
                if (isoGridSquare.Is(IsoFlagType.windowW) || isoGridSquare.Is(IsoFlagType.WindowW)) {
                    n5 = 1;
                }
                if (n5 != 0 && isoGridSquare.Is(IsoFlagType.doorW)) {
                    n5 = 0;
                }
                boolean bl = isoGridSquare.Is(IsoFlagType.collideN);
                if (isoGridSquare.Is(IsoFlagType.windowN) || isoGridSquare.Is(IsoFlagType.WindowN)) {
                    bl = true;
                }
                if (bl && isoGridSquare.Is(IsoFlagType.doorN)) {
                    bl = false;
                }
                if (n5 != 0 || isoGridSquare.hasBlockedDoor(false) || isoGridSquare.Has(IsoObjectType.stairsBN)) {
                    CCObjectOutline.setWest(i - n6, n4 - n7, n3, this.oo);
                }
                if (bl || isoGridSquare.hasBlockedDoor(true) || isoGridSquare.Has(IsoObjectType.stairsBW)) {
                    CCObjectOutline.setNorth(i - n6, n4 - n7, n3, this.oo);
                }
                if (isoGridSquare.Has(IsoObjectType.stairsBN) && i != n8 - 2) {
                    isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i + 1, n4, n3);
                    if (isoGridSquare == null) continue;
                    CCObjectOutline.setWest(i + 1 - n6, n4 - n7, n3, this.oo);
                    continue;
                }
                if (!isoGridSquare.Has(IsoObjectType.stairsBW) || n4 == n9 - 2 || (isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i, n4 + 1, n3)) == null) continue;
                CCObjectOutline.setNorth(i - n6, n4 + 1 - n7, n3, this.oo);
            }
        }
        for (n4 = 0; n4 < n9 - n7; ++n4) {
            for (int i = 0; i < n8 - n6; ++i) {
                CCObjectOutline cCObjectOutline = CCObjectOutline.get(i, n4, n3, this.oo);
                if (cCObjectOutline == null || !cCObjectOutline.nw || !cCObjectOutline.nw_w || !cCObjectOutline.nw_n) continue;
                cCObjectOutline.trace(this.oo, this.obstacleTraceNodes);
                if (cCObjectOutline.nodes.isEmpty()) continue;
                CCObstacle cCObstacle = CCObstacle.alloc().init();
                CCNode cCNode5 = cCObjectOutline.nodes.get(cCObjectOutline.nodes.size() - 1);
                for (int j = cCObjectOutline.nodes.size() - 1; j > 0; --j) {
                    cCNode2 = cCObjectOutline.nodes.get(j);
                    cCNode = cCObjectOutline.nodes.get(j - 1);
                    cCNode2.x += (float)n6;
                    cCNode2.y += (float)n7;
                    object = CCEdge.alloc().init(cCNode2, cCNode, cCObstacle);
                    float f9 = cCNode.x + (cCNode != cCNode5 ? (float)n6 : 0.0f);
                    float f10 = cCNode.y + (cCNode != cCNode5 ? (float)n7 : 0.0f);
                    ((CCEdge)object).normal.set(f9 - cCNode2.x, f10 - cCNode2.y);
                    ((CCEdge)object).normal.normalize();
                    ((CCEdge)object).normal.rotate((float)Math.toRadians(90.0));
                    cCObstacle.edges.add((CCEdge)object);
                    this.nodes.add(cCNode2);
                }
                cCObstacle.calcBounds();
                this.obstacles.add(cCObstacle);
            }
        }
    }

    void checkEdgeIntersection() {
        Object object;
        int n;
        Object object2;
        int n2;
        CCObstacle cCObstacle;
        int n3;
        boolean bl = Core.bDebug && DebugOptions.instance.CollideWithObstaclesRenderObstacles.getValue();
        for (n3 = 0; n3 < this.obstacles.size(); ++n3) {
            cCObstacle = this.obstacles.get(n3);
            for (n2 = n3 + 1; n2 < this.obstacles.size(); ++n2) {
                object2 = this.obstacles.get(n2);
                if (!cCObstacle.bounds.intersects(((CCObstacle)object2).bounds)) continue;
                for (n = 0; n < cCObstacle.edges.size(); ++n) {
                    object = cCObstacle.edges.get(n);
                    for (int i = 0; i < ((CCObstacle)object2).edges.size(); ++i) {
                        CCEdge cCEdge = ((CCObstacle)object2).edges.get(i);
                        CCIntersection cCIntersection = this.getIntersection((CCEdge)object, cCEdge);
                        if (cCIntersection == null) continue;
                        ((CCEdge)object).intersections.add(cCIntersection);
                        cCEdge.intersections.add(cCIntersection);
                        if (bl) {
                            LineDrawer.addLine(cCIntersection.nodeSplit.x - 0.1f, cCIntersection.nodeSplit.y - 0.1f, ((CCEdge)object).node1.z, cCIntersection.nodeSplit.x + 0.1f, cCIntersection.nodeSplit.y + 0.1f, ((CCEdge)object).node1.z, 1.0f, 0.0f, 0.0f, null, false);
                        }
                        if (!((CCEdge)object).hasNode(cCIntersection.nodeSplit) && !cCEdge.hasNode(cCIntersection.nodeSplit)) {
                            this.nodes.add(cCIntersection.nodeSplit);
                        }
                        this.intersections.add(cCIntersection);
                    }
                }
            }
        }
        for (n3 = 0; n3 < this.obstacles.size(); ++n3) {
            cCObstacle = this.obstacles.get(n3);
            for (n2 = cCObstacle.edges.size() - 1; n2 >= 0; --n2) {
                object2 = cCObstacle.edges.get(n2);
                if (((CCEdge)object2).intersections.isEmpty()) continue;
                this.comparator.edge = object2;
                Collections.sort(((CCEdge)object2).intersections, this.comparator);
                for (n = ((CCEdge)object2).intersections.size() - 1; n >= 0; --n) {
                    object = ((CCEdge)object2).intersections.get(n);
                    CCEdge cCEdge = ((CCIntersection)object).split((CCEdge)object2);
                }
            }
        }
    }

    boolean collinear(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = (f3 - f) * (f6 - f2) - (f5 - f) * (f4 - f2);
        return f7 >= -0.05f && f7 < 0.05f;
    }

    boolean within(float f, float f2, float f3) {
        return f <= f2 && f2 <= f3 || f3 <= f2 && f2 <= f;
    }

    boolean is_on(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.collinear(f, f2, f3, f4, f5, f6) && (f != f3 ? this.within(f, f5, f3) : this.within(f2, f6, f4));
    }

    public CCIntersection getIntersection(CCEdge cCEdge, CCEdge cCEdge2) {
        float f = cCEdge2.node2.y;
        float f2 = cCEdge2.node1.y;
        float f3 = cCEdge.node2.x;
        float f4 = cCEdge.node1.x;
        float f5 = cCEdge2.node2.x;
        float f6 = cCEdge2.node1.x;
        float f7 = cCEdge.node2.y;
        float f8 = cCEdge.node1.y;
        double d = (f - f2) * (f3 - f4) - (f5 - f6) * (f7 - f8);
        if (d > -0.01 && d < 0.01) {
            return null;
        }
        double d2 = (double)((f5 - f6) * (f8 - f2) - (f - f2) * (f4 - f6)) / d;
        double d3 = (double)((f3 - f4) * (f8 - f2) - (f7 - f8) * (f4 - f6)) / d;
        if (d2 >= 0.0 && d2 <= 1.0 && d3 >= 0.0 && d3 <= 1.0) {
            float f9 = (float)((double)f4 + d2 * (double)(f3 - f4));
            float f10 = (float)((double)f8 + d2 * (double)(f7 - f8));
            CCNode cCNode = null;
            CCNode cCNode2 = null;
            if (d2 < (double)0.01f) {
                cCNode = cCEdge.node1;
            } else if (d2 > (double)0.99f) {
                cCNode = cCEdge.node2;
            }
            if (d3 < (double)0.01f) {
                cCNode2 = cCEdge2.node1;
            } else if (d3 > (double)0.99f) {
                cCNode2 = cCEdge2.node2;
            }
            if (cCNode != null && cCNode2 != null) {
                CCIntersection cCIntersection = CCIntersection.alloc().init(cCEdge, cCEdge2, (float)d2, (float)d3, cCNode);
                cCEdge.intersections.add(cCIntersection);
                this.intersections.add(cCIntersection);
                cCIntersection = CCIntersection.alloc().init(cCEdge, cCEdge2, (float)d2, (float)d3, cCNode2);
                cCEdge2.intersections.add(cCIntersection);
                this.intersections.add(cCIntersection);
                LineDrawer.addLine(cCIntersection.nodeSplit.x - 0.1f, cCIntersection.nodeSplit.y - 0.1f, cCEdge.node1.z, cCIntersection.nodeSplit.x + 0.1f, cCIntersection.nodeSplit.y + 0.1f, cCEdge.node1.z, 1.0f, 0.0f, 0.0f, null, false);
                return null;
            }
            if (cCNode == null && cCNode2 == null) {
                return CCIntersection.alloc().init(cCEdge, cCEdge2, (float)d2, (float)d3, f9, f10);
            }
            return CCIntersection.alloc().init(cCEdge, cCEdge2, (float)d2, (float)d3, cCNode == null ? cCNode2 : cCNode);
        }
        return null;
    }

    void checkNodesInObstacles() {
        block0: for (int i = 0; i < this.nodes.size(); ++i) {
            CCNode cCNode = this.nodes.get(i);
            for (int j = 0; j < this.obstacles.size(); ++j) {
                CCObstacle cCObstacle = this.obstacles.get(j);
                boolean bl = false;
                for (int k = 0; k < this.intersections.size(); ++k) {
                    CCIntersection cCIntersection = this.intersections.get(k);
                    if (cCIntersection.nodeSplit != cCNode) continue;
                    if (cCIntersection.edge1.obstacle != cCObstacle && cCIntersection.edge2.obstacle != cCObstacle) break;
                    bl = true;
                    break;
                }
                if (bl || !cCObstacle.isNodeInsideOf(cCNode)) continue;
                cCNode.ignore = true;
                continue block0;
            }
        }
    }

    boolean isVisible(CCNode cCNode, CCNode cCNode2) {
        if (cCNode.sharesEdge(cCNode2)) {
            return !cCNode.onSameShapeButDoesNotShareAnEdge(cCNode2);
        }
        return !cCNode.sharesShape(cCNode2);
    }

    void calculateNodeVisibility() {
        for (int i = 0; i < this.obstacles.size(); ++i) {
            CCObstacle cCObstacle = this.obstacles.get(i);
            for (int j = 0; j < cCObstacle.edges.size(); ++j) {
                CCEdge cCEdge = cCObstacle.edges.get(j);
                if (cCEdge.node1.ignore || cCEdge.node2.ignore || !this.isVisible(cCEdge.node1, cCEdge.node2)) continue;
                cCEdge.node1.visible.add(cCEdge.node2);
                cCEdge.node2.visible.add(cCEdge.node1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    Vector2f resolveCollision(IsoGameCharacter isoGameCharacter, float f, float f2, Vector2f vector2f) {
        void var11_24;
        void var11_17;
        float f3;
        Object object;
        int n;
        Object object2;
        int n2;
        vector2f.set(f, f2);
        if (isoGameCharacter.getCurrentSquare() != null && isoGameCharacter.getCurrentSquare().HasStairs()) {
            return vector2f;
        }
        boolean bl = Core.bDebug && DebugOptions.instance.CollideWithObstaclesRenderObstacles.getValue();
        float f4 = isoGameCharacter.x;
        float f5 = isoGameCharacter.y;
        float f6 = f;
        float f7 = f2;
        if (bl) {
            LineDrawer.addLine(f4, f5, (int)isoGameCharacter.z, f6, f7, (int)isoGameCharacter.z, 1.0f, 1.0f, 1.0f, null, true);
        }
        if (f4 == f6 && f5 == f7) {
            return vector2f;
        }
        this.move.set(f - isoGameCharacter.x, f2 - isoGameCharacter.y);
        this.move.normalize();
        for (n2 = 0; n2 < this.nodes.size(); ++n2) {
            this.nodes.get(n2).release();
        }
        for (n2 = 0; n2 < this.obstacles.size(); ++n2) {
            CCObstacle object32 = this.obstacles.get(n2);
            for (int i = 0; i < object32.edges.size(); ++i) {
                object32.edges.get(i).release();
            }
            object32.release();
        }
        for (n2 = 0; n2 < this.intersections.size(); ++n2) {
            this.intersections.get(n2).release();
        }
        this.intersections.clear();
        this.getObstaclesInRect(Math.min(f4, f6), Math.min(f5, f7), Math.max(f4, f6), Math.max(f5, f7), (int)isoGameCharacter.x, (int)isoGameCharacter.y, (int)isoGameCharacter.z);
        this.checkEdgeIntersection();
        this.checkNodesInObstacles();
        this.calculateNodeVisibility();
        if (bl) {
            for (CCNode cCNode : this.nodes) {
                for (CCNode cCNode2 : cCNode.visible) {
                    LineDrawer.addLine(cCNode.x, cCNode.y, cCNode.z, cCNode2.x, cCNode2.y, cCNode2.z, 0.0f, 1.0f, 0.0f, null, true);
                }
                if (DebugOptions.instance.CollideWithObstaclesRenderNormals.getValue() && cCNode.getNormalAndEdgeVectors(this.nodeNormal, this.edgeVec)) {
                    LineDrawer.addLine(cCNode.x, cCNode.y, cCNode.z, cCNode.x + this.nodeNormal.x, cCNode.y + this.nodeNormal.y, cCNode.z, 0.0f, 0.0f, 1.0f, null, true);
                }
                if (!cCNode.ignore) continue;
                LineDrawer.addLine(cCNode.x - 0.05f, cCNode.y - 0.05f, cCNode.z, cCNode.x + 0.05f, cCNode.y + 0.05f, cCNode.z, 1.0f, 1.0f, 0.0f, null, false);
            }
        }
        Object object4 = null;
        Object var11_16 = null;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.obstacles.size(); ++i) {
            object2 = this.obstacles.get(i);
            if (!((CCObstacle)object2).isPointInside(isoGameCharacter.x, isoGameCharacter.y, n = 0)) continue;
            for (int j = 0; j < ((CCObstacle)object2).edges.size(); ++j) {
                CCEdge cCEdge = ((CCObstacle)object2).edges.get(j);
                if (!cCEdge.node1.visible.contains(cCEdge.node2)) continue;
                object = cCEdge.closestPoint(isoGameCharacter.x, isoGameCharacter.y, this.closest);
                double d2 = (isoGameCharacter.x - this.closest.x) * (isoGameCharacter.x - this.closest.x) + (isoGameCharacter.y - this.closest.y) * (isoGameCharacter.y - this.closest.y);
                if (!(d2 < d)) continue;
                d = d2;
                object4 = cCEdge;
                Object object3 = object;
            }
        }
        if (object4 != null && (f3 = ((CCEdge)object4).normal.dot(this.move)) >= 0.01f) {
            object4 = null;
        }
        if (var11_17 != null && var11_17.getNormalAndEdgeVectors(this.nodeNormal, this.edgeVec) && this.nodeNormal.dot(this.move) + 0.05f >= this.nodeNormal.dot(this.edgeVec)) {
            Object var11_19 = null;
            object4 = null;
        }
        if (object4 == null) {
            double d3 = Double.MAX_VALUE;
            object4 = null;
            Object var11_21 = null;
            block8: for (n = 0; n < this.obstacles.size(); ++n) {
                CCObstacle cCObstacle = this.obstacles.get(n);
                for (int i = 0; i < cCObstacle.edges.size(); ++i) {
                    float f8;
                    float f9;
                    double d4;
                    double d5;
                    object = cCObstacle.edges.get(i);
                    if (!((CCEdge)object).node1.visible.contains(((CCEdge)object).node2)) continue;
                    float f10 = ((CCEdge)object).node1.x;
                    float f11 = ((CCEdge)object).node1.y;
                    float f12 = ((CCEdge)object).node2.x;
                    float f13 = ((CCEdge)object).node2.y;
                    float f14 = f10 + 0.5f * (f12 - f10);
                    float f15 = f11 + 0.5f * (f13 - f11);
                    if (bl && DebugOptions.instance.CollideWithObstaclesRenderNormals.getValue()) {
                        LineDrawer.addLine(f14, f15, ((CCEdge)object).node1.z, f14 + ((CCEdge)object).normal.x, f15 + ((CCEdge)object).normal.y, ((CCEdge)object).node1.z, 0.0f, 0.0f, 1.0f, null, true);
                    }
                    if ((d5 = (double)((f13 - f11) * (f6 - f4) - (f12 - f10) * (f7 - f5))) == 0.0) continue;
                    double d6 = (double)((f12 - f10) * (f5 - f11) - (f13 - f11) * (f4 - f10)) / d5;
                    double d7 = (double)((f6 - f4) * (f5 - f11) - (f7 - f5) * (f4 - f10)) / d5;
                    float f16 = ((CCEdge)object).normal.dot(this.move);
                    if (f16 >= 0.0f || !(d6 >= 0.0) || !(d6 <= 1.0) || !(d7 >= 0.0) || !(d7 <= 1.0)) continue;
                    if (d7 < 0.01 || d7 > 0.99) {
                        CCNode cCNode;
                        CCNode cCNode3 = cCNode = d7 < 0.01 ? ((CCEdge)object).node1 : ((CCEdge)object).node2;
                        if (cCNode.getNormalAndEdgeVectors(this.nodeNormal, this.edgeVec)) {
                            if (this.nodeNormal.dot(this.move) + 0.05f >= this.nodeNormal.dot(this.edgeVec)) continue;
                            object4 = object;
                            CCNode cCNode4 = cCNode;
                            continue block8;
                        }
                    }
                    if (!((d4 = (double)IsoUtils.DistanceToSquared(f4, f5, f9 = (float)((double)f4 + d6 * (double)(f6 - f4)), f8 = (float)((double)f5 + d6 * (double)(f7 - f5)))) < d3)) continue;
                    d3 = d4;
                    object4 = object;
                }
            }
        }
        if (var11_24 != null) {
            CCEdge cCEdge = object4;
            object2 = null;
            for (n = 0; n < var11_24.edges.size(); ++n) {
                CCEdge cCEdge2 = var11_24.edges.get(n);
                if (!cCEdge2.node1.visible.contains(cCEdge2.node2) || cCEdge2 == object4 || cCEdge.node1.x == cCEdge2.node1.x && cCEdge.node1.y == cCEdge2.node1.y && cCEdge.node2.x == cCEdge2.node2.x && cCEdge.node2.y == cCEdge2.node2.y || cCEdge.node1.x == cCEdge2.node2.x && cCEdge.node1.y == cCEdge2.node2.y && cCEdge.node2.x == cCEdge2.node1.x && cCEdge.node2.y == cCEdge2.node1.y || cCEdge.hasNode(cCEdge2.node1) && cCEdge.hasNode(cCEdge2.node2)) continue;
                object2 = cCEdge2;
            }
            if (cCEdge != null && object2 != null) {
                if (object4 == cCEdge) {
                    CCNode cCNode = var11_24 == ((CCEdge)object2).node1 ? ((CCEdge)object2).node2 : ((CCEdge)object2).node1;
                    this.edgeVec.set(cCNode.x - var11_24.x, cCNode.y - var11_24.y);
                    this.edgeVec.normalize();
                    if (this.move.dot(this.edgeVec) >= 0.0f) {
                        object4 = object2;
                    }
                } else if (object4 == object2) {
                    CCNode cCNode = var11_24 == cCEdge.node1 ? cCEdge.node2 : cCEdge.node1;
                    this.edgeVec.set(cCNode.x - var11_24.x, cCNode.y - var11_24.y);
                    this.edgeVec.normalize();
                    if (this.move.dot(this.edgeVec) >= 0.0f) {
                        object4 = cCEdge;
                    }
                }
            }
        }
        if (object4 != null) {
            float f17 = ((CCEdge)object4).node1.x;
            float f18 = ((CCEdge)object4).node1.y;
            float f19 = ((CCEdge)object4).node2.x;
            float f20 = ((CCEdge)object4).node2.y;
            if (bl) {
                LineDrawer.addLine(f17, f18, ((CCEdge)object4).node1.z, f19, f20, ((CCEdge)object4).node1.z, 0.0f, 1.0f, 1.0f, null, true);
            }
            ((CCEdge)object4).closestPoint(f, f2, this.closest);
            vector2f.set(this.closest.x, this.closest.y);
        }
        return vector2f;
    }

    private static final class ImmutableRectF {
        private float x;
        private float y;
        private float w;
        private float h;
        static ArrayDeque<ImmutableRectF> pool = new ArrayDeque();

        private ImmutableRectF() {
        }

        ImmutableRectF init(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.w = f3;
            this.h = f4;
            return this;
        }

        float left() {
            return this.x;
        }

        float top() {
            return this.y;
        }

        float right() {
            return this.x + this.w;
        }

        float bottom() {
            return this.y + this.h;
        }

        float width() {
            return this.w;
        }

        float height() {
            return this.h;
        }

        boolean containsPoint(float f, float f2) {
            return f >= this.left() && f < this.right() && f2 >= this.top() && f2 < this.bottom();
        }

        boolean intersects(ImmutableRectF immutableRectF) {
            return this.left() < immutableRectF.right() && this.right() > immutableRectF.left() && this.top() < immutableRectF.bottom() && this.bottom() > immutableRectF.top();
        }

        static ImmutableRectF alloc() {
            return pool.isEmpty() ? new ImmutableRectF() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class CCObjectOutline {
        int x;
        int y;
        int z;
        boolean nw;
        boolean nw_w;
        boolean nw_n;
        boolean nw_e;
        boolean nw_s;
        boolean w_w;
        boolean w_e;
        boolean w_cutoff;
        boolean n_n;
        boolean n_s;
        boolean n_cutoff;
        ArrayList<CCNode> nodes;
        static ArrayDeque<CCObjectOutline> pool = new ArrayDeque();

        private CCObjectOutline() {
        }

        CCObjectOutline init(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
            this.nw_e = false;
            this.nw_n = false;
            this.nw_w = false;
            this.nw = false;
            this.w_cutoff = false;
            this.w_e = false;
            this.w_w = false;
            this.n_cutoff = false;
            this.n_s = false;
            this.n_n = false;
            return this;
        }

        static void setSolid(int n, int n2, int n3, CCObjectOutline[][] cCObjectOutlineArray) {
            CCObjectOutline.setWest(n, n2, n3, cCObjectOutlineArray);
            CCObjectOutline.setNorth(n, n2, n3, cCObjectOutlineArray);
            CCObjectOutline.setWest(n + 1, n2, n3, cCObjectOutlineArray);
            CCObjectOutline.setNorth(n, n2 + 1, n3, cCObjectOutlineArray);
        }

        static void setWest(int n, int n2, int n3, CCObjectOutline[][] cCObjectOutlineArray) {
            CCObjectOutline cCObjectOutline = CCObjectOutline.get(n, n2, n3, cCObjectOutlineArray);
            if (cCObjectOutline != null) {
                if (cCObjectOutline.nw) {
                    cCObjectOutline.nw_s = false;
                } else {
                    cCObjectOutline.nw = true;
                    cCObjectOutline.nw_w = true;
                    cCObjectOutline.nw_n = true;
                    cCObjectOutline.nw_e = true;
                    cCObjectOutline.nw_s = false;
                }
                cCObjectOutline.w_w = true;
                cCObjectOutline.w_e = true;
            }
            CCObjectOutline cCObjectOutline2 = cCObjectOutline;
            cCObjectOutline = CCObjectOutline.get(n, n2 + 1, n3, cCObjectOutlineArray);
            if (cCObjectOutline == null) {
                if (cCObjectOutline2 != null) {
                    cCObjectOutline2.w_cutoff = true;
                }
            } else if (cCObjectOutline.nw) {
                cCObjectOutline.nw_n = false;
            } else {
                cCObjectOutline.nw = true;
                cCObjectOutline.nw_n = false;
                cCObjectOutline.nw_w = true;
                cCObjectOutline.nw_e = true;
                cCObjectOutline.nw_s = true;
            }
        }

        static void setNorth(int n, int n2, int n3, CCObjectOutline[][] cCObjectOutlineArray) {
            CCObjectOutline cCObjectOutline = CCObjectOutline.get(n, n2, n3, cCObjectOutlineArray);
            if (cCObjectOutline != null) {
                if (cCObjectOutline.nw) {
                    cCObjectOutline.nw_e = false;
                } else {
                    cCObjectOutline.nw = true;
                    cCObjectOutline.nw_w = true;
                    cCObjectOutline.nw_n = true;
                    cCObjectOutline.nw_e = false;
                    cCObjectOutline.nw_s = true;
                }
                cCObjectOutline.n_n = true;
                cCObjectOutline.n_s = true;
            }
            CCObjectOutline cCObjectOutline2 = cCObjectOutline;
            cCObjectOutline = CCObjectOutline.get(n + 1, n2, n3, cCObjectOutlineArray);
            if (cCObjectOutline == null) {
                if (cCObjectOutline2 != null) {
                    cCObjectOutline2.n_cutoff = true;
                }
            } else if (cCObjectOutline.nw) {
                cCObjectOutline.nw_w = false;
            } else {
                cCObjectOutline.nw = true;
                cCObjectOutline.nw_n = true;
                cCObjectOutline.nw_w = false;
                cCObjectOutline.nw_e = true;
                cCObjectOutline.nw_s = true;
            }
        }

        static CCObjectOutline get(int n, int n2, int n3, CCObjectOutline[][] cCObjectOutlineArray) {
            if (n < 0 || n >= cCObjectOutlineArray.length) {
                return null;
            }
            if (n2 < 0 || n2 >= cCObjectOutlineArray[0].length) {
                return null;
            }
            if (cCObjectOutlineArray[n][n2] == null) {
                cCObjectOutlineArray[n][n2] = CCObjectOutline.alloc().init(n, n2, n3);
            }
            return cCObjectOutlineArray[n][n2];
        }

        void trace_NW_N(CCObjectOutline[][] cCObjectOutlineArray, CCNode cCNode) {
            if (cCNode != null) {
                cCNode.setXY((float)this.x + 0.3f, (float)this.y - 0.3f);
            } else {
                CCNode cCNode2 = CCNode.alloc().init((float)this.x + 0.3f, (float)this.y - 0.3f, this.z);
                this.nodes.add(cCNode2);
            }
            this.nw_n = false;
            if (this.nw_e) {
                this.trace_NW_E(cCObjectOutlineArray, null);
            } else if (this.n_n) {
                this.trace_N_N(cCObjectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            }
        }

        void trace_NW_S(CCObjectOutline[][] cCObjectOutlineArray, CCNode cCNode) {
            Object object;
            if (cCNode != null) {
                cCNode.setXY((float)this.x - 0.3f, (float)this.y + 0.3f);
            } else {
                object = CCNode.alloc().init((float)this.x - 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add((CCNode)object);
            }
            this.nw_s = false;
            if (this.nw_w) {
                this.trace_NW_W(cCObjectOutlineArray, null);
            } else {
                object = CCObjectOutline.get(this.x - 1, this.y, this.z, cCObjectOutlineArray);
                if (object == null) {
                    return;
                }
                if (((CCObjectOutline)object).n_s) {
                    ((CCObjectOutline)object).nodes = this.nodes;
                    ((CCObjectOutline)object).trace_N_S(cCObjectOutlineArray, this.nodes.get(this.nodes.size() - 1));
                }
            }
        }

        void trace_NW_W(CCObjectOutline[][] cCObjectOutlineArray, CCNode cCNode) {
            Object object;
            if (cCNode != null) {
                cCNode.setXY((float)this.x - 0.3f, (float)this.y - 0.3f);
            } else {
                object = CCNode.alloc().init((float)this.x - 0.3f, (float)this.y - 0.3f, this.z);
                this.nodes.add((CCNode)object);
            }
            this.nw_w = false;
            if (this.nw_n) {
                this.trace_NW_N(cCObjectOutlineArray, null);
            } else {
                object = CCObjectOutline.get(this.x, this.y - 1, this.z, cCObjectOutlineArray);
                if (object == null) {
                    return;
                }
                if (((CCObjectOutline)object).w_w) {
                    ((CCObjectOutline)object).nodes = this.nodes;
                    ((CCObjectOutline)object).trace_W_W(cCObjectOutlineArray, this.nodes.get(this.nodes.size() - 1));
                }
            }
        }

        void trace_NW_E(CCObjectOutline[][] cCObjectOutlineArray, CCNode cCNode) {
            if (cCNode != null) {
                cCNode.setXY((float)this.x + 0.3f, (float)this.y + 0.3f);
            } else {
                CCNode cCNode2 = CCNode.alloc().init((float)this.x + 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add(cCNode2);
            }
            this.nw_e = false;
            if (this.nw_s) {
                this.trace_NW_S(cCObjectOutlineArray, null);
            } else if (this.w_e) {
                this.trace_W_E(cCObjectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            }
        }

        void trace_W_E(CCObjectOutline[][] cCObjectOutlineArray, CCNode cCNode) {
            Object object;
            if (cCNode != null) {
                cCNode.setXY((float)this.x + 0.3f, (float)(this.y + 1) - 0.3f);
            } else {
                object = CCNode.alloc().init((float)this.x + 0.3f, (float)(this.y + 1) - 0.3f, this.z);
                this.nodes.add((CCNode)object);
            }
            this.w_e = false;
            if (this.w_cutoff) {
                object = this.nodes.get(this.nodes.size() - 1);
                ((CCNode)object).setXY((float)this.x + 0.3f, (float)(this.y + 1) + 0.3f);
                object = CCNode.alloc().init((float)this.x - 0.3f, (float)(this.y + 1) + 0.3f, this.z);
                this.nodes.add((CCNode)object);
                object = CCNode.alloc().init((float)this.x - 0.3f, (float)(this.y + 1) - 0.3f, this.z);
                this.nodes.add((CCNode)object);
                this.trace_W_W(cCObjectOutlineArray, (CCNode)object);
                return;
            }
            object = CCObjectOutline.get(this.x, this.y + 1, this.z, cCObjectOutlineArray);
            if (object == null) {
                return;
            }
            if (((CCObjectOutline)object).nw && ((CCObjectOutline)object).nw_e) {
                ((CCObjectOutline)object).nodes = this.nodes;
                ((CCObjectOutline)object).trace_NW_E(cCObjectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            } else if (((CCObjectOutline)object).n_n) {
                ((CCObjectOutline)object).nodes = this.nodes;
                ((CCObjectOutline)object).trace_N_N(cCObjectOutlineArray, null);
            }
        }

        void trace_W_W(CCObjectOutline[][] cCObjectOutlineArray, CCNode cCNode) {
            Object object;
            if (cCNode != null) {
                cCNode.setXY((float)this.x - 0.3f, (float)this.y + 0.3f);
            } else {
                object = CCNode.alloc().init((float)this.x - 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add((CCNode)object);
            }
            this.w_w = false;
            if (this.nw_w) {
                this.trace_NW_W(cCObjectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            } else {
                object = CCObjectOutline.get(this.x - 1, this.y, this.z, cCObjectOutlineArray);
                if (object == null) {
                    return;
                }
                if (((CCObjectOutline)object).n_s) {
                    ((CCObjectOutline)object).nodes = this.nodes;
                    ((CCObjectOutline)object).trace_N_S(cCObjectOutlineArray, null);
                }
            }
        }

        void trace_N_N(CCObjectOutline[][] cCObjectOutlineArray, CCNode cCNode) {
            Object object;
            if (cCNode != null) {
                cCNode.setXY((float)(this.x + 1) - 0.3f, (float)this.y - 0.3f);
            } else {
                object = CCNode.alloc().init((float)(this.x + 1) - 0.3f, (float)this.y - 0.3f, this.z);
                this.nodes.add((CCNode)object);
            }
            this.n_n = false;
            if (this.n_cutoff) {
                object = this.nodes.get(this.nodes.size() - 1);
                ((CCNode)object).setXY((float)(this.x + 1) + 0.3f, (float)this.y - 0.3f);
                object = CCNode.alloc().init((float)(this.x + 1) + 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add((CCNode)object);
                object = CCNode.alloc().init((float)(this.x + 1) - 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add((CCNode)object);
                this.trace_N_S(cCObjectOutlineArray, (CCNode)object);
                return;
            }
            object = CCObjectOutline.get(this.x + 1, this.y, this.z, cCObjectOutlineArray);
            if (object == null) {
                return;
            }
            if (((CCObjectOutline)object).nw_n) {
                ((CCObjectOutline)object).nodes = this.nodes;
                ((CCObjectOutline)object).trace_NW_N(cCObjectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            } else {
                object = CCObjectOutline.get(this.x + 1, this.y - 1, this.z, cCObjectOutlineArray);
                if (object == null) {
                    return;
                }
                if (((CCObjectOutline)object).w_w) {
                    ((CCObjectOutline)object).nodes = this.nodes;
                    ((CCObjectOutline)object).trace_W_W(cCObjectOutlineArray, null);
                }
            }
        }

        void trace_N_S(CCObjectOutline[][] cCObjectOutlineArray, CCNode cCNode) {
            if (cCNode != null) {
                cCNode.setXY((float)this.x + 0.3f, (float)this.y + 0.3f);
            } else {
                CCNode cCNode2 = CCNode.alloc().init((float)this.x + 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add(cCNode2);
            }
            this.n_s = false;
            if (this.nw_s) {
                this.trace_NW_S(cCObjectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            } else if (this.w_e) {
                this.trace_W_E(cCObjectOutlineArray, null);
            }
        }

        void trace(CCObjectOutline[][] cCObjectOutlineArray, ArrayList<CCNode> arrayList) {
            arrayList.clear();
            this.nodes = arrayList;
            CCNode cCNode = CCNode.alloc().init((float)this.x - 0.3f, (float)this.y - 0.3f, this.z);
            arrayList.add(cCNode);
            this.trace_NW_N(cCObjectOutlineArray, null);
            if (arrayList.size() == 2 || cCNode.x != arrayList.get((int)(arrayList.size() - 1)).x || cCNode.y != arrayList.get((int)(arrayList.size() - 1)).y) {
                arrayList.clear();
            } else {
                arrayList.get(arrayList.size() - 1).release();
                arrayList.set(arrayList.size() - 1, cCNode);
            }
        }

        static CCObjectOutline alloc() {
            return pool.isEmpty() ? new CCObjectOutline() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    static final class CompareIntersection
    implements Comparator<CCIntersection> {
        CCEdge edge;

        CompareIntersection() {
        }

        @Override
        public int compare(CCIntersection cCIntersection, CCIntersection cCIntersection2) {
            float f;
            float f2 = this.edge == cCIntersection.edge1 ? cCIntersection.dist1 : cCIntersection.dist2;
            float f3 = f = this.edge == cCIntersection2.edge1 ? cCIntersection2.dist1 : cCIntersection2.dist2;
            if (f2 < f) {
                return -1;
            }
            if (f2 > f) {
                return 1;
            }
            return 0;
        }
    }

    private static final class CCNode {
        float x;
        float y;
        int z;
        boolean ignore;
        final ArrayList<CCEdge> edges = new ArrayList();
        final ArrayList<CCNode> visible = new ArrayList();
        static ArrayList<CCObstacle> tempObstacles = new ArrayList();
        static ArrayDeque<CCNode> pool = new ArrayDeque();

        private CCNode() {
        }

        CCNode init(float f, float f2, int n) {
            this.x = f;
            this.y = f2;
            this.z = n;
            this.ignore = false;
            this.edges.clear();
            this.visible.clear();
            return this;
        }

        CCNode setXY(float f, float f2) {
            this.x = f;
            this.y = f2;
            return this;
        }

        boolean sharesEdge(CCNode cCNode) {
            for (int i = 0; i < this.edges.size(); ++i) {
                CCEdge cCEdge = this.edges.get(i);
                if (!cCEdge.hasNode(cCNode)) continue;
                return true;
            }
            return false;
        }

        boolean sharesShape(CCNode cCNode) {
            for (int i = 0; i < this.edges.size(); ++i) {
                CCEdge cCEdge = this.edges.get(i);
                for (int j = 0; j < cCNode.edges.size(); ++j) {
                    CCEdge cCEdge2 = cCNode.edges.get(j);
                    if (cCEdge.obstacle == null || cCEdge.obstacle != cCEdge2.obstacle) continue;
                    return true;
                }
            }
            return false;
        }

        void getObstacles(ArrayList<CCObstacle> arrayList) {
            for (int i = 0; i < this.edges.size(); ++i) {
                CCEdge cCEdge = this.edges.get(i);
                if (arrayList.contains(cCEdge.obstacle)) continue;
                arrayList.add(cCEdge.obstacle);
            }
        }

        boolean onSameShapeButDoesNotShareAnEdge(CCNode cCNode) {
            tempObstacles.clear();
            this.getObstacles(tempObstacles);
            for (int i = 0; i < tempObstacles.size(); ++i) {
                CCObstacle cCObstacle = tempObstacles.get(i);
                if (!cCObstacle.hasNode(cCNode) || cCObstacle.hasAdjacentNodes(this, cCNode)) continue;
                return true;
            }
            return false;
        }

        boolean getNormalAndEdgeVectors(Vector2 vector22, Vector2 vector23) {
            CCEdge cCEdge = null;
            CCEdge cCEdge2 = null;
            for (int i = 0; i < this.edges.size(); ++i) {
                CCEdge cCEdge3 = this.edges.get(i);
                if (!cCEdge3.node1.visible.contains(cCEdge3.node2)) continue;
                if (cCEdge == null) {
                    cCEdge = cCEdge3;
                    continue;
                }
                if (cCEdge.hasNode(cCEdge3.node1) && cCEdge.hasNode(cCEdge3.node2)) continue;
                cCEdge2 = cCEdge3;
            }
            if (cCEdge == null || cCEdge2 == null) {
                return false;
            }
            float f = cCEdge.normal.x + cCEdge2.normal.x;
            float f2 = cCEdge.normal.y + cCEdge2.normal.y;
            vector22.set(f, f2);
            vector22.normalize();
            if (cCEdge.node1 == this) {
                vector23.set(cCEdge.node2.x - cCEdge.node1.x, cCEdge.node2.y - cCEdge.node1.y);
            } else {
                vector23.set(cCEdge.node1.x - cCEdge.node2.x, cCEdge.node1.y - cCEdge.node2.y);
            }
            vector23.normalize();
            return true;
        }

        static CCNode alloc() {
            if (pool.isEmpty()) {
                boolean bl = false;
            } else {
                boolean bl = false;
            }
            return pool.isEmpty() ? new CCNode() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class CCObstacle {
        final ArrayList<CCEdge> edges = new ArrayList();
        ImmutableRectF bounds;
        static ArrayDeque<CCObstacle> pool = new ArrayDeque();

        private CCObstacle() {
        }

        CCObstacle init() {
            this.edges.clear();
            return this;
        }

        boolean hasNode(CCNode cCNode) {
            for (int i = 0; i < this.edges.size(); ++i) {
                CCEdge cCEdge = this.edges.get(i);
                if (!cCEdge.hasNode(cCNode)) continue;
                return true;
            }
            return false;
        }

        boolean hasAdjacentNodes(CCNode cCNode, CCNode cCNode2) {
            for (int i = 0; i < this.edges.size(); ++i) {
                CCEdge cCEdge = this.edges.get(i);
                if (!cCEdge.hasNode(cCNode) || !cCEdge.hasNode(cCNode2)) continue;
                return true;
            }
            return false;
        }

        boolean isPointInPolygon_CrossingNumber(float f, float f2) {
            int n = 0;
            for (int i = 0; i < this.edges.size(); ++i) {
                float f3;
                CCEdge cCEdge = this.edges.get(i);
                if (!(cCEdge.node1.y <= f2 && cCEdge.node2.y > f2) && (!(cCEdge.node1.y > f2) || !(cCEdge.node2.y <= f2)) || !(f < cCEdge.node1.x + (f3 = (f2 - cCEdge.node1.y) / (cCEdge.node2.y - cCEdge.node1.y)) * (cCEdge.node2.x - cCEdge.node1.x))) continue;
                ++n;
            }
            return n % 2 == 1;
        }

        float isLeft(float f, float f2, float f3, float f4, float f5, float f6) {
            return (f3 - f) * (f6 - f2) - (f5 - f) * (f4 - f2);
        }

        EdgeRingHit isPointInPolygon_WindingNumber(float f, float f2, int n) {
            int n2 = 0;
            for (int i = 0; i < this.edges.size(); ++i) {
                CCEdge cCEdge = this.edges.get(i);
                if ((n & 0x10) != 0 && cCEdge.isPointOn(f, f2)) {
                    return EdgeRingHit.OnEdge;
                }
                if (cCEdge.node1.y <= f2) {
                    if (!(cCEdge.node2.y > f2) || !(this.isLeft(cCEdge.node1.x, cCEdge.node1.y, cCEdge.node2.x, cCEdge.node2.y, f, f2) > 0.0f)) continue;
                    ++n2;
                    continue;
                }
                if (!(cCEdge.node2.y <= f2) || !(this.isLeft(cCEdge.node1.x, cCEdge.node1.y, cCEdge.node2.x, cCEdge.node2.y, f, f2) < 0.0f)) continue;
                --n2;
            }
            return n2 == 0 ? EdgeRingHit.Outside : EdgeRingHit.Inside;
        }

        boolean isPointInside(float f, float f2, int n) {
            return this.isPointInPolygon_WindingNumber(f, f2, n) == EdgeRingHit.Inside;
        }

        boolean isNodeInsideOf(CCNode cCNode) {
            if (this.hasNode(cCNode)) {
                return false;
            }
            if (!this.bounds.containsPoint(cCNode.x, cCNode.y)) {
                return false;
            }
            int n = 0;
            return this.isPointInside(cCNode.x, cCNode.y, n);
        }

        CCNode getClosestPointOnEdge(float f, float f2, Vector2 vector22) {
            double d = Double.MAX_VALUE;
            CCNode cCNode = null;
            float f3 = Float.MAX_VALUE;
            float f4 = Float.MAX_VALUE;
            for (int i = 0; i < this.edges.size(); ++i) {
                CCEdge cCEdge = this.edges.get(i);
                if (!cCEdge.node1.visible.contains(cCEdge.node2)) continue;
                CCNode cCNode2 = cCEdge.closestPoint(f, f2, vector22);
                double d2 = (f - vector22.x) * (f - vector22.x) + (f2 - vector22.y) * (f2 - vector22.y);
                if (!(d2 < d)) continue;
                f3 = vector22.x;
                f4 = vector22.y;
                cCNode = cCNode2;
                d = d2;
            }
            vector22.set(f3, f4);
            return cCNode;
        }

        void calcBounds() {
            float f = Float.MAX_VALUE;
            float f2 = Float.MAX_VALUE;
            float f3 = Float.MIN_VALUE;
            float f4 = Float.MIN_VALUE;
            for (int i = 0; i < this.edges.size(); ++i) {
                CCEdge cCEdge = this.edges.get(i);
                f = Math.min(f, cCEdge.node1.x);
                f2 = Math.min(f2, cCEdge.node1.y);
                f3 = Math.max(f3, cCEdge.node1.x);
                f4 = Math.max(f4, cCEdge.node1.y);
            }
            if (this.bounds != null) {
                this.bounds.release();
            }
            float f5 = 0.01f;
            this.bounds = ImmutableRectF.alloc().init(f - f5, f2 - f5, f3 - f + f5 * 2.0f, f4 - f2 + f5 * 2.0f);
        }

        static CCObstacle alloc() {
            return pool.isEmpty() ? new CCObstacle() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class CCEdge {
        CCNode node1;
        CCNode node2;
        CCObstacle obstacle;
        final ArrayList<CCIntersection> intersections = new ArrayList();
        final Vector2 normal = new Vector2();
        static ArrayDeque<CCEdge> pool = new ArrayDeque();

        private CCEdge() {
        }

        CCEdge init(CCNode cCNode, CCNode cCNode2, CCObstacle cCObstacle) {
            if (cCNode.x == cCNode2.x && cCNode.y == cCNode2.y) {
                boolean bl = false;
            }
            this.node1 = cCNode;
            this.node2 = cCNode2;
            cCNode.edges.add(this);
            cCNode2.edges.add(this);
            this.obstacle = cCObstacle;
            this.intersections.clear();
            this.normal.set(cCNode2.x - cCNode.x, cCNode2.y - cCNode.y);
            this.normal.normalize();
            this.normal.rotate((float)Math.toRadians(90.0));
            return this;
        }

        boolean hasNode(CCNode cCNode) {
            return cCNode == this.node1 || cCNode == this.node2;
        }

        CCEdge split(CCNode cCNode) {
            CCEdge cCEdge = CCEdge.alloc().init(cCNode, this.node2, this.obstacle);
            this.obstacle.edges.add(this.obstacle.edges.indexOf(this) + 1, cCEdge);
            this.node2.edges.remove(this);
            this.node2 = cCNode;
            this.node2.edges.add(this);
            return cCEdge;
        }

        CCNode closestPoint(float f, float f2, Vector2 vector22) {
            double d;
            float f3 = this.node1.x;
            float f4 = this.node2.x;
            float f5 = this.node1.y;
            float f6 = this.node2.y;
            double d2 = (double)((f - f3) * (f4 - f3) + (f2 - f5) * (f6 - f5)) / (Math.pow(f4 - f3, 2.0) + Math.pow(f6 - f5, 2.0));
            if (d2 <= 0.0 + (d = 0.001)) {
                vector22.set(f3, f5);
                return this.node1;
            }
            if (d2 >= 1.0 - d) {
                vector22.set(f4, f6);
                return this.node2;
            }
            double d3 = (double)f3 + d2 * (double)(f4 - f3);
            double d4 = (double)f5 + d2 * (double)(f6 - f5);
            vector22.set((float)d3, (float)d4);
            return null;
        }

        boolean isPointOn(float f, float f2) {
            float f3 = this.node1.x;
            float f4 = this.node1.y;
            float f5 = this.node2.x;
            float f6 = this.node2.y;
            double d = (double)((f - f3) * (f5 - f3) + (f2 - f4) * (f6 - f4)) / (Math.pow(f5 - f3, 2.0) + Math.pow(f6 - f4, 2.0));
            double d2 = (double)f3 + d * (double)(f5 - f3);
            double d3 = (double)f4 + d * (double)(f6 - f4);
            if (d <= 0.0) {
                d2 = f3;
                d3 = f4;
            } else if (d >= 1.0) {
                d2 = f5;
                d3 = f6;
            }
            double d4 = ((double)f - d2) * ((double)f - d2) + ((double)f2 - d3) * ((double)f2 - d3);
            return d4 < 1.0E-6;
        }

        static CCEdge alloc() {
            return pool.isEmpty() ? new CCEdge() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class CCIntersection {
        CCEdge edge1;
        CCEdge edge2;
        float dist1;
        float dist2;
        CCNode nodeSplit;
        static ArrayDeque<CCIntersection> pool = new ArrayDeque();

        private CCIntersection() {
        }

        CCIntersection init(CCEdge cCEdge, CCEdge cCEdge2, float f, float f2, float f3, float f4) {
            this.edge1 = cCEdge;
            this.edge2 = cCEdge2;
            this.dist1 = f;
            this.dist2 = f2;
            this.nodeSplit = CCNode.alloc().init(f3, f4, cCEdge.node1.z);
            return this;
        }

        CCIntersection init(CCEdge cCEdge, CCEdge cCEdge2, float f, float f2, CCNode cCNode) {
            this.edge1 = cCEdge;
            this.edge2 = cCEdge2;
            this.dist1 = f;
            this.dist2 = f2;
            this.nodeSplit = cCNode;
            return this;
        }

        CCEdge split(CCEdge cCEdge) {
            if (cCEdge.hasNode(this.nodeSplit)) {
                return null;
            }
            if (cCEdge.node1.x == this.nodeSplit.x && cCEdge.node1.y == this.nodeSplit.y) {
                return null;
            }
            if (cCEdge.node2.x == this.nodeSplit.x && cCEdge.node2.y == this.nodeSplit.y) {
                return null;
            }
            return cCEdge.split(this.nodeSplit);
        }

        static CCIntersection alloc() {
            return pool.isEmpty() ? new CCIntersection() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static enum EdgeRingHit {
        OnEdge,
        Inside,
        Outside;

    }
}

