/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.nio.ByteBuffer;
import zombie.debug.DebugLog;

public class Clipper {
    private long address;
    final ByteBuffer bb = ByteBuffer.allocateDirect(64);

    public static void init() {
        String string = "";
        if ("1".equals(System.getProperty("zomboid.debuglibs.clipper"))) {
            DebugLog.log("***** Loading debug version of PZClipper");
            string = "d";
        }
        if (System.getProperty("os.name").contains("OS X")) {
            System.loadLibrary("PZClipper");
        } else if (System.getProperty("sun.arch.data.model").equals("64")) {
            System.loadLibrary("PZClipper64" + string);
        } else {
            System.loadLibrary("PZClipper32" + string);
        }
        Clipper.n_init();
    }

    public Clipper() {
        this.newInstance();
    }

    private native void newInstance();

    public native void clear();

    public native void addPath(int var1, ByteBuffer var2, boolean var3);

    public native void addLine(float var1, float var2, float var3, float var4);

    public native void addAABB(float var1, float var2, float var3, float var4);

    public void addAABBBevel(float f, float f2, float f3, float f4, float f5) {
        this.bb.clear();
        this.bb.putFloat(f + f5);
        this.bb.putFloat(f2);
        this.bb.putFloat(f3 - f5);
        this.bb.putFloat(f2);
        this.bb.putFloat(f3);
        this.bb.putFloat(f2 + f5);
        this.bb.putFloat(f3);
        this.bb.putFloat(f4 - f5);
        this.bb.putFloat(f3 - f5);
        this.bb.putFloat(f4);
        this.bb.putFloat(f + f5);
        this.bb.putFloat(f4);
        this.bb.putFloat(f);
        this.bb.putFloat(f4 - f5);
        this.bb.putFloat(f);
        this.bb.putFloat(f2 + f5);
        this.addPath(this.bb.position() / 4 / 2, this.bb, false);
    }

    public native void addPolygon(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    public native void clipAABB(float var1, float var2, float var3, float var4);

    public int generatePolygons() {
        return this.generatePolygons(0.0);
    }

    public native int generatePolygons(double var1);

    public native int getPolygon(int var1, ByteBuffer var2);

    public native int generateTriangulatePolygons(int var1, int var2);

    public native int triangulate(int var1, ByteBuffer var2);

    public static native void n_init();

    private static void writeToStdErr(String string) {
        System.err.println(string);
    }
}

