/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import fmod.fmod.FMODSoundEmitter;
import org.joml.Vector3f;
import zombie.GameTime;
import zombie.ai.State;
import zombie.ai.states.ZombieIdleState;
import zombie.audio.BaseSoundEmitter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.network.GameServer;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehiclePart;
import zombie.vehicles.VehicleWindow;

public final class AttackVehicleState
extends State {
    private static final AttackVehicleState _instance = new AttackVehicleState();
    private BaseSoundEmitter emitter;
    private final Vector3f worldPos = new Vector3f();

    public static AttackVehicleState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (!(isoZombie.target instanceof IsoGameCharacter)) {
            return;
        }
        IsoGameCharacter isoGameCharacter2 = (IsoGameCharacter)isoZombie.target;
        if (isoGameCharacter2.isDead()) {
            if (isoGameCharacter2.getLeaveBodyTimedown() > 3600.0f) {
                isoZombie.changeState(ZombieIdleState.instance());
                isoZombie.setTarget(null);
            } else {
                isoGameCharacter2.setLeaveBodyTimedown(isoGameCharacter2.getLeaveBodyTimedown() + GameTime.getInstance().getMultiplier() / 1.6f);
                if (!GameServer.bServer && !Core.SoundDisabled && Rand.Next(Rand.AdjustForFramerate(15)) == 0) {
                    String string;
                    if (this.emitter == null) {
                        this.emitter = new FMODSoundEmitter();
                    }
                    String string2 = string = isoZombie.isFemale() ? "FemaleZombieEating" : "MaleZombieEating";
                    if (!this.emitter.isPlaying(string)) {
                        this.emitter.playSound(string);
                    }
                }
            }
            isoZombie.TimeSinceSeenFlesh = 0.0f;
            return;
        }
        BaseVehicle baseVehicle = isoGameCharacter2.getVehicle();
        if (baseVehicle == null || !baseVehicle.isCharacterAdjacentTo(isoGameCharacter)) {
            return;
        }
        Vector3f vector3f = baseVehicle.chooseBestAttackPosition(isoGameCharacter2, isoGameCharacter, this.worldPos);
        if (vector3f == null) {
            if (isoZombie.AllowRepathDelay <= 0.0f) {
                isoGameCharacter.pathToCharacter(isoGameCharacter2);
                isoZombie.AllowRepathDelay = 6.25f;
            }
            return;
        }
        if (vector3f != null && (Math.abs(vector3f.x - isoGameCharacter.x) > 0.1f || Math.abs(vector3f.y - isoGameCharacter.y) > 0.1f)) {
            if (Math.abs(baseVehicle.getCurrentSpeedKmHour()) > 0.8f && (baseVehicle.isCharacterAdjacentTo(isoGameCharacter) || baseVehicle.DistToSquared(isoGameCharacter) < 16.0f)) {
                return;
            }
            if (isoZombie.AllowRepathDelay <= 0.0f) {
                isoGameCharacter.pathToCharacter(isoGameCharacter2);
                isoZombie.AllowRepathDelay = 6.25f;
            }
            return;
        }
        isoGameCharacter.faceThisObject(isoGameCharacter2);
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (!(isoZombie.target instanceof IsoGameCharacter)) {
            return;
        }
        IsoGameCharacter isoGameCharacter2 = (IsoGameCharacter)isoZombie.target;
        BaseVehicle baseVehicle = isoGameCharacter2.getVehicle();
        if (baseVehicle == null) {
            return;
        }
        if (isoGameCharacter2.isDead()) {
            return;
        }
        if (animEvent.m_EventName.equalsIgnoreCase("AttackCollisionCheck")) {
            isoGameCharacter2.getBodyDamage().AddRandomDamageFromZombie(isoZombie, null);
            isoGameCharacter2.getBodyDamage().Update();
            if (isoGameCharacter2.isDead()) {
                if (isoGameCharacter2.isFemale()) {
                    isoZombie.getEmitter().playVocals("FemaleBeingEatenDeath");
                } else {
                    isoZombie.getEmitter().playVocals("MaleBeingEatenDeath");
                }
                isoGameCharacter2.setHealth(0.0f);
            } else if (isoGameCharacter2.isAsleep()) {
                if (GameServer.bServer) {
                    isoGameCharacter2.sendObjectChange("wakeUp");
                    isoGameCharacter2.setAsleep(false);
                } else {
                    isoGameCharacter2.forceAwake();
                }
            }
        } else if (animEvent.m_EventName.equalsIgnoreCase("ThumpFrame")) {
            VehicleWindow vehicleWindow = null;
            VehiclePart vehiclePart = null;
            int n = baseVehicle.getSeat(isoGameCharacter2);
            String string = baseVehicle.getPassengerArea(n);
            if (baseVehicle.isInArea(string, isoGameCharacter)) {
                VehiclePart vehiclePart2 = baseVehicle.getPassengerDoor(n);
                if (vehiclePart2 != null && vehiclePart2.getDoor() != null && vehiclePart2.getInventoryItem() != null && !vehiclePart2.getDoor().isOpen()) {
                    vehicleWindow = vehiclePart2.findWindow();
                    if (vehicleWindow != null && !vehicleWindow.isHittable()) {
                        vehicleWindow = null;
                    }
                    if (vehicleWindow == null) {
                        vehiclePart = vehiclePart2;
                    }
                }
            } else {
                vehiclePart = baseVehicle.getNearestBodyworkPart(isoGameCharacter);
                if (vehiclePart != null) {
                    vehicleWindow = vehiclePart.getWindow();
                    if (vehicleWindow == null) {
                        vehicleWindow = vehiclePart.findWindow();
                    }
                    if (vehicleWindow != null && !vehicleWindow.isHittable()) {
                        vehicleWindow = null;
                    }
                    if (vehicleWindow != null) {
                        vehiclePart = null;
                    }
                }
            }
            if (vehicleWindow != null) {
                vehicleWindow.damage(isoZombie.strength);
                baseVehicle.setBloodIntensity(vehicleWindow.part.getId(), baseVehicle.getBloodIntensity(vehicleWindow.part.getId()) + 0.025f);
                if (!GameServer.bServer) {
                    isoZombie.setVehicleHitLocation(baseVehicle);
                    isoGameCharacter.getEmitter().playSound("ZombieThumpVehicleWindow", baseVehicle);
                }
                isoZombie.setThumpFlag(3);
            } else {
                if (!GameServer.bServer) {
                    isoZombie.setVehicleHitLocation(baseVehicle);
                    isoGameCharacter.getEmitter().playSound("ZombieThumpVehicle", baseVehicle);
                }
                isoZombie.setThumpFlag(1);
            }
            baseVehicle.setAddThumpWorldSound(true);
            if (vehiclePart != null && vehiclePart.getWindow() == null && vehiclePart.getCondition() > 0) {
                vehiclePart.setCondition(vehiclePart.getCondition() - isoZombie.strength);
                vehiclePart.doInventoryItemStats(vehiclePart.getInventoryItem(), 0);
                baseVehicle.transmitPartCondition(vehiclePart);
            }
            if (isoGameCharacter2.isAsleep()) {
                if (GameServer.bServer) {
                    isoGameCharacter2.sendObjectChange("wakeUp");
                    isoGameCharacter2.setAsleep(false);
                } else {
                    isoGameCharacter2.forceAwake();
                }
            }
        }
    }

    @Override
    public boolean isAttacking(IsoGameCharacter isoGameCharacter) {
        return true;
    }

    public boolean isPassengerExposed(IsoGameCharacter isoGameCharacter) {
        if (!(isoGameCharacter instanceof IsoZombie)) {
            return false;
        }
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (!(isoZombie.target instanceof IsoGameCharacter)) {
            return false;
        }
        IsoGameCharacter isoGameCharacter2 = (IsoGameCharacter)isoZombie.target;
        BaseVehicle baseVehicle = isoGameCharacter2.getVehicle();
        if (baseVehicle == null) {
            return false;
        }
        boolean bl = false;
        VehicleWindow vehicleWindow = null;
        int n = baseVehicle.getSeat(isoGameCharacter2);
        String string = baseVehicle.getPassengerArea(n);
        VehiclePart vehiclePart = null;
        if (baseVehicle.isInArea(string, isoGameCharacter)) {
            vehiclePart = baseVehicle.getPassengerDoor(n);
            if (vehiclePart != null && vehiclePart.getDoor() != null) {
                if (vehiclePart.getInventoryItem() == null || vehiclePart.getDoor().isOpen()) {
                    bl = true;
                } else {
                    vehicleWindow = vehiclePart.findWindow();
                    if (vehicleWindow != null) {
                        if (!vehicleWindow.isHittable()) {
                            vehicleWindow = null;
                        }
                        bl = vehicleWindow == null;
                    } else {
                        bl = false;
                    }
                }
            }
        } else {
            vehiclePart = baseVehicle.getNearestBodyworkPart(isoGameCharacter);
            if (vehiclePart != null && (vehicleWindow = vehiclePart.findWindow()) != null && !vehicleWindow.isHittable()) {
                vehicleWindow = null;
            }
        }
        return bl;
    }
}

