/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.set;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import zombie.util.IntCollection;
import zombie.util.IntIterator;
import zombie.util.hash.DefaultIntHashFunction;
import zombie.util.hash.IntHashFunction;
import zombie.util.hash.Primes;
import zombie.util.set.AbstractIntSet;
import zombie.util.set.IntSet;
import zombie.util.util.Exceptions;

public class IntOpenHashSet
extends AbstractIntSet
implements IntSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private IntHashFunction keyhash;
    private int size;
    private transient int[] data;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;

    private IntOpenHashSet(IntHashFunction intHashFunction, int n, int n2, double d, int n3, double d2) {
        if (intHashFunction == null) {
            Exceptions.nullArgument("hash function");
        }
        if (n < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(n));
        }
        if (d <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(d));
        }
        if (n3 <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(n3));
        }
        if (d2 <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(d2));
        }
        this.keyhash = intHashFunction;
        n = Primes.nextPrime(n);
        this.data = new int[n];
        this.states = new byte[n];
        this.size = 0;
        this.expandAt = (int)Math.round(d2 * (double)n);
        this.used = 0;
        this.growthPolicy = n2;
        this.growthFactor = d;
        this.growthChunk = n3;
        this.loadFactor = d2;
    }

    private IntOpenHashSet(int n, int n2, double d, int n3, double d2) {
        this(DefaultIntHashFunction.INSTANCE, n, n2, d, n3, d2);
    }

    public IntOpenHashSet() {
        this(11);
    }

    public IntOpenHashSet(IntCollection intCollection) {
        this();
        this.addAll(intCollection);
    }

    public IntOpenHashSet(int[] nArray) {
        this();
        for (int n : nArray) {
            this.add(n);
        }
    }

    public IntOpenHashSet(int n) {
        this(n, 0, 1.0, 10, 0.75);
    }

    public IntOpenHashSet(double d) {
        this(11, 0, 1.0, 10, d);
    }

    public IntOpenHashSet(int n, double d) {
        this(n, 0, 1.0, 10, d);
    }

    public IntOpenHashSet(int n, double d, double d2) {
        this(n, 0, d2, 10, d);
    }

    public IntOpenHashSet(int n, double d, int n2) {
        this(n, 1, 1.0, n2, d);
    }

    public IntOpenHashSet(IntHashFunction intHashFunction) {
        this(intHashFunction, 11, 0, 1.0, 10, 0.75);
    }

    public IntOpenHashSet(IntHashFunction intHashFunction, int n) {
        this(intHashFunction, n, 0, 1.0, 10, 0.75);
    }

    public IntOpenHashSet(IntHashFunction intHashFunction, double d) {
        this(intHashFunction, 11, 0, 1.0, 10, d);
    }

    public IntOpenHashSet(IntHashFunction intHashFunction, int n, double d) {
        this(intHashFunction, n, 0, 1.0, 10, d);
    }

    public IntOpenHashSet(IntHashFunction intHashFunction, int n, double d, double d2) {
        this(intHashFunction, n, 0, d2, 10, d);
    }

    public IntOpenHashSet(IntHashFunction intHashFunction, int n, double d, int n2) {
        this(intHashFunction, n, 1, 1.0, n2, d);
    }

    private void ensureCapacity(int n) {
        if (n >= this.expandAt) {
            int n2 = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)n2 * this.loadFactor < (double)n) {
                n2 = (int)Math.round((double)n / this.loadFactor);
            }
            n2 = Primes.nextPrime(n2);
            this.expandAt = (int)Math.round(this.loadFactor * (double)n2);
            int[] nArray = new int[n2];
            byte[] byArray = new byte[n2];
            this.used = 0;
            for (int i = 0; i < this.data.length; ++i) {
                if (this.states[i] != 1) continue;
                ++this.used;
                int n3 = this.data[i];
                int n4 = Math.abs(this.keyhash.hash(n3));
                int n5 = n4 % n2;
                if (byArray[n5] == 1) {
                    int n6 = 1 + n4 % (n2 - 2);
                    do {
                        if ((n5 -= n6) >= 0) continue;
                        n5 += n2;
                    } while (byArray[n5] != 0);
                }
                byArray[n5] = 1;
                nArray[n5] = n3;
            }
            this.data = nArray;
            this.states = byArray;
        }
    }

    @Override
    public boolean add(int n) {
        int n2;
        block5: {
            this.ensureCapacity(this.used + 1);
            int n3 = Math.abs(this.keyhash.hash(n));
            n2 = n3 % this.data.length;
            if (this.states[n2] == 1) {
                if (this.data[n2] == n) {
                    return false;
                }
                int n4 = 1 + n3 % (this.data.length - 2);
                do {
                    if ((n2 -= n4) < 0) {
                        n2 += this.data.length;
                    }
                    if (this.states[n2] == 0 || this.states[n2] == 2) break block5;
                } while (this.states[n2] != 1 || this.data[n2] != n);
                return false;
            }
        }
        if (this.states[n2] == 0) {
            ++this.used;
        }
        this.states[n2] = 1;
        this.data[n2] = n;
        ++this.size;
        return true;
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            int nextEntry(int n) {
                while (n < IntOpenHashSet.this.data.length && IntOpenHashSet.this.states[n] != 1) {
                    ++n;
                }
                return n;
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry < IntOpenHashSet.this.data.length;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
                return IntOpenHashSet.this.data[this.lastEntry];
            }

            @Override
            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                IntOpenHashSet.this.states[this.lastEntry] = 2;
                --IntOpenHashSet.this.size;
                this.lastEntry = -1;
            }
        };
    }

    @Override
    public void trimToSize() {
    }

    public Object clone() {
        try {
            IntOpenHashSet intOpenHashSet = (IntOpenHashSet)super.clone();
            intOpenHashSet.data = new int[this.data.length];
            System.arraycopy(this.data, 0, intOpenHashSet.data, 0, this.data.length);
            intOpenHashSet.states = new byte[this.data.length];
            System.arraycopy(this.states, 0, intOpenHashSet.states, 0, this.states.length);
            return intOpenHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.used = 0;
        Arrays.fill(this.states, (byte)0);
    }

    @Override
    public boolean contains(int n) {
        int n2 = Math.abs(this.keyhash.hash(n));
        int n3 = n2 % this.data.length;
        if (this.states[n3] != 0) {
            if (this.states[n3] == 1 && this.data[n3] == n) {
                return true;
            }
            int n4 = 1 + n2 % (this.data.length - 2);
            do {
                if ((n3 -= n4) < 0) {
                    n3 += this.data.length;
                }
                if (this.states[n3] != 0) continue;
                return false;
            } while (this.states[n3] != 1 || this.data[n3] != n);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.states[i] != 1) continue;
            n += this.data[i];
        }
        return n;
    }

    @Override
    public boolean remove(int n) {
        int n2 = Math.abs(this.keyhash.hash(n));
        int n3 = n2 % this.data.length;
        if (this.states[n3] != 0) {
            if (this.states[n3] == 1 && this.data[n3] == n) {
                this.states[n3] = 2;
                --this.size;
                return true;
            }
            int n4 = 1 + n2 % (this.data.length - 2);
            do {
                if ((n3 -= n4) < 0) {
                    n3 += this.data.length;
                }
                if (this.states[n3] != 0) continue;
                return false;
            } while (this.states[n3] != 1 || this.data[n3] != n);
            this.states[n3] = 2;
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public int[] toArray(int[] nArray) {
        if (nArray == null || nArray.length < this.size) {
            nArray = new int[this.size];
        }
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.states[i] != 1) continue;
            nArray[n++] = this.data[i];
        }
        return nArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.data.length);
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            objectOutputStream.writeInt(n);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.data = new int[objectInputStream.readInt()];
        this.states = new byte[this.data.length];
        this.used = this.size;
        for (int i = 0; i < this.size; ++i) {
            int n = objectInputStream.readInt();
            int n2 = Math.abs(this.keyhash.hash(n));
            int n3 = n2 % this.data.length;
            if (this.states[n3] == 1) {
                int n4 = 1 + n2 % (this.data.length - 2);
                do {
                    if ((n3 -= n4) >= 0) continue;
                    n3 += this.data.length;
                } while (this.states[n3] != 0);
            }
            this.states[n3] = 1;
            this.data[n3] = n;
        }
    }
}

