/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.list;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import zombie.util.list.FloatConsumer;

public class PrimitiveFloatList
extends AbstractList<Float>
implements RandomAccess {
    private final float[] m_array;

    public PrimitiveFloatList(float[] fArray) {
        this.m_array = Objects.requireNonNull(fArray);
    }

    @Override
    public int size() {
        return this.m_array.length;
    }

    @Override
    public Object[] toArray() {
        return Arrays.asList(new float[][]{this.m_array}).toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.size();
        for (int i = 0; i < n && i < TArray.length; ++i) {
            Float f = Float.valueOf(this.m_array[i]);
            TArray[i] = f;
        }
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    @Override
    public Float get(int n) {
        return Float.valueOf(this.m_array[n]);
    }

    @Override
    public Float set(int n, Float f) {
        return Float.valueOf(this.set(n, f.floatValue()));
    }

    @Override
    public float set(int n, float f) {
        float f2 = this.m_array[n];
        this.m_array[n] = f;
        return f2;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            return -1;
        }
        if (object instanceof Number) {
            return this.indexOf(((Number)object).floatValue());
        }
        return -1;
    }

    public int indexOf(float f) {
        int n = -1;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.m_array[i] != f) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public boolean contains(float f) {
        return this.indexOf(f) != -1;
    }

    @Override
    public void forEach(Consumer<? super Float> consumer) {
        Objects.requireNonNull(consumer);
        this.forEach(consumer::accept);
    }

    public void forEach(FloatConsumer floatConsumer) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            floatConsumer.accept(this.m_array[i]);
        }
    }

    @Override
    public void replaceAll(UnaryOperator<Float> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        float[] fArray = this.m_array;
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Float)unaryOperator.apply(Float.valueOf(fArray[i]))).floatValue();
        }
    }

    @Override
    public void sort(Comparator<? super Float> comparator) {
        this.sort();
    }

    public void sort() {
        Arrays.sort(this.m_array);
    }
}

