/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.list;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class PZConvertArray<S, T>
extends AbstractList<T>
implements RandomAccess {
    private final S[] m_array;
    private final Function<S, T> m_converterST;
    private final Function<T, S> m_converterTS;

    public PZConvertArray(S[] SArray, Function<S, T> function) {
        this(SArray, function, null);
    }

    public PZConvertArray(S[] SArray, Function<S, T> function, Function<T, S> function2) {
        this.m_array = Objects.requireNonNull(SArray);
        this.m_converterST = function;
        this.m_converterTS = function2;
    }

    public boolean isReadonly() {
        return this.m_converterTS == null;
    }

    @Override
    public int size() {
        return this.m_array.length;
    }

    @Override
    public Object[] toArray() {
        return Arrays.asList(this.m_array).toArray();
    }

    @Override
    public <R> R[] toArray(R[] RArray) {
        int n = this.size();
        for (int i = 0; i < n && i < RArray.length; ++i) {
            T t = this.get(i);
            RArray[i] = t;
        }
        if (RArray.length > n) {
            RArray[n] = null;
        }
        return RArray;
    }

    @Override
    public T get(int n) {
        return this.convertST(this.m_array[n]);
    }

    @Override
    public T set(int n, T t) {
        T t2 = this.get(n);
        this.setS(n, this.convertTS(t));
        return t2;
    }

    public S setS(int n, S s) {
        S s2 = this.m_array[n];
        this.m_array[n] = s;
        return s2;
    }

    @Override
    public int indexOf(Object object) {
        int n = -1;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (!PZConvertArray.objectsEqual(object, this.get(i))) continue;
            n = i;
            break;
        }
        return n;
    }

    private static boolean objectsEqual(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    @Override
    public void replaceAll(UnaryOperator<T> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        S[] SArray = this.m_array;
        for (int i = 0; i < SArray.length; ++i) {
            T t = this.get(i);
            Object r = unaryOperator.apply(t);
            SArray[i] = this.convertTS(r);
        }
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        Arrays.sort(this.m_array, (object, object2) -> comparator.compare((T)this.convertST(object), (T)this.convertST(object2)));
    }

    private T convertST(S s) {
        return this.m_converterST.apply(s);
    }

    private S convertTS(T t) {
        return this.m_converterTS.apply(t);
    }
}

