/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.list;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.util.ICloner;
import zombie.util.Pool;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayList;
import zombie.util.list.PZConvertIterable;
import zombie.util.list.PZConvertList;
import zombie.util.list.PZEmptyIterable;
import zombie.util.list.PrimitiveFloatList;

public class PZArrayUtil {
    public static final int[] emptyIntArray = new int[0];
    public static final float[] emptyFloatArray = new float[0];

    public static <E> E pickRandom(E[] EArray) {
        if (EArray.length == 0) {
            return null;
        }
        int n = Rand.Next(EArray.length);
        return EArray[n];
    }

    public static <E> E pickRandom(List<E> list) {
        if (list.isEmpty()) {
            return null;
        }
        int n = Rand.Next(list.size());
        return list.get(n);
    }

    public static <E> E pickRandom(Collection<E> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        int n = Rand.Next(collection.size());
        return PZArrayUtil.getElementAt(collection, n);
    }

    public static <E> E pickRandom(Iterable<E> iterable) {
        int n = PZArrayUtil.getSize(iterable);
        if (n == 0) {
            return null;
        }
        int n2 = Rand.Next(n);
        return PZArrayUtil.getElementAt(iterable, n2);
    }

    public static <E> int getSize(Iterable<E> iterable) {
        int n = 0;
        Iterator<E> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public static <E> E getElementAt(Iterable<E> iterable, int n) throws ArrayIndexOutOfBoundsException {
        E e = null;
        Iterator<E> iterator = iterable.iterator();
        for (int i = 0; i <= n; ++i) {
            if (!iterator.hasNext()) {
                throw new ArrayIndexOutOfBoundsException(i);
            }
            if (i != n) continue;
            e = iterator.next();
        }
        return e;
    }

    public static <E> void copy(ArrayList<E> arrayList, ArrayList<E> arrayList2) {
        PZArrayUtil.copy(arrayList, arrayList2, object -> object);
    }

    public static <E> void copy(ArrayList<E> arrayList, ArrayList<E> arrayList2, ICloner<E> iCloner) {
        if (arrayList == arrayList2) {
            return;
        }
        arrayList.clear();
        arrayList.ensureCapacity(arrayList2.size());
        for (int i = 0; i < arrayList2.size(); ++i) {
            E e = arrayList2.get(i);
            arrayList.add(iCloner.clone(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> int indexOf(E[] EArray, Predicate<E> predicate) {
        try {
            int n;
            for (n = 0; n < EArray.length; ++n) {
                E e = EArray[n];
                if (!predicate.test(e)) continue;
                int n2 = n;
                return n2;
            }
            n = -1;
            return n;
        }
        finally {
            Pool.tryRelease(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> int indexOf(List<E> list, Predicate<E> predicate) {
        try {
            int n;
            int n2 = -1;
            for (n = 0; n < list.size(); ++n) {
                E e = list.get(n);
                if (!predicate.test(e)) continue;
                n2 = n;
                break;
            }
            n = n2;
            return n;
        }
        finally {
            Pool.tryRelease(predicate);
        }
    }

    public static <E> boolean contains(E[] EArray, Predicate<E> predicate) {
        return PZArrayUtil.indexOf(EArray, predicate) > -1;
    }

    public static <E> boolean contains(List<E> list, Predicate<E> predicate) {
        return PZArrayUtil.indexOf(list, predicate) > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> boolean contains(Collection<E> collection, Predicate<E> predicate) {
        if (collection instanceof List) {
            return PZArrayUtil.contains((List)collection, predicate);
        }
        try {
            boolean bl = false;
            for (E e : collection) {
                if (!predicate.test(e)) continue;
                bl = true;
                break;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            Pool.tryRelease(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> boolean contains(Iterable<E> iterable, Predicate<E> predicate) {
        if (iterable instanceof List) {
            return PZArrayUtil.indexOf((List)iterable, predicate) > -1;
        }
        try {
            boolean bl = false;
            for (E e : iterable) {
                if (!predicate.test(e)) continue;
                bl = true;
                break;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            Pool.tryRelease(predicate);
        }
    }

    public static <E> E find(List<E> list, Predicate<E> predicate) {
        int n = PZArrayUtil.indexOf(list, predicate);
        if (n > -1) {
            return list.get(n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E find(Iterable<E> iterable, Predicate<E> predicate) {
        if (iterable instanceof List) {
            return PZArrayUtil.find((List)iterable, predicate);
        }
        try {
            for (E e : iterable) {
                if (!predicate.test(e)) continue;
                E e2 = e;
                return e2;
            }
            Iterator<E> iterator = null;
            return (E)iterator;
        }
        finally {
            Pool.tryRelease(predicate);
        }
    }

    public static <E, S> List<E> listConvert(List<S> list, Function<S, E> function) {
        if (list.isEmpty()) {
            return PZArrayList.emptyList();
        }
        return new PZConvertList<S, E>(list, function);
    }

    public static <E, S> Iterable<E> itConvert(Iterable<S> iterable, Function<S, E> function) {
        return new PZConvertIterable<E, S>(iterable, function);
    }

    public static <E, S> List<E> listConvert(List<S> list, List<E> list2, Function<S, E> function) {
        list2.clear();
        for (int i = 0; i < list.size(); ++i) {
            list2.add(function.apply(list.get(i)));
        }
        return list2;
    }

    public static <E, S, T1> List<E> listConvert(List<S> list, List<E> list2, T1 T1, IListConverter1Param<S, E, T1> iListConverter1Param) {
        list2.clear();
        for (int i = 0; i < list.size(); ++i) {
            list2.add(iListConverter1Param.convert(list.get(i), T1));
        }
        return list2;
    }

    private static <E> List<E> asList(E[] EArray) {
        return Arrays.asList(EArray);
    }

    private static List<Float> asList(float[] fArray) {
        return new PrimitiveFloatList(fArray);
    }

    private static <E> Iterable<E> asSafeIterable(E[] EArray) {
        return EArray != null ? PZArrayUtil.asList(EArray) : PZEmptyIterable.getInstance();
    }

    private static Iterable<Float> asSafeIterable(float[] fArray) {
        return fArray != null ? PZArrayUtil.asList(fArray) : PZEmptyIterable.getInstance();
    }

    public static String arrayToString(float[] fArray) {
        return PZArrayUtil.arrayToString(PZArrayUtil.asSafeIterable(fArray));
    }

    public static String arrayToString(float[] fArray, String string, String string2, String string3) {
        return PZArrayUtil.arrayToString(PZArrayUtil.asSafeIterable(fArray), string, string2, string3);
    }

    public static <E> String arrayToString(E[] EArray) {
        return PZArrayUtil.arrayToString(PZArrayUtil.asSafeIterable(EArray));
    }

    public static <E> String arrayToString(E[] EArray, String string, String string2, String string3) {
        return PZArrayUtil.arrayToString(PZArrayUtil.asSafeIterable(EArray), string, string2, string3);
    }

    public static <E> String arrayToString(Iterable<E> iterable, Function<E, String> function) {
        return PZArrayUtil.arrayToString(iterable, function, "{", "}", System.lineSeparator());
    }

    public static <E> String arrayToString(Iterable<E> iterable) {
        return PZArrayUtil.arrayToString(iterable, String::valueOf, "{", "}", System.lineSeparator());
    }

    public static <E> String arrayToString(Iterable<E> iterable, String string, String string2, String string3) {
        return PZArrayUtil.arrayToString(iterable, String::valueOf, string, string2, string3);
    }

    public static <E> String arrayToString(Iterable<E> iterable, Function<E, String> function, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (iterable != null) {
            boolean bl = true;
            for (E e : iterable) {
                if (!bl) {
                    stringBuilder.append(string3);
                }
                String string4 = function.apply(e);
                stringBuilder.append(string4);
                bl = false;
            }
        }
        stringBuilder.append(string2);
        Pool.tryRelease(function);
        return stringBuilder.toString();
    }

    public static <E> E[] newInstance(Class<?> clazz, int n) {
        return (Object[])Array.newInstance(clazz, n);
    }

    public static <E> E[] newInstance(Class<?> clazz, int n, Supplier<E> supplier) {
        E[] EArray = PZArrayUtil.newInstance(clazz, n);
        int n2 = EArray.length;
        for (int i = 0; i < n2; ++i) {
            EArray[i] = supplier.get();
        }
        return EArray;
    }

    public static <E> E[] newInstance(Class<?> clazz, E[] EArray, int n) {
        return PZArrayUtil.newInstance(clazz, EArray, n, false, () -> null);
    }

    public static <E> E[] newInstance(Class<?> clazz, E[] EArray, int n, boolean bl) {
        return PZArrayUtil.newInstance(clazz, EArray, n, bl, () -> null);
    }

    public static <E> E[] newInstance(Class<?> clazz, E[] EArray, int n, Supplier<E> supplier) {
        return PZArrayUtil.newInstance(clazz, EArray, n, false, supplier);
    }

    public static <E> E[] newInstance(Class<?> clazz, E[] EArray, int n, boolean bl, Supplier<E> supplier) {
        int n2;
        if (EArray == null) {
            return PZArrayUtil.newInstance(clazz, n, supplier);
        }
        int n3 = EArray.length;
        if (n3 == n) {
            return EArray;
        }
        if (bl && n3 > n) {
            return EArray;
        }
        E[] EArray2 = PZArrayUtil.newInstance(clazz, n);
        PZArrayUtil.arrayCopy(EArray2, EArray, 0, PZMath.min(n, n3));
        if (n > n3) {
            for (n2 = n3; n2 < n; ++n2) {
                EArray2[n2] = supplier.get();
            }
        }
        if (n < n3) {
            for (n2 = n; n2 < n3; ++n2) {
                EArray[n2] = Pool.tryRelease(EArray[n2]);
            }
        }
        return EArray2;
    }

    public static float[] add(float[] fArray, float f) {
        float[] fArray2 = new float[fArray.length + 1];
        PZArrayUtil.arrayCopy(fArray2, fArray, 0, fArray.length);
        fArray2[fArray.length] = f;
        return fArray2;
    }

    public static <E> E[] add(E[] EArray, E e) {
        E[] EArray2 = PZArrayUtil.newInstance(EArray.getClass().getComponentType(), EArray.length + 1);
        PZArrayUtil.arrayCopy(EArray2, EArray, 0, EArray.length);
        EArray2[EArray.length] = e;
        return EArray2;
    }

    public static <E> E[] concat(E[] EArray, E[] EArray2) {
        boolean bl;
        boolean bl2 = EArray == null || EArray.length == 0;
        boolean bl3 = bl = EArray2 == null || EArray2.length == 0;
        if (bl2 && bl) {
            return null;
        }
        if (bl2) {
            return PZArrayUtil.clone(EArray2);
        }
        if (bl) {
            return EArray;
        }
        E[] EArray3 = PZArrayUtil.newInstance(EArray.getClass().getComponentType(), EArray.length + EArray2.length);
        PZArrayUtil.arrayCopy(EArray3, EArray, 0, EArray.length);
        PZArrayUtil.arrayCopy(EArray3, EArray2, EArray.length, EArray3.length);
        return EArray3;
    }

    public static <E, S extends E> E[] arrayCopy(E[] EArray, S[] SArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            EArray[i] = SArray[i];
        }
        return EArray;
    }

    public static float[] arrayCopy(float[] fArray, float[] fArray2, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            fArray[i] = fArray2[i];
        }
        return fArray;
    }

    public static int[] arrayCopy(int[] nArray, int[] nArray2, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            nArray[i] = nArray2[i];
        }
        return nArray;
    }

    public static <L extends List<E>, E> L arrayCopy(L l, List<? extends E> list) {
        l.clear();
        l.addAll(list);
        return l;
    }

    public static <E> E[] arrayCopy(E[] EArray, List<? extends E> list) {
        for (int i = 0; i < list.size(); ++i) {
            EArray[i] = list.get(i);
        }
        return EArray;
    }

    public static <E, S extends E> E[] arrayCopy(E[] EArray, S[] SArray) {
        System.arraycopy(SArray, 0, EArray, 0, SArray.length);
        return EArray;
    }

    public static <L extends List<E>, E, S> L arrayConvert(L l, List<S> list, Function<S, E> function) {
        l.clear();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            S s = list.get(i);
            l.add(function.apply(s));
        }
        return l;
    }

    public static float[] clone(float[] fArray) {
        if (PZArrayUtil.isNullOrEmpty(fArray)) {
            return fArray;
        }
        float[] fArray2 = new float[fArray.length];
        PZArrayUtil.arrayCopy(fArray2, fArray, 0, fArray.length);
        return fArray2;
    }

    public static <E> E[] clone(E[] EArray) {
        if (PZArrayUtil.isNullOrEmpty(EArray)) {
            return EArray;
        }
        E[] EArray2 = PZArrayUtil.newInstance(EArray.getClass().getComponentType(), EArray.length);
        PZArrayUtil.arrayCopy(EArray2, EArray, 0, EArray.length);
        return EArray2;
    }

    public static <E> boolean isNullOrEmpty(E[] EArray) {
        return EArray == null || EArray.length == 0;
    }

    public static boolean isNullOrEmpty(int[] nArray) {
        return nArray == null || nArray.length == 0;
    }

    public static boolean isNullOrEmpty(float[] fArray) {
        return fArray == null || fArray.length == 0;
    }

    public static <E> boolean isNullOrEmpty(List<E> list) {
        return list == null || list.isEmpty();
    }

    public static <E> boolean isNullOrEmpty(Iterable<E> iterable) {
        boolean bl;
        block1: {
            if (iterable instanceof List) {
                return PZArrayUtil.isNullOrEmpty((List)iterable);
            }
            bl = true;
            Iterator<E> iterator = iterable.iterator();
            if (!iterator.hasNext()) break block1;
            E e = iterator.next();
            bl = false;
        }
        return bl;
    }

    public static <E> E getOrDefault(List<E> list, int n) {
        return PZArrayUtil.getOrDefault(list, n, null);
    }

    public static <E> E getOrDefault(List<E> list, int n, E e) {
        if (n >= 0 && n < list.size()) {
            return list.get(n);
        }
        return e;
    }

    public static <E> E getOrDefault(E[] EArray, int n, E e) {
        if (EArray != null && n >= 0 && n < EArray.length) {
            return EArray[n];
        }
        return e;
    }

    public static float getOrDefault(float[] fArray, int n, float f) {
        if (fArray != null && n >= 0 && n < fArray.length) {
            return fArray[n];
        }
        return f;
    }

    public static int[] arraySet(int[] nArray, int n) {
        if (PZArrayUtil.isNullOrEmpty(nArray)) {
            return nArray;
        }
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
        return nArray;
    }

    public static float[] arraySet(float[] fArray, float f) {
        if (PZArrayUtil.isNullOrEmpty(fArray)) {
            return fArray;
        }
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray[i] = f;
        }
        return fArray;
    }

    public static <E> E[] arraySet(E[] EArray, E e) {
        if (PZArrayUtil.isNullOrEmpty(EArray)) {
            return EArray;
        }
        int n = EArray.length;
        for (int i = 0; i < n; ++i) {
            EArray[i] = e;
        }
        return EArray;
    }

    public static <E> E[] arrayPopulate(E[] EArray, Supplier<E> supplier) {
        if (PZArrayUtil.isNullOrEmpty(EArray)) {
            return EArray;
        }
        int n = EArray.length;
        for (int i = 0; i < n; ++i) {
            EArray[i] = supplier.get();
        }
        return EArray;
    }

    public static void insertAt(int[] nArray, int n, int n2) {
        for (int i = nArray.length - 1; i > n; --i) {
            nArray[i] = nArray[i - 1];
        }
        nArray[n] = n2;
    }

    public static void insertAt(float[] fArray, int n, float f) {
        for (int i = fArray.length - 1; i > n; --i) {
            fArray[i] = fArray[i - 1];
        }
        fArray[n] = f;
    }

    public static <E> E[] toArray(List<E> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        E[] EArray = PZArrayUtil.newInstance(list.get(0).getClass(), list.size());
        PZArrayUtil.arrayCopy(EArray, list);
        return EArray;
    }

    public static <E> int indexOf(E[] EArray, int n, E e) {
        for (int i = 0; i < n; ++i) {
            if (EArray[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] fArray, int n, float f) {
        for (int i = 0; i < n; ++i) {
            if (fArray[i] != f) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(float[] fArray, int n, float f) {
        return PZArrayUtil.indexOf(fArray, n, f) != -1;
    }

    public static int indexOf(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != n2) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int[] nArray, int n, int n2) {
        return PZArrayUtil.indexOf(nArray, n, n2) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> void forEach(List<E> list, Consumer<? super E> consumer) {
        try {
            if (list == null) {
                return;
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                E e = list.get(i);
                consumer.accept(e);
            }
        }
        finally {
            Pool.tryRelease(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> void forEach(Iterable<E> iterable, Consumer<? super E> consumer) {
        if (iterable == null) {
            Pool.tryRelease(consumer);
            return;
        }
        if (iterable instanceof List) {
            PZArrayUtil.forEach((List)iterable, consumer);
            return;
        }
        try {
            for (E e : iterable) {
                consumer.accept(e);
            }
        }
        finally {
            Pool.tryRelease(consumer);
        }
    }

    public static <E> void forEach(E[] EArray, Consumer<? super E> consumer) {
        if (PZArrayUtil.isNullOrEmpty(EArray)) {
            return;
        }
        int n = EArray.length;
        for (int i = 0; i < n; ++i) {
            consumer.accept(EArray[i]);
        }
    }

    public static <K, V> V getOrCreate(HashMap<K, V> hashMap, K k, Supplier<V> supplier) {
        V v = hashMap.get(k);
        if (v == null) {
            v = supplier.get();
            hashMap.put(k, v);
        }
        return v;
    }

    public static <E> void sort(Stack<E> stack, Comparator<E> comparator) {
        try {
            stack.sort(comparator);
        }
        finally {
            Pool.tryRelease(comparator);
        }
    }

    public static <E> boolean sequenceEqual(E[] EArray, List<? extends E> list) {
        return PZArrayUtil.sequenceEqual(EArray, list, Comparators::objectsEqual);
    }

    public static <E> boolean sequenceEqual(E[] EArray, List<? extends E> list, Comparator<E> comparator) {
        return EArray.length == list.size() && PZArrayUtil.sequenceEqual(PZArrayUtil.asList(EArray), list, comparator);
    }

    public static <E> boolean sequenceEqual(List<? extends E> list, List<? extends E> list2) {
        return PZArrayUtil.sequenceEqual(list, list2, Comparators::objectsEqual);
    }

    public static <E> boolean sequenceEqual(List<? extends E> list, List<? extends E> list2, Comparator<E> comparator) {
        if (list.size() != list2.size()) {
            return false;
        }
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            E e;
            E e2 = list.get(i);
            if (comparator.compare(e2, e = list2.get(i)) == 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static int[] arrayAdd(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            nArray[n] = nArray[n] + nArray2[i];
        }
        return nArray;
    }

    public static interface IListConverter1Param<S, E, T1> {
        public E convert(S var1, T1 var2);
    }

    public static class Comparators {
        public static <E> int referencesEqual(E e, E e2) {
            return e == e2 ? 0 : 1;
        }

        public static <E> int objectsEqual(E e, E e2) {
            return e != null && e.equals(e2) ? 0 : 1;
        }

        public static int equalsIgnoreCase(String string, String string2) {
            return StringUtils.equals(string, string2) ? 0 : 1;
        }
    }
}

