/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.list;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import zombie.util.IntCollection;
import zombie.util.hash.DefaultIntHashFunction;
import zombie.util.list.AbstractIntList;
import zombie.util.list.IntList;
import zombie.util.list.IntListIterator;
import zombie.util.util.Exceptions;

public class IntArrayList
extends AbstractIntList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 10;
    private transient int[] data;
    private int size;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;

    private IntArrayList(int n, int n2, double d, int n3) {
        if (n < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(n));
        }
        if (d < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(d));
        }
        if (n3 < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(n3));
        }
        this.data = new int[n];
        this.size = 0;
        this.growthPolicy = n2;
        this.growthFactor = d;
        this.growthChunk = n3;
    }

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(IntCollection intCollection) {
        this(intCollection.size());
        this.addAll(intCollection);
    }

    public IntArrayList(int[] nArray) {
        this(nArray.length);
        System.arraycopy(nArray, 0, this.data, 0, nArray.length);
        this.size = nArray.length;
    }

    public IntArrayList(int n) {
        this(n, 1.0);
    }

    public IntArrayList(int n, double d) {
        this(n, 0, d, 10);
    }

    public IntArrayList(int n, int n2) {
        this(n, 1, 1.0, n2);
    }

    private int computeCapacity(int n) {
        int n2 = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
        if (n2 < n) {
            n2 = n;
        }
        return n2;
    }

    public int ensureCapacity(int n) {
        if (n > this.data.length) {
            n = this.computeCapacity(n);
            int[] nArray = new int[n];
            System.arraycopy(this.data, 0, nArray, 0, this.size);
            this.data = nArray;
        }
        return n;
    }

    public int capacity() {
        return this.data.length;
    }

    @Override
    public void add(int n, int n2) {
        if (n < 0 || n > this.size) {
            Exceptions.indexOutOfBounds(n, 0, this.size);
        }
        this.ensureCapacity(this.size + 1);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.data, n, this.data, n + 1, n3);
        }
        this.data[n] = n2;
        ++this.size;
    }

    @Override
    public int get(int n) {
        if (n < 0 || n >= this.size) {
            Exceptions.indexOutOfBounds(n, 0, this.size - 1);
        }
        return this.data[n];
    }

    @Override
    public int set(int n, int n2) {
        if (n < 0 || n >= this.size) {
            Exceptions.indexOutOfBounds(n, 0, this.size - 1);
        }
        int n3 = this.data[n];
        this.data[n] = n2;
        return n3;
    }

    @Override
    public int removeElementAt(int n) {
        if (n < 0 || n >= this.size) {
            Exceptions.indexOutOfBounds(n, 0, this.size - 1);
        }
        int n2 = this.data[n];
        int n3 = this.size - (n + 1);
        if (n3 > 0) {
            System.arraycopy(this.data, n + 1, this.data, n, n3);
        }
        --this.size;
        return n2;
    }

    @Override
    public void trimToSize() {
        if (this.data.length > this.size) {
            int[] nArray = new int[this.size];
            System.arraycopy(this.data, 0, nArray, 0, this.size);
            this.data = nArray;
        }
    }

    public Object clone() {
        try {
            IntArrayList intArrayList = (IntArrayList)super.clone();
            intArrayList.data = new int[this.data.length];
            System.arraycopy(this.data, 0, intArrayList.data, 0, this.size);
            return intArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Exceptions.cloning();
            return null;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOf(int n, int n2) {
        if (n < 0 || n > this.size) {
            Exceptions.indexOutOfBounds(n, 0, this.size);
        }
        for (int i = n; i < this.size; ++i) {
            if (this.data[i] != n2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int n) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.data[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean remove(int n) {
        int n2 = this.indexOf(n);
        if (n2 != -1) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    @Override
    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        return nArray;
    }

    @Override
    public int[] toArray(int[] nArray) {
        if (nArray == null || nArray.length < this.size) {
            nArray = new int[this.size];
        }
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        return nArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntList)) {
            return false;
        }
        int n = 0;
        IntListIterator intListIterator = ((IntList)object).listIterator();
        while (n < this.size && intListIterator.hasNext()) {
            if (this.data[n++] == intListIterator.next()) continue;
            return false;
        }
        return n >= this.size && !intListIterator.hasNext();
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + DefaultIntHashFunction.INSTANCE.hash(this.data[i]);
        }
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.data.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeInt(this.data[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.data = new int[objectInputStream.readInt()];
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = objectInputStream.readInt();
        }
    }
}

