/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.list;

import zombie.util.AbstractIntCollection;
import zombie.util.IntCollection;
import zombie.util.IntIterator;
import zombie.util.hash.DefaultIntHashFunction;
import zombie.util.list.IntList;
import zombie.util.list.IntListIterator;
import zombie.util.util.Exceptions;

public abstract class AbstractIntList
extends AbstractIntCollection
implements IntList {
    protected AbstractIntList() {
    }

    @Override
    public boolean add(int n) {
        this.add(this.size(), n);
        return true;
    }

    @Override
    public void add(int n, int n2) {
        Exceptions.unsupported("add");
    }

    @Override
    public boolean addAll(int n, IntCollection intCollection) {
        if (n < 0 || n > this.size()) {
            Exceptions.indexOutOfBounds(n, 0, this.size());
        }
        IntIterator intIterator = intCollection.iterator();
        boolean bl = intIterator.hasNext();
        while (intIterator.hasNext()) {
            this.add(n, intIterator.next());
            ++n;
        }
        return bl;
    }

    @Override
    public int indexOf(int n) {
        return this.indexOf(0, n);
    }

    @Override
    public int indexOf(int n, int n2) {
        IntListIterator intListIterator = this.listIterator(n);
        while (intListIterator.hasNext()) {
            if (intListIterator.next() != n2) continue;
            return intListIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public IntIterator iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(int n) {
        IntListIterator intListIterator = this.listIterator(this.size());
        while (intListIterator.hasPrevious()) {
            if (intListIterator.previous() != n) continue;
            return intListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int n, int n2) {
        IntListIterator intListIterator = this.listIterator(n);
        while (intListIterator.hasPrevious()) {
            if (intListIterator.previous() != n2) continue;
            return intListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public IntListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public IntListIterator listIterator(final int n) {
        if (n < 0 || n > this.size()) {
            Exceptions.indexOutOfBounds(n, 0, this.size());
        }
        return new IntListIterator(){
            private int ptr;
            private int lptr;
            {
                this.ptr = n;
                this.lptr = -1;
            }

            @Override
            public boolean hasNext() {
                return this.ptr < AbstractIntList.this.size();
            }

            @Override
            public int next() {
                if (this.ptr == AbstractIntList.this.size()) {
                    Exceptions.endOfIterator();
                }
                this.lptr = this.ptr++;
                return AbstractIntList.this.get(this.lptr);
            }

            @Override
            public void remove() {
                if (this.lptr == -1) {
                    Exceptions.noElementToRemove();
                }
                AbstractIntList.this.removeElementAt(this.lptr);
                if (this.lptr < this.ptr) {
                    --this.ptr;
                }
                this.lptr = -1;
            }

            @Override
            public void add(int n2) {
                AbstractIntList.this.add(this.ptr++, n2);
                this.lptr = -1;
            }

            @Override
            public boolean hasPrevious() {
                return this.ptr > 0;
            }

            @Override
            public int nextIndex() {
                return this.ptr;
            }

            @Override
            public int previous() {
                if (this.ptr == 0) {
                    Exceptions.startOfIterator();
                }
                --this.ptr;
                this.lptr = this.ptr;
                return AbstractIntList.this.get(this.ptr);
            }

            @Override
            public int previousIndex() {
                return this.ptr - 1;
            }

            @Override
            public void set(int n2) {
                if (this.lptr == -1) {
                    Exceptions.noElementToSet();
                }
                AbstractIntList.this.set(this.lptr, n2);
            }
        };
    }

    @Override
    public int removeElementAt(int n) {
        Exceptions.unsupported("removeElementAt");
        throw new RuntimeException();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntList)) {
            return false;
        }
        IntListIterator intListIterator = this.listIterator();
        IntListIterator intListIterator2 = ((IntList)object).listIterator();
        while (intListIterator.hasNext() && intListIterator2.hasNext()) {
            if (intListIterator.next() == intListIterator2.next()) continue;
            return false;
        }
        return !intListIterator.hasNext() && !intListIterator2.hasNext();
    }

    @Override
    public int hashCode() {
        int n = 1;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            n = 31 * n + DefaultIntHashFunction.INSTANCE.hash(intIterator.next());
        }
        return n;
    }
}

