/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import zombie.core.Core;
import zombie.core.ThreadGroups;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.util.Lambda;

public final class PublicServerUtil {
    public static String webSite = "https://www.projectzomboid.com/server_browser/";
    private static long timestampForUpdate = 0L;
    private static long timestampForPlayerUpdate = 0L;
    private static long updateTick = 600000L;
    private static long updatePlayerTick = 300000L;
    private static int sentPlayerCount = 0;
    private static boolean isEnabled = false;

    public static void init() {
        isEnabled = false;
        if (!DebugOptions.instance.Network.PublicServerUtil.Enabled.getValue()) {
            return;
        }
        try {
            String[] stringArray;
            if (GameServer.bServer) {
                ServerOptions.instance.changeOption("PublicName", PublicServerUtil.checkHacking(ServerOptions.instance.getOption("PublicName")));
                ServerOptions.instance.changeOption("PublicDescription", PublicServerUtil.checkHacking(ServerOptions.instance.getOption("PublicDescription")));
            }
            if (GameServer.bServer && !PublicServerUtil.isPublic()) {
                return;
            }
            DebugLog.log("connecting to public server list");
            URL uRL = new URL(webSite + "serverVar.php");
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(3000);
            uRLConnection.connect();
            InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append('\n');
            }
            bufferedReader.close();
            for (String string2 : stringArray = stringBuilder.toString().split("<br>")) {
                if (string2.contains("allowed") && string2.contains("true")) {
                    isEnabled = true;
                }
                if (string2.contains("updateTick")) {
                    updateTick = Long.parseLong(string2.split("=")[1].trim());
                }
                if (string2.contains("updatePlayerTick")) {
                    updatePlayerTick = Long.parseLong(string2.split("=")[1].trim());
                }
                if (!string2.contains("ip") || !(GameServer.ip = string2.split("=")[1].trim()).contains(":")) continue;
                DebugLog.log("The IP address (" + GameServer.ip + ") looks like the IPv6 address. Please make sure IPv4 server address is set to the " + ServerOptions.getInstance().server_browser_announced_ip.getName() + " server option.");
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            isEnabled = false;
            DebugLog.log("timeout trying to connect to public server list");
        }
        catch (Exception exception) {
            isEnabled = false;
            exception.printStackTrace();
        }
    }

    private static String checkHacking(String string) {
        if (string == null) {
            return "";
        }
        return string.replaceAll("--", "").replaceAll("->", "").replaceAll("(?i)select union", "").replaceAll("(?i)select join", "").replaceAll("1=1", "").replaceAll("(?i)delete from", "");
    }

    public static void insertOrUpdate() {
        if (!isEnabled) {
            return;
        }
        if (PublicServerUtil.isPublic()) {
            try {
                PublicServerUtil.insertDatas();
            }
            catch (Exception exception) {
                System.out.println("Can't reach PZ.com");
            }
        }
    }

    private static boolean isPublic() {
        String string = PublicServerUtil.checkHacking(ServerOptions.instance.PublicName.getValue());
        return ServerOptions.instance.Public.getValue() && !string.isEmpty();
    }

    public static void update() {
        if (System.currentTimeMillis() - timestampForUpdate > updateTick) {
            timestampForUpdate = System.currentTimeMillis();
            PublicServerUtil.init();
            if (!isEnabled) {
                return;
            }
            if (PublicServerUtil.isPublic()) {
                try {
                    PublicServerUtil.insertDatas();
                }
                catch (Exception exception) {
                    System.out.println("Can't reach PZ.com");
                }
            }
        }
    }

    private static void insertDatas() throws Exception {
        if (!isEnabled) {
            return;
        }
        Object object = "";
        if (!ServerOptions.instance.PublicDescription.getValue().isEmpty()) {
            object = "&desc=" + ServerOptions.instance.PublicDescription.getValue().replaceAll(" ", "%20");
        }
        Object object2 = "";
        for (String string : GameServer.ServerMods) {
            object2 = (String)object2 + string + ",";
        }
        if (!"".equals(object2)) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            object2 = "&mods=" + ((String)object2).replaceAll(" ", "%20");
        }
        Object object3 = GameServer.ip;
        if (!ServerOptions.instance.server_browser_announced_ip.getValue().isEmpty()) {
            object3 = ServerOptions.instance.server_browser_announced_ip.getValue();
        }
        timestampForUpdate = System.currentTimeMillis();
        int n = GameServer.getPlayerCount();
        PublicServerUtil.callUrl(webSite + "write.php?name=" + ServerOptions.instance.PublicName.getValue().replaceAll(" ", "%20") + (String)object + "&port=" + ServerOptions.instance.DefaultPort.getValue() + "&UDPPort=" + ServerOptions.instance.UDPPort.getValue() + "&players=" + n + "&ip=" + (String)object3 + "&open=" + (ServerOptions.instance.Open.getValue() ? "1" : "0") + "&password=" + ("".equals(ServerOptions.instance.Password.getValue()) ? "0" : "1") + "&maxPlayers=" + ServerOptions.getInstance().getMaxPlayers() + "&version=" + Core.getInstance().getVersion().replaceAll(" ", "%20") + (String)object2 + "&mac=" + PublicServerUtil.getMacAddress());
        sentPlayerCount = n;
    }

    public static void updatePlayers() {
        if (System.currentTimeMillis() - timestampForPlayerUpdate > updatePlayerTick) {
            timestampForPlayerUpdate = System.currentTimeMillis();
            if (!isEnabled) {
                return;
            }
            try {
                String string = GameServer.ip;
                if (!ServerOptions.instance.server_browser_announced_ip.getValue().isEmpty()) {
                    string = ServerOptions.instance.server_browser_announced_ip.getValue();
                }
                int n = GameServer.getPlayerCount();
                PublicServerUtil.callUrl(webSite + "updatePlayers.php?port=" + ServerOptions.instance.DefaultPort.getValue() + "&players=" + n + "&ip=" + string);
                sentPlayerCount = GameServer.getPlayerCount();
            }
            catch (Exception exception) {
                System.out.println("Can't reach PZ.com");
            }
        }
    }

    public static void updatePlayerCountIfChanged() {
        if (isEnabled && sentPlayerCount != GameServer.getPlayerCount()) {
            PublicServerUtil.updatePlayers();
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    private static String getMacAddress() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (networkInterface != null) {
                byte[] byArray = networkInterface.getHardwareAddress();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuilder.append(String.format("%02X%s", byArray[i], i < byArray.length - 1 ? "-" : ""));
                }
                return stringBuilder.toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    private static void callUrl(String string2) {
        new Thread(ThreadGroups.Workers, Lambda.invoker(string2, string -> {
            try {
                URL uRL = new URL((String)string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.getInputStream();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }), "openUrl").start();
    }
}

