/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import zombie.ZomboidFileSystem;
import zombie.core.logger.ExceptionLogger;
import zombie.util.PZXmlParserException;
import zombie.util.StringUtils;

public final class PZXmlUtil {
    private static boolean s_debugLogging = false;
    private static final ThreadLocal<DocumentBuilder> documentBuilders = ThreadLocal.withInitial(() -> {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ExceptionLogger.logException(parserConfigurationException);
            throw new RuntimeException(parserConfigurationException);
        }
    });

    public static Element parseXml(String string) throws PZXmlParserException {
        Element element;
        String string2 = ZomboidFileSystem.instance.resolveFileOrGUID(string);
        try {
            element = PZXmlUtil.parseXmlInternal(string2);
        }
        catch (IOException | SAXException exception) {
            throw new PZXmlParserException("Exception thrown while parsing XML file \"" + string2 + "\"", exception);
        }
        element = PZXmlUtil.includeAnotherFile(element, string2);
        String string3 = element.getAttribute("x_extends");
        if (string3 == null || string3.trim().length() == 0) {
            return element;
        }
        if (!ZomboidFileSystem.instance.isValidFilePathGuid(string3)) {
            string3 = ZomboidFileSystem.instance.resolveRelativePath(string2, string3);
        }
        Element element2 = PZXmlUtil.parseXml(string3);
        Element element3 = PZXmlUtil.resolve(element, element2);
        return element3;
    }

    private static Element includeAnotherFile(Element element, String string) throws PZXmlParserException {
        Element element2;
        String string2 = element.getAttribute("x_include");
        if (string2 == null || string2.trim().length() == 0) {
            return element;
        }
        if (!ZomboidFileSystem.instance.isValidFilePathGuid(string2)) {
            string2 = ZomboidFileSystem.instance.resolveRelativePath(string, string2);
        }
        if (!(element2 = PZXmlUtil.parseXml(string2)).getTagName().equals(element.getTagName())) {
            return element;
        }
        Document document = PZXmlUtil.createNewDocument();
        Node node = document.importNode(element, true);
        Node node2 = node.getFirstChild();
        for (Node node3 = element2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            if (!(node3 instanceof Element)) continue;
            Element element3 = (Element)document.importNode(node3, true);
            node.insertBefore(element3, node2);
        }
        node.normalize();
        return (Element)node;
    }

    private static Element resolve(Element element, Element element2) {
        Document document = PZXmlUtil.createNewDocument();
        Element element3 = PZXmlUtil.resolve(element, element2, document);
        document.appendChild(element3);
        if (s_debugLogging) {
            System.out.println("PZXmlUtil.resolve> \r\n<Parent>\r\n" + PZXmlUtil.elementToPrettyStringSafe(element2) + "\r\n</Parent>\r\n<Child>\r\n" + PZXmlUtil.elementToPrettyStringSafe(element) + "\r\n</Child>\r\n<Resolved>\r\n" + PZXmlUtil.elementToPrettyStringSafe(element3) + "\r\n</Resolved>");
        }
        return element3;
    }

    private static Element resolve(Element element, Element element2, Document document) {
        int n;
        int n2;
        Object object;
        Object object22;
        if (PZXmlUtil.isTextOnly(element)) {
            Element element3 = (Element)document.importNode(element, true);
            return element3;
        }
        Element element4 = document.createElement(element.getTagName());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object3 = element2.getAttributes();
        for (int i = 0; i < object3.getLength(); ++i) {
            Node node = object3.item(i);
            if (!(node instanceof Attr)) {
                if (!s_debugLogging) continue;
                System.out.println("PZXmlUtil.resolve> Skipping parent.attrib: " + node);
                continue;
            }
            object22 = (Attr)document.importNode(node, true);
            arrayList.add(object22);
        }
        Object object4 = element.getAttributes();
        for (int i = 0; i < object4.getLength(); ++i) {
            object22 = object4.item(i);
            if (!(object22 instanceof Attr)) {
                if (!s_debugLogging) continue;
                System.out.println("PZXmlUtil.resolve> Skipping attrib: " + (Node)object22);
                continue;
            }
            object = (Attr)document.importNode((Node)object22, true);
            String string = object.getName();
            n2 = 1;
            for (n = 0; n < arrayList.size(); ++n) {
                Attr attr = (Attr)arrayList.get(n);
                String string2 = attr.getName();
                if (!string2.equals(string)) continue;
                arrayList.set(n, object);
                n2 = 0;
                break;
            }
            if (n2 == 0) continue;
            arrayList.add(object);
        }
        Object object5 = arrayList.iterator();
        while (object5.hasNext()) {
            object22 = (Attr)object5.next();
            element4.setAttributeNode((Attr)object22);
        }
        arrayList = new ArrayList();
        object3 = new HashMap();
        for (object4 = element2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
            if (!(object4 instanceof Element)) {
                if (!s_debugLogging) continue;
                System.out.println("PZXmlUtil.resolve> Skipping parent.node: " + object4);
                continue;
            }
            object5 = (Element)document.importNode((Node)object4, true);
            object22 = object5.getTagName();
            ((HashMap)object3).put(object22, 1 + ((HashMap)object3).getOrDefault(object22, 0));
            arrayList.add(object5);
        }
        object4 = new HashMap();
        block5: for (object5 = element.getFirstChild(); object5 != null; object5 = object5.getNextSibling()) {
            if (!(object5 instanceof Element)) {
                if (!s_debugLogging) continue;
                System.out.println("PZXmlUtil.resolve> Skipping node: " + object5);
                continue;
            }
            object22 = (Element)document.importNode((Node)object5, true);
            object = object22.getTagName();
            int n3 = ((HashMap)object4).getOrDefault(object, 0);
            n2 = 1 + n3;
            ((HashMap)object4).put(object, n2);
            n = ((HashMap)object3).getOrDefault(object, 0);
            if (n < n2) {
                arrayList.add(object22);
                continue;
            }
            int n4 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                Element element5 = (Element)arrayList.get(i);
                String string = element5.getTagName();
                if (!string.equals(object)) continue;
                if (n4 != n3) {
                    ++n4;
                    continue;
                }
                Element element6 = PZXmlUtil.resolve((Element)object22, element5, document);
                arrayList.set(i, element6);
                continue block5;
            }
        }
        for (Object object22 : arrayList) {
            element4.appendChild((Node)object22);
        }
        return element4;
    }

    private static boolean isTextOnly(Element element) {
        boolean bl = false;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            boolean bl2 = false;
            if (node instanceof Text) {
                String string = node.getTextContent();
                boolean bl3 = StringUtils.isNullOrWhitespace(string);
                boolean bl4 = bl2 = !bl3;
            }
            if (!bl2) {
                bl = false;
                break;
            }
            bl = true;
        }
        return bl;
    }

    private static String elementToPrettyStringSafe(Element element) {
        try {
            return PZXmlUtil.elementToPrettyString(element);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    private static String elementToPrettyString(Element element) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult streamResult = new StreamResult(new StringWriter());
        DOMSource dOMSource = new DOMSource(element);
        transformer.transform(dOMSource, streamResult);
        String string = streamResult.getWriter().toString();
        return string;
    }

    public static Document createNewDocument() {
        DocumentBuilder documentBuilder = documentBuilders.get();
        Document document = documentBuilder.newDocument();
        return document;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Element parseXmlInternal(String string) throws SAXException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            Element element;
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                DocumentBuilder documentBuilder = documentBuilders.get();
                Document document = documentBuilder.parse(bufferedInputStream);
                bufferedInputStream.close();
                Element element2 = document.getDocumentElement();
                element2.normalize();
                element = element2;
            }
            return element;
        }
        catch (SAXException sAXException) {
            System.err.println("Exception parsing filename: " + string);
            throw sAXException;
        }
    }

    public static void forEachElement(Element element, Consumer<Element> consumer) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            consumer.accept((Element)node);
        }
    }

    public static <T> T parse(Class<T> clazz, String string) throws PZXmlParserException {
        Element element = PZXmlUtil.parseXml(string);
        try {
            Unmarshaller unmarshaller = UnmarshallerAllocator.get(clazz);
            Object object = unmarshaller.unmarshal((Node)element);
            return (T)object;
        }
        catch (JAXBException jAXBException) {
            throw new PZXmlParserException("Exception thrown loading source: \"" + string + "\". Loading for type \"" + clazz + "\"", jAXBException);
        }
    }

    public static <T> void write(T t, File file) throws TransformerException, IOException, JAXBException {
        Document document = PZXmlUtil.createNewDocument();
        Marshaller marshaller = MarshallerAllocator.get(t);
        marshaller.marshal(t, (Node)document);
        PZXmlUtil.write(document, file);
    }

    public static void write(Document document, File file) throws TransformerException, IOException {
        Element element = document.getDocumentElement();
        String string = PZXmlUtil.elementToPrettyString(element);
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.write(string);
        printWriter.flush();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static <T> boolean tryWrite(T t, File file) {
        try {
            PZXmlUtil.write(t, file);
            return true;
        }
        catch (IOException | JAXBException | TransformerException throwable) {
            ExceptionLogger.logException(throwable, "Exception thrown writing data: \"" + t + "\". Out file: \"" + file + "\"");
            return false;
        }
    }

    public static boolean tryWrite(Document document, File file) {
        try {
            PZXmlUtil.write(document, file);
            return true;
        }
        catch (IOException | TransformerException exception) {
            ExceptionLogger.logException(exception, "Exception thrown writing document: \"" + document + "\". Out file: \"" + file + "\"");
            return false;
        }
    }

    private static final class UnmarshallerAllocator {
        private static final ThreadLocal<UnmarshallerAllocator> instance = ThreadLocal.withInitial(UnmarshallerAllocator::new);
        private final Map<Class, Unmarshaller> m_map = new HashMap<Class, Unmarshaller>();

        private UnmarshallerAllocator() {
        }

        public static <T> Unmarshaller get(Class<T> clazz) throws JAXBException {
            return instance.get().getOrCreate(clazz);
        }

        private <T> Unmarshaller getOrCreate(Class<T> clazz) throws JAXBException {
            Unmarshaller unmarshaller = this.m_map.get(clazz);
            if (unmarshaller == null) {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                unmarshaller = jAXBContext.createUnmarshaller();
                unmarshaller.setListener(new Unmarshaller.Listener(){

                    public void beforeUnmarshal(Object object, Object object2) {
                        super.beforeUnmarshal(object, object2);
                    }
                });
                this.m_map.put(clazz, unmarshaller);
            }
            return unmarshaller;
        }
    }

    private static final class MarshallerAllocator {
        private static final ThreadLocal<MarshallerAllocator> instance = ThreadLocal.withInitial(MarshallerAllocator::new);
        private final Map<Class<?>, Marshaller> m_map = new HashMap();

        private MarshallerAllocator() {
        }

        public static <T> Marshaller get(T t) throws JAXBException {
            return MarshallerAllocator.get(t.getClass());
        }

        public static <T> Marshaller get(Class<T> clazz) throws JAXBException {
            return instance.get().getOrCreate(clazz);
        }

        private <T> Marshaller getOrCreate(Class<T> clazz) throws JAXBException {
            Marshaller marshaller = this.m_map.get(clazz);
            if (marshaller == null) {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                marshaller = jAXBContext.createMarshaller();
                marshaller.setListener(new Marshaller.Listener(){

                    public void beforeMarshal(Object object) {
                        super.beforeMarshal(object);
                    }
                });
                this.m_map.put(clazz, marshaller);
            }
            return marshaller;
        }
    }
}

