/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

public class ExecuteTimeAnalyse {
    String caption;
    TimeStamp[] list;
    int listIndex = 0;

    public ExecuteTimeAnalyse(String string, int n) {
        this.caption = string;
        this.list = new TimeStamp[n];
        for (int i = 0; i < n; ++i) {
            this.list[i] = new TimeStamp();
        }
    }

    public void reset() {
        this.listIndex = 0;
    }

    public void add(String string) {
        this.list[this.listIndex].time = System.nanoTime();
        this.list[this.listIndex].comment = string;
        ++this.listIndex;
    }

    public long getNanoTime() {
        if (this.listIndex == 0) {
            return 0L;
        }
        return System.nanoTime() - this.list[0].time;
    }

    public int getMsTime() {
        if (this.listIndex == 0) {
            return 0;
        }
        return (int)((System.nanoTime() - this.list[0].time) / 1000000L);
    }

    public void print() {
        long l = this.list[0].time;
        System.out.println("========== START === " + this.caption + " =============");
        for (int i = 1; i < this.listIndex; ++i) {
            System.out.println(i + " " + this.list[i].comment + ": " + (this.list[i].time - l) / 1000000L);
            l = this.list[i].time;
        }
        System.out.println("END: " + (System.nanoTime() - this.list[0].time) / 1000000L);
        System.out.println("==========  END  === " + this.caption + " =============");
    }

    static class TimeStamp {
        long time;
        String comment;

        public TimeStamp(String string) {
            this.comment = string;
            this.time = System.nanoTime();
        }

        public TimeStamp() {
        }
    }
}

