/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer wrappedBuffer;
    private final boolean autoEnlarge;

    public ByteBufferOutputStream(ByteBuffer byteBuffer, boolean bl) {
        this.wrappedBuffer = byteBuffer;
        this.autoEnlarge = bl;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer = this.wrappedBuffer.duplicate();
        byteBuffer.flip();
        return byteBuffer.asReadOnlyBuffer();
    }

    public ByteBuffer getWrappedBuffer() {
        return this.wrappedBuffer;
    }

    public void clear() {
        this.wrappedBuffer.clear();
    }

    public void flip() {
        this.wrappedBuffer.flip();
    }

    private void growTo(int n) {
        int n2 = this.wrappedBuffer.capacity();
        int n3 = n2 << 1;
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 < 0) {
            if (n < 0) {
                throw new OutOfMemoryError();
            }
            n3 = Integer.MAX_VALUE;
        }
        ByteBuffer byteBuffer = this.wrappedBuffer;
        this.wrappedBuffer = this.wrappedBuffer.isDirect() ? ByteBuffer.allocateDirect(n3) : ByteBuffer.allocate(n3);
        byteBuffer.flip();
        this.wrappedBuffer.put(byteBuffer);
    }

    @Override
    public void write(int n) {
        try {
            this.wrappedBuffer.put((byte)n);
        }
        catch (BufferOverflowException bufferOverflowException) {
            if (this.autoEnlarge) {
                int n2 = this.wrappedBuffer.capacity() * 2;
                this.growTo(n2);
                this.write(n);
            }
            throw bufferOverflowException;
        }
    }

    @Override
    public void write(byte[] byArray) {
        int n = 0;
        try {
            n = this.wrappedBuffer.position();
            this.wrappedBuffer.put(byArray);
        }
        catch (BufferOverflowException bufferOverflowException) {
            if (this.autoEnlarge) {
                int n2 = Math.max(this.wrappedBuffer.capacity() * 2, n + byArray.length);
                this.growTo(n2);
                this.write(byArray);
            }
            throw bufferOverflowException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            n3 = this.wrappedBuffer.position();
            this.wrappedBuffer.put(byArray, n, n2);
        }
        catch (BufferOverflowException bufferOverflowException) {
            if (this.autoEnlarge) {
                int n4 = Math.max(this.wrappedBuffer.capacity() * 2, n3 + n2);
                this.growTo(n4);
                this.write(byArray, n, n2);
            }
            throw bufferOverflowException;
        }
    }
}

