/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import zombie.Lua.LuaEventManager;
import zombie.SoundManager;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.physics.WorldSimulation;
import zombie.debug.DebugLog;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.LightingJNI;
import zombie.iso.LosUtil;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.popman.ZombiePopulationManager;
import zombie.ui.UIManager;

public final class AddCoopPlayer {
    private Stage stage = Stage.Init;
    private IsoPlayer player;

    public AddCoopPlayer(IsoPlayer isoPlayer) {
        this.player = isoPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        switch (this.stage) {
            case Init: {
                if (GameClient.bClient) {
                    ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
                    PacketTypes.PacketType.AddCoopPlayer.doPacket(byteBufferWriter);
                    byteBufferWriter.putByte((byte)1);
                    byteBufferWriter.putByte((byte)this.player.PlayerIndex);
                    byteBufferWriter.putUTF(this.player.username != null ? this.player.username : "");
                    byteBufferWriter.putFloat(this.player.x);
                    byteBufferWriter.putFloat(this.player.y);
                    PacketTypes.PacketType.AddCoopPlayer.send(GameClient.connection);
                    this.stage = Stage.ReceiveClientConnect;
                    break;
                }
                this.stage = Stage.StartMapLoading;
                break;
            }
            case ReceiveClientConnect: {
                break;
            }
            case StartMapLoading: {
                IsoCell isoCell = IsoWorld.instance.CurrentCell;
                int n = this.player.PlayerIndex;
                IsoChunkMap isoChunkMap = isoCell.ChunkMap[n];
                IsoChunkMap.bSettingChunk.lock();
                try {
                    isoChunkMap.Unload();
                    isoChunkMap.ignore = false;
                    int n2 = (int)(this.player.x / 10.0f);
                    int n3 = (int)(this.player.y / 10.0f);
                    try {
                        if (LightingJNI.init) {
                            LightingJNI.teleport(n, n2 - IsoChunkMap.ChunkGridWidth / 2, n3 - IsoChunkMap.ChunkGridWidth / 2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!GameServer.bServer && !GameClient.bClient) {
                        ZombiePopulationManager.instance.playerSpawnedAt((int)this.player.x, (int)this.player.y, (int)this.player.z);
                    }
                    isoChunkMap.WorldX = n2;
                    isoChunkMap.WorldY = n3;
                    if (!GameServer.bServer) {
                        WorldSimulation.instance.activateChunkMap(n);
                    }
                    int n4 = n2 - IsoChunkMap.ChunkGridWidth / 2;
                    int n5 = n3 - IsoChunkMap.ChunkGridWidth / 2;
                    int n6 = n2 + IsoChunkMap.ChunkGridWidth / 2 + 1;
                    int n7 = n3 + IsoChunkMap.ChunkGridWidth / 2 + 1;
                    for (int i = n4; i < n6; ++i) {
                        for (int j = n5; j < n7; ++j) {
                            IsoChunk isoChunk;
                            if (!IsoWorld.instance.getMetaGrid().isValidChunk(i, j) || (isoChunk = isoChunkMap.LoadChunkForLater(i, j, i - n4, j - n5)) == null || !isoChunk.bLoaded) continue;
                            isoCell.setCacheChunk(isoChunk, n);
                        }
                    }
                    isoChunkMap.SwapChunkBuffers();
                }
                finally {
                    IsoChunkMap.bSettingChunk.unlock();
                }
                this.stage = Stage.CheckMapLoading;
                break;
            }
            case CheckMapLoading: {
                IsoCell isoCell = IsoWorld.instance.CurrentCell;
                IsoChunkMap isoChunkMap = isoCell.ChunkMap[this.player.PlayerIndex];
                isoChunkMap.update();
                for (int i = 0; i < IsoChunkMap.ChunkGridWidth; ++i) {
                    for (int j = 0; j < IsoChunkMap.ChunkGridWidth; ++j) {
                        if (!IsoWorld.instance.getMetaGrid().isValidChunk(isoChunkMap.getWorldXMin() + j, isoChunkMap.getWorldYMin() + i) || isoChunkMap.getChunk(j, i) != null) continue;
                        return;
                    }
                }
                IsoGridSquare isoGridSquare = isoCell.getGridSquare((int)this.player.x, (int)this.player.y, (int)this.player.z);
                if (isoGridSquare != null && isoGridSquare.getRoom() != null) {
                    isoGridSquare.getRoom().def.setExplored(true);
                    isoGridSquare.getRoom().building.setAllExplored(true);
                }
                this.stage = GameClient.bClient ? Stage.SendPlayerConnect : Stage.AddToWorld;
                break;
            }
            case SendPlayerConnect: {
                ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
                PacketTypes.PacketType.AddCoopPlayer.doPacket(byteBufferWriter);
                byteBufferWriter.putByte((byte)2);
                byteBufferWriter.putByte((byte)this.player.PlayerIndex);
                GameClient.instance.writePlayerConnectData(byteBufferWriter, this.player);
                PacketTypes.PacketType.AddCoopPlayer.send(GameClient.connection);
                this.stage = Stage.ReceivePlayerConnect;
                break;
            }
            case ReceivePlayerConnect: {
                break;
            }
            case AddToWorld: {
                IsoPlayer.players[this.player.PlayerIndex] = this.player;
                LosUtil.cachecleared[this.player.PlayerIndex] = true;
                this.player.updateLightInfo();
                IsoCell isoCell = IsoWorld.instance.CurrentCell;
                this.player.setCurrent(isoCell.getGridSquare((int)this.player.x, (int)this.player.y, (int)this.player.z));
                this.player.updateUsername();
                this.player.setSceneCulled(false);
                if (isoCell.isSafeToAdd()) {
                    isoCell.getObjectList().add(this.player);
                } else {
                    isoCell.getAddList().add(this.player);
                }
                this.player.getInventory().addItemsToProcessItems();
                LuaEventManager.triggerEvent("OnCreatePlayer", this.player.PlayerIndex, this.player);
                if (this.player.isAsleep()) {
                    UIManager.setFadeBeforeUI(this.player.PlayerIndex, true);
                    UIManager.FadeOut(this.player.PlayerIndex, 2.0);
                    UIManager.setFadeTime(this.player.PlayerIndex, 0.0);
                }
                this.stage = Stage.Finished;
                SoundManager.instance.stopMusic(IsoPlayer.DEATH_MUSIC_NAME);
                break;
            }
        }
    }

    public boolean isFinished() {
        return this.stage == Stage.Finished;
    }

    public void accessGranted(int n) {
        if (this.player.PlayerIndex == n) {
            DebugLog.log("coop player=" + (n + 1) + "/4 access granted");
            this.stage = Stage.StartMapLoading;
        }
    }

    public void accessDenied(int n, String string) {
        if (this.player.PlayerIndex == n) {
            DebugLog.log("coop player=" + (n + 1) + "/4 access denied: " + string);
            IsoCell isoCell = IsoWorld.instance.CurrentCell;
            int n2 = this.player.PlayerIndex;
            IsoChunkMap isoChunkMap = isoCell.ChunkMap[n2];
            isoChunkMap.Unload();
            isoChunkMap.ignore = true;
            this.stage = Stage.Finished;
            LuaEventManager.triggerEvent("OnCoopJoinFailed", n);
        }
    }

    public void receivePlayerConnect(int n) {
        if (this.player.PlayerIndex == n) {
            this.stage = Stage.AddToWorld;
            this.update();
        }
    }

    public boolean isLoadingThisSquare(int n, int n2) {
        int n3 = (int)(this.player.x / 10.0f);
        int n4 = (int)(this.player.y / 10.0f);
        int n5 = n3 - IsoChunkMap.ChunkGridWidth / 2;
        int n6 = n4 - IsoChunkMap.ChunkGridWidth / 2;
        int n7 = n5 + IsoChunkMap.ChunkGridWidth;
        int n8 = n6 + IsoChunkMap.ChunkGridWidth;
        return (n /= 10) >= n5 && n < n7 && (n2 /= 10) >= n6 && n2 < n8;
    }

    public static enum Stage {
        Init,
        ReceiveClientConnect,
        StartMapLoading,
        CheckMapLoading,
        SendPlayerConnect,
        ReceivePlayerConnect,
        AddToWorld,
        Finished;

    }
}

