/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.awt.Rectangle;
import java.util.Stack;
import zombie.core.Color;
import zombie.core.textures.Texture;
import zombie.ui.UIElement;

public final class UIDialoguePanel
extends UIElement {
    float alpha = 1.0f;
    Texture dialogBottomLeft = null;
    Texture dialogBottomMiddle = null;
    Texture dialogBottomRight = null;
    Texture dialogLeft = null;
    Texture dialogMiddle = null;
    Texture dialogRight = null;
    Texture titleLeft = null;
    Texture titleMiddle = null;
    Texture titleRight = null;
    public float clientH = 0.0f;
    public float clientW = 0.0f;
    public Stack<Rectangle> nestedItems = new Stack();

    public UIDialoguePanel(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
        this.titleLeft = Texture.getSharedTexture("media/ui/Dialog_Titlebar_Left.png");
        this.titleMiddle = Texture.getSharedTexture("media/ui/Dialog_Titlebar_Middle.png");
        this.titleRight = Texture.getSharedTexture("media/ui/Dialog_Titlebar_Right.png");
        this.dialogLeft = Texture.getSharedTexture("media/ui/Dialog_Left.png");
        this.dialogMiddle = Texture.getSharedTexture("media/ui/Dialog_Middle.png");
        this.dialogRight = Texture.getSharedTexture("media/ui/Dialog_Right.png");
        this.dialogBottomLeft = Texture.getSharedTexture("media/ui/Dialog_Bottom_Left.png");
        this.dialogBottomMiddle = Texture.getSharedTexture("media/ui/Dialog_Bottom_Middle.png");
        this.dialogBottomRight = Texture.getSharedTexture("media/ui/Dialog_Bottom_Right.png");
        this.clientW = f3;
        this.clientH = f4;
    }

    public void Nest(UIElement uIElement, int n, int n2, int n3, int n4) {
        this.AddChild(uIElement);
        this.nestedItems.add(new Rectangle(n4, n, n2, n3));
        uIElement.setX(n4);
        uIElement.setY(n);
        uIElement.update();
    }

    @Override
    public void render() {
        this.DrawTextureScaledCol(this.titleLeft, 0.0, 0.0, 28.0, 28.0, new Color(255, 255, 255, 100));
        this.DrawTextureScaledCol(this.titleMiddle, 28.0, 0.0, this.getWidth() - 56.0, 28.0, new Color(255, 255, 255, 100));
        this.DrawTextureScaledCol(this.titleRight, 0.0 + this.getWidth() - 28.0, 0.0, 28.0, 28.0, new Color(255, 255, 255, 100));
        this.DrawTextureScaledCol(this.dialogLeft, 0.0, 28.0, 78.0, this.getHeight() - 100.0, new Color(255, 255, 255, 100));
        this.DrawTextureScaledCol(this.dialogMiddle, 78.0, 28.0, this.getWidth() - 156.0, this.getHeight() - 100.0, new Color(255, 255, 255, 100));
        this.DrawTextureScaledCol(this.dialogRight, 0.0 + this.getWidth() - 78.0, 28.0, 78.0, this.getHeight() - 100.0, new Color(255, 255, 255, 100));
        this.DrawTextureScaledCol(this.dialogBottomLeft, 0.0, 0.0 + this.getHeight() - 72.0, 78.0, 72.0, new Color(255, 255, 255, 100));
        this.DrawTextureScaledCol(this.dialogBottomMiddle, 78.0, 0.0 + this.getHeight() - 72.0, this.getWidth() - 156.0, 72.0, new Color(255, 255, 255, 100));
        this.DrawTextureScaledCol(this.dialogBottomRight, 0.0 + this.getWidth() - 78.0, 0.0 + this.getHeight() - 72.0, 78.0, 72.0, new Color(255, 255, 255, 100));
        super.render();
    }

    @Override
    public void update() {
        super.update();
        int n = 0;
        for (Rectangle rectangle : this.nestedItems) {
            UIElement uIElement = this.getControls().get(n);
            uIElement.setX((float)rectangle.getX());
            uIElement.setY((float)rectangle.getY());
            uIElement.setWidth((int)((double)this.clientW - (rectangle.getX() + rectangle.getWidth())));
            uIElement.setHeight((int)((double)this.clientH - (rectangle.getY() + rectangle.getHeight())));
            uIElement.onresize();
            ++n;
        }
    }
}

