/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.krka.kahlua.integration.LuaReturn;
import se.krka.kahlua.luaj.compiler.LuaCompiler;
import se.krka.kahlua.stdlib.BaseLib;
import se.krka.kahlua.vm.KahluaException;
import se.krka.kahlua.vm.LuaClosure;
import zombie.Lua.LuaManager;
import zombie.characters.IsoGameCharacter;
import zombie.core.Core;
import zombie.debug.DebugOptions;
import zombie.ui.NewWindow;
import zombie.ui.ScrollBar;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.ui.UITextBox2;

public final class UIDebugConsole
extends NewWindow {
    public static UIDebugConsole instance;
    IsoGameCharacter ParentChar;
    ScrollBar ScrollBarV;
    UITextBox2 OutputLog;
    public UITextBox2 CommandLine;
    UITextBox2 autosuggest;
    String ConsoleVersion = "v1.1.0";
    int inputlength = 0;
    private final ArrayList<String> Previous = new ArrayList();
    private final ArrayList<Method> globalLuaMethods = new ArrayList();
    public int PreviousIndex = 0;
    Method prevSuggestion = null;
    String[] AvailableCommands = new String[]{"?", "help", "commands", "clr", "AddInvItem", "SpawnZombie"};
    String[] AvailableCommandsHelp = new String[]{"'?' - Shows available commands", "'help' - Shows available commands", "'commands' - Shows available commands", "'clr' - Clears the command log", "'AddInvItem' - Adds an item to player inventory. USAGE - AddInvItem 'ItemName' [ammount]", "'SpawnZombie' - Spawn a zombie at a map location. USAGE - SpawnZombie X,Y,Z (integers)"};
    public boolean bDebounceUp = false;
    public boolean bDebounceDown = false;
    private static final Object outputLock;
    private static final ByteBuffer outputBB;
    private static boolean outputChanged;
    private static CharsetDecoder outputDecoder;
    private static char[] outputChars;
    private static CharBuffer outputCharBuf;

    public UIDebugConsole(int n, int n2) {
        super(n, n2, 10, 10, true);
        this.ResizeToFitY = false;
        this.visible = true;
        instance = this;
        this.width = 640.0f;
        int n3 = TextManager.instance.getFontHeight(UIFont.DebugConsole);
        int n4 = 11;
        int n5 = 5;
        this.OutputLog = new UITextBox2(UIFont.DebugConsole, 5, 33, 630, n3 * n4 + n5 * 2, "Project Zomboid - " + Core.getInstance().getVersion() + "\nDebug Console - " + this.ConsoleVersion + "\n(C) Indie Stone Studios 2021\n---------------------------------------------------------------------------------------------------------------------------\n\n", true);
        this.OutputLog.multipleLine = true;
        this.OutputLog.bAlwaysPaginate = false;
        this.CommandLine = new CommandEntry(UIFont.DebugConsole, 5, (int)(this.OutputLog.getY() + this.OutputLog.getHeight()) + 15, 630, 24, "", true);
        this.CommandLine.IsEditable = true;
        this.CommandLine.TextEntryMaxLength = 256;
        this.autosuggest = new UITextBox2(UIFont.DebugConsole, 5, 180, 15, 25, "", true);
        this.height = (int)(this.CommandLine.getY() + this.CommandLine.getHeight()) + 6;
        this.ScrollBarV = new ScrollBar("UIDebugConsoleScrollbar", null, (int)(this.OutputLog.getX() + this.OutputLog.getWidth()) - 14, this.OutputLog.getY().intValue() + 4, this.OutputLog.getHeight().intValue() - 8, true);
        this.ScrollBarV.SetParentTextBox(this.OutputLog);
        this.AddChild(this.OutputLog);
        this.AddChild(this.ScrollBarV);
        this.AddChild(this.CommandLine);
        this.AddChild(this.autosuggest);
        this.InitSuggestionEngine();
        if (Core.bDebug) {
            BaseLib.setPrintCallback(this::SpoolText);
        }
    }

    @Override
    public void render() {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        super.render();
        this.DrawTextCentre(UIFont.DebugConsole, "Command Console", this.getWidth() / 2.0, 2.0, 1.0, 1.0, 1.0, 1.0);
        this.DrawText(UIFont.DebugConsole, "Output Log", 7.0, 19.0, 0.7f, 0.7f, 1.0, 1.0);
        this.DrawText(UIFont.DebugConsole, "Lua Command Line", 7.0, this.OutputLog.getY() + this.OutputLog.getHeight() + 1.0, 0.7f, 0.7f, 1.0, 1.0);
    }

    @Override
    public void update() {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        this.handleOutput();
        super.update();
        if (this.CommandLine.getText().length() != this.inputlength && this.CommandLine.getText().length() != 0) {
            Object object;
            this.inputlength = this.CommandLine.getText().length();
            String[] stringArray = this.CommandLine.getText().split(":");
            String string = "";
            if (stringArray.length > 0) {
                string = stringArray[stringArray.length - 1];
                if (stringArray[stringArray.length - 1].isEmpty() && this.autosuggest.isVisible().booleanValue()) {
                    this.autosuggest.setVisible(false);
                    return;
                }
            }
            Method method = null;
            if (stringArray.length > 1 && stringArray[0].indexOf(")") > 0 && !stringArray[stringArray.length - 1].contains("(")) {
                object = new ArrayList<Method>(this.globalLuaMethods);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (string2.indexOf(")") <= 0) continue;
                    string2 = string2.split("\\(", 0)[0];
                    Iterator iterator = ((ArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        Method method2 = (Method)iterator.next();
                        if (!method2.getName().equals(string2)) continue;
                        ((ArrayList)object).clear();
                        for (Class<?> clazz = method2.getReturnType(); clazz != null; clazz = clazz.getSuperclass()) {
                            for (Method method3 : clazz.getDeclaredMethods()) {
                                if (!Modifier.isPublic(method3.getModifiers())) continue;
                                ((ArrayList)object).add(method3);
                            }
                        }
                    }
                }
                method = this.SuggestionEngine(string, (ArrayList<Method>)object);
            } else if (stringArray.length == 1) {
                method = this.SuggestionEngine(string);
            }
            String string3 = "void";
            if (method != null) {
                if (!method.getReturnType().toString().equals("void")) {
                    object = method.getReturnType().toString().split("\\.");
                    string3 = object[((String[])object).length - 1];
                }
                if (!this.autosuggest.isVisible().booleanValue()) {
                    this.autosuggest.setVisible(true);
                }
                this.autosuggest.SetText("<" + string3 + "> " + method.getName());
                this.autosuggest.setX(5 * this.CommandLine.getText().length());
                this.autosuggest.setWidth(15 * (string3.length() + method.getName().length()));
                this.autosuggest.Frame.width = 10 * (string3.length() + method.getName().length());
            }
        } else if (this.CommandLine.getText().length() == 0 && this.autosuggest.isVisible().booleanValue()) {
            this.autosuggest.setVisible(false);
        }
    }

    public void ProcessCommand() {
        if (this.CommandLine.internalText != null) {
            String string = this.CommandLine.internalText;
            this.CommandLine.internalText = "";
            string = string.trim();
            String[] stringArray = string.split(" ");
            stringArray[0] = stringArray[0].trim();
            if (this.Previous.isEmpty() || !string.equals(this.Previous.get(this.Previous.size() - 1))) {
                this.Previous.add(string);
            }
            this.PreviousIndex = this.Previous.size();
            this.CommandLine.DoingTextEntry = true;
            Core.CurrentTextEntryBox = this.CommandLine;
            if ("clear".equals(string)) {
                this.OutputLog.bTextChanged = true;
                this.OutputLog.clearInput();
                return;
            }
            if (DebugOptions.instance.UIDebugConsoleEchoCommand.getValue()) {
                this.SpoolText("[USER] - \"" + string + "\".");
            }
            try {
                LuaClosure luaClosure = LuaCompiler.loadstring(string, "console", LuaManager.env);
                LuaReturn luaReturn = LuaManager.caller.protectedCall(LuaManager.thread, luaClosure, new Object[0]);
            }
            catch (KahluaException kahluaException) {
                this.SpoolText(kahluaException.getMessage());
            }
            catch (Exception exception) {
                Logger.getLogger(UIDebugConsole.class.getName()).log(Level.SEVERE, null, exception);
            }
            return;
        }
    }

    void historyPrev() {
        --this.PreviousIndex;
        if (this.PreviousIndex < 0) {
            this.PreviousIndex = 0;
        }
        if (this.PreviousIndex >= 0 && this.PreviousIndex < this.Previous.size()) {
            this.CommandLine.SetText(this.Previous.get(this.PreviousIndex));
        }
    }

    void historyNext() {
        ++this.PreviousIndex;
        if (this.PreviousIndex >= this.Previous.size()) {
            this.PreviousIndex = this.Previous.size() - 1;
        }
        if (this.PreviousIndex >= 0 && this.PreviousIndex < this.Previous.size()) {
            this.CommandLine.SetText(this.Previous.get(this.PreviousIndex));
        }
    }

    public void onOtherKey(int n) {
        switch (n) {
            case 15: {
                if (this.prevSuggestion == null) break;
                String[] stringArray = this.CommandLine.getText().split(":");
                StringBuilder stringBuilder = new StringBuilder();
                if (stringArray.length > 0) {
                    stringArray[stringArray.length - 1] = this.prevSuggestion.getName();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuilder.append(stringArray[i]);
                        if (i == stringArray.length - 1) continue;
                        stringBuilder.append(":");
                    }
                }
                if (this.prevSuggestion.getParameterTypes().length == 0) {
                    this.CommandLine.SetText(stringBuilder + "()");
                    break;
                }
                this.CommandLine.SetText(stringBuilder + "(");
            }
        }
    }

    void ClearConsole() {
        this.OutputLog.bTextChanged = true;
        this.OutputLog.SetText("");
        this.UpdateViewPos();
    }

    void UpdateViewPos() {
        this.OutputLog.TopLineIndex = this.OutputLog.Lines.size() - this.OutputLog.NumVisibleLines;
        if (this.OutputLog.TopLineIndex < 0) {
            this.OutputLog.TopLineIndex = 0;
        }
        this.ScrollBarV.scrollToBottom();
    }

    void SpoolText(String string) {
        this.OutputLog.bTextChanged = true;
        this.OutputLog.SetText(this.OutputLog.Text + string + "\n");
        this.UpdateViewPos();
    }

    Method SuggestionEngine(String string) {
        return this.SuggestionEngine(string, this.globalLuaMethods);
    }

    Method SuggestionEngine(String string, ArrayList<Method> arrayList) {
        int n = 0;
        int n2 = 0;
        Method method = null;
        for (Method method2 : arrayList) {
            if (method == null) {
                method = method2;
                n = this.levenshteinDistance(string, method2.getName());
                continue;
            }
            n2 = this.levenshteinDistance(string, method2.getName());
            if (n2 >= n) continue;
            n = n2;
            method = method2;
        }
        this.prevSuggestion = method;
        return method;
    }

    void InitSuggestionEngine() {
        Class<LuaManager.GlobalObject> clazz = LuaManager.GlobalObject.class;
        this.globalLuaMethods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
    }

    public int levenshteinDistance(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        int n2 = charSequence.length() + 1;
        int n3 = charSequence2.length() + 1;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        for (n = 1; n < n3; ++n) {
            nArray2[0] = n;
            for (int i = 1; i < n2; ++i) {
                int n4 = charSequence.charAt(i - 1) == charSequence2.charAt(n - 1) ? 0 : 1;
                int n5 = nArray[i - 1] + n4;
                int n6 = nArray[i] + 1;
                int n7 = nArray2[i - 1] + 1;
                nArray2[i] = Math.min(Math.min(n6, n7), n5);
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        return nArray[n2 - 1];
    }

    void setSuggestWidth(int n) {
        this.autosuggest.setWidth(n);
        this.autosuggest.Frame.width = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutput(byte[] byArray, int n, int n2) {
        if (n2 < 1) {
            return;
        }
        Object object = outputLock;
        synchronized (object) {
            int n3 = n2 - outputBB.capacity();
            if (n3 > 0) {
                n += n3;
                n2 -= n3;
            }
            if (outputBB.position() + n2 > outputBB.capacity()) {
                outputBB.clear();
            }
            outputBB.put(byArray, n, n2);
            if (byArray[n + n2 - 1] == 10) {
                outputChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOutput() {
        Object object = outputLock;
        synchronized (object) {
            if (outputChanged) {
                outputChanged = false;
                try {
                    if (outputDecoder == null) {
                        outputDecoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                    }
                    outputDecoder.reset();
                    int n = outputBB.position();
                    outputBB.flip();
                    int n2 = (int)((double)n * (double)outputDecoder.maxCharsPerByte());
                    if (outputChars == null || outputChars.length < n2) {
                        int n3 = (n2 + 128 - 1) / 128 * 128;
                        outputChars = new char[n3];
                        outputCharBuf = CharBuffer.wrap(outputChars);
                    }
                    outputCharBuf.clear();
                    CoderResult coderResult = outputDecoder.decode(outputBB, outputCharBuf, true);
                    outputBB.clear();
                    String string = new String(outputChars, 0, outputCharBuf.position());
                    this.OutputLog.bTextChanged = true;
                    this.OutputLog.SetText(this.OutputLog.Text + string);
                    int n4 = 8192;
                    if (this.OutputLog.Text.length() > n4) {
                        int n5;
                        for (n5 = this.OutputLog.Text.length() - n4; n5 < this.OutputLog.Text.length() && this.OutputLog.Text.charAt(n5) != '\n'; ++n5) {
                        }
                        this.OutputLog.bTextChanged = true;
                        this.OutputLog.SetText(this.OutputLog.Text.substring(n5 + 1));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.UpdateViewPos();
            }
        }
    }

    static {
        outputLock = "DebugConsole Output Lock";
        outputBB = ByteBuffer.allocate(8192);
        outputChanged = false;
        outputCharBuf = null;
    }

    private class CommandEntry
    extends UITextBox2 {
        public CommandEntry(UIFont uIFont, int n, int n2, int n3, int n4, String string, boolean bl) {
            super(uIFont, n, n2, n3, n4, string, bl);
        }

        @Override
        public void onPressUp() {
            UIDebugConsole.this.historyPrev();
        }

        @Override
        public void onPressDown() {
            UIDebugConsole.this.historyNext();
        }

        @Override
        public void onOtherKey(int n) {
            UIDebugConsole.this.onOtherKey(n);
        }
    }
}

