/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import se.krka.kahlua.vm.KahluaTable;
import zombie.characters.IsoGameCharacter;
import zombie.characters.SurvivorDesc;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.skinnedmodel.advancedanimation.AnimatedModel;
import zombie.core.skinnedmodel.population.IClothingItemListener;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.textures.TextureDraw;
import zombie.iso.IsoDirections;
import zombie.ui.UIElement;
import zombie.util.StringUtils;

public final class UI3DModel
extends UIElement
implements IClothingItemListener {
    private final AnimatedModel animatedModel = new AnimatedModel();
    private IsoDirections dir = IsoDirections.E;
    private boolean bDoExt = false;
    private long nextExt = -1L;
    private final Drawer[] drawers = new Drawer[3];
    private float zoom = 0.0f;
    private float yOffset = 0.0f;
    private float xOffset = 0.0f;

    public UI3DModel(KahluaTable kahluaTable) {
        super(kahluaTable);
        for (int i = 0; i < this.drawers.length; ++i) {
            this.drawers[i] = new Drawer();
        }
        if (OutfitManager.instance != null) {
            OutfitManager.instance.addClothingItemListener(this);
        }
    }

    @Override
    public void render() {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        super.render();
        if (this.Parent != null && this.Parent.maxDrawHeight != -1 && (double)this.Parent.maxDrawHeight <= this.y) {
            return;
        }
        if (this.bDoExt) {
            long l = System.currentTimeMillis();
            if (this.nextExt < 0L) {
                this.nextExt = l + (long)Rand.Next(5000, 10000);
            }
            if (this.nextExt < l) {
                this.animatedModel.getActionContext().reportEvent("EventDoExt");
                this.animatedModel.setVariable("Ext", Rand.Next(0, 6) + 1);
                this.nextExt = -1L;
            }
        }
        this.animatedModel.update();
        Drawer drawer = this.drawers[SpriteRenderer.instance.getMainStateIndex()];
        drawer.init(this.getAbsoluteX().intValue(), this.getAbsoluteY().intValue());
        SpriteRenderer.instance.drawGeneric(drawer);
    }

    public void setDirection(IsoDirections isoDirections) {
        this.dir = isoDirections;
        this.animatedModel.setAngle(isoDirections.ToVector());
    }

    public IsoDirections getDirection() {
        return this.dir;
    }

    public void setAnimate(boolean bl) {
        this.animatedModel.setAnimate(bl);
    }

    public void setAnimSetName(String string) {
        this.animatedModel.setAnimSetName(string);
    }

    public void setDoRandomExtAnimations(boolean bl) {
        this.bDoExt = bl;
    }

    public void setIsometric(boolean bl) {
        this.animatedModel.setIsometric(bl);
    }

    public void setOutfitName(String string, boolean bl, boolean bl2) {
        this.animatedModel.setOutfitName(string, bl, bl2);
    }

    public void setCharacter(IsoGameCharacter isoGameCharacter) {
        this.animatedModel.setCharacter(isoGameCharacter);
    }

    public void setSurvivorDesc(SurvivorDesc survivorDesc) {
        this.animatedModel.setSurvivorDesc(survivorDesc);
    }

    public void setState(String string) {
        this.animatedModel.setState(string);
    }

    public void reportEvent(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        this.animatedModel.getActionContext().reportEvent(string);
    }

    @Override
    public void clothingItemChanged(String string) {
        this.animatedModel.clothingItemChanged(string);
    }

    public void setZoom(float f) {
        this.zoom = f;
    }

    public void setYOffset(float f) {
        this.yOffset = f;
    }

    public void setXOffset(float f) {
        this.xOffset = f;
    }

    private final class Drawer
    extends TextureDraw.GenericDrawer {
        int absX;
        int absY;
        float m_animPlayerAngle;
        boolean bRendered;

        private Drawer() {
        }

        public void init(int n, int n2) {
            float f;
            this.absX = n;
            this.absY = n2;
            this.m_animPlayerAngle = UI3DModel.this.animatedModel.getAnimationPlayer().getRenderedAngle();
            this.bRendered = false;
            float f2 = f = UI3DModel.this.animatedModel.isIsometric() ? -0.45f : -0.5f;
            if (UI3DModel.this.yOffset != 0.0f) {
                f = UI3DModel.this.yOffset;
            }
            UI3DModel.this.animatedModel.setOffset(UI3DModel.this.xOffset, f, 0.0f);
            UI3DModel.this.animatedModel.renderMain();
        }

        @Override
        public void render() {
            float f;
            float f2 = f = UI3DModel.this.animatedModel.isIsometric() ? 22.0f : 25.0f;
            if (UI3DModel.this.zoom > 0.0f) {
                f -= UI3DModel.this.zoom;
            }
            UI3DModel.this.animatedModel.DoRender(this.absX, Core.height - this.absY - (int)UI3DModel.this.height, (int)UI3DModel.this.width, (int)UI3DModel.this.height, f, this.m_animPlayerAngle);
            this.bRendered = true;
        }

        @Override
        public void postRender() {
            UI3DModel.this.animatedModel.postRender(this.bRendered);
        }
    }
}

