/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatElement;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.fonts.AngelCodeFont;
import zombie.core.textures.Texture;
import zombie.network.GameServer;
import zombie.ui.TextDrawHorizontal;
import zombie.ui.TextManager;
import zombie.ui.UIFont;

public final class TextDrawObject {
    private String[] validImages = new String[]{"Icon_music_notes", "media/ui/CarKey.png", "media/ui/ArrowUp.png", "media/ui/ArrowDown.png"};
    private String[] validFonts = new String[]{"Small", "Dialogue", "Medium", "Code", "Large", "Massive"};
    private final ArrayList<DrawLine> lines = new ArrayList();
    private int width = 0;
    private int height = 0;
    private int maxCharsLine = -1;
    private UIFont defaultFontEnum = UIFont.Dialogue;
    private AngelCodeFont defaultFont = null;
    private String original = "";
    private String unformatted = "";
    private DrawLine currentLine;
    private DrawElement currentElement;
    private boolean hasOpened = false;
    private boolean drawBackground = false;
    private boolean allowImages = true;
    private boolean allowChatIcons = true;
    private boolean allowColors = true;
    private boolean allowFonts = true;
    private boolean allowBBcode = true;
    private boolean allowAnyImage = false;
    private boolean allowLineBreaks = true;
    private boolean equalizeLineHeights = false;
    private boolean enabled = true;
    private int visibleRadius = -1;
    private float scrambleVal = 0.0f;
    private float outlineR = 0.0f;
    private float outlineG = 0.0f;
    private float outlineB = 0.0f;
    private float outlineA = 1.0f;
    private float defaultR = 1.0f;
    private float defaultG = 1.0f;
    private float defaultB = 1.0f;
    private float defaultA = 1.0f;
    private int hearRange = -1;
    private float internalClock = 0.0f;
    private String customTag = "default";
    private int customImageMaxDim = 18;
    private TextDrawHorizontal defaultHorz = TextDrawHorizontal.Center;
    private int drawMode = 0;
    private static ArrayList<RenderBatch> renderBatch = new ArrayList();
    private static ArrayDeque<RenderBatch> renderBatchPool = new ArrayDeque();
    private String elemText;

    public TextDrawObject() {
        this(255, 255, 255, true, true, true, true, true, false);
    }

    public TextDrawObject(int n, int n2, int n3, boolean bl) {
        this(n, n2, n3, bl, true, true, true, true, false);
    }

    public TextDrawObject(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.setSettings(bl, bl2, bl3, bl4, bl5, bl6);
        this.setDefaultColors(n, n2, n3);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setVisibleRadius(int n) {
        this.visibleRadius = n;
    }

    public int getVisibleRadius() {
        return this.visibleRadius;
    }

    public void setDrawBackground(boolean bl) {
        this.drawBackground = bl;
    }

    public void setAllowImages(boolean bl) {
        this.allowImages = bl;
    }

    public void setAllowChatIcons(boolean bl) {
        this.allowChatIcons = bl;
    }

    public void setAllowColors(boolean bl) {
        this.allowColors = bl;
    }

    public void setAllowFonts(boolean bl) {
        this.allowFonts = bl;
    }

    public void setAllowBBcode(boolean bl) {
        this.allowBBcode = bl;
    }

    public void setAllowAnyImage(boolean bl) {
        this.allowAnyImage = bl;
    }

    public void setAllowLineBreaks(boolean bl) {
        this.allowLineBreaks = bl;
    }

    public void setEqualizeLineHeights(boolean bl) {
        this.equalizeLineHeights = bl;
        this.calculateDimensions();
    }

    public void setSettings(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.allowImages = bl2;
        this.allowChatIcons = bl3;
        this.allowColors = bl4;
        this.allowFonts = bl5;
        this.allowBBcode = bl;
        this.equalizeLineHeights = bl6;
    }

    public void setCustomTag(String string) {
        this.customTag = string;
    }

    public String getCustomTag() {
        return this.customTag;
    }

    public void setValidImages(String[] stringArray) {
        this.validImages = stringArray;
    }

    public void setValidFonts(String[] stringArray) {
        this.validFonts = stringArray;
    }

    public void setMaxCharsPerLine(int n) {
        if (n <= 0) {
            return;
        }
        this.ReadString(this.original, n);
    }

    public void setCustomImageMaxDimensions(int n) {
        if (n < 1) {
            return;
        }
        this.customImageMaxDim = n;
        this.calculateDimensions();
    }

    public void setOutlineColors(int n, int n2, int n3) {
        this.setOutlineColors((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, 1.0f);
    }

    public void setOutlineColors(int n, int n2, int n3, int n4) {
        this.setOutlineColors((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, (float)n4 / 255.0f);
    }

    public void setOutlineColors(float f, float f2, float f3) {
        this.setOutlineColors(f, f2, f3, 1.0f);
    }

    public void setOutlineColors(float f, float f2, float f3, float f4) {
        this.outlineR = f;
        this.outlineG = f2;
        this.outlineB = f3;
        this.outlineA = f4;
    }

    public void setDefaultColors(int n, int n2, int n3) {
        this.setDefaultColors((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, 1.0f);
    }

    public void setDefaultColors(int n, int n2, int n3, int n4) {
        this.setDefaultColors((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, (float)n4 / 255.0f);
    }

    public void setDefaultColors(float f, float f2, float f3) {
        this.setDefaultColors(f, f2, f3, 1.0f);
    }

    public void setDefaultColors(float f, float f2, float f3, float f4) {
        this.defaultR = f;
        this.defaultG = f2;
        this.defaultB = f3;
        this.defaultA = f4;
    }

    public void setHorizontalAlign(String string) {
        if (string.equals("left")) {
            this.defaultHorz = TextDrawHorizontal.Left;
        } else if (string.equals("center")) {
            this.defaultHorz = TextDrawHorizontal.Center;
        }
        if (string.equals("right")) {
            this.defaultHorz = TextDrawHorizontal.Right;
        }
    }

    public void setHorizontalAlign(TextDrawHorizontal textDrawHorizontal) {
        this.defaultHorz = textDrawHorizontal;
    }

    public TextDrawHorizontal getHorizontalAlign() {
        return this.defaultHorz;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getUnformatted() {
        if (this.scrambleVal > 0.0f) {
            Object object = "";
            for (DrawLine drawLine : this.lines) {
                for (DrawElement drawElement : drawLine.elements) {
                    if (drawElement.isImage) continue;
                    object = (String)object + drawElement.scrambleText;
                }
            }
            return object;
        }
        return this.unformatted;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public UIFont getDefaultFontEnum() {
        return this.defaultFontEnum;
    }

    public boolean isNullOrZeroLength() {
        return this.original == null || this.original.length() == 0;
    }

    public float getInternalClock() {
        return this.internalClock;
    }

    public void setInternalTickClock(float f) {
        if (f > 0.0f) {
            this.internalClock = f;
        }
    }

    public float updateInternalTickClock() {
        return this.updateInternalTickClock(1.25f * GameTime.getInstance().getMultiplier());
    }

    public float updateInternalTickClock(float f) {
        if (this.internalClock <= 0.0f) {
            return 0.0f;
        }
        this.internalClock -= f;
        if (this.internalClock <= 0.0f) {
            this.internalClock = 0.0f;
        }
        return this.internalClock;
    }

    public void setScrambleVal(float f) {
        if (this.scrambleVal != f) {
            this.scrambleVal = f;
            if (this.scrambleVal > 0.0f) {
                for (DrawLine drawLine : this.lines) {
                    for (DrawElement drawElement : drawLine.elements) {
                        if (drawElement.isImage) continue;
                        drawElement.scrambleText(this.scrambleVal);
                    }
                }
            }
        }
    }

    public float getScrambleVal() {
        return this.scrambleVal;
    }

    public void setHearRange(int n) {
        this.hearRange = n < 0 ? 0 : n;
    }

    public int getHearRange() {
        return this.hearRange;
    }

    private boolean isValidFont(String string) {
        for (String string2 : this.validFonts) {
            if (!string.equals(string2) || UIFont.FromString(string) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isValidImage(String string) {
        for (String string2 : this.validImages) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private int tryColorInt(String string) {
        if (string.length() <= 0 || string.length() > 3) {
            return -1;
        }
        try {
            int n = Integer.parseInt(string);
            if (n >= 0 && n < 256) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return -1;
    }

    private String readTagValue(char[] cArray, int n) {
        if (cArray[n] == '=') {
            Object object = "";
            for (int i = n + 1; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == ']') {
                    return object;
                }
                object = (String)object + c;
            }
        }
        return null;
    }

    public void Clear() {
        this.original = "";
        this.unformatted = "";
        this.reset();
    }

    private void reset() {
        this.lines.clear();
        this.currentLine = new DrawLine();
        this.lines.add(this.currentLine);
        this.currentElement = new DrawElement();
        this.currentLine.addElement(this.currentElement);
        this.enabled = true;
        this.scrambleVal = 0.0f;
    }

    private void addNewLine() {
        this.currentLine = new DrawLine();
        this.lines.add(this.currentLine);
        this.currentElement = this.currentElement.softclone();
        this.currentLine.addElement(this.currentElement);
    }

    private void addText(String string) {
        this.currentElement.addText(string);
        this.currentLine.charW += string.length();
    }

    private void addWord(String string) {
        if (this.maxCharsLine <= 0 || this.currentLine.charW + string.length() < this.maxCharsLine) {
            this.addText(string);
        } else {
            for (int i = 0; i < string.length() / this.maxCharsLine + 1; ++i) {
                int n;
                int n2 = i * this.maxCharsLine;
                int n3 = n = n2 + this.maxCharsLine < string.length() ? n2 + this.maxCharsLine : string.length();
                if (string.substring(n2, n).length() <= 0) continue;
                if (i > 0 || this.currentLine.charW != 0) {
                    this.addNewLine();
                }
                this.addText(string.substring(n2, n));
            }
        }
    }

    private void addNewElement() {
        if (this.currentElement.text.length() == 0) {
            this.currentElement.reset();
        } else {
            this.currentElement = new DrawElement();
            this.currentLine.addElement(this.currentElement);
        }
    }

    private int readTag(char[] cArray, int n, String string) {
        String string2;
        if (this.allowFonts && string.equals("fnt")) {
            String string3 = this.readTagValue(cArray, n);
            if (string3 != null && this.isValidFont(string3)) {
                this.addNewElement();
                this.currentElement.f = UIFont.FromString(string3);
                this.currentElement.useFont = true;
                this.currentElement.font = TextManager.instance.getFontFromEnum(this.currentElement.f);
                this.hasOpened = true;
                return n + string3.length() + 1;
            }
        } else if ((this.allowImages || this.allowChatIcons) && string.equals("img")) {
            String string4 = this.readTagValue(cArray, n);
            if (string4 != null && string4.trim().length() > 0) {
                this.addNewElement();
                int n2 = string4.length();
                String[] stringArray = string4.split(",");
                if (stringArray.length > 1) {
                    string4 = stringArray[0];
                }
                this.currentElement.isImage = true;
                this.currentElement.text = string4.trim();
                if (this.currentElement.text.equals("music")) {
                    this.currentElement.text = "Icon_music_notes";
                }
                if (this.allowChatIcons && this.isValidImage(this.currentElement.text)) {
                    this.currentElement.tex = Texture.getSharedTexture(this.currentElement.text);
                    this.currentElement.isTextImage = true;
                } else if (this.allowImages) {
                    this.currentElement.tex = Texture.getSharedTexture("Item_" + this.currentElement.text);
                    if (this.currentElement.tex == null) {
                        this.currentElement.tex = Texture.getSharedTexture("media/ui/Container_" + this.currentElement.text);
                    }
                    if (this.currentElement.tex != null) {
                        this.currentElement.isTextImage = false;
                        this.currentElement.text = "Item_" + this.currentElement.text;
                    }
                }
                if (this.allowAnyImage && this.currentElement.tex == null) {
                    this.currentElement.tex = Texture.getSharedTexture(this.currentElement.text);
                    if (this.currentElement.tex != null) {
                        this.currentElement.isTextImage = false;
                    }
                }
                if (stringArray.length == 4) {
                    int n3 = this.tryColorInt(stringArray[1]);
                    int n4 = this.tryColorInt(stringArray[2]);
                    int n5 = this.tryColorInt(stringArray[3]);
                    if (n3 != -1 && n4 != -1 && n5 != -1) {
                        this.currentElement.useColor = true;
                        this.currentElement.R = (float)n3 / 255.0f;
                        this.currentElement.G = (float)n4 / 255.0f;
                        this.currentElement.B = (float)n5 / 255.0f;
                    }
                }
                this.addNewElement();
                return n + n2 + 1;
            }
        } else if (this.allowColors && string.equals("col")) {
            String[] stringArray;
            String string5 = this.readTagValue(cArray, n);
            if (string5 != null && (stringArray = string5.split(",")).length == 3) {
                int n6 = this.tryColorInt(stringArray[0]);
                int n7 = this.tryColorInt(stringArray[1]);
                int n8 = this.tryColorInt(stringArray[2]);
                if (n6 != -1 && n7 != -1 && n8 != -1) {
                    this.addNewElement();
                    this.currentElement.useColor = true;
                    this.currentElement.R = (float)n6 / 255.0f;
                    this.currentElement.G = (float)n7 / 255.0f;
                    this.currentElement.B = (float)n8 / 255.0f;
                    this.hasOpened = true;
                    return n + string5.length() + 1;
                }
            }
        } else if (string.equals("cdt") && (string2 = this.readTagValue(cArray, n)) != null) {
            float f = this.internalClock;
            try {
                f = Float.parseFloat(string2);
                f *= 60.0f;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            this.internalClock = f;
            return n + string2.length() + 1;
        }
        return -1;
    }

    public void setDefaultFont(UIFont uIFont) {
        if (!uIFont.equals((Object)this.defaultFontEnum)) {
            this.ReadString(uIFont, this.original, this.maxCharsLine);
        }
    }

    private void setDefaultFontInternal(UIFont uIFont) {
        if (this.defaultFont == null || !uIFont.equals((Object)this.defaultFontEnum)) {
            this.defaultFontEnum = uIFont;
            this.defaultFont = TextManager.instance.getFontFromEnum(uIFont);
        }
    }

    public void ReadString(String string) {
        this.ReadString(this.defaultFontEnum, string, this.maxCharsLine);
    }

    public void ReadString(String string, int n) {
        this.ReadString(this.defaultFontEnum, string, n);
    }

    public void ReadString(UIFont uIFont, String string, int n) {
        if (string == null) {
            string = "";
        }
        this.reset();
        this.setDefaultFontInternal(uIFont);
        if (this.defaultFont == null) {
            return;
        }
        this.maxCharsLine = n;
        this.original = string;
        char[] cArray = string.toCharArray();
        this.hasOpened = false;
        Object object = "";
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (this.allowBBcode && c == '[') {
                if (((String)object).length() > 0) {
                    this.addWord((String)object);
                    object = "";
                }
                if (i + 4 < cArray.length) {
                    int n2;
                    String string2 = ("" + cArray[i + 1] + cArray[i + 2] + cArray[i + 3]).toLowerCase();
                    if (this.allowLineBreaks && string2.equals("br/")) {
                        this.addNewLine();
                        i += 4;
                        continue;
                    }
                    if (!this.hasOpened && (n2 = this.readTag(cArray, i + 4, string2)) >= 0) {
                        i = n2;
                        continue;
                    }
                }
                if (this.hasOpened && i + 2 < cArray.length && cArray[i + 1] == '/' && cArray[i + 2] == ']') {
                    this.hasOpened = false;
                    this.addNewElement();
                    i += 2;
                    continue;
                }
            }
            if (Character.isWhitespace(c) && i > 0 && !Character.isWhitespace(cArray[i - 1])) {
                this.addWord((String)object);
                object = "";
            }
            object = (String)object + c;
            this.unformatted = this.unformatted + c;
        }
        if (((String)object).length() > 0) {
            this.addWord((String)object);
        }
        this.calculateDimensions();
    }

    public void calculateDimensions() {
        DrawLine drawLine;
        int n;
        this.width = 0;
        this.height = 0;
        int n2 = 0;
        for (n = 0; n < this.lines.size(); ++n) {
            drawLine = this.lines.get(n);
            drawLine.h = 0;
            drawLine.w = 0;
            for (int i = 0; i < drawLine.elements.size(); ++i) {
                DrawElement drawElement = drawLine.elements.get(i);
                drawElement.w = 0;
                drawElement.h = 0;
                if (drawElement.isImage && drawElement.tex != null) {
                    if (drawElement.isTextImage) {
                        drawElement.w = drawElement.tex.getWidth();
                        drawElement.h = drawElement.tex.getHeight();
                    } else {
                        drawElement.w = (int)((float)drawElement.tex.getWidth() * 0.75f);
                        drawElement.h = (int)((float)drawElement.tex.getHeight() * 0.75f);
                    }
                } else if (drawElement.useFont && drawElement.font != null) {
                    drawElement.w = drawElement.font.getWidth(drawElement.text);
                    drawElement.h = drawElement.font.getHeight(drawElement.text);
                } else if (this.defaultFont != null) {
                    drawElement.w = this.defaultFont.getWidth(drawElement.text);
                    drawElement.h = this.defaultFont.getHeight(drawElement.text);
                }
                drawLine.w += drawElement.w;
                if (drawElement.h <= drawLine.h) continue;
                drawLine.h = drawElement.h;
            }
            if (drawLine.w > this.width) {
                this.width = drawLine.w;
            }
            this.height += drawLine.h;
            if (drawLine.h <= n2) continue;
            n2 = drawLine.h;
        }
        if (this.equalizeLineHeights) {
            this.height = 0;
            for (n = 0; n < this.lines.size(); ++n) {
                drawLine = this.lines.get(n);
                drawLine.h = n2;
                this.height += n2;
            }
        }
    }

    public void Draw(double d, double d2) {
        this.Draw(this.defaultHorz, d, d2, this.defaultR, this.defaultG, this.defaultB, this.defaultA, false);
    }

    public void Draw(double d, double d2, boolean bl) {
        this.Draw(this.defaultHorz, d, d2, this.defaultR, this.defaultG, this.defaultB, this.defaultA, bl);
    }

    public void Draw(double d, double d2, boolean bl, float f) {
        this.Draw(this.defaultHorz, d, d2, this.defaultR, this.defaultG, this.defaultB, f, bl);
    }

    public void Draw(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.Draw(this.defaultHorz, d, d2, d3, d4, d5, d6, bl);
    }

    public void Draw(TextDrawHorizontal textDrawHorizontal, double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.DrawRaw(textDrawHorizontal, d, d2, (float)d3, (float)d4, (float)d5, (float)d6, bl);
    }

    public void AddBatchedDraw(double d, double d2) {
        this.AddBatchedDraw(this.defaultHorz, d, d2, this.defaultR, this.defaultG, this.defaultB, this.defaultA, false);
    }

    public void AddBatchedDraw(double d, double d2, boolean bl) {
        this.AddBatchedDraw(this.defaultHorz, d, d2, this.defaultR, this.defaultG, this.defaultB, this.defaultA, bl);
    }

    public void AddBatchedDraw(double d, double d2, boolean bl, float f) {
        this.AddBatchedDraw(this.defaultHorz, d, d2, this.defaultR, this.defaultG, this.defaultB, f, bl);
    }

    public void AddBatchedDraw(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.AddBatchedDraw(this.defaultHorz, d, d2, d3, d4, d5, d6, bl);
    }

    public void AddBatchedDraw(TextDrawHorizontal textDrawHorizontal, double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        if (GameServer.bServer) {
            return;
        }
        RenderBatch renderBatch = renderBatchPool.isEmpty() ? new RenderBatch() : renderBatchPool.pop();
        renderBatch.playerNum = IsoPlayer.getPlayerIndex();
        renderBatch.element = this;
        renderBatch.horz = textDrawHorizontal;
        renderBatch.x = d;
        renderBatch.y = d2;
        renderBatch.r = (float)d3;
        renderBatch.g = (float)d4;
        renderBatch.b = (float)d5;
        renderBatch.a = (float)d6;
        renderBatch.drawOutlines = bl;
        TextDrawObject.renderBatch.add(renderBatch);
    }

    public static void RenderBatch(int n) {
        if (renderBatch.size() > 0) {
            for (int i = 0; i < renderBatch.size(); ++i) {
                RenderBatch renderBatch = TextDrawObject.renderBatch.get(i);
                if (renderBatch.playerNum != n) continue;
                renderBatch.element.DrawRaw(renderBatch.horz, renderBatch.x, renderBatch.y, renderBatch.r, renderBatch.g, renderBatch.b, renderBatch.a, renderBatch.drawOutlines);
                renderBatchPool.add(renderBatch);
                TextDrawObject.renderBatch.remove(i--);
            }
        }
    }

    public static void NoRender(int n) {
        for (int i = 0; i < renderBatch.size(); ++i) {
            RenderBatch renderBatch = TextDrawObject.renderBatch.get(i);
            if (renderBatch.playerNum != n) continue;
            renderBatchPool.add(renderBatch);
            TextDrawObject.renderBatch.remove(i--);
        }
    }

    public void DrawRaw(TextDrawHorizontal textDrawHorizontal, double d, double d2, float f, float f2, float f3, float f4, boolean bl) {
        double d3 = d;
        double d4 = d2;
        double d5 = 0.0;
        int n = Core.getInstance().getScreenWidth();
        int n2 = Core.getInstance().getScreenHeight();
        int n3 = 20;
        if (textDrawHorizontal == TextDrawHorizontal.Center) {
            d3 = d - (double)(this.getWidth() / 2);
        } else if (textDrawHorizontal == TextDrawHorizontal.Right) {
            d3 = d - (double)this.getWidth();
        }
        if (d3 - (double)n3 >= (double)n || d3 + (double)this.getWidth() + (double)n3 <= 0.0 || d4 - (double)n3 >= (double)n2 || d4 + (double)this.getHeight() + (double)n3 <= 0.0) {
            return;
        }
        if (this.drawBackground && ChatElement.backdropTexture != null) {
            ChatElement.backdropTexture.renderInnerBased((int)d3, (int)d4, this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.0f, 0.4f * f4);
        }
        float f5 = this.outlineA;
        if (bl && f4 < 1.0f) {
            f5 = this.outlineA * f4;
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            DrawLine drawLine = this.lines.get(i);
            d3 = d;
            if (textDrawHorizontal == TextDrawHorizontal.Center) {
                d3 = d - (double)(drawLine.w / 2);
            } else if (textDrawHorizontal == TextDrawHorizontal.Right) {
                d3 = d - (double)drawLine.w;
            }
            for (int j = 0; j < drawLine.elements.size(); ++j) {
                DrawElement drawElement = drawLine.elements.get(j);
                d5 = drawLine.h / 2 - drawElement.h / 2;
                String string = this.elemText = this.scrambleVal > 0.0f ? drawElement.scrambleText : drawElement.text;
                if (drawElement.isImage && drawElement.tex != null) {
                    if (bl && drawElement.isTextImage) {
                        SpriteRenderer.instance.renderi(drawElement.tex, (int)(d3 - 1.0), (int)(d4 + d5 - 1.0), drawElement.w, drawElement.h, this.outlineR, this.outlineG, this.outlineB, f5, null);
                        SpriteRenderer.instance.renderi(drawElement.tex, (int)(d3 + 1.0), (int)(d4 + d5 + 1.0), drawElement.w, drawElement.h, this.outlineR, this.outlineG, this.outlineB, f5, null);
                        SpriteRenderer.instance.renderi(drawElement.tex, (int)(d3 - 1.0), (int)(d4 + d5 + 1.0), drawElement.w, drawElement.h, this.outlineR, this.outlineG, this.outlineB, f5, null);
                        SpriteRenderer.instance.renderi(drawElement.tex, (int)(d3 + 1.0), (int)(d4 + d5 - 1.0), drawElement.w, drawElement.h, this.outlineR, this.outlineG, this.outlineB, f5, null);
                    }
                    if (drawElement.useColor) {
                        SpriteRenderer.instance.renderi(drawElement.tex, (int)d3, (int)(d4 + d5), drawElement.w, drawElement.h, drawElement.R, drawElement.G, drawElement.B, f4, null);
                    } else if (drawElement.isTextImage) {
                        SpriteRenderer.instance.renderi(drawElement.tex, (int)d3, (int)(d4 + d5), drawElement.w, drawElement.h, f, f2, f3, f4, null);
                    } else {
                        SpriteRenderer.instance.renderi(drawElement.tex, (int)d3, (int)(d4 + d5), drawElement.w, drawElement.h, 1.0f, 1.0f, 1.0f, f4, null);
                    }
                } else if (drawElement.useFont && drawElement.font != null) {
                    if (bl) {
                        drawElement.font.drawString((float)(d3 - 1.0), (float)(d4 + d5 - 1.0), this.elemText, this.outlineR, this.outlineG, this.outlineB, f5);
                        drawElement.font.drawString((float)(d3 + 1.0), (float)(d4 + d5 + 1.0), this.elemText, this.outlineR, this.outlineG, this.outlineB, f5);
                        drawElement.font.drawString((float)(d3 - 1.0), (float)(d4 + d5 + 1.0), this.elemText, this.outlineR, this.outlineG, this.outlineB, f5);
                        drawElement.font.drawString((float)(d3 + 1.0), (float)(d4 + d5 - 1.0), this.elemText, this.outlineR, this.outlineG, this.outlineB, f5);
                    }
                    drawElement.font.drawString((float)d3, (float)(d4 + d5), this.elemText, f, f2, f3, f4);
                } else if (this.defaultFont != null) {
                    if (bl) {
                        this.defaultFont.drawString((float)(d3 - 1.0), (float)(d4 + d5 - 1.0), this.elemText, this.outlineR, this.outlineG, this.outlineB, f5);
                        this.defaultFont.drawString((float)(d3 + 1.0), (float)(d4 + d5 + 1.0), this.elemText, this.outlineR, this.outlineG, this.outlineB, f5);
                        this.defaultFont.drawString((float)(d3 - 1.0), (float)(d4 + d5 + 1.0), this.elemText, this.outlineR, this.outlineG, this.outlineB, f5);
                        this.defaultFont.drawString((float)(d3 + 1.0), (float)(d4 + d5 - 1.0), this.elemText, this.outlineR, this.outlineG, this.outlineB, f5);
                    }
                    if (drawElement.useColor) {
                        this.defaultFont.drawString((float)d3, (float)(d4 + d5), this.elemText, drawElement.R, drawElement.G, drawElement.B, f4);
                    } else {
                        this.defaultFont.drawString((float)d3, (float)(d4 + d5), this.elemText, f, f2, f3, f4);
                    }
                }
                d3 += (double)drawElement.w;
            }
            d4 += (double)drawLine.h;
        }
    }

    private static final class DrawLine {
        private final ArrayList<DrawElement> elements = new ArrayList();
        private int h = 0;
        private int w = 0;
        private int charW = 0;

        private DrawLine() {
        }

        private void addElement(DrawElement drawElement) {
            this.elements.add(drawElement);
        }
    }

    private static final class DrawElement {
        private String text = "";
        private String scrambleText = "";
        private float currentScrambleVal = 0.0f;
        private UIFont f = UIFont.AutoNormSmall;
        private AngelCodeFont font = null;
        private float R = 1.0f;
        private float G = 1.0f;
        private float B = 1.0f;
        private int w = 0;
        private int h = 0;
        private boolean isImage = false;
        private boolean useFont = false;
        private boolean useColor = false;
        private Texture tex = null;
        private boolean isTextImage = false;
        private int charWidth = 0;

        private DrawElement() {
        }

        private void reset() {
            this.text = "";
            this.scrambleText = "";
            this.f = UIFont.AutoNormSmall;
            this.font = null;
            this.R = 1.0f;
            this.G = 1.0f;
            this.B = 1.0f;
            this.w = 0;
            this.h = 0;
            this.isImage = false;
            this.useFont = false;
            this.useColor = false;
            this.tex = null;
            this.isTextImage = false;
            this.charWidth = 0;
        }

        private void addText(String string) {
            this.text = this.text + string;
            this.charWidth = this.text.length();
        }

        private void scrambleText(float f) {
            if (f != this.currentScrambleVal) {
                this.currentScrambleVal = f;
                int n = (int)(f * 100.0f);
                String[] stringArray = this.text.split("\\s+");
                this.scrambleText = "";
                for (String string : stringArray) {
                    int n2 = Rand.Next(100);
                    if (n2 > n) {
                        this.scrambleText = this.scrambleText + string + " ";
                        continue;
                    }
                    char[] cArray = new char[string.length()];
                    Arrays.fill(cArray, ".".charAt(0));
                    this.scrambleText = this.scrambleText + new String(cArray) + " ";
                }
            }
        }

        private void trim() {
            this.text = this.text.trim();
        }

        private DrawElement softclone() {
            DrawElement drawElement = new DrawElement();
            if (this.useColor) {
                drawElement.R = this.R;
                drawElement.G = this.G;
                drawElement.B = this.B;
                drawElement.useColor = this.useColor;
            }
            if (this.useFont) {
                drawElement.f = this.f;
                drawElement.font = this.font;
                drawElement.useFont = this.useFont;
            }
            return drawElement;
        }
    }

    private static final class RenderBatch {
        int playerNum;
        TextDrawObject element;
        TextDrawHorizontal horz;
        double x;
        double y;
        float r;
        float g;
        float b;
        float a;
        boolean drawOutlines;

        private RenderBatch() {
        }
    }
}

