/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.util.Stack;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIFont;

public final class TextBox
extends UIElement {
    public boolean ResizeParent;
    UIFont font;
    Stack<String> Lines = new Stack();
    String Text;
    public boolean Centred = false;

    public TextBox(UIFont uIFont, int n, int n2, int n3, String string) {
        this.font = uIFont;
        this.x = n;
        this.y = n2;
        this.Text = string;
        this.width = n3;
        this.Paginate();
    }

    @Override
    public void onresize() {
        this.Paginate();
    }

    @Override
    public void render() {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        super.render();
        this.Paginate();
        int n = 0;
        for (String string : this.Lines) {
            if (this.Centred) {
                TextManager.instance.DrawStringCentre(this.font, (double)this.getAbsoluteX().intValue() + this.getWidth() / 2.0, this.getAbsoluteY().intValue() + n, string, 1.0, 1.0, 1.0, 1.0);
            } else {
                TextManager.instance.DrawString(this.font, this.getAbsoluteX().intValue(), this.getAbsoluteY().intValue() + n, string, 1.0, 1.0, 1.0, 1.0);
            }
            n += TextManager.instance.MeasureStringY(this.font, (String)this.Lines.get(0));
        }
        this.setHeight(n);
    }

    @Override
    public void update() {
        this.Paginate();
        int n = 0;
        for (String string : this.Lines) {
            n += TextManager.instance.MeasureStringY(this.font, (String)this.Lines.get(0));
        }
        this.setHeight(n);
    }

    private void Paginate() {
        String[] stringArray;
        int n = 0;
        this.Lines.clear();
        block0: for (String string : stringArray = this.Text.split("<br>")) {
            if (string.length() == 0) {
                this.Lines.add(" ");
                continue;
            }
            do {
                int n2;
                int n3;
                int n4;
                if ((n4 = (n3 = string.indexOf(" ", n + 1))) == -1) {
                    n4 = string.length();
                }
                if ((double)(n2 = TextManager.instance.MeasureStringX(this.font, string.substring(0, n4))) >= this.getWidth()) {
                    var10_10 = string.substring(0, n);
                    string = string.substring(n + 1);
                    this.Lines.add(var10_10);
                    n3 = 0;
                } else if (n3 == -1) {
                    var10_10 = string;
                    this.Lines.add(var10_10);
                    continue block0;
                }
                n = n3;
            } while (string.length() > 0);
        }
    }

    public void SetText(String string) {
        this.Text = string;
        this.Paginate();
    }
}

