/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import zombie.GameTime;
import zombie.SoundManager;
import zombie.core.Core;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.ui.HUDButton;
import zombie.ui.UIElement;

public final class SpeedControls
extends UIElement {
    public static SpeedControls instance = null;
    public int CurrentSpeed = 1;
    public int SpeedBeforePause = 1;
    public float MultiBeforePause = 1.0f;
    float alpha = 1.0f;
    boolean MouseOver = false;
    public static HUDButton Play;
    public static HUDButton Pause;
    public static HUDButton FastForward;
    public static HUDButton FasterForward;
    public static HUDButton Wait;

    public SpeedControls() {
        this.x = 0.0;
        this.y = 0.0;
        int n = 2;
        Pause = new SCButton("Pause", 1.0f, 0.0f, "media/ui/Time_Pause_Off.png", "media/ui/Time_Pause_On.png", (UIElement)this);
        Play = new SCButton("Play", (float)(SpeedControls.Pause.x + (double)SpeedControls.Pause.width + (double)n), 0.0f, "media/ui/Time_Play_Off.png", "media/ui/Time_Play_On.png", (UIElement)this);
        FastForward = new SCButton("Fast Forward x 1", (float)(SpeedControls.Play.x + (double)SpeedControls.Play.width + (double)n), 0.0f, "media/ui/Time_FFwd1_Off.png", "media/ui/Time_FFwd1_On.png", (UIElement)this);
        FasterForward = new SCButton("Fast Forward x 2", (float)(SpeedControls.FastForward.x + (double)SpeedControls.FastForward.width + (double)n), 0.0f, "media/ui/Time_FFwd2_Off.png", "media/ui/Time_FFwd2_On.png", (UIElement)this);
        Wait = new SCButton("Wait", (float)(SpeedControls.FasterForward.x + (double)SpeedControls.FasterForward.width + (double)n), 0.0f, "media/ui/Time_Wait_Off.png", "media/ui/Time_Wait_On.png", (UIElement)this);
        this.width = (float)((int)SpeedControls.Wait.x) + SpeedControls.Wait.width;
        this.height = SpeedControls.Wait.height;
        this.AddChild(Pause);
        this.AddChild(Play);
        this.AddChild(FastForward);
        this.AddChild(FasterForward);
        this.AddChild(Wait);
    }

    @Override
    public void ButtonClicked(String string) {
        GameTime.instance.setMultiplier(1.0f);
        if ("Pause".equals(string)) {
            if (this.CurrentSpeed > 0) {
                this.SetCurrentGameSpeed(0);
            } else {
                this.SetCurrentGameSpeed(5);
            }
        }
        if ("Play".equals(string)) {
            this.SetCurrentGameSpeed(1);
            GameTime.instance.setMultiplier(1.0f);
        }
        if ("Fast Forward x 1".equals(string)) {
            this.SetCurrentGameSpeed(2);
            GameTime.instance.setMultiplier(5.0f);
        }
        if ("Fast Forward x 2".equals(string)) {
            this.SetCurrentGameSpeed(3);
            GameTime.instance.setMultiplier(20.0f);
        }
        if ("Wait".equals(string)) {
            this.SetCurrentGameSpeed(4);
            GameTime.instance.setMultiplier(40.0f);
        }
    }

    public int getCurrentGameSpeed() {
        if (GameClient.bClient || GameServer.bServer) {
            return 1;
        }
        return this.CurrentSpeed;
    }

    public void SetCorrectIconStates() {
        if (this.CurrentSpeed == 0) {
            super.ButtonClicked("Pause");
        }
        if (this.CurrentSpeed == 1) {
            super.ButtonClicked("Play");
        }
        if (GameTime.instance.getTrueMultiplier() == 5.0f) {
            super.ButtonClicked("Fast Forward x 1");
        }
        if (GameTime.instance.getTrueMultiplier() == 20.0f) {
            super.ButtonClicked("Fast Forward x 2");
        }
        if (GameTime.instance.getTrueMultiplier() == 40.0f) {
            super.ButtonClicked("Wait");
        }
    }

    public void SetCurrentGameSpeed(int n) {
        if (this.CurrentSpeed > 0 && n == 0) {
            SoundManager.instance.pauseSoundAndMusic();
            SoundManager.instance.setMusicState("PauseMenu");
        } else if (this.CurrentSpeed == 0 && n > 0) {
            SoundManager.instance.setMusicState("InGame");
            SoundManager.instance.resumeSoundAndMusic();
        }
        GameTime.instance.setMultiplier(1.0f);
        if (n == 0) {
            this.SpeedBeforePause = this.CurrentSpeed;
            this.MultiBeforePause = GameTime.instance.getMultiplier();
        }
        if (n == 5) {
            n = this.SpeedBeforePause;
            GameTime.instance.setMultiplier(this.MultiBeforePause);
        }
        this.CurrentSpeed = n;
        this.SetCorrectIconStates();
    }

    @Override
    public Boolean onMouseMove(double d, double d2) {
        if (!this.isVisible().booleanValue()) {
            return false;
        }
        this.MouseOver = true;
        super.onMouseMove(d, d2);
        this.SetCorrectIconStates();
        return Boolean.TRUE;
    }

    @Override
    public void onMouseMoveOutside(double d, double d2) {
        super.onMouseMoveOutside(d, d2);
        this.MouseOver = false;
        this.SetCorrectIconStates();
    }

    @Override
    public void render() {
        super.render();
        if ("Tutorial".equals(Core.GameMode)) {
            Pause.setVisible(false);
            Play.setVisible(false);
            FastForward.setVisible(false);
            FasterForward.setVisible(false);
            Wait.setVisible(false);
        }
        this.SetCorrectIconStates();
    }

    @Override
    public void update() {
        super.update();
        this.SetCorrectIconStates();
    }

    public static final class SCButton
    extends HUDButton {
        private static final int BORDER = 3;

        public SCButton(String string, float f, float f2, String string2, String string3, UIElement uIElement) {
            super(string, (double)f, (double)f2, string2, string3, uIElement);
            this.width += 6.0f;
            this.height += 6.0f;
        }

        @Override
        public void render() {
            int n = 3;
            if (this.clicked) {
                ++n;
            }
            this.DrawTextureScaledCol(null, 0.0, this.clicked ? 1.0 : 0.0, this.width, this.height, 0.0, 0.0, 0.0, 0.5);
            if (this.mouseOver || this.name.equals(this.display.getClickedValue())) {
                this.DrawTextureScaled(this.highlight, 3.0, n, this.highlight.getWidth(), this.highlight.getHeight(), this.clickedalpha);
            } else {
                this.DrawTextureScaled(this.texture, 3.0, n, this.texture.getWidth(), this.texture.getHeight(), this.notclickedAlpha);
            }
            if (this.overicon != null) {
                this.DrawTextureScaled(this.overicon, 3.0, n, this.overicon.getWidth(), this.overicon.getHeight(), 1.0);
            }
        }
    }
}

