/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import zombie.core.Color;
import zombie.core.textures.Texture;
import zombie.input.Mouse;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIEventHandler;
import zombie.ui.UITextBox2;

public final class ScrollBar
extends UIElement {
    public final Color BackgroundColour = new Color(255, 255, 255, 255);
    public final Color ButtonColour = new Color(255, 255, 255, 127);
    public final Color ButtonHighlightColour = new Color(255, 255, 255, 255);
    public boolean IsVerticle = true;
    private int FullLength = 114;
    private int InsideLength = 100;
    private int EndLength = 7;
    private float ButtonInsideLength = 30.0f;
    private int ButtonEndLength = 6;
    private int Thickness = 10;
    private int ButtonThickness = 9;
    private float ButtonOffset = 40.0f;
    private int MouseDragStartPos = 0;
    private float ButtonDragStartPos = 0.0f;
    private Texture BackVertical;
    private Texture TopVertical;
    private Texture BottomVertical;
    private Texture ButtonBackVertical;
    private Texture ButtonTopVertical;
    private Texture ButtonBottomVertical;
    private Texture BackHorizontal;
    private Texture LeftHorizontal;
    private Texture RightHorizontal;
    private Texture ButtonBackHorizontal;
    private Texture ButtonLeftHorizontal;
    private Texture ButtonRightHorizontal;
    private boolean mouseOver = false;
    private boolean BeingDragged = false;
    private UITextBox2 ParentTextBox = null;
    UIEventHandler messageParent;
    private String name;

    public ScrollBar(String string, UIEventHandler uIEventHandler, int n, int n2, int n3, boolean bl) {
        this.messageParent = uIEventHandler;
        this.name = string;
        this.x = n;
        this.y = n2;
        this.FullLength = n3;
        this.InsideLength = n3 - this.EndLength * 2;
        this.IsVerticle = true;
        this.width = this.Thickness;
        this.height = n3;
        this.ButtonInsideLength = this.height - (float)(this.ButtonEndLength * 2);
        this.ButtonOffset = 0.0f;
        this.BackVertical = Texture.getSharedTexture("media/ui/ScrollbarV_Bkg_Middle.png");
        this.TopVertical = Texture.getSharedTexture("media/ui/ScrollbarV_Bkg_Top.png");
        this.BottomVertical = Texture.getSharedTexture("media/ui/ScrollbarV_Bkg_Bottom.png");
        this.ButtonBackVertical = Texture.getSharedTexture("media/ui/ScrollbarV_Middle.png");
        this.ButtonTopVertical = Texture.getSharedTexture("media/ui/ScrollbarV_Top.png");
        this.ButtonBottomVertical = Texture.getSharedTexture("media/ui/ScrollbarV_Bottom.png");
        this.BackHorizontal = Texture.getSharedTexture("media/ui/ScrollbarH_Bkg_Middle.png");
        this.LeftHorizontal = Texture.getSharedTexture("media/ui/ScrollbarH_Bkg_Bottom.png");
        this.RightHorizontal = Texture.getSharedTexture("media/ui/ScrollbarH_Bkg_Top.png");
        this.ButtonBackHorizontal = Texture.getSharedTexture("media/ui/ScrollbarH_Middle.png");
        this.ButtonLeftHorizontal = Texture.getSharedTexture("media/ui/ScrollbarH_Bottom.png");
        this.ButtonRightHorizontal = Texture.getSharedTexture("media/ui/ScrollbarH_Top.png");
    }

    public void SetParentTextBox(UITextBox2 uITextBox2) {
        this.ParentTextBox = uITextBox2;
    }

    @Override
    public void setHeight(double d) {
        super.setHeight(d);
        this.FullLength = (int)d;
        this.InsideLength = (int)d - this.EndLength * 2;
    }

    @Override
    public void render() {
        if (this.IsVerticle) {
            this.DrawTextureScaledCol(this.TopVertical, 0.0, 0.0, this.Thickness, this.EndLength, this.BackgroundColour);
            this.DrawTextureScaledCol(this.BackVertical, 0.0, 0 + this.EndLength, this.Thickness, this.InsideLength, this.BackgroundColour);
            this.DrawTextureScaledCol(this.BottomVertical, 0.0, 0 + this.EndLength + this.InsideLength, this.Thickness, this.EndLength, this.BackgroundColour);
            Color color = this.mouseOver ? this.ButtonHighlightColour : this.ButtonColour;
            this.DrawTextureScaledCol(this.ButtonTopVertical, 1.0, (int)this.ButtonOffset + 1, this.ButtonThickness, this.ButtonEndLength, color);
            this.DrawTextureScaledCol(this.ButtonBackVertical, 1.0, (int)this.ButtonOffset + 1 + this.ButtonEndLength, this.ButtonThickness, this.ButtonInsideLength, color);
            this.DrawTextureScaledCol(this.ButtonBottomVertical, 1.0, (float)((int)this.ButtonOffset + 1 + this.ButtonEndLength) + this.ButtonInsideLength, this.ButtonThickness, this.ButtonEndLength, color);
        }
    }

    @Override
    public Boolean onMouseMove(double d, double d2) {
        this.mouseOver = true;
        return Boolean.TRUE;
    }

    @Override
    public void onMouseMoveOutside(double d, double d2) {
        this.mouseOver = false;
    }

    @Override
    public Boolean onMouseUp(double d, double d2) {
        this.BeingDragged = false;
        return Boolean.FALSE;
    }

    @Override
    public Boolean onMouseDown(double d, double d2) {
        boolean bl = false;
        if (d2 >= (double)this.ButtonOffset && d2 <= (double)(this.ButtonOffset + this.ButtonInsideLength + (float)(this.ButtonEndLength * 2))) {
            bl = true;
        }
        if (bl) {
            this.BeingDragged = true;
            this.MouseDragStartPos = Mouse.getY();
            this.ButtonDragStartPos = this.ButtonOffset;
        } else {
            this.ButtonOffset = (float)(d2 - (double)((this.ButtonInsideLength + (float)(this.ButtonEndLength * 2)) / 2.0f));
        }
        if (this.ButtonOffset < 0.0f) {
            this.ButtonOffset = 0.0f;
        }
        if (this.ButtonOffset > (float)this.getHeight().intValue() - (this.ButtonInsideLength + (float)(this.ButtonEndLength * 2)) - 1.0f) {
            this.ButtonOffset = (float)this.getHeight().intValue() - (this.ButtonInsideLength + (float)(this.ButtonEndLength * 2)) - 1.0f;
        }
        return Boolean.FALSE;
    }

    @Override
    public void update() {
        int n;
        super.update();
        if (this.BeingDragged) {
            n = this.MouseDragStartPos - Mouse.getY();
            this.ButtonOffset = this.ButtonDragStartPos - (float)n;
            if (this.ButtonOffset < 0.0f) {
                this.ButtonOffset = 0.0f;
            }
            if (this.ButtonOffset > (float)this.getHeight().intValue() - (this.ButtonInsideLength + (float)(this.ButtonEndLength * 2)) - 0.0f) {
                this.ButtonOffset = (float)this.getHeight().intValue() - (this.ButtonInsideLength + (float)(this.ButtonEndLength * 2)) - 0.0f;
            }
            if (!Mouse.isButtonDown(0)) {
                this.BeingDragged = false;
            }
        }
        if (this.ParentTextBox != null) {
            n = TextManager.instance.getFontFromEnum(this.ParentTextBox.font).getLineHeight();
            if (this.ParentTextBox.Lines.size() > this.ParentTextBox.NumVisibleLines) {
                if (this.ParentTextBox.Lines.size() > 0) {
                    int n2 = this.ParentTextBox.NumVisibleLines;
                    if (n2 * n > this.ParentTextBox.getHeight().intValue() - this.ParentTextBox.getInset() * 2) {
                        --n2;
                    }
                    float f = (float)n2 / (float)this.ParentTextBox.Lines.size();
                    this.ButtonInsideLength = (int)((float)this.getHeight().intValue() * f) - this.ButtonEndLength * 2;
                    this.ButtonInsideLength = Math.max(this.ButtonInsideLength, 0.0f);
                    float f2 = this.ButtonInsideLength + (float)(this.ButtonEndLength * 2);
                    if (this.ButtonOffset < 0.0f) {
                        this.ButtonOffset = 0.0f;
                    }
                    if (this.ButtonOffset > (float)this.getHeight().intValue() - f2 - 0.0f) {
                        this.ButtonOffset = (float)this.getHeight().intValue() - f2 - 0.0f;
                    }
                    float f3 = this.ButtonOffset / (float)this.getHeight().intValue();
                    this.ParentTextBox.TopLineIndex = (int)((float)this.ParentTextBox.Lines.size() * f3);
                    int n3 = this.getHeight().intValue();
                    int n4 = n3 - (int)f2;
                    int n5 = n * (this.ParentTextBox.Lines.size() - n2);
                    float f4 = (float)n4 / (float)n5;
                    float f5 = this.ButtonOffset / f4;
                    this.ParentTextBox.TopLineIndex = (int)(f5 / (float)n);
                } else {
                    this.ButtonOffset = 0.0f;
                    this.ButtonInsideLength = this.getHeight().intValue() - this.ButtonEndLength * 2;
                    this.ParentTextBox.TopLineIndex = 0;
                }
            } else {
                this.ButtonOffset = 0.0f;
                this.ButtonInsideLength = this.getHeight().intValue() - this.ButtonEndLength * 2;
                this.ParentTextBox.TopLineIndex = 0;
            }
        }
    }

    public void scrollToBottom() {
        this.ButtonOffset = (float)this.getHeight().intValue() - (this.ButtonInsideLength + (float)(this.ButtonEndLength * 2)) - 0.0f;
    }
}

