/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import se.krka.kahlua.vm.KahluaTable;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.iso.Vector2;
import zombie.ui.UIElement;

public final class RadialProgressBar
extends UIElement {
    private static final boolean DEBUG = false;
    Texture radialTexture;
    float deltaValue = 1.0f;
    private static final RadSegment[] segments = new RadSegment[8];
    private final float PIx2 = 6.283185f;
    private final float PiOver2 = 1.570796f;

    public RadialProgressBar(KahluaTable kahluaTable, Texture texture) {
        super(kahluaTable);
        this.radialTexture = texture;
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public void render() {
        float f;
        float f2;
        if (!this.enabled) {
            return;
        }
        if (!this.isVisible().booleanValue()) {
            return;
        }
        if (this.Parent != null && this.Parent.maxDrawHeight != -1 && (double)this.Parent.maxDrawHeight <= this.y) {
            return;
        }
        if (this.radialTexture == null) {
            return;
        }
        float f3 = (float)(this.x + this.xScroll + this.getAbsoluteX() + (double)this.radialTexture.offsetX);
        float f4 = (float)(this.y + this.yScroll + this.getAbsoluteY() + (double)this.radialTexture.offsetY);
        float f5 = this.radialTexture.xStart;
        float f6 = this.radialTexture.yStart;
        float f7 = this.radialTexture.xEnd - this.radialTexture.xStart;
        float f8 = this.radialTexture.yEnd - this.radialTexture.yStart;
        float f9 = f3 + 0.5f * this.width;
        float f10 = f4 + 0.5f * this.height;
        float f11 = this.deltaValue;
        float f12 = f11 * 6.283185f - 1.570796f;
        Vector2 vector22 = new Vector2((float)Math.cos(f12), (float)Math.sin(f12));
        if (Math.abs(this.width / 2.0f / vector22.x) < Math.abs(this.height / 2.0f / vector22.y)) {
            f2 = Math.abs(this.width / 2.0f / vector22.x);
            f = Math.abs(0.5f / vector22.x);
        } else {
            f2 = Math.abs(this.height / 2.0f / vector22.y);
            f = Math.abs(0.5f / vector22.y);
        }
        float f13 = f9 + vector22.x * f2;
        float f14 = f10 + vector22.y * f2;
        float f15 = 0.5f + vector22.x * f;
        float f16 = 0.5f + vector22.y * f;
        int n = (int)(f11 * 8.0f);
        if (f11 <= 0.0f) {
            n = -1;
        }
        for (int i = 0; i < segments.length; ++i) {
            RadSegment radSegment = segments[i];
            if (radSegment == null || i > n) continue;
            if (i != n) {
                SpriteRenderer.instance.renderPoly(this.radialTexture, f3 + radSegment.vertex[0].x * (float)this.radialTexture.getWidth(), f4 + radSegment.vertex[0].y * (float)this.radialTexture.getHeight(), f3 + radSegment.vertex[1].x * (float)this.radialTexture.getWidth(), f4 + radSegment.vertex[1].y * (float)this.radialTexture.getHeight(), f3 + radSegment.vertex[2].x * (float)this.radialTexture.getWidth(), f4 + radSegment.vertex[2].y * (float)this.radialTexture.getHeight(), f3 + radSegment.vertex[2].x * (float)this.radialTexture.getWidth(), f4 + radSegment.vertex[2].y * (float)this.radialTexture.getHeight(), 1.0f, 1.0f, 1.0f, 1.0f, f5 + radSegment.uv[0].x * f7, f6 + radSegment.uv[0].y * f8, f5 + radSegment.uv[1].x * f7, f6 + radSegment.uv[1].y * f8, f5 + radSegment.uv[2].x * f7, f6 + radSegment.uv[2].y * f8, f5 + radSegment.uv[2].x * f7, f6 + radSegment.uv[2].y * f8);
                continue;
            }
            SpriteRenderer.instance.renderPoly(this.radialTexture, f3 + radSegment.vertex[0].x * (float)this.radialTexture.getWidth(), f4 + radSegment.vertex[0].y * (float)this.radialTexture.getHeight(), f13, f14, f3 + radSegment.vertex[2].x * (float)this.radialTexture.getWidth(), f4 + radSegment.vertex[2].y * (float)this.radialTexture.getHeight(), f3 + radSegment.vertex[2].x * (float)this.radialTexture.getWidth(), f4 + radSegment.vertex[2].y * (float)this.radialTexture.getHeight(), 1.0f, 1.0f, 1.0f, 1.0f, f5 + radSegment.uv[0].x * f7, f6 + radSegment.uv[0].y * f8, f5 + f15 * f7, f6 + f16 * f8, f5 + radSegment.uv[2].x * f7, f6 + radSegment.uv[2].y * f8, f5 + radSegment.uv[2].x * f7, f6 + radSegment.uv[2].y * f8);
        }
    }

    public void setValue(float f) {
        this.deltaValue = PZMath.clamp(f, 0.0f, 1.0f);
    }

    public float getValue() {
        return this.deltaValue;
    }

    public void setTexture(Texture texture) {
        this.radialTexture = texture;
    }

    public Texture getTexture() {
        return this.radialTexture;
    }

    private void printTexture(Texture texture) {
        DebugLog.log("xStart = " + texture.xStart);
        DebugLog.log("yStart = " + texture.yStart);
        DebugLog.log("offX = " + texture.offsetX);
        DebugLog.log("offY = " + texture.offsetY);
        DebugLog.log("xEnd = " + texture.xEnd);
        DebugLog.log("yEnd = " + texture.yEnd);
        DebugLog.log("Width = " + texture.getWidth());
        DebugLog.log("Height = " + texture.getHeight());
        DebugLog.log("RealWidth = " + texture.getRealWidth());
        DebugLog.log("RealHeight = " + texture.getRealHeight());
        DebugLog.log("OrigWidth = " + texture.getWidthOrig());
        DebugLog.log("OrigHeight = " + texture.getHeightOrig());
    }

    static {
        RadialProgressBar.segments[0] = new RadSegment();
        segments[0].set(0.5f, 0.0f, 1.0f, 0.0f, 0.5f, 0.5f);
        RadialProgressBar.segments[1] = new RadSegment();
        segments[1].set(1.0f, 0.0f, 1.0f, 0.5f, 0.5f, 0.5f);
        RadialProgressBar.segments[2] = new RadSegment();
        segments[2].set(1.0f, 0.5f, 1.0f, 1.0f, 0.5f, 0.5f);
        RadialProgressBar.segments[3] = new RadSegment();
        segments[3].set(1.0f, 1.0f, 0.5f, 1.0f, 0.5f, 0.5f);
        RadialProgressBar.segments[4] = new RadSegment();
        segments[4].set(0.5f, 1.0f, 0.0f, 1.0f, 0.5f, 0.5f);
        RadialProgressBar.segments[5] = new RadSegment();
        segments[5].set(0.0f, 1.0f, 0.0f, 0.5f, 0.5f, 0.5f);
        RadialProgressBar.segments[6] = new RadSegment();
        segments[6].set(0.0f, 0.5f, 0.0f, 0.0f, 0.5f, 0.5f);
        RadialProgressBar.segments[7] = new RadSegment();
        segments[7].set(0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f);
    }

    private static class RadSegment {
        Vector2[] vertex = new Vector2[3];
        Vector2[] uv = new Vector2[3];

        private RadSegment() {
        }

        private RadSegment set(int n, float f, float f2, float f3, float f4) {
            this.vertex[n] = new Vector2(f, f2);
            this.uv[n] = new Vector2(f3, f4);
            return this;
        }

        private void set(float f, float f2, float f3, float f4, float f5, float f6) {
            this.vertex[0] = new Vector2(f, f2);
            this.vertex[1] = new Vector2(f3, f4);
            this.vertex[2] = new Vector2(f5, f6);
            this.uv[0] = new Vector2(f, f2);
            this.uv[1] = new Vector2(f3, f4);
            this.uv[2] = new Vector2(f5, f6);
        }
    }
}

