/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.util.ArrayList;
import zombie.core.SpriteRenderer;
import zombie.core.fonts.AngelCodeFont;
import zombie.core.textures.Texture;
import zombie.input.JoypadManager;
import zombie.input.Mouse;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIFont;
import zombie.ui.UITransition;
import zombie.util.StringUtils;

public final class RadialMenu
extends UIElement {
    protected int outerRadius = 200;
    protected int innerRadius = 100;
    protected ArrayList<Slice> slices = new ArrayList();
    protected int highlight = -1;
    protected int joypad = -1;
    protected UITransition transition = new UITransition();
    protected UITransition select = new UITransition();
    protected UITransition deselect = new UITransition();
    protected int selectIndex = -1;
    protected int deselectIndex = -1;

    public RadialMenu(int n, int n2, int n3, int n4) {
        this.setX(n);
        this.setY(n2);
        this.setWidth(n4 * 2);
        this.setHeight(n4 * 2);
        this.innerRadius = n3;
        this.outerRadius = n4;
    }

    @Override
    public void update() {
    }

    @Override
    public void render() {
        Slice slice;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        float f;
        if (!this.isVisible().booleanValue()) {
            return;
        }
        this.transition.setIgnoreUpdateTime(true);
        this.transition.setFadeIn(true);
        this.transition.update();
        if (this.slices.isEmpty()) {
            return;
        }
        float f2 = this.transition.fraction();
        float f3 = (float)this.innerRadius * 0.85f + (float)this.innerRadius * f2 * 0.15f;
        float f4 = (float)this.outerRadius * 0.85f + (float)this.outerRadius * f2 * 0.15f;
        for (int i = 0; i < 48; ++i) {
            f = 7.5f;
            double d7 = Math.toRadians((float)i * f);
            double d8 = Math.toRadians((float)(i + 1) * f);
            double d9 = this.x + (double)(this.width / 2.0f);
            d6 = this.y + (double)(this.height / 2.0f);
            double d10 = this.x + (double)(this.width / 2.0f);
            d5 = this.y + (double)(this.height / 2.0f);
            d4 = this.x + (double)(this.width / 2.0f) + (double)(f4 * (float)Math.cos(d7));
            d3 = this.y + (double)(this.height / 2.0f) + (double)(f4 * (float)Math.sin(d7));
            d2 = this.x + (double)(this.width / 2.0f) + (double)(f4 * (float)Math.cos(d8));
            d = this.y + (double)(this.height / 2.0f) + (double)(f4 * (float)Math.sin(d8));
            if (i == 47) {
                d = d5;
            }
            float f5 = 0.1f;
            float f6 = 0.1f;
            float f7 = 0.1f;
            float f8 = 0.45f + 0.45f * f2;
            SpriteRenderer.instance.renderPoly((float)d9, (float)d6, (float)d4, (float)d3, (float)d2, (float)d, (float)d10, (float)d5, f5, f6, f7, f8);
        }
        float f9 = 360.0f / (float)Math.max(this.slices.size(), 2);
        f = this.slices.size() == 1 ? 0.0f : 1.5f;
        int n = this.highlight;
        if (n == -1) {
            n = this.joypad != -1 ? this.getSliceIndexFromJoypad(this.joypad) : this.getSliceIndexFromMouse(Mouse.getXA() - this.getAbsoluteX().intValue(), Mouse.getYA() - this.getAbsoluteY().intValue());
        }
        if ((slice = this.getSlice(n)) != null && slice.isEmpty()) {
            n = -1;
        }
        if (n != this.selectIndex) {
            this.select.reset();
            this.select.setIgnoreUpdateTime(true);
            if (this.selectIndex != -1) {
                this.deselectIndex = this.selectIndex;
                this.deselect.reset();
                this.deselect.setFadeIn(false);
                this.deselect.init(66.666664f, true);
            }
            this.selectIndex = n;
        }
        this.select.update();
        this.deselect.update();
        float f10 = this.getStartAngle() - 180.0f;
        for (int i = 0; i < this.slices.size(); ++i) {
            int n2 = Math.max(6, 48 / Math.max(this.slices.size(), 2));
            for (int j = 0; j < n2; ++j) {
                d6 = Math.toRadians(f10 + (float)i * f9 + (float)j * f9 / (float)n2 + (j == 0 ? f : 0.0f));
                double d11 = Math.toRadians(f10 + (float)i * f9 + (float)(j + 1) * f9 / (float)n2 - (j == n2 - 1 ? f : 0.0f));
                d5 = Math.toRadians(f10 + (float)i * f9 + (float)j * f9 / (float)n2 + (j == 0 ? f / 2.0f : 0.0f));
                d4 = Math.toRadians((double)(f10 + (float)i * f9 + (float)(j + 1) * f9 / (float)n2) - (j == n2 - 1 ? (double)f / 1.5 : 0.0));
                d3 = this.x + (double)(this.width / 2.0f) + (double)(f3 * (float)Math.cos(d6));
                d2 = this.y + (double)(this.height / 2.0f) + (double)(f3 * (float)Math.sin(d6));
                d = this.x + (double)(this.width / 2.0f) + (double)(f3 * (float)Math.cos(d11));
                double d12 = this.y + (double)(this.height / 2.0f) + (double)(f3 * (float)Math.sin(d11));
                double d13 = this.x + (double)(this.width / 2.0f) + (double)(f4 * (float)Math.cos(d5));
                double d14 = this.y + (double)(this.height / 2.0f) + (double)(f4 * (float)Math.sin(d5));
                double d15 = this.x + (double)(this.width / 2.0f) + (double)(f4 * (float)Math.cos(d4));
                double d16 = this.y + (double)(this.height / 2.0f) + (double)(f4 * (float)Math.sin(d4));
                float f11 = 1.0f;
                float f12 = 1.0f;
                float f13 = 1.0f;
                float f14 = 0.025f;
                if (i == n) {
                    f14 = 0.25f + 0.25f * this.select.fraction();
                } else if (i == this.deselectIndex) {
                    f14 = 0.025f + 0.475f * this.deselect.fraction();
                }
                SpriteRenderer.instance.renderPoly((float)d3, (float)d2, (float)d13, (float)d14, (float)d15, (float)d16, (float)d, (float)d12, f11, f12, f13, f14);
            }
            Texture texture = this.slices.get((int)i).texture;
            if (texture == null) continue;
            d6 = Math.toRadians(f10 + (float)i * f9 + f9 / 2.0f);
            float f15 = 0.0f + this.width / 2.0f + (f3 + (f4 - f3) / 2.0f) * (float)Math.cos(d6);
            float f16 = 0.0f + this.height / 2.0f + (f3 + (f4 - f3) / 2.0f) * (float)Math.sin(d6);
            this.DrawTexture(texture, f15 - (float)(texture.getWidth() / 2) - texture.offsetX, f16 - (float)(texture.getHeight() / 2) - texture.offsetY, f2);
        }
        if (slice != null && !StringUtils.isNullOrWhitespace(slice.text)) {
            this.formatTextInsideCircle(slice.text);
        }
    }

    private void formatTextInsideCircle(String string) {
        int n;
        UIFont uIFont = UIFont.Medium;
        AngelCodeFont angelCodeFont = TextManager.instance.getFontFromEnum(uIFont);
        int n2 = angelCodeFont.getLineHeight();
        int n3 = 1;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '\n') continue;
            ++n3;
        }
        if (n3 > 1) {
            int n4;
            n = n3 * n2;
            int n5 = this.getAbsoluteX().intValue() + (int)this.width / 2;
            int n6 = this.getAbsoluteY().intValue() + (int)this.height / 2 - n / 2;
            int n7 = 0;
            for (n4 = 0; n4 < string.length(); ++n4) {
                if (string.charAt(n4) != '\n') continue;
                int n8 = angelCodeFont.getWidth(string, n7, n4);
                angelCodeFont.drawString(n5 - n8 / 2, n6, string, 1.0f, 1.0f, 1.0f, 1.0f, n7, n4 - 1);
                n7 = n4 + 1;
                n6 += n2;
            }
            if (n7 < string.length()) {
                n4 = angelCodeFont.getWidth(string, n7, string.length() - 1);
                angelCodeFont.drawString(n5 - n4 / 2, n6, string, 1.0f, 1.0f, 1.0f, 1.0f, n7, string.length() - 1);
            }
        } else {
            this.DrawTextCentre(uIFont, string, this.width / 2.0f, this.height / 2.0f - (float)(n2 / 2), 1.0, 1.0, 1.0, 1.0);
        }
    }

    public void clear() {
        this.slices.clear();
        this.transition.reset();
        this.transition.init(66.666664f, false);
        this.selectIndex = -1;
        this.deselectIndex = -1;
    }

    public void addSlice(String string, Texture texture) {
        Slice slice = new Slice();
        slice.text = string;
        slice.texture = texture;
        this.slices.add(slice);
    }

    private Slice getSlice(int n) {
        if (n < 0 || n >= this.slices.size()) {
            return null;
        }
        return this.slices.get(n);
    }

    public void setSliceText(int n, String string) {
        Slice slice = this.getSlice(n);
        if (slice != null) {
            slice.text = string;
        }
    }

    public void setSliceTexture(int n, Texture texture) {
        Slice slice = this.getSlice(n);
        if (slice != null) {
            slice.texture = texture;
        }
    }

    private float getStartAngle() {
        float f = 360.0f / (float)Math.max(this.slices.size(), 2);
        return 90.0f - f / 2.0f;
    }

    public int getSliceIndexFromMouse(int n, int n2) {
        float f = 0.0f + this.width / 2.0f;
        float f2 = 0.0f + this.height / 2.0f;
        double d = Math.sqrt(Math.pow((float)n - f, 2.0) + Math.pow((float)n2 - f2, 2.0));
        if (d > (double)this.outerRadius || d < (double)this.innerRadius) {
            return -1;
        }
        double d2 = Math.atan2((float)n2 - f2, (float)n - f) + Math.PI;
        double d3 = Math.toDegrees(d2);
        float f3 = 360.0f / (float)Math.max(this.slices.size(), 2);
        if (d3 < (double)this.getStartAngle()) {
            return (int)((d3 + 360.0 - (double)this.getStartAngle()) / (double)f3);
        }
        return (int)((d3 - (double)this.getStartAngle()) / (double)f3);
    }

    public int getSliceIndexFromJoypad(int n) {
        float f = JoypadManager.instance.getAimingAxisX(n);
        float f2 = JoypadManager.instance.getAimingAxisY(n);
        if (Math.abs(f) > 0.3f || Math.abs(f2) > 0.3f) {
            double d = Math.atan2(-f2, -f);
            double d2 = Math.toDegrees(d);
            float f3 = 360.0f / (float)Math.max(this.slices.size(), 2);
            if (d2 < (double)this.getStartAngle()) {
                return (int)((d2 + 360.0 - (double)this.getStartAngle()) / (double)f3);
            }
            return (int)((d2 - (double)this.getStartAngle()) / (double)f3);
        }
        return -1;
    }

    public void setJoypad(int n) {
        this.joypad = n;
    }

    protected static class Slice {
        public String text;
        public Texture texture;

        protected Slice() {
        }

        boolean isEmpty() {
            return this.text == null && this.texture == null;
        }
    }
}

