/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import zombie.IndieGL;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.SpriteRenderer;
import zombie.core.textures.Texture;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCamera;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LotHeader;
import zombie.iso.RoomDef;
import zombie.network.GameClient;
import zombie.popman.ZombiePopulationManager;
import zombie.ui.UIElement;

public final class RadarPanel
extends UIElement {
    private int playerIndex;
    private float xPos;
    private float yPos;
    private float offx;
    private float offy;
    private float zoom;
    private float draww;
    private float drawh;
    private Texture mask;
    private Texture border;
    private ArrayList<ZombiePos> zombiePos = new ArrayList();
    private ZombiePosPool zombiePosPool = new ZombiePosPool();
    private int zombiePosFrameCount;
    private boolean[] zombiePosOccupied = new boolean[360];

    public RadarPanel(int n) {
        this.setX(IsoCamera.getScreenLeft(n) + 20);
        this.setY(IsoCamera.getScreenTop(n) + IsoCamera.getScreenHeight(n) - 120 - 20);
        this.setWidth(120.0);
        this.setHeight(120.0);
        this.mask = Texture.getSharedTexture("media/ui/RadarMask.png");
        this.border = Texture.getSharedTexture("media/ui/RadarBorder.png");
        this.playerIndex = n;
    }

    @Override
    public void update() {
        int n = 0;
        if (IsoPlayer.players[this.playerIndex] != null && IsoPlayer.players[this.playerIndex].getJoypadBind() != -1) {
            n = -72;
        }
        this.setX(IsoCamera.getScreenLeft(this.playerIndex) + 20);
        this.setY((double)(IsoCamera.getScreenTop(this.playerIndex) + IsoCamera.getScreenHeight(this.playerIndex)) - this.getHeight() - 20.0 + (double)n);
    }

    @Override
    public void render() {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        if (IsoPlayer.players[this.playerIndex] == null) {
            return;
        }
        if (GameClient.bClient) {
            return;
        }
        this.draww = this.getWidth().intValue();
        this.drawh = this.getHeight().intValue();
        this.xPos = IsoPlayer.players[this.playerIndex].getX();
        this.yPos = IsoPlayer.players[this.playerIndex].getY();
        this.offx = this.getAbsoluteX().intValue();
        this.offy = this.getAbsoluteY().intValue();
        this.zoom = 3.0f;
        this.stencilOn();
        SpriteRenderer.instance.render(null, this.offx, this.offy, this.getWidth().intValue(), this.drawh, 0.0f, 0.2f, 0.0f, 0.66f, null);
        this.renderBuildings();
        this.renderRect(this.xPos - 0.5f, this.yPos - 0.5f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.stencilOff();
        this.renderZombies();
        SpriteRenderer.instance.render(this.border, this.offx - 4.0f, this.offy - 4.0f, this.draww + 8.0f, this.drawh + 8.0f, 1.0f, 1.0f, 1.0f, 0.25f, null);
    }

    private void stencilOn() {
        IndieGL.glStencilMask(255);
        IndieGL.glClear(1280);
        IndieGL.enableStencilTest();
        IndieGL.glStencilFunc(519, 128, 255);
        IndieGL.glStencilOp(7680, 7680, 7681);
        IndieGL.enableAlphaTest();
        IndieGL.glAlphaFunc(516, 0.1f);
        IndieGL.glColorMask(false, false, false, false);
        SpriteRenderer.instance.renderi(this.mask, (int)this.x, (int)this.y, (int)this.width, (int)this.height, 1.0f, 1.0f, 1.0f, 1.0f, null);
        IndieGL.glColorMask(true, true, true, true);
        IndieGL.glAlphaFunc(516, 0.0f);
        IndieGL.glStencilFunc(514, 128, 128);
        IndieGL.glStencilOp(7680, 7680, 7680);
    }

    private void stencilOff() {
        IndieGL.glAlphaFunc(519, 0.0f);
        IndieGL.disableStencilTest();
        IndieGL.disableAlphaTest();
        IndieGL.glStencilFunc(519, 255, 255);
        IndieGL.glStencilOp(7680, 7680, 7680);
        IndieGL.glClear(1280);
    }

    private void renderBuildings() {
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.MetaGrid;
        IsoMetaCell[][] isoMetaCellArray = isoMetaGrid.Grid;
        int n = (int)((this.xPos - 100.0f) / 300.0f) - isoMetaGrid.minX;
        int n2 = (int)((this.yPos - 100.0f) / 300.0f) - isoMetaGrid.minY;
        int n3 = (int)((this.xPos + 100.0f) / 300.0f) - isoMetaGrid.minX;
        int n4 = (int)((this.yPos + 100.0f) / 300.0f) - isoMetaGrid.minY;
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        n3 = Math.min(n3, isoMetaCellArray.length - 1);
        n4 = Math.min(n4, isoMetaCellArray[0].length - 1);
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                LotHeader lotHeader = isoMetaCellArray[i][j].info;
                if (lotHeader == null) continue;
                for (int k = 0; k < lotHeader.Buildings.size(); ++k) {
                    BuildingDef buildingDef = lotHeader.Buildings.get(k);
                    for (int i2 = 0; i2 < buildingDef.rooms.size(); ++i2) {
                        if (buildingDef.rooms.get((int)i2).level > 0) continue;
                        ArrayList<RoomDef.RoomRect> arrayList = buildingDef.rooms.get(i2).getRects();
                        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                            RoomDef.RoomRect roomRect = arrayList.get(i3);
                            this.renderRect(roomRect.getX(), roomRect.getY(), roomRect.getW(), roomRect.getH(), 0.5f, 0.5f, 0.8f, 0.3f);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void renderZombies() {
        Object object;
        int n;
        float f = this.offx + this.draww / 2.0f;
        float f2 = this.offy + this.drawh / 2.0f;
        float f3 = this.draww / 2.0f;
        float f4 = 0.5f * this.zoom;
        if (++this.zombiePosFrameCount >= PerformanceSettings.getLockFPS() / 5) {
            float f5;
            float f6;
            this.zombiePosFrameCount = 0;
            this.zombiePosPool.release(this.zombiePos);
            this.zombiePos.clear();
            Arrays.fill(this.zombiePosOccupied, false);
            ArrayList<IsoZombie> arrayList = IsoWorld.instance.CurrentCell.getZombieList();
            for (n = 0; n < arrayList.size(); ++n) {
                object = arrayList.get(n);
                float f7 = this.worldToScreenX(((IsoMovingObject)object).getX());
                f5 = IsoUtils.DistanceToSquared(f, f2, f7, f6 = this.worldToScreenY(((IsoMovingObject)object).getY()));
                if (f5 > f3 * f3) {
                    double d = Math.atan2(f6 - f2, f7 - f) + Math.PI;
                    double d2 = (Math.toDegrees(d) + 180.0) % 360.0;
                    this.zombiePosOccupied[(int)d2] = true;
                    continue;
                }
                this.zombiePos.add(this.zombiePosPool.alloc(((IsoZombie)object).x, ((IsoZombie)object).y));
            }
            if (Core.bLastStand) {
                if (ZombiePopulationManager.instance.radarXY == null) {
                    ZombiePopulationManager.instance.radarXY = new float[2048];
                }
                float[] fArray = ZombiePopulationManager.instance.radarXY;
                object = fArray;
                // MONITORENTER : fArray
                for (int i = 0; i < ZombiePopulationManager.instance.radarCount; ++i) {
                    float f8;
                    f6 = fArray[i * 2 + 0];
                    f5 = fArray[i * 2 + 1];
                    float f9 = this.worldToScreenX(f6);
                    float f10 = IsoUtils.DistanceToSquared(f, f2, f9, f8 = this.worldToScreenY(f5));
                    if (f10 > f3 * f3) {
                        double d = Math.atan2(f8 - f2, f9 - f) + Math.PI;
                        double d3 = (Math.toDegrees(d) + 180.0) % 360.0;
                        this.zombiePosOccupied[(int)d3] = true;
                        continue;
                    }
                    this.zombiePos.add(this.zombiePosPool.alloc(f6, f5));
                }
                ZombiePopulationManager.instance.radarRenderFlag = true;
                // MONITOREXIT : object
            }
        }
        int n2 = this.zombiePos.size();
        for (n = 0; n < n2; ++n) {
            object = this.zombiePos.get(n);
            this.renderRect(((ZombiePos)object).x - 0.5f, ((ZombiePos)object).y - 0.5f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        }
        n = 0;
        while (n < this.zombiePosOccupied.length) {
            if (this.zombiePosOccupied[n]) {
                double d = Math.toRadians((float)n / (float)this.zombiePosOccupied.length * 360.0f);
                SpriteRenderer.instance.render(null, f + (f3 + 1.0f) * (float)Math.cos(d) - f4, f2 + (f3 + 1.0f) * (float)Math.sin(d) - f4, 1.0f * this.zoom, 1.0f * this.zoom, 1.0f, 1.0f, 0.0f, 1.0f, null);
            }
            ++n;
        }
    }

    private float worldToScreenX(float f) {
        f -= this.xPos;
        f *= this.zoom;
        f += this.offx;
        return f += this.draww / 2.0f;
    }

    private float worldToScreenY(float f) {
        f -= this.yPos;
        f *= this.zoom;
        f += this.offy;
        return f += this.drawh / 2.0f;
    }

    private void renderRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = this.worldToScreenX(f);
        float f10 = this.worldToScreenY(f2);
        float f11 = this.worldToScreenX(f + f3);
        float f12 = this.worldToScreenY(f2 + f4);
        f3 = f11 - f9;
        f4 = f12 - f10;
        if (f9 >= this.offx + this.draww || f11 < this.offx || f10 >= this.offy + this.drawh || f12 < this.offy) {
            return;
        }
        SpriteRenderer.instance.render(null, f9, f10, f3, f4, f5, f6, f7, f8, null);
    }

    private static class ZombiePosPool {
        private ArrayDeque<ZombiePos> pool = new ArrayDeque();

        private ZombiePosPool() {
        }

        public ZombiePos alloc(float f, float f2) {
            return this.pool.isEmpty() ? new ZombiePos(f, f2) : this.pool.pop().set(f, f2);
        }

        public void release(Collection<ZombiePos> collection) {
            this.pool.addAll(collection);
        }
    }

    private static final class ZombiePos {
        public float x;
        public float y;

        public ZombiePos(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public ZombiePos set(float f, float f2) {
            this.x = f;
            this.y = f2;
            return this;
        }
    }
}

