/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.util.ArrayList;
import java.util.Stack;
import zombie.characters.IsoGameCharacter;
import zombie.core.Core;
import zombie.core.textures.Texture;
import zombie.inventory.InventoryItem;
import zombie.iso.IsoObject;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIFont;

public final class ObjectTooltip
extends UIElement {
    public static float alphaStep = 0.1f;
    public boolean bIsItem = false;
    public InventoryItem Item = null;
    public IsoObject Object;
    float alpha = 0.0f;
    int showDelay = 0;
    float targetAlpha = 0.0f;
    Texture texture = Texture.getSharedTexture("black");
    public int padRight = 5;
    public int padBottom = 5;
    private IsoGameCharacter character;
    private boolean measureOnly;
    private float weightOfStack = 0.0f;
    private static int lineSpacing = 14;
    private static String fontSize = "Small";
    private static UIFont font = UIFont.Small;
    private static Stack<Layout> freeLayouts = new Stack();

    public ObjectTooltip() {
        this.width = 130.0f;
        this.height = 130.0f;
        this.defaultDraw = false;
        lineSpacing = TextManager.instance.getFontFromEnum(font).getLineHeight();
        ObjectTooltip.checkFont();
    }

    public static void checkFont() {
        if (!fontSize.equals(Core.getInstance().getOptionTooltipFont())) {
            fontSize = Core.getInstance().getOptionTooltipFont();
            font = "Large".equals(fontSize) ? UIFont.Large : ("Medium".equals(fontSize) ? UIFont.Medium : UIFont.Small);
            lineSpacing = TextManager.instance.getFontFromEnum(font).getLineHeight();
        }
    }

    public UIFont getFont() {
        return font;
    }

    public int getLineSpacing() {
        return lineSpacing;
    }

    @Override
    public void DrawText(UIFont uIFont, String string, double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.measureOnly) {
            return;
        }
        super.DrawText(uIFont, string, d, d2, d3, d4, d5, d6);
    }

    @Override
    public void DrawTextCentre(UIFont uIFont, String string, double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.measureOnly) {
            return;
        }
        super.DrawTextCentre(uIFont, string, d, d2, d3, d4, d5, d6);
    }

    @Override
    public void DrawTextRight(UIFont uIFont, String string, double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.measureOnly) {
            return;
        }
        super.DrawTextRight(uIFont, string, d, d2, d3, d4, d5, d6);
    }

    public void DrawValueRight(int n, int n2, int n3, boolean bl) {
        Integer n4 = n;
        Object object = n4.toString();
        float f = 0.3f;
        float f2 = 1.0f;
        float f3 = 0.2f;
        float f4 = 1.0f;
        if (n > 0) {
            object = "+" + (String)object;
        }
        if (n < 0 && bl || n > 0 && !bl) {
            f = 0.8f;
            f2 = 0.3f;
            f3 = 0.2f;
        }
        this.DrawTextRight(font, (String)object, n2, n3, f, f2, f3, f4);
    }

    public void DrawValueRightNoPlus(int n, int n2, int n3) {
        Integer n4 = n;
        String string = n4.toString();
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        this.DrawTextRight(font, string, n2, n3, f, f2, f3, f4);
    }

    public void DrawValueRightNoPlus(float f, int n, int n2) {
        Float f2 = Float.valueOf(f);
        f2 = Float.valueOf((float)((int)(((double)f2.floatValue() + 0.01) * 10.0)) / 10.0f);
        String string = f2.toString();
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = 1.0f;
        float f6 = 1.0f;
        this.DrawTextRight(font, string, n, n2, f3, f4, f5, f6);
    }

    @Override
    public void DrawTextureScaled(Texture texture, double d, double d2, double d3, double d4, double d5) {
        if (this.measureOnly) {
            return;
        }
        super.DrawTextureScaled(texture, d, d2, d3, d4, d5);
    }

    @Override
    public void DrawTextureScaledAspect(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (this.measureOnly) {
            return;
        }
        super.DrawTextureScaledAspect(texture, d, d2, d3, d4, d5, d6, d7, d8);
    }

    public void DrawProgressBar(int n, int n2, int n3, int n4, float f, double d, double d2, double d3, double d4) {
        if (this.measureOnly) {
            return;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        int n5 = (int)Math.floor((float)n3 * f);
        if (f > 0.0f && n5 == 0) {
            n5 = 1;
        }
        this.DrawTextureScaledColor(null, Double.valueOf(n), Double.valueOf(n2), Double.valueOf(n5), 3.0, d, d2, d3, d4);
        this.DrawTextureScaledColor(null, (double)n + (double)n5, Double.valueOf(n2), (double)n3 - (double)n5, 3.0, 0.25, 0.25, 0.25, 1.0);
    }

    @Override
    public Boolean onMouseMove(double d, double d2) {
        this.setX(this.getX() + d);
        this.setY(this.getY() + d2);
        return Boolean.FALSE;
    }

    @Override
    public void onMouseMoveOutside(double d, double d2) {
        this.setX(this.getX() + d);
        this.setY(this.getY() + d2);
    }

    @Override
    public void render() {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        if (this.alpha <= 0.0f) {
            return;
        }
        if (!this.bIsItem && this.Object != null && this.Object.haveSpecialTooltip()) {
            this.Object.DoSpecialTooltip(this, this.Object.square);
        }
        super.render();
    }

    public void show(IsoObject isoObject, double d, double d2) {
        this.bIsItem = false;
        this.Object = isoObject;
        this.setX(d);
        this.setY(d2);
        this.targetAlpha = 0.5f;
        this.showDelay = 15;
        this.alpha = 0.0f;
    }

    public void hide() {
        this.Object = null;
        this.showDelay = 0;
        this.setVisible(false);
    }

    @Override
    public void update() {
        if (this.alpha <= 0.0f && this.targetAlpha == 0.0f) {
            return;
        }
        if (this.showDelay > 0) {
            if (--this.showDelay == 0) {
                this.setVisible(true);
            }
            return;
        }
        if (this.alpha < this.targetAlpha) {
            this.alpha += alphaStep;
            if (this.alpha > 0.5f) {
                this.alpha = 0.5f;
            }
        } else if (this.alpha > this.targetAlpha) {
            this.alpha -= alphaStep;
            if (this.alpha < this.targetAlpha) {
                this.alpha = this.targetAlpha;
            }
        }
    }

    void show(InventoryItem inventoryItem, int n, int n2) {
        this.Object = null;
        this.Item = inventoryItem;
        this.bIsItem = true;
        this.setX(this.getX());
        this.setY(this.getY());
        this.targetAlpha = 0.5f;
        this.showDelay = 15;
        this.alpha = 0.0f;
        this.setVisible(true);
    }

    public void adjustWidth(int n, String string) {
        int n2 = TextManager.instance.MeasureStringX(font, string);
        if ((float)(n + n2 + this.padRight) > this.width) {
            this.setWidth(n + n2 + this.padRight);
        }
    }

    public Layout beginLayout() {
        Layout layout = null;
        layout = freeLayouts.isEmpty() ? new Layout() : freeLayouts.pop();
        return layout;
    }

    public void endLayout(Layout layout) {
        while (layout != null) {
            Layout layout2 = layout.next;
            layout.free();
            freeLayouts.push(layout);
            layout = layout2;
        }
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setCharacter(IsoGameCharacter isoGameCharacter) {
        this.character = isoGameCharacter;
    }

    public IsoGameCharacter getCharacter() {
        return this.character;
    }

    public void setMeasureOnly(boolean bl) {
        this.measureOnly = bl;
    }

    public boolean isMeasureOnly() {
        return this.measureOnly;
    }

    public float getWeightOfStack() {
        return this.weightOfStack;
    }

    public void setWeightOfStack(float f) {
        this.weightOfStack = f;
    }

    public static class Layout {
        public ArrayList<LayoutItem> items = new ArrayList();
        public int minLabelWidth;
        public int minValueWidth;
        public Layout next;
        public int nextPadY;
        private static Stack<LayoutItem> freeItems = new Stack();

        public LayoutItem addItem() {
            LayoutItem layoutItem = null;
            layoutItem = freeItems.isEmpty() ? new LayoutItem() : freeItems.pop();
            layoutItem.reset();
            this.items.add(layoutItem);
            return layoutItem;
        }

        public void setMinLabelWidth(int n) {
            this.minLabelWidth = n;
        }

        public void setMinValueWidth(int n) {
            this.minValueWidth = n;
        }

        public int render(int n, int n2, ObjectTooltip objectTooltip) {
            LayoutItem layoutItem;
            int n3;
            int n4 = this.minLabelWidth;
            int n5 = this.minValueWidth;
            int n6 = this.minValueWidth;
            int n7 = 0;
            int n8 = 0;
            int n9 = 8;
            int n10 = 0;
            for (n3 = 0; n3 < this.items.size(); ++n3) {
                layoutItem = this.items.get(n3);
                layoutItem.calcSizes();
                if (layoutItem.hasValue) {
                    n4 = Math.max(n4, layoutItem.labelWidth);
                    n5 = Math.max(n5, layoutItem.valueWidth);
                    n6 = Math.max(n6, layoutItem.valueWidthRight);
                    n7 = Math.max(n7, layoutItem.progressWidth);
                    n10 = Math.max(n10, Math.max(layoutItem.labelWidth, this.minLabelWidth) + n9);
                    n8 = Math.max(n8, n4 + n9 + Math.max(Math.max(n5, n6), n7));
                    continue;
                }
                n4 = Math.max(n4, layoutItem.labelWidth);
                n8 = Math.max(n8, layoutItem.labelWidth);
            }
            if ((float)(n + n8 + objectTooltip.padRight) > objectTooltip.width) {
                objectTooltip.setWidth(n + n8 + objectTooltip.padRight);
            }
            for (n3 = 0; n3 < this.items.size(); ++n3) {
                layoutItem = this.items.get(n3);
                layoutItem.render(n, n2, n10, n6, objectTooltip);
                n2 += layoutItem.height;
            }
            if (this.next != null) {
                return this.next.render(n, n2 + this.next.nextPadY, objectTooltip);
            }
            return n2;
        }

        public void free() {
            freeItems.addAll(this.items);
            this.items.clear();
            this.minLabelWidth = 0;
            this.minValueWidth = 0;
            this.next = null;
            this.nextPadY = 0;
        }
    }

    public static class LayoutItem {
        public String label;
        public float r0;
        public float g0;
        public float b0;
        public float a0;
        public boolean hasValue = false;
        public String value;
        public boolean rightJustify = false;
        public float r1;
        public float g1;
        public float b1;
        public float a1;
        public float progressFraction = -1.0f;
        public int labelWidth;
        public int valueWidth;
        public int valueWidthRight;
        public int progressWidth;
        public int height;

        public void reset() {
            this.label = null;
            this.value = null;
            this.hasValue = false;
            this.rightJustify = false;
            this.progressFraction = -1.0f;
        }

        public void setLabel(String string, float f, float f2, float f3, float f4) {
            this.label = string;
            this.r0 = f;
            this.b0 = f3;
            this.g0 = f2;
            this.a0 = f4;
        }

        public void setValue(String string, float f, float f2, float f3, float f4) {
            this.value = string;
            this.r1 = f;
            this.b1 = f3;
            this.g1 = f2;
            this.a1 = f4;
            this.hasValue = true;
        }

        public void setValueRight(int n, boolean bl) {
            this.value = Integer.toString(n);
            if (n > 0) {
                this.value = "+" + this.value;
            }
            if (n < 0 && bl || n > 0 && !bl) {
                this.r1 = Core.getInstance().getBadHighlitedColor().getR();
                this.g1 = Core.getInstance().getBadHighlitedColor().getG();
                this.b1 = Core.getInstance().getBadHighlitedColor().getB();
            } else {
                this.r1 = Core.getInstance().getGoodHighlitedColor().getR();
                this.g1 = Core.getInstance().getGoodHighlitedColor().getG();
                this.b1 = Core.getInstance().getGoodHighlitedColor().getB();
            }
            this.a1 = 1.0f;
            this.hasValue = true;
            this.rightJustify = true;
        }

        public void setValueRightNoPlus(float f) {
            f = (float)((int)((f + 0.005f) * 100.0f)) / 100.0f;
            this.value = Float.toString(f);
            this.r1 = 1.0f;
            this.g1 = 1.0f;
            this.b1 = 1.0f;
            this.a1 = 1.0f;
            this.hasValue = true;
            this.rightJustify = true;
        }

        public void setValueRightNoPlus(int n) {
            this.value = Integer.toString(n);
            this.r1 = 1.0f;
            this.g1 = 1.0f;
            this.b1 = 1.0f;
            this.a1 = 1.0f;
            this.hasValue = true;
            this.rightJustify = true;
        }

        public void setProgress(float f, float f2, float f3, float f4, float f5) {
            this.progressFraction = f;
            this.r1 = f2;
            this.b1 = f4;
            this.g1 = f3;
            this.a1 = f5;
            this.hasValue = true;
        }

        public void calcSizes() {
            int n;
            int n2;
            int n3;
            this.progressWidth = 0;
            this.valueWidthRight = 0;
            this.valueWidth = 0;
            this.labelWidth = 0;
            if (this.label != null) {
                this.labelWidth = TextManager.instance.MeasureStringX(font, this.label);
            }
            if (this.hasValue) {
                if (this.value != null) {
                    n3 = TextManager.instance.MeasureStringX(font, this.value);
                    this.valueWidth = this.rightJustify ? 0 : n3;
                    this.valueWidthRight = this.rightJustify ? n3 : 0;
                } else if (this.progressFraction != -1.0f) {
                    this.progressWidth = 80;
                }
            }
            n3 = 1;
            if (this.label != null) {
                n2 = 1;
                for (n = 0; n < this.label.length(); ++n) {
                    if (this.label.charAt(n) != '\n') continue;
                    ++n2;
                }
                n3 = Math.max(n3, n2);
            }
            if (this.hasValue && this.value != null) {
                n2 = 1;
                for (n = 0; n < this.value.length(); ++n) {
                    if (this.value.charAt(n) != '\n') continue;
                    ++n2;
                }
                n3 = Math.max(n3, n2);
            }
            this.height = n3 * lineSpacing;
        }

        public void render(int n, int n2, int n3, int n4, ObjectTooltip objectTooltip) {
            if (this.label != null) {
                objectTooltip.DrawText(font, this.label, n, n2, this.r0, this.g0, this.b0, this.a0);
            }
            if (this.value != null) {
                if (this.rightJustify) {
                    objectTooltip.DrawTextRight(font, this.value, n + n3 + n4, n2, this.r1, this.g1, this.b1, this.a1);
                } else {
                    objectTooltip.DrawText(font, this.value, n + n3, n2, this.r1, this.g1, this.b1, this.a1);
                }
            }
            if (this.progressFraction != -1.0f) {
                objectTooltip.DrawProgressBar(n + n3, n2 + lineSpacing / 2 - 1, this.progressWidth, 2, this.progressFraction, this.r1, this.g1, this.b1, this.a1);
            }
        }
    }
}

