/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import zombie.core.Core;
import zombie.core.Translator;
import zombie.core.textures.Texture;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIFont;
import zombie.ui.UIManager;

public class LoadingQueueUI
extends UIElement {
    private String strLoadingQueue = Translator.getText("UI_GameLoad_LoadingQueue");
    private String strQueuePlace = Translator.getText("UI_GameLoad_PlaceInQueue");
    private static int placeInQueue = -1;
    private Texture arrowBG = Texture.getSharedTexture("media/ui/ArrowRight_Disabled.png");
    private Texture arrowFG = Texture.getSharedTexture("media/ui/ArrowRight.png");
    private double timerMultiplierAnim = 0.0;
    private int animOffset = -1;

    public LoadingQueueUI() {
        placeInQueue = -1;
        this.onresize();
    }

    @Override
    public void update() {
    }

    @Override
    public void onresize() {
        this.x = 288.0;
        this.y = 101.0;
        this.width = (float)((double)Core.getInstance().getScreenWidth() - 2.0 * this.x);
        this.height = (float)((double)Core.getInstance().getScreenHeight() - 2.0 * this.y);
    }

    @Override
    public void render() {
        this.onresize();
        double d = 0.4f;
        double d2 = 0.4f;
        double d3 = 0.4f;
        double d4 = 1.0;
        this.DrawTextureScaledColor(null, 0.0, 0.0, 1.0, Double.valueOf(this.height), d, d2, d3, d4);
        this.DrawTextureScaledColor(null, 1.0, 0.0, (double)this.width - 2.0, 1.0, d, d2, d3, d4);
        this.DrawTextureScaledColor(null, (double)this.width - 1.0, 0.0, 1.0, Double.valueOf(this.height), d, d2, d3, d4);
        this.DrawTextureScaledColor(null, 1.0, (double)this.height - 1.0, (double)this.width - 2.0, 1.0, d, d2, d3, d4);
        this.DrawTextureScaledColor(null, 1.0, 1.0, (double)this.width - 2.0, Double.valueOf(this.height - 2.0f), 0.0, 0.0, 0.0, 0.5);
        TextManager.instance.DrawStringCentre(UIFont.Large, this.x + (double)(this.width / 2.0f), this.y + 60.0, this.strLoadingQueue, 1.0, 1.0, 1.0, 1.0);
        this.DrawTextureColor(this.arrowBG, (this.width - (float)this.arrowBG.getWidth()) / 2.0f - 15.0f, 120.0, 1.0, 1.0, 1.0, 1.0);
        this.DrawTextureColor(this.arrowBG, (this.width - (float)this.arrowBG.getWidth()) / 2.0f, 120.0, 1.0, 1.0, 1.0, 1.0);
        this.DrawTextureColor(this.arrowBG, (this.width - (float)this.arrowBG.getWidth()) / 2.0f + 15.0f, 120.0, 1.0, 1.0, 1.0, 1.0);
        this.timerMultiplierAnim += UIManager.getMillisSinceLastRender();
        if (this.timerMultiplierAnim <= 500.0) {
            this.animOffset = Integer.MIN_VALUE;
        } else if (this.timerMultiplierAnim <= 1000.0) {
            this.animOffset = -15;
        } else if (this.timerMultiplierAnim <= 1500.0) {
            this.animOffset = 0;
        } else if (this.timerMultiplierAnim <= 2000.0) {
            this.animOffset = 15;
        } else {
            this.timerMultiplierAnim = 0.0;
        }
        if (this.animOffset != Integer.MIN_VALUE) {
            this.DrawTextureColor(this.arrowFG, (this.width - (float)this.arrowBG.getWidth()) / 2.0f + (float)this.animOffset, 120.0, 1.0, 1.0, 1.0, 1.0);
        }
        if (placeInQueue >= 0) {
            TextManager.instance.DrawStringCentre(UIFont.Medium, this.x + (double)(this.width / 2.0f), this.y + 180.0, String.format(this.strQueuePlace, placeInQueue), 1.0, 1.0, 1.0, 1.0);
        }
    }

    public void setPlaceInQueue(int n) {
        placeInQueue = n;
    }
}

