/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.HashMap;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.scripting.ScriptParser;
import zombie.ui.FontsFileFont;
import zombie.util.StringUtils;

public final class FontsFile {
    private static final int VERSION1 = 1;
    private static final int VERSION = 1;

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean read(String string, HashMap<String, FontsFileFont> hashMap) {
        try (FileReader fileReader = new FileReader(string);){
            boolean bl;
            try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuilder.append(string2);
                    string2 = bufferedReader.readLine();
                }
                this.fromString(stringBuilder.toString(), hashMap);
                bl = true;
            }
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return false;
        }
    }

    private void fromString(String string, HashMap<String, FontsFileFont> hashMap) {
        string = ScriptParser.stripComments(string);
        ScriptParser.Block block = ScriptParser.parse(string);
        int n = -1;
        ScriptParser.Value value = block.getValue("VERSION");
        if (value != null) {
            n = PZMath.tryParseInt(value.getValue(), -1);
        }
        if (n < 1 || n > 1) {
            throw new RuntimeException("invalid or missing VERSION");
        }
        for (ScriptParser.Block block2 : block.children) {
            if (!block2.type.equalsIgnoreCase("font")) {
                throw new RuntimeException("unknown block type \"" + block2.type + "\"");
            }
            if (StringUtils.isNullOrWhitespace(block2.id)) {
                DebugLog.General.warn("missing or empty font id");
                continue;
            }
            ScriptParser.Value value2 = block2.getValue("fnt");
            ScriptParser.Value value3 = block2.getValue("img");
            if (value2 == null || StringUtils.isNullOrWhitespace(value2.getValue())) {
                DebugLog.General.warn("missing or empty value \"fnt\"");
                continue;
            }
            FontsFileFont fontsFileFont = new FontsFileFont();
            fontsFileFont.id = block2.id;
            fontsFileFont.fnt = value2.getValue().trim();
            if (value3 != null && !StringUtils.isNullOrWhitespace(value3.getValue())) {
                fontsFileFont.img = value3.getValue().trim();
            }
            hashMap.put(fontsFileFont.id, fontsFileFont);
        }
    }
}

