/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.util.ArrayList;
import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.textures.Texture;
import zombie.debug.DebugOptions;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.AlarmClock;
import zombie.inventory.types.AlarmClockClothing;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameClient;
import zombie.ui.UIElement;
import zombie.ui.UIManager;

public final class Clock
extends UIElement {
    boolean bLargeTextures = false;
    Texture background = null;
    Texture[] digitsLarge;
    Texture[] digitsSmall;
    Texture colon = null;
    Texture slash = null;
    Texture minus = null;
    Texture dot = null;
    Texture tempC = null;
    Texture tempF = null;
    Texture tempE = null;
    Texture texAM = null;
    Texture texPM = null;
    Texture alarmOn = null;
    Texture alarmRinging = null;
    Color displayColour = new Color(100, 200, 210, 255);
    Color ghostColour = new Color(40, 40, 40, 128);
    int uxOriginal;
    int uyOriginal;
    int largeDigitSpacing;
    int smallDigitSpacing;
    int colonSpacing;
    int ampmSpacing;
    int alarmBellSpacing;
    int decimalSpacing;
    int degreeSpacing;
    int slashSpacing;
    int tempDateSpacing;
    int dateOffset;
    int minusOffset;
    int amVerticalSpacing;
    int pmVerticalSpacing;
    int alarmBellVerticalSpacing;
    int displayVerticalSpacing;
    int decimalVerticalSpacing;
    public boolean digital = false;
    public boolean isAlarmSet = false;
    public boolean isAlarmRinging = false;
    private IsoPlayer clockPlayer = null;
    public static Clock instance = null;

    public Clock(int n, int n2) {
        this.x = n;
        this.y = n2;
        instance = this;
    }

    @Override
    public void render() {
        if (!this.visible) {
            return;
        }
        this.assignTextures(Core.getInstance().getOptionClockSize() == 2);
        this.DrawTexture(this.background, 0.0, 0.0, 0.75);
        this.renderDisplay(true, this.ghostColour);
        this.renderDisplay(false, this.displayColour);
        super.render();
    }

    private void renderDisplay(boolean bl, Color color) {
        int n = this.uxOriginal;
        int n2 = this.uyOriginal;
        for (int i = 0; i < 4; ++i) {
            int[] nArray = this.timeDigits();
            if (bl) {
                this.DrawTextureCol(this.digitsLarge[8], n, n2, color);
            } else {
                this.DrawTextureCol(this.digitsLarge[nArray[i]], n, n2, color);
            }
            n += this.digitsLarge[0].getWidth();
            if (i == 1) {
                this.DrawTextureCol(this.colon, n += this.colonSpacing, n2, color);
                n += this.colon.getWidth() + this.colonSpacing;
                continue;
            }
            if (i >= 3) continue;
            n += this.largeDigitSpacing;
        }
        n += this.ampmSpacing;
        if (!Core.getInstance().getOptionClock24Hour() || bl) {
            if (bl) {
                this.DrawTextureCol(this.texAM, n, n2 + this.amVerticalSpacing, color);
                this.DrawTextureCol(this.texPM, n, n2 + this.pmVerticalSpacing, color);
            } else if (GameTime.getInstance().getTimeOfDay() < 12.0f) {
                this.DrawTextureCol(this.texAM, n, n2 + this.amVerticalSpacing, color);
            } else {
                this.DrawTextureCol(this.texPM, n, n2 + this.pmVerticalSpacing, color);
            }
        }
        if (this.isAlarmRinging || bl) {
            this.DrawTextureCol(this.alarmRinging, n + this.texAM.getWidth() + this.alarmBellSpacing, n2 + this.alarmBellVerticalSpacing, color);
        } else if (this.isAlarmSet) {
            this.DrawTextureCol(this.alarmOn, n + this.texAM.getWidth() + this.alarmBellSpacing, n2 + this.alarmBellVerticalSpacing, color);
        }
        if (this.digital || bl) {
            n = this.uxOriginal;
            n2 += this.digitsLarge[0].getHeight() + this.displayVerticalSpacing;
            if (this.clockPlayer != null) {
                int[] nArray = this.tempDigits();
                if (nArray[0] == 1 || bl) {
                    this.DrawTextureCol(this.minus, n, n2, color);
                }
                n += this.minusOffset;
                if (nArray[1] == 1 || bl) {
                    this.DrawTextureCol(this.digitsSmall[1], n, n2, color);
                }
                n += this.digitsSmall[0].getWidth() + this.smallDigitSpacing;
                for (int i = 2; i < 5; ++i) {
                    if (bl) {
                        this.DrawTextureCol(this.digitsSmall[8], n, n2, color);
                    } else {
                        this.DrawTextureCol(this.digitsSmall[nArray[i]], n, n2, color);
                    }
                    n += this.digitsSmall[0].getWidth();
                    if (i == 3) {
                        this.DrawTextureCol(this.dot, n += this.decimalSpacing, n2 + this.decimalVerticalSpacing, color);
                        n += this.dot.getWidth() + this.decimalSpacing;
                        continue;
                    }
                    if (i >= 4) continue;
                    n += this.smallDigitSpacing;
                }
                this.DrawTextureCol(this.dot, n += this.degreeSpacing, n2, color);
                n += this.dot.getWidth() + this.degreeSpacing;
                if (bl) {
                    this.DrawTextureCol(this.tempE, n, n2, color);
                } else if (nArray[5] == 0) {
                    this.DrawTextureCol(this.tempC, n, n2, color);
                } else {
                    this.DrawTextureCol(this.tempF, n, n2, color);
                }
                n += this.digitsSmall[0].getWidth() + this.tempDateSpacing;
            } else {
                n += this.dateOffset;
            }
            int[] nArray = this.dateDigits();
            for (int i = 0; i < 4; ++i) {
                if (bl) {
                    this.DrawTextureCol(this.digitsSmall[8], n, n2, color);
                } else {
                    this.DrawTextureCol(this.digitsSmall[nArray[i]], n, n2, color);
                }
                n += this.digitsSmall[0].getWidth();
                if (i == 1) {
                    this.DrawTextureCol(this.slash, n += this.slashSpacing, n2, color);
                    n += this.slash.getWidth() + this.slashSpacing;
                    continue;
                }
                if (i >= 3) continue;
                n += this.smallDigitSpacing;
            }
        }
    }

    private void assignTextures(boolean bl) {
        if (this.digitsLarge != null && this.bLargeTextures == bl) {
            return;
        }
        this.bLargeTextures = bl;
        this.background = bl ? Texture.getSharedTexture("media/ui/ClockAssets/ClockLargeBackground.png") : Texture.getSharedTexture("media/ui/ClockAssets/ClockSmallBackground.png");
        String string = "Medium";
        String string2 = "Small";
        if (bl) {
            string = "Large";
            string2 = "Medium";
            this.assignLargeOffsets();
        } else {
            this.assignSmallOffsets();
        }
        if (this.digitsLarge == null) {
            this.digitsLarge = new Texture[10];
            this.digitsSmall = new Texture[10];
        }
        for (int i = 0; i < 10; ++i) {
            this.digitsLarge[i] = Texture.getSharedTexture("media/ui/ClockAssets/ClockDigits" + string + i + ".png");
            this.digitsSmall[i] = Texture.getSharedTexture("media/ui/ClockAssets/ClockDigits" + string2 + i + ".png");
        }
        this.colon = Texture.getSharedTexture("media/ui/ClockAssets/ClockDivide" + string + ".png");
        this.slash = Texture.getSharedTexture("media/ui/ClockAssets/DateDivide" + string2 + ".png");
        this.minus = Texture.getSharedTexture("media/ui/ClockAssets/ClockDigits" + string2 + "Minus.png");
        this.dot = Texture.getSharedTexture("media/ui/ClockAssets/ClockDigits" + string2 + "Dot.png");
        this.tempC = Texture.getSharedTexture("media/ui/ClockAssets/ClockDigits" + string2 + "C.png");
        this.tempF = Texture.getSharedTexture("media/ui/ClockAssets/ClockDigits" + string2 + "F.png");
        this.tempE = Texture.getSharedTexture("media/ui/ClockAssets/ClockDigits" + string2 + "E.png");
        this.texAM = Texture.getSharedTexture("media/ui/ClockAssets/ClockAm" + string + ".png");
        this.texPM = Texture.getSharedTexture("media/ui/ClockAssets/ClockPm" + string + ".png");
        this.alarmOn = Texture.getSharedTexture("media/ui/ClockAssets/ClockAlarm" + string + "Set.png");
        this.alarmRinging = Texture.getSharedTexture("media/ui/ClockAssets/ClockAlarm" + string + "Sound.png");
    }

    private void assignSmallOffsets() {
        this.uxOriginal = 3;
        this.uyOriginal = 3;
        this.largeDigitSpacing = 1;
        this.smallDigitSpacing = 1;
        this.colonSpacing = 1;
        this.ampmSpacing = 1;
        this.alarmBellSpacing = 1;
        this.decimalSpacing = 1;
        this.degreeSpacing = 1;
        this.slashSpacing = 1;
        this.tempDateSpacing = 5;
        this.dateOffset = 33;
        this.minusOffset = 0;
        this.amVerticalSpacing = 7;
        this.pmVerticalSpacing = 12;
        this.alarmBellVerticalSpacing = 1;
        this.displayVerticalSpacing = 2;
        this.decimalVerticalSpacing = 6;
    }

    private void assignLargeOffsets() {
        this.uxOriginal = 3;
        this.uyOriginal = 3;
        this.largeDigitSpacing = 2;
        this.smallDigitSpacing = 1;
        this.colonSpacing = 3;
        this.ampmSpacing = 3;
        this.alarmBellSpacing = 5;
        this.decimalSpacing = 2;
        this.degreeSpacing = 2;
        this.slashSpacing = 2;
        this.tempDateSpacing = 8;
        this.dateOffset = 65;
        this.minusOffset = -2;
        this.amVerticalSpacing = 15;
        this.pmVerticalSpacing = 25;
        this.alarmBellVerticalSpacing = 1;
        this.displayVerticalSpacing = 5;
        this.decimalVerticalSpacing = 15;
    }

    private int[] timeDigits() {
        float f = GameTime.getInstance().getTimeOfDay();
        if (GameClient.bClient && GameClient.bFastForward) {
            f = GameTime.getInstance().ServerTimeOfDay;
        }
        if (!Core.getInstance().getOptionClock24Hour()) {
            if (f >= 13.0f) {
                f -= 12.0f;
            }
            if (f < 1.0f) {
                f += 12.0f;
            }
        }
        int n = (int)f;
        float f2 = (f - (float)((int)f)) * 60.0f;
        int n2 = n / 10;
        int n3 = n % 10;
        int n4 = (int)(f2 / 10.0f);
        return new int[]{n2, n3, n4, 0};
    }

    private int[] dateDigits() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = (GameTime.getInstance().getDay() + 1) / 10;
        n2 = (GameTime.getInstance().getDay() + 1) % 10;
        n3 = (GameTime.getInstance().getMonth() + 1) / 10;
        n4 = (GameTime.getInstance().getMonth() + 1) % 10;
        if (Core.getInstance().getOptionClockFormat() == 1) {
            return new int[]{n3, n4, n, n2};
        }
        return new int[]{n, n2, n3, n4};
    }

    private int[] tempDigits() {
        float f = ClimateManager.getInstance().getAirTemperatureForCharacter(this.clockPlayer, false);
        int n = 0;
        int n2 = 0;
        if (!Core.OptionTemperatureDisplayCelsius) {
            f = f * 1.8f + 32.0f;
            n2 = 1;
        }
        if (f < 0.0f) {
            n = 1;
            f *= -1.0f;
        }
        int n3 = (int)f / 100;
        int n4 = (int)(f % 100.0f) / 10;
        int n5 = (int)f % 10;
        int n6 = (int)(f * 10.0f) % 10;
        return new int[]{n, n3, n4, n5, n6, n2};
    }

    public void resize() {
        this.visible = false;
        this.digital = false;
        this.clockPlayer = null;
        this.isAlarmSet = false;
        this.isAlarmRinging = false;
        if (IsoPlayer.getInstance() != null) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.isDead()) continue;
                for (int j = 0; j < isoPlayer.getWornItems().size(); ++j) {
                    InventoryItem inventoryItem = isoPlayer.getWornItems().getItemByIndex(j);
                    if (!(inventoryItem instanceof AlarmClock) && !(inventoryItem instanceof AlarmClockClothing)) continue;
                    this.visible = UIManager.VisibleAllUI;
                    this.digital |= inventoryItem.hasTag("Digital");
                    if (inventoryItem instanceof AlarmClock) {
                        if (((AlarmClock)inventoryItem).isAlarmSet()) {
                            this.isAlarmSet = true;
                        }
                        if (((AlarmClock)inventoryItem).isRinging()) {
                            this.isAlarmRinging = true;
                        }
                    } else {
                        if (((AlarmClockClothing)inventoryItem).isAlarmSet()) {
                            this.isAlarmSet = true;
                        }
                        if (((AlarmClockClothing)inventoryItem).isRinging()) {
                            this.isAlarmRinging = true;
                        }
                    }
                    this.clockPlayer = isoPlayer;
                }
                if (this.clockPlayer != null) break;
                ArrayList<InventoryItem> arrayList = isoPlayer.getInventory().getItems();
                for (int j = 0; j < arrayList.size(); ++j) {
                    InventoryItem inventoryItem = arrayList.get(j);
                    if (!(inventoryItem instanceof AlarmClock) && !(inventoryItem instanceof AlarmClockClothing)) continue;
                    this.visible = UIManager.VisibleAllUI;
                    this.digital |= inventoryItem.hasTag("Digital");
                    if (inventoryItem instanceof AlarmClock) {
                        if (((AlarmClock)inventoryItem).isAlarmSet()) {
                            this.isAlarmSet = true;
                        }
                        if (((AlarmClock)inventoryItem).isRinging()) {
                            this.isAlarmRinging = true;
                        }
                    } else {
                        if (((AlarmClockClothing)inventoryItem).isAlarmSet()) {
                            this.isAlarmSet = true;
                        }
                        if (((AlarmClockClothing)inventoryItem).isRinging()) {
                            this.isAlarmRinging = true;
                        }
                    }
                    this.clockPlayer = isoPlayer;
                }
            }
        }
        if (DebugOptions.instance.CheatClockVisible.getValue()) {
            this.digital = true;
            this.visible = UIManager.VisibleAllUI;
        }
        if (this.background == null) {
            this.background = Core.getInstance().getOptionClockSize() == 2 ? Texture.getSharedTexture("media/ui/ClockAssets/ClockLargeBackground.png") : Texture.getSharedTexture("media/ui/ClockAssets/ClockSmallBackground.png");
        }
        this.setHeight(this.background.getHeight());
        this.setWidth(this.background.getWidth());
    }

    public boolean isDateVisible() {
        return this.visible && this.digital;
    }

    @Override
    public Boolean onMouseDown(double d, double d2) {
        block20: {
            block21: {
                block19: {
                    if (!this.isVisible().booleanValue()) {
                        return false;
                    }
                    if (!this.isAlarmRinging) break block19;
                    if (IsoPlayer.getInstance() == null) break block20;
                    for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                        InventoryItem inventoryItem;
                        int n;
                        IsoPlayer isoPlayer = IsoPlayer.players[i];
                        if (isoPlayer == null || isoPlayer.isDead()) continue;
                        for (n = 0; n < isoPlayer.getWornItems().size(); ++n) {
                            inventoryItem = isoPlayer.getWornItems().getItemByIndex(n);
                            if (inventoryItem instanceof AlarmClock) {
                                ((AlarmClock)inventoryItem).stopRinging();
                                continue;
                            }
                            if (!(inventoryItem instanceof AlarmClockClothing)) continue;
                            ((AlarmClockClothing)inventoryItem).stopRinging();
                        }
                        for (n = 0; n < isoPlayer.getInventory().getItems().size(); ++n) {
                            inventoryItem = isoPlayer.getInventory().getItems().get(n);
                            if (inventoryItem instanceof AlarmClock) {
                                ((AlarmClock)inventoryItem).stopRinging();
                                continue;
                            }
                            if (!(inventoryItem instanceof AlarmClockClothing)) continue;
                            ((AlarmClockClothing)inventoryItem).stopRinging();
                        }
                    }
                    break block20;
                }
                if (!this.isAlarmSet) break block21;
                if (IsoPlayer.getInstance() == null) break block20;
                for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                    InventoryItem inventoryItem;
                    int n;
                    IsoPlayer isoPlayer = IsoPlayer.players[i];
                    if (isoPlayer == null || isoPlayer.isDead()) continue;
                    for (n = 0; n < isoPlayer.getWornItems().size(); ++n) {
                        inventoryItem = isoPlayer.getWornItems().getItemByIndex(n);
                        if (inventoryItem instanceof AlarmClock && ((AlarmClock)inventoryItem).isAlarmSet()) {
                            ((AlarmClock)inventoryItem).setAlarmSet(false);
                            continue;
                        }
                        if (!(inventoryItem instanceof AlarmClockClothing) || !((AlarmClockClothing)inventoryItem).isAlarmSet()) continue;
                        ((AlarmClockClothing)inventoryItem).setAlarmSet(false);
                    }
                    for (n = 0; n < isoPlayer.getInventory().getItems().size(); ++n) {
                        inventoryItem = isoPlayer.getInventory().getItems().get(n);
                        if (inventoryItem instanceof AlarmClockClothing && ((AlarmClockClothing)inventoryItem).isAlarmSet()) {
                            ((AlarmClockClothing)inventoryItem).setAlarmSet(false);
                        }
                        if (!(inventoryItem instanceof AlarmClock) || !((AlarmClock)inventoryItem).isAlarmSet()) continue;
                        ((AlarmClock)inventoryItem).setAlarmSet(false);
                    }
                }
                break block20;
            }
            if (IsoPlayer.getInstance() != null) {
                for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                    InventoryItem inventoryItem;
                    int n;
                    IsoPlayer isoPlayer = IsoPlayer.players[i];
                    if (isoPlayer == null || isoPlayer.isDead()) continue;
                    for (n = 0; n < isoPlayer.getWornItems().size(); ++n) {
                        inventoryItem = isoPlayer.getWornItems().getItemByIndex(n);
                        if (inventoryItem instanceof AlarmClock && ((AlarmClock)inventoryItem).isDigital() && !((AlarmClock)inventoryItem).isAlarmSet()) {
                            ((AlarmClock)inventoryItem).setAlarmSet(true);
                            if (this.isAlarmSet) {
                                return true;
                            }
                        }
                        if (!(inventoryItem instanceof AlarmClockClothing) || !((AlarmClockClothing)inventoryItem).isDigital() || ((AlarmClockClothing)inventoryItem).isAlarmSet()) continue;
                        ((AlarmClockClothing)inventoryItem).setAlarmSet(true);
                        if (!this.isAlarmSet) continue;
                        return true;
                    }
                    for (n = 0; n < isoPlayer.getInventory().getItems().size(); ++n) {
                        inventoryItem = isoPlayer.getInventory().getItems().get(n);
                        if (inventoryItem instanceof AlarmClock && ((AlarmClock)inventoryItem).isDigital() && !((AlarmClock)inventoryItem).isAlarmSet()) {
                            ((AlarmClock)inventoryItem).setAlarmSet(true);
                            if (this.isAlarmSet) {
                                return true;
                            }
                        }
                        if (!(inventoryItem instanceof AlarmClockClothing) || !((AlarmClockClothing)inventoryItem).isDigital() || ((AlarmClockClothing)inventoryItem).isAlarmSet()) continue;
                        ((AlarmClockClothing)inventoryItem).setAlarmSet(true);
                        if (!this.isAlarmSet) continue;
                        return true;
                    }
                }
            }
        }
        return true;
    }
}

