/*
 * Decompiled with CFR 0.152.
 */
package zombie.text.templating;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.krka.kahlua.j2se.KahluaTableImpl;
import zombie.debug.DebugLog;
import zombie.text.templating.IReplace;
import zombie.text.templating.IReplaceProvider;
import zombie.text.templating.ITemplateBuilder;
import zombie.text.templating.ReplaceList;
import zombie.text.templating.ReplaceProviderLua;

public class TemplateTextBuilder
implements ITemplateBuilder {
    private static final String fieldStart = "\\$\\{";
    private static final String fieldEnd = "\\}";
    private static final String regex = "\\$\\{([^}]+)\\}";
    private static final Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");
    private Map<String, IReplace> m_keys = new HashMap<String, IReplace>();

    protected TemplateTextBuilder() {
    }

    @Override
    public void Reset() {
        this.m_keys.clear();
    }

    @Override
    public String Build(String string) {
        return this.format(string, null);
    }

    @Override
    public String Build(String string, IReplaceProvider iReplaceProvider) {
        return this.format(string, iReplaceProvider);
    }

    @Override
    public String Build(String string, KahluaTableImpl kahluaTableImpl) {
        ReplaceProviderLua replaceProviderLua = ReplaceProviderLua.Alloc();
        replaceProviderLua.fromLuaTable(kahluaTableImpl);
        String string2 = this.format(string, replaceProviderLua);
        replaceProviderLua.release();
        return string2;
    }

    private String format(String string, IReplaceProvider iReplaceProvider) {
        Matcher matcher = pattern.matcher(string);
        String string2 = string;
        while (matcher.find()) {
            String string3 = matcher.group(1).toLowerCase().trim();
            Object object = null;
            if (iReplaceProvider != null && iReplaceProvider.hasReplacer(string3)) {
                object = iReplaceProvider.getReplacer(string3).getString();
            } else {
                IReplace iReplace = this.m_keys.get(string3);
                if (iReplace != null) {
                    object = iReplace.getString();
                }
            }
            if (object == null) {
                object = "missing_" + string3;
            }
            string2 = string2.replaceFirst(regex, (String)object);
        }
        return string2;
    }

    @Override
    public void RegisterKey(String string, KahluaTableImpl kahluaTableImpl) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < kahluaTableImpl.len() + 1; ++i) {
                arrayList.add((String)kahluaTableImpl.rawget(i));
            }
            if (arrayList.size() > 0) {
                this.localRegisterKey(string, new ReplaceList(arrayList));
            } else {
                DebugLog.log("TemplateTextBuilder -> key '" + string + "' contains no entries, ignoring.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void RegisterKey(String string, IReplace iReplace) {
        this.localRegisterKey(string, iReplace);
    }

    private void localRegisterKey(String string, IReplace iReplace) {
        if (this.m_keys.containsKey(string.toLowerCase().trim())) {
            DebugLog.log("TemplateTextBuilder -> Warning: key '" + string + "' replaces an existing key.");
        }
        this.m_keys.put(string.toLowerCase().trim(), iReplace);
    }
}

