/*
 * Decompiled with CFR 0.152.
 */
package zombie.text.templating;

import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import se.krka.kahlua.j2se.KahluaTableImpl;
import zombie.debug.DebugLog;
import zombie.text.templating.ReplaceList;
import zombie.text.templating.ReplaceProvider;
import zombie.text.templating.ReplaceSingle;

public class ReplaceProviderLua
extends ReplaceProvider {
    private static final ConcurrentLinkedDeque<ReplaceSingle> pool_single = new ConcurrentLinkedDeque();
    private static final ConcurrentLinkedDeque<ReplaceList> pool_list = new ConcurrentLinkedDeque();
    private static final ConcurrentLinkedDeque<ReplaceProviderLua> pool = new ConcurrentLinkedDeque();

    private static ReplaceSingle alloc_single() {
        ReplaceSingle replaceSingle = pool_single.poll();
        if (replaceSingle == null) {
            replaceSingle = new ReplaceSingle();
        }
        return replaceSingle;
    }

    private static void release_single(ReplaceSingle replaceSingle) {
        pool_single.offer(replaceSingle);
    }

    private static ReplaceList alloc_list() {
        ReplaceList replaceList = pool_list.poll();
        if (replaceList == null) {
            replaceList = new ReplaceList();
        }
        return replaceList;
    }

    private static void release_list(ReplaceList replaceList) {
        replaceList.getReplacements().clear();
        pool_list.offer(replaceList);
    }

    protected static ReplaceProviderLua Alloc() {
        ReplaceProviderLua replaceProviderLua = pool.poll();
        if (replaceProviderLua == null) {
            replaceProviderLua = new ReplaceProviderLua();
        }
        replaceProviderLua.reset();
        return replaceProviderLua;
    }

    private void reset() {
        for (Map.Entry entry : this.m_keys.entrySet()) {
            if (entry.getValue() instanceof ReplaceList) {
                ReplaceProviderLua.release_list((ReplaceList)entry.getValue());
                continue;
            }
            ReplaceProviderLua.release_single((ReplaceSingle)entry.getValue());
        }
        this.m_keys.clear();
    }

    public void release() {
        this.reset();
        pool.offer(this);
    }

    public void fromLuaTable(KahluaTableImpl kahluaTableImpl) {
        for (Map.Entry<Object, Object> entry : kahluaTableImpl.delegate.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            if (entry.getValue() instanceof String) {
                this.addKey((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof KahluaTableImpl)) continue;
            KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)entry.getValue();
            ReplaceList replaceList = ReplaceProviderLua.alloc_list();
            for (int i = 1; i < kahluaTableImpl2.len() + 1; ++i) {
                replaceList.getReplacements().add((String)kahluaTableImpl2.rawget(i));
            }
            if (replaceList.getReplacements().size() > 0) {
                this.addReplacer((String)entry.getKey(), replaceList);
                continue;
            }
            DebugLog.log("ReplaceProvider -> key '" + entry.getKey() + "' contains no entries, ignoring.");
            ReplaceProviderLua.release_list(replaceList);
        }
    }

    @Override
    public void addKey(String string, String string2) {
        ReplaceSingle replaceSingle = ReplaceProviderLua.alloc_single();
        replaceSingle.setValue(string2);
        this.addReplacer(string, replaceSingle);
    }
}

