/*
 * Decompiled with CFR 0.152.
 */
package zombie.spnetwork;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.debug.DebugLog;
import zombie.globalObjects.SGlobalObjectNetwork;
import zombie.iso.IsoObject;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.network.GameClient;
import zombie.network.PacketTypes;
import zombie.network.TableNetworkUtils;
import zombie.spnetwork.SinglePlayerClient;
import zombie.spnetwork.UdpConnection;
import zombie.spnetwork.UdpEngine;
import zombie.spnetwork.ZomboidNetData;
import zombie.spnetwork.ZomboidNetDataPool;
import zombie.vehicles.BaseVehicle;

public final class SinglePlayerServer {
    private static final ArrayList<ZomboidNetData> MainLoopNetData = new ArrayList();
    public static final UdpEngineServer udpEngine = new UdpEngineServer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIncoming(short s, ByteBuffer byteBuffer, UdpConnection udpConnection) {
        ZomboidNetData zomboidNetData = byteBuffer.remaining() > 2048 ? ZomboidNetDataPool.instance.getLong(byteBuffer.remaining()) : ZomboidNetDataPool.instance.get();
        zomboidNetData.read(s, byteBuffer, udpConnection);
        ArrayList<ZomboidNetData> arrayList = MainLoopNetData;
        synchronized (arrayList) {
            MainLoopNetData.add(zomboidNetData);
        }
    }

    private static void sendObjectChange(IsoObject isoObject, String string, KahluaTable kahluaTable, UdpConnection udpConnection) {
        if (isoObject.getSquare() == null) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.ObjectChange.doPacket(byteBufferWriter);
        if (isoObject instanceof IsoPlayer) {
            byteBufferWriter.putByte((byte)1);
            byteBufferWriter.putShort(((IsoPlayer)isoObject).OnlineID);
        } else if (isoObject instanceof BaseVehicle) {
            byteBufferWriter.putByte((byte)2);
            byteBufferWriter.putShort(((BaseVehicle)isoObject).getId());
        } else if (isoObject instanceof IsoWorldInventoryObject) {
            byteBufferWriter.putByte((byte)3);
            byteBufferWriter.putInt(isoObject.getSquare().getX());
            byteBufferWriter.putInt(isoObject.getSquare().getY());
            byteBufferWriter.putInt(isoObject.getSquare().getZ());
            byteBufferWriter.putInt(((IsoWorldInventoryObject)isoObject).getItem().getID());
        } else {
            byteBufferWriter.putByte((byte)0);
            byteBufferWriter.putInt(isoObject.getSquare().getX());
            byteBufferWriter.putInt(isoObject.getSquare().getY());
            byteBufferWriter.putInt(isoObject.getSquare().getZ());
            byteBufferWriter.putInt(isoObject.getSquare().getObjects().indexOf(isoObject));
        }
        byteBufferWriter.putUTF(string);
        isoObject.saveChange(string, kahluaTable, byteBufferWriter.bb);
        udpConnection.endPacketImmediate();
    }

    public static void sendObjectChange(IsoObject isoObject, String string, KahluaTable kahluaTable) {
        if (isoObject == null) {
            return;
        }
        for (int i = 0; i < SinglePlayerServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = SinglePlayerServer.udpEngine.connections.get(i);
            if (!udpConnection.ReleventTo(isoObject.getX(), isoObject.getY())) continue;
            SinglePlayerServer.sendObjectChange(isoObject, string, kahluaTable, udpConnection);
        }
    }

    public static void sendObjectChange(IsoObject isoObject, String string, Object ... objectArray) {
        if (objectArray.length == 0) {
            SinglePlayerServer.sendObjectChange(isoObject, string, null);
            return;
        }
        if (objectArray.length % 2 != 0) {
            return;
        }
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i + 1];
            if (object instanceof Float) {
                kahluaTable.rawset(objectArray[i], (Object)((Float)object).doubleValue());
                continue;
            }
            if (object instanceof Integer) {
                kahluaTable.rawset(objectArray[i], (Object)((Integer)object).doubleValue());
                continue;
            }
            if (object instanceof Short) {
                kahluaTable.rawset(objectArray[i], (Object)((Short)object).doubleValue());
                continue;
            }
            kahluaTable.rawset(objectArray[i], object);
        }
        SinglePlayerServer.sendObjectChange(isoObject, string, kahluaTable);
    }

    public static void sendServerCommand(String string, String string2, KahluaTable kahluaTable, UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.ClientCommand.doPacket(byteBufferWriter);
        byteBufferWriter.putUTF(string);
        byteBufferWriter.putUTF(string2);
        if (kahluaTable == null || kahluaTable.isEmpty()) {
            byteBufferWriter.putByte((byte)0);
        } else {
            byteBufferWriter.putByte((byte)1);
            try {
                KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
                while (kahluaTableIterator.advance()) {
                    if (TableNetworkUtils.canSave(kahluaTableIterator.getKey(), kahluaTableIterator.getValue())) continue;
                    DebugLog.log("ERROR: sendServerCommand: can't save key,value=" + kahluaTableIterator.getKey() + "," + kahluaTableIterator.getValue());
                }
                TableNetworkUtils.save(kahluaTable, byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        udpConnection.endPacketImmediate();
    }

    public static void sendServerCommand(String string, String string2, KahluaTable kahluaTable) {
        for (int i = 0; i < SinglePlayerServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = SinglePlayerServer.udpEngine.connections.get(i);
            SinglePlayerServer.sendServerCommand(string, string2, kahluaTable, udpConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() {
        if (GameClient.bClient) {
            return;
        }
        for (short s = 0; s < IsoPlayer.numPlayers; s = (short)(s + 1)) {
            if (IsoPlayer.players[s] == null) continue;
            IsoPlayer.players[s].setOnlineID(s);
        }
        ArrayList<ZomboidNetData> arrayList = MainLoopNetData;
        synchronized (arrayList) {
            for (int i = 0; i < MainLoopNetData.size(); ++i) {
                ZomboidNetData zomboidNetData = MainLoopNetData.get(i);
                SinglePlayerServer.mainLoopDealWithNetData(zomboidNetData);
                MainLoopNetData.remove(i--);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void mainLoopDealWithNetData(ZomboidNetData zomboidNetData) {
        ByteBuffer byteBuffer = zomboidNetData.buffer;
        try {
            PacketTypes.PacketType packetType = PacketTypes.packetTypes.get(zomboidNetData.type);
            switch (packetType) {
                case ClientCommand: {
                    SinglePlayerServer.receiveClientCommand(byteBuffer, zomboidNetData.connection);
                    return;
                }
                case GlobalObjects: {
                    SinglePlayerServer.receiveGlobalObjects(byteBuffer, zomboidNetData.connection);
                    return;
                }
            }
            return;
        }
        finally {
            ZomboidNetDataPool.instance.discard(zomboidNetData);
        }
    }

    private static IsoPlayer getAnyPlayerFromConnection(UdpConnection udpConnection) {
        for (int i = 0; i < 4; ++i) {
            if (udpConnection.players[i] == null) continue;
            return udpConnection.players[i];
        }
        return null;
    }

    private static IsoPlayer getPlayerFromConnection(UdpConnection udpConnection, int n) {
        if (n >= 0 && n < 4) {
            return udpConnection.players[n];
        }
        return null;
    }

    private static void receiveClientCommand(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        byte by = byteBuffer.get();
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        boolean bl = byteBuffer.get() == 1;
        KahluaTable kahluaTable = null;
        if (bl) {
            kahluaTable = LuaManager.platform.newTable();
            try {
                TableNetworkUtils.load(kahluaTable, byteBuffer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        IsoPlayer isoPlayer = SinglePlayerServer.getPlayerFromConnection(udpConnection, by);
        if (by == -1) {
            isoPlayer = SinglePlayerServer.getAnyPlayerFromConnection(udpConnection);
        }
        if (isoPlayer == null) {
            DebugLog.log("receiveClientCommand: player is null");
            return;
        }
        LuaEventManager.triggerEvent("OnClientCommand", string, string2, isoPlayer, kahluaTable);
    }

    private static void receiveGlobalObjects(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        byte by = byteBuffer.get();
        IsoPlayer isoPlayer = SinglePlayerServer.getPlayerFromConnection(udpConnection, by);
        if (by == -1) {
            isoPlayer = SinglePlayerServer.getAnyPlayerFromConnection(udpConnection);
        }
        if (isoPlayer == null) {
            DebugLog.log("receiveGlobalObjects: player is null");
            return;
        }
        SGlobalObjectNetwork.receive(byteBuffer, isoPlayer);
    }

    public static void Reset() {
        for (ZomboidNetData zomboidNetData : MainLoopNetData) {
            ZomboidNetDataPool.instance.discard(zomboidNetData);
        }
        MainLoopNetData.clear();
    }

    public static final class UdpEngineServer
    extends UdpEngine {
        public final ArrayList<UdpConnection> connections = new ArrayList();

        UdpEngineServer() {
            this.connections.add(new UdpConnection(this));
        }

        @Override
        public void Send(ByteBuffer byteBuffer) {
            SinglePlayerClient.udpEngine.Receive(byteBuffer);
        }

        @Override
        public void Receive(ByteBuffer byteBuffer) {
            int n = byteBuffer.get() & 0xFF;
            short s = byteBuffer.getShort();
            SinglePlayerServer.addIncoming(s, byteBuffer, SinglePlayerServer.udpEngine.connections.get(0));
        }
    }
}

