/*
 * Decompiled with CFR 0.152.
 */
package zombie.spnetwork;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.network.ByteBufferWriter;
import zombie.debug.DebugLog;
import zombie.globalObjects.CGlobalObjectNetwork;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.network.GameClient;
import zombie.network.PacketTypes;
import zombie.network.TableNetworkUtils;
import zombie.spnetwork.SinglePlayerServer;
import zombie.spnetwork.UdpConnection;
import zombie.spnetwork.UdpEngine;
import zombie.spnetwork.ZomboidNetData;
import zombie.spnetwork.ZomboidNetDataPool;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleManager;

public final class SinglePlayerClient {
    private static final ArrayList<ZomboidNetData> MainLoopNetData = new ArrayList();
    public static final UdpEngine udpEngine = new UdpEngineClient();
    public static final UdpConnection connection = new UdpConnection(udpEngine);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIncoming(short s, ByteBuffer byteBuffer) {
        ZomboidNetData zomboidNetData = byteBuffer.remaining() > 2048 ? ZomboidNetDataPool.instance.getLong(byteBuffer.remaining()) : ZomboidNetDataPool.instance.get();
        zomboidNetData.read(s, byteBuffer, connection);
        ArrayList<ZomboidNetData> arrayList = MainLoopNetData;
        synchronized (arrayList) {
            MainLoopNetData.add(zomboidNetData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() throws Exception {
        if (GameClient.bClient) {
            return;
        }
        for (short s = 0; s < IsoPlayer.numPlayers; s = (short)(s + 1)) {
            if (IsoPlayer.players[s] == null) continue;
            IsoPlayer.players[s].setOnlineID(s);
        }
        ArrayList<ZomboidNetData> arrayList = MainLoopNetData;
        synchronized (arrayList) {
            for (int i = 0; i < MainLoopNetData.size(); ++i) {
                ZomboidNetData zomboidNetData = MainLoopNetData.get(i);
                try {
                    SinglePlayerClient.mainLoopDealWithNetData(zomboidNetData);
                    continue;
                }
                finally {
                    MainLoopNetData.remove(i--);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mainLoopDealWithNetData(ZomboidNetData zomboidNetData) throws Exception {
        ByteBuffer byteBuffer = zomboidNetData.buffer;
        try {
            PacketTypes.PacketType packetType = PacketTypes.packetTypes.get(zomboidNetData.type);
            switch (packetType) {
                case ClientCommand: {
                    SinglePlayerClient.receiveServerCommand(byteBuffer);
                    return;
                }
                case GlobalObjects: {
                    CGlobalObjectNetwork.receive(byteBuffer);
                    return;
                }
                case ObjectChange: {
                    SinglePlayerClient.receiveObjectChange(byteBuffer);
                    return;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + packetType);
                }
            }
        }
        finally {
            ZomboidNetDataPool.instance.discard(zomboidNetData);
        }
    }

    private static void delayPacket(int n, int n2, int n3) {
    }

    private static IsoPlayer getPlayerByID(int n) {
        return IsoPlayer.players[n];
    }

    private static void receiveObjectChange(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by == 1) {
            IsoPlayer isoPlayer;
            short s = byteBuffer.getShort();
            String string = GameWindow.ReadString(byteBuffer);
            if (Core.bDebug) {
                DebugLog.log("receiveObjectChange " + string);
            }
            if ((isoPlayer = SinglePlayerClient.getPlayerByID(s)) != null) {
                isoPlayer.loadChange(string, byteBuffer);
            }
        } else if (by == 2) {
            BaseVehicle baseVehicle;
            short s = byteBuffer.getShort();
            String string = GameWindow.ReadString(byteBuffer);
            if (Core.bDebug) {
                DebugLog.log("receiveObjectChange " + string);
            }
            if ((baseVehicle = VehicleManager.instance.getVehicleByID(s)) != null) {
                baseVehicle.loadChange(string, byteBuffer);
            } else if (Core.bDebug) {
                DebugLog.log("receiveObjectChange: unknown vehicle id=" + s);
            }
        } else if (by == 3) {
            IsoGridSquare isoGridSquare;
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            String string = GameWindow.ReadString(byteBuffer);
            if (Core.bDebug) {
                DebugLog.log("receiveObjectChange " + string);
            }
            if ((isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3)) == null) {
                SinglePlayerClient.delayPacket(n, n2, n3);
                return;
            }
            for (int i = 0; i < isoGridSquare.getWorldObjects().size(); ++i) {
                IsoWorldInventoryObject isoWorldInventoryObject = isoGridSquare.getWorldObjects().get(i);
                if (isoWorldInventoryObject.getItem() == null || isoWorldInventoryObject.getItem().getID() != n4) continue;
                isoWorldInventoryObject.loadChange(string, byteBuffer);
                return;
            }
            if (Core.bDebug) {
                DebugLog.log("receiveObjectChange: itemID=" + n4 + " is invalid x,y,z=" + n + "," + n2 + "," + n3);
            }
        } else {
            IsoGridSquare isoGridSquare;
            int n = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            int n6 = byteBuffer.getInt();
            int n7 = byteBuffer.getInt();
            String string = GameWindow.ReadString(byteBuffer);
            if (Core.bDebug) {
                DebugLog.log("receiveObjectChange " + string);
            }
            if ((isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n5, n6)) == null) {
                SinglePlayerClient.delayPacket(n, n5, n6);
                return;
            }
            if (n7 >= 0 && n7 < isoGridSquare.getObjects().size()) {
                IsoObject isoObject = isoGridSquare.getObjects().get(n7);
                isoObject.loadChange(string, byteBuffer);
            } else if (Core.bDebug) {
                DebugLog.log("receiveObjectChange: index=" + n7 + " is invalid x,y,z=" + n + "," + n5 + "," + n6);
            }
        }
    }

    public static void sendClientCommand(IsoPlayer isoPlayer, String string, String string2, KahluaTable kahluaTable) {
        ByteBufferWriter byteBufferWriter = connection.startPacket();
        PacketTypes.PacketType.ClientCommand.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)(isoPlayer != null ? isoPlayer.PlayerIndex : -1));
        byteBufferWriter.putUTF(string);
        byteBufferWriter.putUTF(string2);
        if (kahluaTable == null || kahluaTable.isEmpty()) {
            byteBufferWriter.putByte((byte)0);
        } else {
            byteBufferWriter.putByte((byte)1);
            try {
                KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
                while (kahluaTableIterator.advance()) {
                    if (TableNetworkUtils.canSave(kahluaTableIterator.getKey(), kahluaTableIterator.getValue())) continue;
                    DebugLog.log("ERROR: sendClientCommand: can't save key,value=" + kahluaTableIterator.getKey() + "," + kahluaTableIterator.getValue());
                }
                TableNetworkUtils.save(kahluaTable, byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        connection.endPacketImmediate();
    }

    private static void receiveServerCommand(ByteBuffer byteBuffer) {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        boolean bl = byteBuffer.get() == 1;
        KahluaTable kahluaTable = null;
        if (bl) {
            kahluaTable = LuaManager.platform.newTable();
            try {
                TableNetworkUtils.load(kahluaTable, byteBuffer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        LuaEventManager.triggerEvent("OnServerCommand", string, string2, kahluaTable);
    }

    public static void Reset() {
        for (ZomboidNetData zomboidNetData : MainLoopNetData) {
            ZomboidNetDataPool.instance.discard(zomboidNetData);
        }
        MainLoopNetData.clear();
    }

    private static final class UdpEngineClient
    extends UdpEngine {
        private UdpEngineClient() {
        }

        @Override
        public void Send(ByteBuffer byteBuffer) {
            SinglePlayerServer.udpEngine.Receive(byteBuffer);
        }

        @Override
        public void Receive(ByteBuffer byteBuffer) {
            int n = byteBuffer.get() & 0xFF;
            short s = byteBuffer.getShort();
            SinglePlayerClient.addIncoming(s, byteBuffer);
        }
    }
}

