/*
 * Decompiled with CFR 0.152.
 */
package zombie.scripting.objects;

import gnu.trove.list.array.TFloatArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector4f;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.SystemDisabler;
import zombie.core.BoxedStaticValues;
import zombie.core.ImmutableColor;
import zombie.core.math.PZMath;
import zombie.core.physics.Bullet;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.network.GameServer;
import zombie.scripting.ScriptManager;
import zombie.scripting.ScriptParser;
import zombie.scripting.objects.BaseScriptObject;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.VehicleTemplate;
import zombie.util.StringUtils;
import zombie.vehicles.BaseVehicle;

public final class VehicleScript
extends BaseScriptObject {
    private String fileName;
    private String name;
    private final ArrayList<Model> models = new ArrayList();
    public final ArrayList<ModelAttachment> m_attachments = new ArrayList();
    private float mass = 800.0f;
    private final Vector3f centerOfMassOffset = new Vector3f();
    private float engineForce = 3000.0f;
    private float engineIdleSpeed = 750.0f;
    private float steeringIncrement = 0.04f;
    private float steeringClamp = 0.4f;
    private float steeringClampMax = 0.9f;
    private float wheelFriction = 800.0f;
    private float stoppingMovementForce = 1.0f;
    private float suspensionStiffness = 20.0f;
    private float suspensionDamping = 2.3f;
    private float suspensionCompression = 4.4f;
    private float suspensionRestLength = 0.6f;
    private float maxSuspensionTravelCm = 500.0f;
    private float rollInfluence = 0.1f;
    private final Vector3f extents = new Vector3f(0.75f, 0.5f, 2.0f);
    private final Vector2f shadowExtents = new Vector2f(0.0f, 0.0f);
    private final Vector2f shadowOffset = new Vector2f(0.0f, 0.0f);
    private boolean bHadShadowOExtents = false;
    private boolean bHadShadowOffset = false;
    private final Vector2f extentsOffset = new Vector2f(0.5f, 0.5f);
    private final Vector3f physicsChassisShape = new Vector3f(0.75f, 0.5f, 1.0f);
    private final ArrayList<PhysicsShape> m_physicsShapes = new ArrayList();
    private final ArrayList<Wheel> wheels = new ArrayList();
    private final ArrayList<Passenger> passengers = new ArrayList();
    public float maxSpeed = 20.0f;
    public boolean isSmallVehicle = true;
    public float spawnOffsetY = 0.0f;
    private int frontEndHealth = 100;
    private int rearEndHealth = 100;
    private int storageCapacity = 100;
    private int engineLoudness = 100;
    private int engineQuality = 100;
    private int seats = 2;
    private int mechanicType;
    private int engineRepairLevel;
    private float playerDamageProtection;
    private float forcedHue = -1.0f;
    private float forcedSat = -1.0f;
    private float forcedVal = -1.0f;
    public ImmutableColor leftSirenCol;
    public ImmutableColor rightSirenCol;
    private String engineRPMType = "jeep";
    private float offroadEfficiency = 1.0f;
    private final TFloatArrayList crawlOffsets = new TFloatArrayList();
    public int gearRatioCount = 4;
    public final float[] gearRatio = new float[9];
    private final Skin textures = new Skin();
    private final ArrayList<Skin> skins = new ArrayList();
    private final ArrayList<Area> areas = new ArrayList();
    private final ArrayList<Part> parts = new ArrayList();
    private boolean hasSiren = false;
    private final LightBar lightbar = new LightBar();
    private final Sounds sound = new Sounds();
    public boolean textureMaskEnable = false;
    private static final int PHYSICS_SHAPE_BOX = 1;
    private static final int PHYSICS_SHAPE_SPHERE = 2;

    public VehicleScript() {
        this.gearRatio[0] = 7.09f;
        this.gearRatio[1] = 6.44f;
        this.gearRatio[2] = 4.1f;
        this.gearRatio[3] = 2.29f;
        this.gearRatio[4] = 1.47f;
        this.gearRatio[5] = 1.0f;
    }

    public void Load(String string, String string2) {
        ScriptManager scriptManager = ScriptManager.instance;
        this.fileName = scriptManager.currentFileName;
        if (!scriptManager.scriptsWithVehicles.contains(this.fileName)) {
            scriptManager.scriptsWithVehicles.add(this.fileName);
        }
        this.name = string;
        ScriptParser.Block block = ScriptParser.parse(string2);
        block = block.children.get(0);
        for (ScriptParser.BlockElement blockElement : block.elements) {
            Object object;
            Object object3;
            String[] stringArray;
            if (blockElement.asValue() != null) {
                stringArray = blockElement.asValue().string.split("=");
                object3 = stringArray[0].trim();
                String string3 = stringArray[1].trim();
                if ("extents".equals(object3)) {
                    this.LoadVector3f(string3, this.extents);
                    continue;
                }
                if ("shadowExtents".equals(object3)) {
                    this.LoadVector2f(string3, this.shadowExtents);
                    this.bHadShadowOExtents = true;
                    continue;
                }
                if ("shadowOffset".equals(object3)) {
                    this.LoadVector2f(string3, this.shadowOffset);
                    this.bHadShadowOffset = true;
                    continue;
                }
                if ("physicsChassisShape".equals(object3)) {
                    this.LoadVector3f(string3, this.physicsChassisShape);
                    continue;
                }
                if ("extentsOffset".equals(object3)) {
                    this.LoadVector2f(string3, this.extentsOffset);
                    continue;
                }
                if ("mass".equals(object3)) {
                    this.mass = Float.parseFloat(string3);
                    continue;
                }
                if ("offRoadEfficiency".equalsIgnoreCase((String)object3)) {
                    this.offroadEfficiency = Float.parseFloat(string3);
                    continue;
                }
                if ("centerOfMassOffset".equals(object3)) {
                    this.LoadVector3f(string3, this.centerOfMassOffset);
                    continue;
                }
                if ("engineForce".equals(object3)) {
                    this.engineForce = Float.parseFloat(string3);
                    continue;
                }
                if ("engineIdleSpeed".equals(object3)) {
                    this.engineIdleSpeed = Float.parseFloat(string3);
                    continue;
                }
                if ("gearRatioCount".equals(object3)) {
                    this.gearRatioCount = Integer.parseInt(string3);
                    continue;
                }
                if ("gearRatioR".equals(object3)) {
                    this.gearRatio[0] = Float.parseFloat(string3);
                    continue;
                }
                if ("gearRatio1".equals(object3)) {
                    this.gearRatio[1] = Float.parseFloat(string3);
                    continue;
                }
                if ("gearRatio2".equals(object3)) {
                    this.gearRatio[2] = Float.parseFloat(string3);
                    continue;
                }
                if ("gearRatio3".equals(object3)) {
                    this.gearRatio[3] = Float.parseFloat(string3);
                    continue;
                }
                if ("gearRatio4".equals(object3)) {
                    this.gearRatio[4] = Float.parseFloat(string3);
                    continue;
                }
                if ("gearRatio5".equals(object3)) {
                    this.gearRatio[5] = Float.parseFloat(string3);
                    continue;
                }
                if ("gearRatio6".equals(object3)) {
                    this.gearRatio[6] = Float.parseFloat(string3);
                    continue;
                }
                if ("gearRatio7".equals(object3)) {
                    this.gearRatio[7] = Float.parseFloat(string3);
                    continue;
                }
                if ("gearRatio8".equals(object3)) {
                    this.gearRatio[8] = Float.parseFloat(string3);
                    continue;
                }
                if ("textureMaskEnable".equals(object3)) {
                    this.textureMaskEnable = Boolean.parseBoolean(string3);
                    continue;
                }
                if ("textureRust".equals(object3)) {
                    this.textures.textureRust = StringUtils.discardNullOrWhitespace(string3);
                    continue;
                }
                if ("textureMask".equals(object3)) {
                    this.textures.textureMask = StringUtils.discardNullOrWhitespace(string3);
                    continue;
                }
                if ("textureLights".equals(object3)) {
                    this.textures.textureLights = StringUtils.discardNullOrWhitespace(string3);
                    continue;
                }
                if ("textureDamage1Overlay".equals(object3)) {
                    this.textures.textureDamage1Overlay = StringUtils.discardNullOrWhitespace(string3);
                    continue;
                }
                if ("textureDamage1Shell".equals(object3)) {
                    this.textures.textureDamage1Shell = StringUtils.discardNullOrWhitespace(string3);
                    continue;
                }
                if ("textureDamage2Overlay".equals(object3)) {
                    this.textures.textureDamage2Overlay = StringUtils.discardNullOrWhitespace(string3);
                    continue;
                }
                if ("textureDamage2Shell".equals(object3)) {
                    this.textures.textureDamage2Shell = StringUtils.discardNullOrWhitespace(string3);
                    continue;
                }
                if ("textureShadow".equals(object3)) {
                    this.textures.textureShadow = StringUtils.discardNullOrWhitespace(string3);
                    continue;
                }
                if ("rollInfluence".equals(object3)) {
                    this.rollInfluence = Float.parseFloat(string3);
                    continue;
                }
                if ("steeringIncrement".equals(object3)) {
                    this.steeringIncrement = Float.parseFloat(string3);
                    continue;
                }
                if ("steeringClamp".equals(object3)) {
                    this.steeringClamp = Float.parseFloat(string3);
                    continue;
                }
                if ("suspensionStiffness".equals(object3)) {
                    this.suspensionStiffness = Float.parseFloat(string3);
                    continue;
                }
                if ("suspensionDamping".equals(object3)) {
                    this.suspensionDamping = Float.parseFloat(string3);
                    continue;
                }
                if ("suspensionCompression".equals(object3)) {
                    this.suspensionCompression = Float.parseFloat(string3);
                    continue;
                }
                if ("suspensionRestLength".equals(object3)) {
                    this.suspensionRestLength = Float.parseFloat(string3);
                    continue;
                }
                if ("maxSuspensionTravelCm".equals(object3)) {
                    this.maxSuspensionTravelCm = Float.parseFloat(string3);
                    continue;
                }
                if ("wheelFriction".equals(object3)) {
                    this.wheelFriction = Float.parseFloat(string3);
                    continue;
                }
                if ("stoppingMovementForce".equals(object3)) {
                    this.stoppingMovementForce = Float.parseFloat(string3);
                    continue;
                }
                if ("maxSpeed".equals(object3)) {
                    this.maxSpeed = Float.parseFloat(string3);
                    continue;
                }
                if ("isSmallVehicle".equals(object3)) {
                    this.isSmallVehicle = Boolean.parseBoolean(string3);
                    continue;
                }
                if ("spawnOffsetY".equals(object3)) {
                    this.spawnOffsetY = Float.parseFloat(string3) - 0.995f;
                    continue;
                }
                if ("frontEndDurability".equals(object3)) {
                    this.frontEndHealth = Integer.parseInt(string3);
                    continue;
                }
                if ("rearEndDurability".equals(object3)) {
                    this.rearEndHealth = Integer.parseInt(string3);
                    continue;
                }
                if ("storageCapacity".equals(object3)) {
                    this.storageCapacity = Integer.parseInt(string3);
                    continue;
                }
                if ("engineLoudness".equals(object3)) {
                    this.engineLoudness = Integer.parseInt(string3);
                    continue;
                }
                if ("engineQuality".equals(object3)) {
                    this.engineQuality = Integer.parseInt(string3);
                    continue;
                }
                if ("seats".equals(object3)) {
                    this.seats = Integer.parseInt(string3);
                    continue;
                }
                if ("hasSiren".equals(object3)) {
                    this.hasSiren = Boolean.parseBoolean(string3);
                    continue;
                }
                if ("mechanicType".equals(object3)) {
                    this.mechanicType = Integer.parseInt(string3);
                    continue;
                }
                if ("forcedColor".equals(object3)) {
                    String[] stringArray2 = string3.split(" ");
                    this.setForcedHue(Float.parseFloat(stringArray2[0]));
                    this.setForcedSat(Float.parseFloat(stringArray2[1]));
                    this.setForcedVal(Float.parseFloat(stringArray2[2]));
                    continue;
                }
                if ("engineRPMType".equals(object3)) {
                    this.engineRPMType = string3.trim();
                    continue;
                }
                if ("template".equals(object3)) {
                    this.LoadTemplate(string3);
                    continue;
                }
                if ("template!".equals(object3)) {
                    String string4 = string3;
                    object = ScriptManager.instance.getVehicleTemplate(string4);
                    if (object == null) {
                        DebugLog.log("ERROR: template \"" + string4 + "\" not found");
                        continue;
                    }
                    this.Load(string, ((VehicleTemplate)object).body);
                    continue;
                }
                if ("engineRepairLevel".equals(object3)) {
                    this.engineRepairLevel = Integer.parseInt(string3);
                    continue;
                }
                if (!"playerDamageProtection".equals(object3)) continue;
                this.setPlayerDamageProtection(Float.parseFloat(string3));
                continue;
            }
            stringArray = blockElement.asBlock();
            if ("area".equals(stringArray.type)) {
                this.LoadArea((ScriptParser.Block)stringArray);
                continue;
            }
            if ("attachment".equals(stringArray.type)) {
                this.LoadAttachment((ScriptParser.Block)stringArray);
                continue;
            }
            if ("model".equals(stringArray.type)) {
                this.LoadModel((ScriptParser.Block)stringArray, this.models);
                continue;
            }
            if ("part".equals(stringArray.type)) {
                if (stringArray.id != null && stringArray.id.contains("*")) {
                    object3 = stringArray.id;
                    for (Part part : this.parts) {
                        if (!this.globMatch((String)object3, part.id)) continue;
                        stringArray.id = part.id;
                        this.LoadPart((ScriptParser.Block)stringArray);
                    }
                    continue;
                }
                this.LoadPart((ScriptParser.Block)stringArray);
                continue;
            }
            if ("passenger".equals(stringArray.type)) {
                if (stringArray.id != null && stringArray.id.contains("*")) {
                    object3 = stringArray.id;
                    for (Passenger passenger : this.passengers) {
                        if (!this.globMatch((String)object3, passenger.id)) continue;
                        stringArray.id = passenger.id;
                        this.LoadPassenger((ScriptParser.Block)stringArray);
                    }
                    continue;
                }
                this.LoadPassenger((ScriptParser.Block)stringArray);
                continue;
            }
            if ("physics".equals(stringArray.type)) {
                object3 = this.LoadPhysicsShape((ScriptParser.Block)stringArray);
                if (object3 == null || this.m_physicsShapes.size() >= 10) continue;
                this.m_physicsShapes.add((PhysicsShape)object3);
                continue;
            }
            if ("skin".equals(stringArray.type)) {
                object3 = this.LoadSkin((ScriptParser.Block)stringArray);
                if (StringUtils.isNullOrWhitespace(((Skin)object3).texture)) continue;
                this.skins.add((Skin)object3);
                continue;
            }
            if ("wheel".equals(stringArray.type)) {
                this.LoadWheel((ScriptParser.Block)stringArray);
                continue;
            }
            if ("lightbar".equals(stringArray.type)) {
                for (ScriptParser.Value value : stringArray.values) {
                    Object object2;
                    String string5 = value.getKey().trim();
                    object = value.getValue().trim();
                    if ("soundSiren".equals(string5)) {
                        this.lightbar.soundSiren0 = (String)object + "Yelp";
                        this.lightbar.soundSiren1 = (String)object + "Wall";
                        this.lightbar.soundSiren2 = (String)object + "Alarm";
                    }
                    if ("soundSiren0".equals(string5)) {
                        this.lightbar.soundSiren0 = object;
                    }
                    if ("soundSiren1".equals(string5)) {
                        this.lightbar.soundSiren1 = object;
                    }
                    if ("soundSiren2".equals(string5)) {
                        this.lightbar.soundSiren2 = object;
                    }
                    if ("leftCol".equals(string5)) {
                        object2 = ((String)object).split(";");
                        this.leftSirenCol = new ImmutableColor(Float.parseFloat(object2[0]), Float.parseFloat(object2[1]), Float.parseFloat(object2[2]));
                    }
                    if ("rightCol".equals(string5)) {
                        object2 = ((String)object).split(";");
                        this.rightSirenCol = new ImmutableColor(Float.parseFloat(object2[0]), Float.parseFloat(object2[1]), Float.parseFloat(object2[2]));
                    }
                    this.lightbar.enable = true;
                    if (this.getPartById("lightbar") != null) continue;
                    object2 = new Part();
                    object2.id = "lightbar";
                    this.parts.add((Part)object2);
                }
                continue;
            }
            if (!"sound".equals(stringArray.type)) continue;
            for (ScriptParser.Value value : stringArray.values) {
                String string6 = value.getKey().trim();
                object = value.getValue().trim();
                if ("backSignal".equals(string6)) {
                    this.sound.backSignal = StringUtils.discardNullOrWhitespace((String)object);
                    this.sound.backSignalEnable = this.sound.backSignal != null;
                    continue;
                }
                if ("engine".equals(string6)) {
                    this.sound.engine = StringUtils.discardNullOrWhitespace((String)object);
                    continue;
                }
                if ("engineStart".equals(string6)) {
                    this.sound.engineStart = StringUtils.discardNullOrWhitespace((String)object);
                    continue;
                }
                if ("engineTurnOff".equals(string6)) {
                    this.sound.engineTurnOff = StringUtils.discardNullOrWhitespace((String)object);
                    continue;
                }
                if ("horn".equals(string6)) {
                    this.sound.horn = StringUtils.discardNullOrWhitespace((String)object);
                    this.sound.hornEnable = this.sound.horn != null;
                    continue;
                }
                if ("ignitionFail".equals(string6)) {
                    this.sound.ignitionFail = StringUtils.discardNullOrWhitespace((String)object);
                    continue;
                }
                if (!"ignitionFailNoPower".equals(string6)) continue;
                this.sound.ignitionFailNoPower = StringUtils.discardNullOrWhitespace((String)object);
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void Loaded() {
        int n;
        int n2;
        float f = this.getModelScale();
        this.extents.mul(f);
        this.maxSuspensionTravelCm *= f;
        this.suspensionRestLength *= f;
        this.centerOfMassOffset.mul(f);
        this.physicsChassisShape.mul(f);
        if (this.bHadShadowOExtents) {
            this.shadowExtents.mul(f);
        } else {
            this.shadowExtents.set(this.extents.x(), this.extents.z());
        }
        if (this.bHadShadowOffset) {
            this.shadowOffset.mul(f);
        } else {
            this.shadowOffset.set(this.centerOfMassOffset.x(), this.centerOfMassOffset.z());
        }
        for (Model object2 : this.models) {
            object2.offset.mul(f);
        }
        for (ModelAttachment modelAttachment : this.m_attachments) {
            modelAttachment.getOffset().mul(f);
        }
        for (PhysicsShape physicsShape : this.m_physicsShapes) {
            physicsShape.offset.mul(f);
            switch (physicsShape.type) {
                case 1: {
                    physicsShape.extents.mul(f);
                    break;
                }
                case 2: {
                    physicsShape.radius *= f;
                }
            }
        }
        for (Wheel wheel : this.wheels) {
            wheel.radius *= f;
            wheel.offset.mul(f);
        }
        for (Area area : this.areas) {
            area.x *= f;
            area.y *= f;
            area.w *= f;
            area.h *= f;
        }
        if (!this.extents.equals(this.physicsChassisShape)) {
            DebugLog.Script.warn("vehicle \"" + this.name + "\" extents != physicsChassisShape");
        }
        for (n2 = 0; n2 < this.passengers.size(); ++n2) {
            Object object;
            Passenger passenger = this.passengers.get(n2);
            for (n = 0; n < passenger.getPositionCount(); ++n) {
                object = passenger.getPosition(n);
                ((Position)object).getOffset().mul(f);
            }
            for (n = 0; n < passenger.switchSeats.size(); ++n) {
                object = passenger.switchSeats.get(n);
                ((Passenger.SwitchSeat)object).seat = this.getPassengerIndex(((Passenger.SwitchSeat)object).id);
                assert (((Passenger.SwitchSeat)object).seat != -1);
            }
        }
        for (n2 = 0; n2 < this.parts.size(); ++n2) {
            Part part = this.parts.get(n2);
            if (part.container != null && part.container.seatID != null && !part.container.seatID.isEmpty()) {
                part.container.seat = this.getPassengerIndex(part.container.seatID);
            }
            if (!part.specificItem || part.itemType == null) continue;
            for (n = 0; n < part.itemType.size(); ++n) {
                part.itemType.set(n, part.itemType.get(n) + this.mechanicType);
            }
        }
        this.initCrawlOffsets();
        if (!GameServer.bServer) {
            this.toBullet();
        }
    }

    public void toBullet() {
        Object object;
        int n;
        float[] fArray = new float[200];
        int n2 = 0;
        fArray[n2++] = this.getModelScale();
        fArray[n2++] = this.extents.x;
        fArray[n2++] = this.extents.y;
        fArray[n2++] = this.extents.z;
        fArray[n2++] = this.physicsChassisShape.x;
        fArray[n2++] = this.physicsChassisShape.y;
        fArray[n2++] = this.physicsChassisShape.z;
        fArray[n2++] = this.mass;
        fArray[n2++] = this.centerOfMassOffset.x;
        fArray[n2++] = this.centerOfMassOffset.y;
        fArray[n2++] = this.centerOfMassOffset.z;
        fArray[n2++] = this.rollInfluence;
        fArray[n2++] = this.suspensionStiffness;
        fArray[n2++] = this.suspensionCompression;
        fArray[n2++] = this.suspensionDamping;
        fArray[n2++] = this.maxSuspensionTravelCm;
        fArray[n2++] = this.suspensionRestLength;
        fArray[n2++] = SystemDisabler.getdoHighFriction() ? this.wheelFriction * 100.0f : this.wheelFriction;
        fArray[n2++] = this.stoppingMovementForce;
        fArray[n2++] = this.getWheelCount();
        for (n = 0; n < this.getWheelCount(); ++n) {
            object = this.getWheel(n);
            fArray[n2++] = ((Wheel)object).front ? 1.0f : 0.0f;
            fArray[n2++] = ((Wheel)object).offset.x + this.getModel().offset.x - 0.0f * this.centerOfMassOffset.x;
            fArray[n2++] = ((Wheel)object).offset.y + this.getModel().offset.y - 0.0f * this.centerOfMassOffset.y + 1.0f * this.suspensionRestLength;
            fArray[n2++] = ((Wheel)object).offset.z + this.getModel().offset.z - 0.0f * this.centerOfMassOffset.z;
            fArray[n2++] = ((Wheel)object).radius;
        }
        fArray[n2++] = this.m_physicsShapes.size() + 1;
        fArray[n2++] = 1.0f;
        fArray[n2++] = this.centerOfMassOffset.x;
        fArray[n2++] = this.centerOfMassOffset.y;
        fArray[n2++] = this.centerOfMassOffset.z;
        fArray[n2++] = this.physicsChassisShape.x;
        fArray[n2++] = this.physicsChassisShape.y;
        fArray[n2++] = this.physicsChassisShape.z;
        fArray[n2++] = 0.0f;
        fArray[n2++] = 0.0f;
        fArray[n2++] = 0.0f;
        for (n = 0; n < this.m_physicsShapes.size(); ++n) {
            object = this.m_physicsShapes.get(n);
            fArray[n2++] = ((PhysicsShape)object).type;
            fArray[n2++] = ((PhysicsShape)object).offset.x;
            fArray[n2++] = ((PhysicsShape)object).offset.y;
            fArray[n2++] = ((PhysicsShape)object).offset.z;
            if (((PhysicsShape)object).type == 1) {
                fArray[n2++] = ((PhysicsShape)object).extents.x;
                fArray[n2++] = ((PhysicsShape)object).extents.y;
                fArray[n2++] = ((PhysicsShape)object).extents.z;
                fArray[n2++] = ((PhysicsShape)object).rotate.x;
                fArray[n2++] = ((PhysicsShape)object).rotate.y;
                fArray[n2++] = ((PhysicsShape)object).rotate.z;
                continue;
            }
            if (((PhysicsShape)object).type != 2) continue;
            fArray[n2++] = ((PhysicsShape)object).radius;
        }
        Bullet.defineVehicleScript(this.getFullName(), fArray);
    }

    private void LoadVector2f(String string, Vector2f vector2f) {
        String[] stringArray = string.split(" ");
        vector2f.set(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]));
    }

    private void LoadVector3f(String string, Vector3f vector3f) {
        String[] stringArray = string.split(" ");
        vector3f.set(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
    }

    private void LoadVector4f(String string, Vector4f vector4f) {
        String[] stringArray = string.split(" ");
        vector4f.set(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]));
    }

    private void LoadVector2i(String string, Vector2i vector2i) {
        String[] stringArray = string.split(" ");
        vector2i.set(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
    }

    private ModelAttachment LoadAttachment(ScriptParser.Block block) {
        ModelAttachment modelAttachment = this.getAttachmentById(block.id);
        if (modelAttachment == null) {
            modelAttachment = new ModelAttachment(block.id);
            this.m_attachments.add(modelAttachment);
        }
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("bone".equals(string)) {
                modelAttachment.setBone(string2);
                continue;
            }
            if ("offset".equals(string)) {
                this.LoadVector3f(string2, modelAttachment.getOffset());
                continue;
            }
            if ("rotate".equals(string)) {
                this.LoadVector3f(string2, modelAttachment.getRotate());
                continue;
            }
            if ("canAttach".equals(string)) {
                modelAttachment.setCanAttach(new ArrayList<String>(Arrays.asList(string2.split(","))));
                continue;
            }
            if ("zoffset".equals(string)) {
                modelAttachment.setZOffset(Float.parseFloat(string2));
                continue;
            }
            if (!"updateconstraint".equals(string)) continue;
            modelAttachment.setUpdateConstraint(Boolean.parseBoolean(string2));
        }
        return modelAttachment;
    }

    private Model LoadModel(ScriptParser.Block block, ArrayList<Model> arrayList) {
        Model model = this.getModelById(block.id, arrayList);
        if (model == null) {
            model = new Model();
            model.id = block.id;
            arrayList.add(model);
        }
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("file".equals(string)) {
                model.file = string2;
                continue;
            }
            if ("offset".equals(string)) {
                this.LoadVector3f(string2, model.offset);
                continue;
            }
            if ("rotate".equals(string)) {
                this.LoadVector3f(string2, model.rotate);
                continue;
            }
            if (!"scale".equals(string)) continue;
            model.scale = Float.parseFloat(string2);
        }
        return model;
    }

    private Skin LoadSkin(ScriptParser.Block block) {
        Skin skin = new Skin();
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("texture".equals(string)) {
                skin.texture = StringUtils.discardNullOrWhitespace(string2);
                continue;
            }
            if ("textureRust".equals(string)) {
                skin.textureRust = StringUtils.discardNullOrWhitespace(string2);
                continue;
            }
            if ("textureMask".equals(string)) {
                skin.textureMask = StringUtils.discardNullOrWhitespace(string2);
                continue;
            }
            if ("textureLights".equals(string)) {
                skin.textureLights = StringUtils.discardNullOrWhitespace(string2);
                continue;
            }
            if ("textureDamage1Overlay".equals(string)) {
                skin.textureDamage1Overlay = StringUtils.discardNullOrWhitespace(string2);
                continue;
            }
            if ("textureDamage1Shell".equals(string)) {
                skin.textureDamage1Shell = StringUtils.discardNullOrWhitespace(string2);
                continue;
            }
            if ("textureDamage2Overlay".equals(string)) {
                skin.textureDamage2Overlay = StringUtils.discardNullOrWhitespace(string2);
                continue;
            }
            if ("textureDamage2Shell".equals(string)) {
                skin.textureDamage2Shell = StringUtils.discardNullOrWhitespace(string2);
                continue;
            }
            if (!"textureShadow".equals(string)) continue;
            skin.textureShadow = StringUtils.discardNullOrWhitespace(string2);
        }
        return skin;
    }

    private Wheel LoadWheel(ScriptParser.Block block) {
        Wheel wheel = this.getWheelById(block.id);
        if (wheel == null) {
            wheel = new Wheel();
            wheel.id = block.id;
            this.wheels.add(wheel);
        }
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("model".equals(string)) {
                wheel.model = string2;
                continue;
            }
            if ("front".equals(string)) {
                wheel.front = Boolean.parseBoolean(string2);
                continue;
            }
            if ("offset".equals(string)) {
                this.LoadVector3f(string2, wheel.offset);
                continue;
            }
            if ("radius".equals(string)) {
                wheel.radius = Float.parseFloat(string2);
                continue;
            }
            if (!"width".equals(string)) continue;
            wheel.width = Float.parseFloat(string2);
        }
        return wheel;
    }

    private Passenger LoadPassenger(ScriptParser.Block block) {
        Passenger passenger = this.getPassengerById(block.id);
        if (passenger == null) {
            passenger = new Passenger();
            passenger.id = block.id;
            this.passengers.add(passenger);
        }
        for (ScriptParser.Value blockElement : block.values) {
            String string = blockElement.getKey().trim();
            String string2 = blockElement.getValue().trim();
            if ("area".equals(string)) {
                passenger.area = string2;
                continue;
            }
            if ("door".equals(string)) {
                passenger.door = string2;
                continue;
            }
            if ("door2".equals(string)) {
                passenger.door2 = string2;
                continue;
            }
            if ("hasRoof".equals(string)) {
                passenger.hasRoof = Boolean.parseBoolean(string2);
                continue;
            }
            if (!"showPassenger".equals(string)) continue;
            passenger.showPassenger = Boolean.parseBoolean(string2);
        }
        for (ScriptParser.Block block2 : block.children) {
            if ("anim".equals(block2.type)) {
                this.LoadAnim(block2, passenger.anims);
                continue;
            }
            if ("position".equals(block2.type)) {
                this.LoadPosition(block2, passenger.positions);
                continue;
            }
            if (!"switchSeat".equals(block2.type)) continue;
            this.LoadPassengerSwitchSeat(block2, passenger);
        }
        return passenger;
    }

    private Anim LoadAnim(ScriptParser.Block block, ArrayList<Anim> arrayList) {
        Anim anim = this.getAnimationById(block.id, arrayList);
        if (anim == null) {
            anim = new Anim();
            anim.id = block.id;
            arrayList.add(anim);
        }
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("angle".equals(string)) {
                this.LoadVector3f(string2, anim.angle);
                continue;
            }
            if ("anim".equals(string)) {
                anim.anim = string2;
                continue;
            }
            if ("animate".equals(string)) {
                anim.bAnimate = Boolean.parseBoolean(string2);
                continue;
            }
            if ("loop".equals(string)) {
                anim.bLoop = Boolean.parseBoolean(string2);
                continue;
            }
            if ("reverse".equals(string)) {
                anim.bReverse = Boolean.parseBoolean(string2);
                continue;
            }
            if ("rate".equals(string)) {
                anim.rate = Float.parseFloat(string2);
                continue;
            }
            if ("offset".equals(string)) {
                this.LoadVector3f(string2, anim.offset);
                continue;
            }
            if (!"sound".equals(string)) continue;
            anim.sound = string2;
        }
        return anim;
    }

    private Passenger.SwitchSeat LoadPassengerSwitchSeat(ScriptParser.Block block, Passenger passenger) {
        Passenger.SwitchSeat switchSeat = passenger.getSwitchSeatById(block.id);
        if (block.isEmpty()) {
            if (switchSeat != null) {
                passenger.switchSeats.remove(switchSeat);
            }
            return null;
        }
        if (switchSeat == null) {
            switchSeat = new Passenger.SwitchSeat();
            switchSeat.id = block.id;
            passenger.switchSeats.add(switchSeat);
        }
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("anim".equals(string)) {
                switchSeat.anim = string2;
                continue;
            }
            if ("rate".equals(string)) {
                switchSeat.rate = Float.parseFloat(string2);
                continue;
            }
            if (!"sound".equals(string)) continue;
            switchSeat.sound = string2.isEmpty() ? null : string2;
        }
        return switchSeat;
    }

    private Area LoadArea(ScriptParser.Block block) {
        Area area = this.getAreaById(block.id);
        if (area == null) {
            area = new Area();
            area.id = block.id;
            this.areas.add(area);
        }
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if (!"xywh".equals(string)) continue;
            String[] stringArray = string2.split(" ");
            area.x = Float.parseFloat(stringArray[0]);
            area.y = Float.parseFloat(stringArray[1]);
            area.w = Float.parseFloat(stringArray[2]);
            area.h = Float.parseFloat(stringArray[3]);
        }
        return area;
    }

    private Part LoadPart(ScriptParser.Block block) {
        Object object;
        String string;
        Part part = this.getPartById(block.id);
        if (part == null) {
            part = new Part();
            part.id = block.id;
            this.parts.add(part);
        }
        for (ScriptParser.Value blockElement : block.values) {
            string = blockElement.getKey().trim();
            object = blockElement.getValue().trim();
            if ("area".equals(string)) {
                part.area = ((String)object).isEmpty() ? null : object;
                continue;
            }
            if ("itemType".equals(string)) {
                String[] stringArray;
                part.itemType = new ArrayList();
                for (String string2 : stringArray = ((String)object).split(";")) {
                    part.itemType.add(string2);
                }
                continue;
            }
            if ("parent".equals(string)) {
                part.parent = ((String)object).isEmpty() ? null : object;
                continue;
            }
            if ("mechanicRequireKey".equals(string)) {
                part.mechanicRequireKey = Boolean.parseBoolean((String)object);
                continue;
            }
            if ("repairMechanic".equals(string)) {
                part.setRepairMechanic(Boolean.parseBoolean((String)object));
                continue;
            }
            if ("setAllModelsVisible".equals(string)) {
                part.bSetAllModelsVisible = Boolean.parseBoolean((String)object);
                continue;
            }
            if ("wheel".equals(string)) {
                part.wheel = object;
                continue;
            }
            if ("category".equals(string)) {
                part.category = object;
                continue;
            }
            if ("specificItem".equals(string)) {
                part.specificItem = Boolean.parseBoolean((String)object);
                continue;
            }
            if (!"hasLightsRear".equals(string)) continue;
            part.hasLightsRear = Boolean.parseBoolean((String)object);
        }
        for (ScriptParser.Block block2 : block.children) {
            if ("anim".equals(block2.type)) {
                if (part.anims == null) {
                    part.anims = new ArrayList();
                }
                this.LoadAnim(block2, part.anims);
                continue;
            }
            if ("container".equals(block2.type)) {
                part.container = this.LoadContainer(block2, part.container);
                continue;
            }
            if ("door".equals(block2.type)) {
                part.door = this.LoadDoor(block2);
                continue;
            }
            if ("lua".equals(block2.type)) {
                part.luaFunctions = this.LoadLuaFunctions(block2);
                continue;
            }
            if ("model".equals(block2.type)) {
                if (part.models == null) {
                    part.models = new ArrayList();
                }
                this.LoadModel(block2, part.models);
                continue;
            }
            if ("table".equals(block2.type)) {
                string = part.tables == null ? null : part.tables.get(block2.id);
                object = this.LoadTable(block2, string instanceof KahluaTable ? (KahluaTable)((Object)string) : null);
                if (part.tables == null) {
                    part.tables = new HashMap();
                }
                part.tables.put(block2.id, (KahluaTable)object);
                continue;
            }
            if (!"window".equals(block2.type)) continue;
            part.window = this.LoadWindow(block2);
        }
        return part;
    }

    private PhysicsShape LoadPhysicsShape(ScriptParser.Block block) {
        int n = -1;
        switch (block.id) {
            case "box": {
                n = 1;
                break;
            }
            case "sphere": {
                n = 2;
                break;
            }
            default: {
                return null;
            }
        }
        Object object = new PhysicsShape();
        ((PhysicsShape)object).type = n;
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("extents".equalsIgnoreCase(string)) {
                this.LoadVector3f(string2, ((PhysicsShape)object).extents);
                continue;
            }
            if ("offset".equalsIgnoreCase(string)) {
                this.LoadVector3f(string2, ((PhysicsShape)object).offset);
                continue;
            }
            if ("radius".equalsIgnoreCase(string)) {
                ((PhysicsShape)object).radius = Float.parseFloat(string2);
                continue;
            }
            if (!"rotate".equalsIgnoreCase(string)) continue;
            this.LoadVector3f(string2, ((PhysicsShape)object).rotate);
        }
        switch (((PhysicsShape)object).type) {
            case 1: {
                if (!(((PhysicsShape)object).extents.x() <= 0.0f) && !(((PhysicsShape)object).extents.y() <= 0.0f) && !(((PhysicsShape)object).extents.z() <= 0.0f)) break;
                return null;
            }
            case 2: {
                if (!(((PhysicsShape)object).radius <= 0.0f)) break;
                return null;
            }
        }
        return object;
    }

    private Door LoadDoor(ScriptParser.Block block) {
        Door door = new Door();
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
        }
        return door;
    }

    private Window LoadWindow(ScriptParser.Block block) {
        Window window = new Window();
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if (!"openable".equals(string)) continue;
            window.openable = Boolean.parseBoolean(string2);
        }
        return window;
    }

    private Container LoadContainer(ScriptParser.Block block, Container container) {
        Container container2 = container == null ? new Container() : container;
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("capacity".equals(string)) {
                container2.capacity = Integer.parseInt(string2);
                continue;
            }
            if ("conditionAffectsCapacity".equals(string)) {
                container2.conditionAffectsCapacity = Boolean.parseBoolean(string2);
                continue;
            }
            if ("contentType".equals(string)) {
                container2.contentType = string2;
                continue;
            }
            if ("seat".equals(string)) {
                container2.seatID = string2;
                continue;
            }
            if (!"test".equals(string)) continue;
            container2.luaTest = string2;
        }
        return container2;
    }

    private HashMap<String, String> LoadLuaFunctions(ScriptParser.Block block) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (ScriptParser.Value value : block.values) {
            if (value.string.indexOf(61) == -1) {
                throw new RuntimeException("expected \"key = value\", got \"" + value.string.trim() + "\" in " + this.getFullName());
            }
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private Object checkIntegerKey(Object object) {
        if (!(object instanceof String)) {
            return object;
        }
        String string = (String)object;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return object;
        }
        return Double.valueOf(string);
    }

    private KahluaTable LoadTable(ScriptParser.Block block, KahluaTable kahluaTable) {
        Object object;
        Object object2;
        KahluaTable kahluaTable2 = kahluaTable == null ? LuaManager.platform.newTable() : kahluaTable;
        for (ScriptParser.Value blockElement : block.values) {
            object2 = blockElement.getKey().trim();
            object = blockElement.getValue().trim();
            if (((String)object).isEmpty()) {
                object = null;
            }
            kahluaTable2.rawset(this.checkIntegerKey(object2), object);
        }
        for (ScriptParser.Block block2 : block.children) {
            object2 = kahluaTable2.rawget(block2.type);
            object = this.LoadTable(block2, object2 instanceof KahluaTable ? (KahluaTable)object2 : null);
            kahluaTable2.rawset(this.checkIntegerKey(block2.type), object);
        }
        return kahluaTable2;
    }

    private void LoadTemplate(String string) {
        if (string.contains("/")) {
            String[] stringArray = string.split("/");
            if (stringArray.length == 0 || stringArray.length > 3) {
                DebugLog.log("ERROR: template \"" + string + "\"");
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if (!stringArray[i].isEmpty()) continue;
                DebugLog.log("ERROR: template \"" + string + "\"");
                return;
            }
            String string2 = stringArray[0];
            VehicleTemplate vehicleTemplate = ScriptManager.instance.getVehicleTemplate(string2);
            if (vehicleTemplate == null) {
                DebugLog.log("ERROR: template \"" + string + "\" not found");
                return;
            }
            VehicleScript vehicleScript = vehicleTemplate.getScript();
            switch (stringArray[1]) {
                case "area": {
                    if (stringArray.length == 2) {
                        DebugLog.log("ERROR: template \"" + string + "\"");
                        return;
                    }
                    this.copyAreasFrom(vehicleScript, stringArray[2]);
                    break;
                }
                case "part": {
                    if (stringArray.length == 2) {
                        DebugLog.log("ERROR: template \"" + string + "\"");
                        return;
                    }
                    this.copyPartsFrom(vehicleScript, stringArray[2]);
                    break;
                }
                case "passenger": {
                    if (stringArray.length == 2) {
                        DebugLog.log("ERROR: template \"" + string + "\"");
                        return;
                    }
                    this.copyPassengersFrom(vehicleScript, stringArray[2]);
                    break;
                }
                case "wheel": {
                    if (stringArray.length == 2) {
                        DebugLog.log("ERROR: template \"" + string + "\"");
                        return;
                    }
                    this.copyWheelsFrom(vehicleScript, stringArray[2]);
                    break;
                }
                default: {
                    DebugLog.log("ERROR: template \"" + string + "\"");
                    return;
                }
            }
        } else {
            String string3 = string.trim();
            VehicleTemplate vehicleTemplate = ScriptManager.instance.getVehicleTemplate(string3);
            if (vehicleTemplate == null) {
                DebugLog.log("ERROR: template \"" + string + "\" not found");
                return;
            }
            VehicleScript vehicleScript = vehicleTemplate.getScript();
            this.copyAreasFrom(vehicleScript, "*");
            this.copyPartsFrom(vehicleScript, "*");
            this.copyPassengersFrom(vehicleScript, "*");
            this.copyWheelsFrom(vehicleScript, "*");
        }
    }

    public void copyAreasFrom(VehicleScript vehicleScript, String string) {
        if ("*".equals(string)) {
            for (int i = 0; i < vehicleScript.getAreaCount(); ++i) {
                Area area = vehicleScript.getArea(i);
                int n = this.getIndexOfAreaById(area.id);
                if (n == -1) {
                    this.areas.add(area.makeCopy());
                    continue;
                }
                this.areas.set(n, area.makeCopy());
            }
        } else {
            Area area = vehicleScript.getAreaById(string);
            if (area == null) {
                DebugLog.log("ERROR: area \"" + string + "\" not found");
                return;
            }
            int n = this.getIndexOfAreaById(area.id);
            if (n == -1) {
                this.areas.add(area.makeCopy());
            } else {
                this.areas.set(n, area.makeCopy());
            }
        }
    }

    public void copyPartsFrom(VehicleScript vehicleScript, String string) {
        if ("*".equals(string)) {
            for (int i = 0; i < vehicleScript.getPartCount(); ++i) {
                Part part = vehicleScript.getPart(i);
                int n = this.getIndexOfPartById(part.id);
                if (n == -1) {
                    this.parts.add(part.makeCopy());
                    continue;
                }
                this.parts.set(n, part.makeCopy());
            }
        } else {
            Part part = vehicleScript.getPartById(string);
            if (part == null) {
                DebugLog.log("ERROR: part \"" + string + "\" not found");
                return;
            }
            int n = this.getIndexOfPartById(part.id);
            if (n == -1) {
                this.parts.add(part.makeCopy());
            } else {
                this.parts.set(n, part.makeCopy());
            }
        }
    }

    public void copyPassengersFrom(VehicleScript vehicleScript, String string) {
        if ("*".equals(string)) {
            for (int i = 0; i < vehicleScript.getPassengerCount(); ++i) {
                Passenger passenger = vehicleScript.getPassenger(i);
                int n = this.getPassengerIndex(passenger.id);
                if (n == -1) {
                    this.passengers.add(passenger.makeCopy());
                    continue;
                }
                this.passengers.set(n, passenger.makeCopy());
            }
        } else {
            Passenger passenger = vehicleScript.getPassengerById(string);
            if (passenger == null) {
                DebugLog.log("ERROR: passenger \"" + string + "\" not found");
                return;
            }
            int n = this.getPassengerIndex(passenger.id);
            if (n == -1) {
                this.passengers.add(passenger.makeCopy());
            } else {
                this.passengers.set(n, passenger.makeCopy());
            }
        }
    }

    public void copyWheelsFrom(VehicleScript vehicleScript, String string) {
        if ("*".equals(string)) {
            for (int i = 0; i < vehicleScript.getWheelCount(); ++i) {
                Wheel wheel = vehicleScript.getWheel(i);
                int n = this.getIndexOfWheelById(wheel.id);
                if (n == -1) {
                    this.wheels.add(wheel.makeCopy());
                    continue;
                }
                this.wheels.set(n, wheel.makeCopy());
            }
        } else {
            Wheel wheel = vehicleScript.getWheelById(string);
            if (wheel == null) {
                DebugLog.log("ERROR: wheel \"" + string + "\" not found");
                return;
            }
            int n = this.getIndexOfWheelById(wheel.id);
            if (n == -1) {
                this.wheels.add(wheel.makeCopy());
            } else {
                this.wheels.set(n, wheel.makeCopy());
            }
        }
    }

    private Position LoadPosition(ScriptParser.Block block, ArrayList<Position> arrayList) {
        Position position = this.getPositionById(block.id, arrayList);
        if (block.isEmpty()) {
            if (position != null) {
                arrayList.remove(position);
            }
            return null;
        }
        if (position == null) {
            position = new Position();
            position.id = block.id;
            arrayList.add(position);
        }
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("rotate".equals(string)) {
                this.LoadVector3f(string2, position.rotate);
                continue;
            }
            if ("offset".equals(string)) {
                this.LoadVector3f(string2, position.offset);
                continue;
            }
            if (!"area".equals(string)) continue;
            position.area = string2.isEmpty() ? null : string2;
        }
        return position;
    }

    private void initCrawlOffsets() {
        int n;
        for (int i = 0; i < this.getWheelCount(); ++i) {
            Wheel wheel = this.getWheel(i);
            if (!wheel.id.contains("Left")) continue;
            this.initCrawlOffsets(wheel);
        }
        float f = this.extents.z + BaseVehicle.PLUS_RADIUS * 2.0f;
        for (n = 0; n < this.crawlOffsets.size(); ++n) {
            this.crawlOffsets.set(n, (this.extents.z / 2.0f + BaseVehicle.PLUS_RADIUS + this.crawlOffsets.get(n) - this.centerOfMassOffset.z) / f);
        }
        this.crawlOffsets.sort();
        for (n = 0; n < this.crawlOffsets.size(); ++n) {
            float f2 = this.crawlOffsets.get(n);
            for (int i = n + 1; i < this.crawlOffsets.size(); ++i) {
                float f3 = this.crawlOffsets.get(i);
                if (!((f3 - f2) * f < 0.15f)) continue;
                this.crawlOffsets.removeAt(i--);
            }
        }
    }

    private void initCrawlOffsets(Wheel wheel) {
        float f = 0.3f;
        float f2 = this.getModel() == null ? 0.0f : this.getModel().getOffset().z;
        float f3 = this.centerOfMassOffset.z + this.extents.z / 2.0f;
        float f4 = this.centerOfMassOffset.z - this.extents.z / 2.0f;
        for (int i = 0; i < 10; ++i) {
            float f5 = f2 + wheel.offset.z + wheel.radius + f + f * (float)i;
            if (f5 + f <= f3 && !this.isOverlappingWheel(f5)) {
                this.crawlOffsets.add(f5);
            }
            if (!((f5 = f2 + wheel.offset.z - wheel.radius - f - f * (float)i) - f >= f4) || this.isOverlappingWheel(f5)) continue;
            this.crawlOffsets.add(f5);
        }
    }

    private boolean isOverlappingWheel(float f) {
        float f2 = 0.3f;
        float f3 = this.getModel() == null ? 0.0f : this.getModel().getOffset().z;
        for (int i = 0; i < this.getWheelCount(); ++i) {
            Wheel wheel = this.getWheel(i);
            if (!wheel.id.contains("Left") || !(Math.abs(f3 + wheel.offset.z - f) < (wheel.radius + f2) * 0.99f)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getModule().getName() + "." + this.getName();
    }

    public Model getModel() {
        return this.models.isEmpty() ? null : this.models.get(0);
    }

    public Vector3f getModelOffset() {
        return this.getModel() == null ? null : this.getModel().getOffset();
    }

    public float getModelScale() {
        return this.getModel() == null ? 1.0f : this.getModel().scale;
    }

    public void setModelScale(float f) {
        Model model = this.getModel();
        if (model != null) {
            float f2 = model.scale;
            model.scale = 1.0f / f2;
            this.Loaded();
            model.scale = PZMath.clamp(f, 0.01f, 100.0f);
            this.Loaded();
        }
    }

    public int getModelCount() {
        return this.models.size();
    }

    public Model getModelByIndex(int n) {
        return this.models.get(n);
    }

    public Model getModelById(String string, ArrayList<Model> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Model model = arrayList.get(i);
            if (StringUtils.isNullOrWhitespace(model.id) && StringUtils.isNullOrWhitespace(string)) {
                return model;
            }
            if (model.id == null || !model.id.equals(string)) continue;
            return model;
        }
        return null;
    }

    public Model getModelById(String string) {
        return this.getModelById(string, this.models);
    }

    public int getAttachmentCount() {
        return this.m_attachments.size();
    }

    public ModelAttachment getAttachment(int n) {
        return this.m_attachments.get(n);
    }

    public ModelAttachment getAttachmentById(String string) {
        for (int i = 0; i < this.m_attachments.size(); ++i) {
            ModelAttachment modelAttachment = this.m_attachments.get(i);
            if (!modelAttachment.getId().equals(string)) continue;
            return modelAttachment;
        }
        return null;
    }

    public ModelAttachment addAttachment(ModelAttachment modelAttachment) {
        this.m_attachments.add(modelAttachment);
        return modelAttachment;
    }

    public ModelAttachment removeAttachment(ModelAttachment modelAttachment) {
        this.m_attachments.remove(modelAttachment);
        return modelAttachment;
    }

    public ModelAttachment addAttachmentAt(int n, ModelAttachment modelAttachment) {
        this.m_attachments.add(n, modelAttachment);
        return modelAttachment;
    }

    public ModelAttachment removeAttachment(int n) {
        return this.m_attachments.remove(n);
    }

    public LightBar getLightbar() {
        return this.lightbar;
    }

    public Sounds getSounds() {
        return this.sound;
    }

    public boolean getHasSiren() {
        return this.hasSiren;
    }

    public Vector3f getExtents() {
        return this.extents;
    }

    public Vector3f getPhysicsChassisShape() {
        return this.physicsChassisShape;
    }

    public Vector2f getShadowExtents() {
        return this.shadowExtents;
    }

    public Vector2f getShadowOffset() {
        return this.shadowOffset;
    }

    public Vector2f getExtentsOffset() {
        return this.extentsOffset;
    }

    public float getMass() {
        return this.mass;
    }

    public Vector3f getCenterOfMassOffset() {
        return this.centerOfMassOffset;
    }

    public float getEngineForce() {
        return this.engineForce;
    }

    public float getEngineIdleSpeed() {
        return this.engineIdleSpeed;
    }

    public int getEngineQuality() {
        return this.engineQuality;
    }

    public int getEngineLoudness() {
        return this.engineLoudness;
    }

    public float getRollInfluence() {
        return this.rollInfluence;
    }

    public float getSteeringIncrement() {
        return this.steeringIncrement;
    }

    public float getSteeringClamp(float f) {
        float f2 = (f = Math.abs(f)) / this.maxSpeed;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return (this.steeringClampMax - this.steeringClamp) * f2 + this.steeringClamp;
    }

    public float getSuspensionStiffness() {
        return this.suspensionStiffness;
    }

    public float getSuspensionDamping() {
        return this.suspensionDamping;
    }

    public float getSuspensionCompression() {
        return this.suspensionCompression;
    }

    public float getSuspensionRestLength() {
        return this.suspensionRestLength;
    }

    public float getSuspensionTravel() {
        return this.maxSuspensionTravelCm;
    }

    public float getWheelFriction() {
        return this.wheelFriction;
    }

    public int getWheelCount() {
        return this.wheels.size();
    }

    public Wheel getWheel(int n) {
        return this.wheels.get(n);
    }

    public Wheel getWheelById(String string) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            Wheel wheel = this.wheels.get(i);
            if (wheel.id == null || !wheel.id.equals(string)) continue;
            return wheel;
        }
        return null;
    }

    public int getIndexOfWheelById(String string) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            Wheel wheel = this.wheels.get(i);
            if (wheel.id == null || !wheel.id.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getPassengerCount() {
        return this.passengers.size();
    }

    public Passenger getPassenger(int n) {
        return this.passengers.get(n);
    }

    public Passenger getPassengerById(String string) {
        for (int i = 0; i < this.passengers.size(); ++i) {
            Passenger passenger = this.passengers.get(i);
            if (passenger.id == null || !passenger.id.equals(string)) continue;
            return passenger;
        }
        return null;
    }

    public int getPassengerIndex(String string) {
        for (int i = 0; i < this.passengers.size(); ++i) {
            Passenger passenger = this.passengers.get(i);
            if (passenger.id == null || !passenger.id.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getPhysicsShapeCount() {
        return this.m_physicsShapes.size();
    }

    public PhysicsShape getPhysicsShape(int n) {
        if (n < 0 || n >= this.m_physicsShapes.size()) {
            return null;
        }
        return this.m_physicsShapes.get(n);
    }

    public int getFrontEndHealth() {
        return this.frontEndHealth;
    }

    public int getRearEndHealth() {
        return this.rearEndHealth;
    }

    public int getStorageCapacity() {
        return this.storageCapacity;
    }

    public Skin getTextures() {
        return this.textures;
    }

    public int getSkinCount() {
        return this.skins.size();
    }

    public Skin getSkin(int n) {
        return this.skins.get(n);
    }

    public int getAreaCount() {
        return this.areas.size();
    }

    public Area getArea(int n) {
        return this.areas.get(n);
    }

    public Area getAreaById(String string) {
        for (int i = 0; i < this.areas.size(); ++i) {
            Area area = this.areas.get(i);
            if (area.id == null || !area.id.equals(string)) continue;
            return area;
        }
        return null;
    }

    public int getIndexOfAreaById(String string) {
        for (int i = 0; i < this.areas.size(); ++i) {
            Area area = this.areas.get(i);
            if (area.id == null || !area.id.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getPartCount() {
        return this.parts.size();
    }

    public Part getPart(int n) {
        return this.parts.get(n);
    }

    public Part getPartById(String string) {
        for (int i = 0; i < this.parts.size(); ++i) {
            Part part = this.parts.get(i);
            if (part.id == null || !part.id.equals(string)) continue;
            return part;
        }
        return null;
    }

    public int getIndexOfPartById(String string) {
        for (int i = 0; i < this.parts.size(); ++i) {
            Part part = this.parts.get(i);
            if (part.id == null || !part.id.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private Anim getAnimationById(String string, ArrayList<Anim> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Anim anim = arrayList.get(i);
            if (anim.id == null || !anim.id.equals(string)) continue;
            return anim;
        }
        return null;
    }

    private Position getPositionById(String string, ArrayList<Position> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Position position = arrayList.get(i);
            if (position.id == null || !position.id.equals(string)) continue;
            return position;
        }
        return null;
    }

    public boolean globMatch(String string, String string2) {
        Pattern pattern = Pattern.compile(string.replaceAll("\\*", ".*"));
        return pattern.matcher(string2).matches();
    }

    public int getGearRatioCount() {
        return this.gearRatioCount;
    }

    public int getSeats() {
        return this.seats;
    }

    public void setSeats(int n) {
        this.seats = n;
    }

    public int getMechanicType() {
        return this.mechanicType;
    }

    public void setMechanicType(int n) {
        this.mechanicType = n;
    }

    public int getEngineRepairLevel() {
        return this.engineRepairLevel;
    }

    public int getHeadlightConfigLevel() {
        return 2;
    }

    public void setEngineRepairLevel(int n) {
        this.engineRepairLevel = n;
    }

    public float getPlayerDamageProtection() {
        return this.playerDamageProtection;
    }

    public void setPlayerDamageProtection(float f) {
        this.playerDamageProtection = f;
    }

    public float getForcedHue() {
        return this.forcedHue;
    }

    public void setForcedHue(float f) {
        this.forcedHue = f;
    }

    public float getForcedSat() {
        return this.forcedSat;
    }

    public void setForcedSat(float f) {
        this.forcedSat = f;
    }

    public float getForcedVal() {
        return this.forcedVal;
    }

    public void setForcedVal(float f) {
        this.forcedVal = f;
    }

    public String getEngineRPMType() {
        return this.engineRPMType;
    }

    public void setEngineRPMType(String string) {
        this.engineRPMType = string;
    }

    public float getOffroadEfficiency() {
        return this.offroadEfficiency;
    }

    public void setOffroadEfficiency(float f) {
        this.offroadEfficiency = f;
    }

    public TFloatArrayList getCrawlOffsets() {
        return this.crawlOffsets;
    }

    public static final class Skin {
        public String texture;
        public String textureRust = null;
        public String textureMask = null;
        public String textureLights = null;
        public String textureDamage1Overlay = null;
        public String textureDamage1Shell = null;
        public String textureDamage2Overlay = null;
        public String textureDamage2Shell = null;
        public String textureShadow = null;
        public Texture textureData;
        public Texture textureDataRust;
        public Texture textureDataMask;
        public Texture textureDataLights;
        public Texture textureDataDamage1Overlay;
        public Texture textureDataDamage1Shell;
        public Texture textureDataDamage2Overlay;
        public Texture textureDataDamage2Shell;
        public Texture textureDataShadow;

        public void copyMissingFrom(Skin skin) {
            if (this.textureRust == null) {
                this.textureRust = skin.textureRust;
            }
            if (this.textureMask == null) {
                this.textureMask = skin.textureMask;
            }
            if (this.textureLights == null) {
                this.textureLights = skin.textureLights;
            }
            if (this.textureDamage1Overlay == null) {
                this.textureDamage1Overlay = skin.textureDamage1Overlay;
            }
            if (this.textureDamage1Shell == null) {
                this.textureDamage1Shell = skin.textureDamage1Shell;
            }
            if (this.textureDamage2Overlay == null) {
                this.textureDamage2Overlay = skin.textureDamage2Overlay;
            }
            if (this.textureDamage2Shell == null) {
                this.textureDamage2Shell = skin.textureDamage2Shell;
            }
            if (this.textureShadow == null) {
                this.textureShadow = skin.textureShadow;
            }
        }
    }

    public static final class LightBar {
        public boolean enable = false;
        public String soundSiren0 = "";
        public String soundSiren1 = "";
        public String soundSiren2 = "";
    }

    public static final class Sounds {
        public boolean hornEnable = false;
        public String horn = "";
        public boolean backSignalEnable = false;
        public String backSignal = "";
        public String engine = null;
        public String engineStart = null;
        public String engineTurnOff = null;
        public String ignitionFail = null;
        public String ignitionFailNoPower = null;
    }

    public static final class Area {
        public String id;
        public float x;
        public float y;
        public float w;
        public float h;

        public String getId() {
            return this.id;
        }

        public Double getX() {
            return BoxedStaticValues.toDouble(this.x);
        }

        public Double getY() {
            return BoxedStaticValues.toDouble(this.y);
        }

        public Double getW() {
            return BoxedStaticValues.toDouble(this.w);
        }

        public Double getH() {
            return BoxedStaticValues.toDouble(this.h);
        }

        public void setX(Double d) {
            this.x = d.floatValue();
        }

        public void setY(Double d) {
            this.y = d.floatValue();
        }

        public void setW(Double d) {
            this.w = d.floatValue();
        }

        public void setH(Double d) {
            this.h = d.floatValue();
        }

        private Area makeCopy() {
            Area area = new Area();
            area.id = this.id;
            area.x = this.x;
            area.y = this.y;
            area.w = this.w;
            area.h = this.h;
            return area;
        }
    }

    public static final class Model {
        public String id;
        public String file;
        public float scale = 1.0f;
        public final Vector3f offset = new Vector3f();
        public final Vector3f rotate = new Vector3f();

        public String getId() {
            return this.id;
        }

        public Vector3f getOffset() {
            return this.offset;
        }

        public Vector3f getRotate() {
            return this.rotate;
        }

        Model makeCopy() {
            Model model = new Model();
            model.id = this.id;
            model.file = this.file;
            model.scale = this.scale;
            model.offset.set(this.offset);
            model.rotate.set(this.rotate);
            return model;
        }
    }

    public static final class Part {
        public String id = "Unknown";
        public String parent;
        public ArrayList<String> itemType;
        public Container container;
        public String area;
        public String wheel;
        public HashMap<String, KahluaTable> tables;
        public HashMap<String, String> luaFunctions;
        public ArrayList<Model> models;
        public boolean bSetAllModelsVisible = true;
        public Door door;
        public Window window;
        public ArrayList<Anim> anims;
        public String category;
        public boolean specificItem = true;
        public boolean mechanicRequireKey = false;
        public boolean repairMechanic = false;
        public boolean hasLightsRear = false;

        public boolean isMechanicRequireKey() {
            return this.mechanicRequireKey;
        }

        public void setMechanicRequireKey(boolean bl) {
            this.mechanicRequireKey = bl;
        }

        public boolean isRepairMechanic() {
            return this.repairMechanic;
        }

        public void setRepairMechanic(boolean bl) {
            this.repairMechanic = bl;
        }

        Part makeCopy() {
            Part part = new Part();
            part.id = this.id;
            part.parent = this.parent;
            if (this.itemType != null) {
                part.itemType = new ArrayList();
                part.itemType.addAll(this.itemType);
            }
            if (this.container != null) {
                part.container = this.container.makeCopy();
            }
            part.area = this.area;
            part.wheel = this.wheel;
            if (this.tables != null) {
                part.tables = new HashMap();
                for (Map.Entry<String, KahluaTable> entry : this.tables.entrySet()) {
                    KahluaTable kahluaTable = LuaManager.copyTable(entry.getValue());
                    part.tables.put(entry.getKey(), kahluaTable);
                }
            }
            if (this.luaFunctions != null) {
                part.luaFunctions = new HashMap();
                part.luaFunctions.putAll(this.luaFunctions);
            }
            if (this.models != null) {
                part.models = new ArrayList();
                for (int i = 0; i < this.models.size(); ++i) {
                    part.models.add(this.models.get(i).makeCopy());
                }
            }
            part.bSetAllModelsVisible = this.bSetAllModelsVisible;
            if (this.door != null) {
                part.door = this.door.makeCopy();
            }
            if (this.window != null) {
                part.window = this.window.makeCopy();
            }
            if (this.anims != null) {
                part.anims = new ArrayList();
                for (int i = 0; i < this.anims.size(); ++i) {
                    part.anims.add(this.anims.get(i).makeCopy());
                }
            }
            part.category = this.category;
            part.specificItem = this.specificItem;
            part.mechanicRequireKey = this.mechanicRequireKey;
            part.repairMechanic = this.repairMechanic;
            part.hasLightsRear = this.hasLightsRear;
            return part;
        }
    }

    public static final class Passenger {
        public String id;
        public final ArrayList<Anim> anims = new ArrayList();
        public final ArrayList<SwitchSeat> switchSeats = new ArrayList();
        public boolean hasRoof = true;
        public boolean showPassenger = false;
        public String door;
        public String door2;
        public String area;
        public final ArrayList<Position> positions = new ArrayList();

        public String getId() {
            return this.id;
        }

        public Passenger makeCopy() {
            int n;
            Passenger passenger = new Passenger();
            passenger.id = this.id;
            for (n = 0; n < this.anims.size(); ++n) {
                passenger.anims.add(this.anims.get(n).makeCopy());
            }
            for (n = 0; n < this.switchSeats.size(); ++n) {
                passenger.switchSeats.add(this.switchSeats.get(n).makeCopy());
            }
            passenger.hasRoof = this.hasRoof;
            passenger.showPassenger = this.showPassenger;
            passenger.door = this.door;
            passenger.door2 = this.door2;
            passenger.area = this.area;
            for (n = 0; n < this.positions.size(); ++n) {
                passenger.positions.add(this.positions.get(n).makeCopy());
            }
            return passenger;
        }

        public int getPositionCount() {
            return this.positions.size();
        }

        public Position getPosition(int n) {
            return this.positions.get(n);
        }

        public Position getPositionById(String string) {
            for (int i = 0; i < this.positions.size(); ++i) {
                Position position = this.positions.get(i);
                if (position.id == null || !position.id.equals(string)) continue;
                return position;
            }
            return null;
        }

        public SwitchSeat getSwitchSeatById(String string) {
            for (int i = 0; i < this.switchSeats.size(); ++i) {
                SwitchSeat switchSeat = this.switchSeats.get(i);
                if (switchSeat.id == null || !switchSeat.id.equals(string)) continue;
                return switchSeat;
            }
            return null;
        }

        public static final class SwitchSeat {
            public String id;
            public int seat;
            public String anim;
            public float rate = 1.0f;
            public String sound;

            public String getId() {
                return this.id;
            }

            public SwitchSeat makeCopy() {
                SwitchSeat switchSeat = new SwitchSeat();
                switchSeat.id = this.id;
                switchSeat.seat = this.seat;
                switchSeat.anim = this.anim;
                switchSeat.rate = this.rate;
                switchSeat.sound = this.sound;
                return switchSeat;
            }
        }
    }

    public static final class PhysicsShape {
        public int type;
        public final Vector3f offset = new Vector3f();
        public final Vector3f rotate = new Vector3f();
        public final Vector3f extents = new Vector3f();
        public float radius;

        public String getTypeString() {
            switch (this.type) {
                case 1: {
                    return "box";
                }
                case 2: {
                    return "sphere";
                }
            }
            throw new RuntimeException("unhandled VehicleScript.PhysicsShape");
        }

        public Vector3f getOffset() {
            return this.offset;
        }

        public Vector3f getExtents() {
            return this.extents;
        }

        public Vector3f getRotate() {
            return this.rotate;
        }

        public float getRadius() {
            return this.radius;
        }

        public void setRadius(float f) {
            this.radius = PZMath.clamp(f, 0.05f, 5.0f);
        }
    }

    public static final class Wheel {
        public String id;
        public String model;
        public boolean front;
        public final Vector3f offset = new Vector3f();
        public float radius = 0.5f;
        public float width = 0.4f;

        public String getId() {
            return this.id;
        }

        public Vector3f getOffset() {
            return this.offset;
        }

        Wheel makeCopy() {
            Wheel wheel = new Wheel();
            wheel.id = this.id;
            wheel.model = this.model;
            wheel.front = this.front;
            wheel.offset.set(this.offset);
            wheel.radius = this.radius;
            wheel.width = this.width;
            return wheel;
        }
    }

    public static final class Position {
        public String id;
        public final Vector3f offset = new Vector3f();
        public final Vector3f rotate = new Vector3f();
        public String area = null;

        public String getId() {
            return this.id;
        }

        public Vector3f getOffset() {
            return this.offset;
        }

        public Vector3f getRotate() {
            return this.rotate;
        }

        public String getArea() {
            return this.area;
        }

        Position makeCopy() {
            Position position = new Position();
            position.id = this.id;
            position.offset.set(this.offset);
            position.rotate.set(this.rotate);
            return position;
        }
    }

    public static final class Container {
        public int capacity;
        public int seat = -1;
        public String seatID;
        public String luaTest;
        public String contentType;
        public boolean conditionAffectsCapacity = false;

        Container makeCopy() {
            Container container = new Container();
            container.capacity = this.capacity;
            container.seat = this.seat;
            container.seatID = this.seatID;
            container.luaTest = this.luaTest;
            container.contentType = this.contentType;
            container.conditionAffectsCapacity = this.conditionAffectsCapacity;
            return container;
        }
    }

    public static final class Anim {
        public String id;
        public String anim;
        public float rate = 1.0f;
        public boolean bAnimate = true;
        public boolean bLoop = false;
        public boolean bReverse = false;
        public final Vector3f offset = new Vector3f();
        public final Vector3f angle = new Vector3f();
        public String sound;

        Anim makeCopy() {
            Anim anim = new Anim();
            anim.id = this.id;
            anim.anim = this.anim;
            anim.rate = this.rate;
            anim.bAnimate = this.bAnimate;
            anim.bLoop = this.bLoop;
            anim.bReverse = this.bReverse;
            anim.offset.set(this.offset);
            anim.angle.set(this.angle);
            anim.sound = this.sound;
            return anim;
        }
    }

    public static final class Door {
        Door makeCopy() {
            Door door = new Door();
            return door;
        }
    }

    public static final class Window {
        public boolean openable;

        Window makeCopy() {
            Window window = new Window();
            window.openable = this.openable;
            return window;
        }
    }
}

