/*
 * Decompiled with CFR 0.152.
 */
package zombie.scripting.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.runtime.RuntimeAnimationScript;
import zombie.debug.DebugLog;
import zombie.iso.MultiStageBuilding;
import zombie.scripting.IScriptObjectStore;
import zombie.scripting.ScriptManager;
import zombie.scripting.ScriptParser;
import zombie.scripting.objects.AnimationsMesh;
import zombie.scripting.objects.BaseScriptObject;
import zombie.scripting.objects.EvolvedRecipe;
import zombie.scripting.objects.Fixing;
import zombie.scripting.objects.GameSoundScript;
import zombie.scripting.objects.Item;
import zombie.scripting.objects.MannequinScript;
import zombie.scripting.objects.ModelScript;
import zombie.scripting.objects.Recipe;
import zombie.scripting.objects.SoundTimelineScript;
import zombie.scripting.objects.UniqueRecipe;
import zombie.scripting.objects.VehicleScript;
import zombie.scripting.objects.VehicleTemplate;
import zombie.vehicles.VehicleEngineRPM;

public final class ScriptModule
extends BaseScriptObject
implements IScriptObjectStore {
    public String name;
    public String value;
    public final HashMap<String, Item> ItemMap = new HashMap();
    public final HashMap<String, GameSoundScript> GameSoundMap = new HashMap();
    public final ArrayList<GameSoundScript> GameSoundList = new ArrayList();
    public final HashMap<String, AnimationsMesh> AnimationsMeshMap = new HashMap();
    public final HashMap<String, MannequinScript> MannequinScriptMap = new HashMap();
    public final TreeMap<String, ModelScript> ModelScriptMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    public final HashMap<String, RuntimeAnimationScript> RuntimeAnimationScriptMap = new HashMap();
    public final HashMap<String, SoundTimelineScript> SoundTimelineMap = new HashMap();
    public final HashMap<String, VehicleScript> VehicleMap = new HashMap();
    public final HashMap<String, VehicleTemplate> VehicleTemplateMap = new HashMap();
    public final HashMap<String, VehicleEngineRPM> VehicleEngineRPMMap = new HashMap();
    public final ArrayList<Recipe> RecipeMap = new ArrayList();
    public final HashMap<String, Recipe> RecipeByName = new HashMap();
    public final HashMap<String, Recipe> RecipesWithDotInName = new HashMap();
    public final ArrayList<EvolvedRecipe> EvolvedRecipeMap = new ArrayList();
    public final ArrayList<UniqueRecipe> UniqueRecipeMap = new ArrayList();
    public final HashMap<String, Fixing> FixingMap = new HashMap();
    public final ArrayList<String> Imports = new ArrayList();
    public boolean disabled = false;

    public void Load(String string, String string2) {
        this.name = string;
        this.value = string2.trim();
        ScriptManager.instance.CurrentLoadingModule = this;
        this.ParseScriptPP(this.value);
        this.ParseScript(this.value);
        this.value = "";
    }

    private String GetTokenType(String string) {
        int n = string.indexOf(123);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n).trim();
        int n2 = string2.indexOf(32);
        int n3 = string2.indexOf(9);
        if (n2 != -1 && n3 != -1) {
            return string2.substring(0, PZMath.min(n2, n3));
        }
        if (n2 != -1) {
            return string2.substring(0, n2);
        }
        if (n3 != -1) {
            return string2.substring(0, n3);
        }
        return string2;
    }

    private void CreateFromTokenPP(String string) {
        String string2 = this.GetTokenType(string = string.trim());
        if (string2 == null) {
            return;
        }
        if ("item".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string3 = stringArray[0];
            string3 = string3.replace("item", "");
            string3 = string3.trim();
            Item item = new Item();
            this.ItemMap.put(string3, item);
        } else if ("animationsMesh".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string4 = stringArray[0];
            string4 = string4.replace("animationsMesh", "");
            if (this.AnimationsMeshMap.containsKey(string4 = string4.trim())) {
                AnimationsMesh animationsMesh = this.AnimationsMeshMap.get(string4);
                animationsMesh.reset();
            } else {
                AnimationsMesh animationsMesh = new AnimationsMesh();
                this.AnimationsMeshMap.put(string4, animationsMesh);
            }
        } else if ("mannequin".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string5 = stringArray[0];
            string5 = string5.replace("mannequin", "");
            if (this.MannequinScriptMap.containsKey(string5 = string5.trim())) {
                MannequinScript mannequinScript = this.MannequinScriptMap.get(string5);
                mannequinScript.reset();
            } else {
                MannequinScript mannequinScript = new MannequinScript();
                this.MannequinScriptMap.put(string5, mannequinScript);
            }
        } else if ("model".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string6 = stringArray[0];
            string6 = string6.replace("model", "");
            if (this.ModelScriptMap.containsKey(string6 = string6.trim())) {
                ModelScript modelScript = this.ModelScriptMap.get(string6);
                modelScript.reset();
            } else {
                ModelScript modelScript = new ModelScript();
                this.ModelScriptMap.put(string6, modelScript);
            }
        } else if ("sound".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string7 = stringArray[0];
            string7 = string7.replace("sound", "");
            if (this.GameSoundMap.containsKey(string7 = string7.trim())) {
                GameSoundScript gameSoundScript = this.GameSoundMap.get(string7);
                gameSoundScript.reset();
            } else {
                GameSoundScript gameSoundScript = new GameSoundScript();
                this.GameSoundMap.put(string7, gameSoundScript);
                this.GameSoundList.add(gameSoundScript);
            }
        } else if ("soundTimeline".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string8 = stringArray[0];
            string8 = string8.replace("soundTimeline", "");
            if (this.SoundTimelineMap.containsKey(string8 = string8.trim())) {
                SoundTimelineScript soundTimelineScript = this.SoundTimelineMap.get(string8);
                soundTimelineScript.reset();
            } else {
                SoundTimelineScript soundTimelineScript = new SoundTimelineScript();
                this.SoundTimelineMap.put(string8, soundTimelineScript);
            }
        } else if ("vehicle".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string9 = stringArray[0];
            string9 = string9.replace("vehicle", "");
            string9 = string9.trim();
            VehicleScript vehicleScript = new VehicleScript();
            this.VehicleMap.put(string9, vehicleScript);
        } else if ("template".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string10 = stringArray[0];
            String[] stringArray2 = (string10 = string10.replace("template", "")).trim().split("\\s+");
            if (stringArray2.length == 2) {
                String string11 = stringArray2[0].trim();
                String string12 = stringArray2[1].trim();
                if ("vehicle".equals(string11)) {
                    VehicleTemplate vehicleTemplate = new VehicleTemplate(this, string12, string);
                    vehicleTemplate.module = this;
                    this.VehicleTemplateMap.put(string12, vehicleTemplate);
                }
            }
        } else if ("animation".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string13 = stringArray[0];
            string13 = string13.replace("animation", "");
            if (this.RuntimeAnimationScriptMap.containsKey(string13 = string13.trim())) {
                RuntimeAnimationScript runtimeAnimationScript = this.RuntimeAnimationScriptMap.get(string13);
                runtimeAnimationScript.reset();
            } else {
                RuntimeAnimationScript runtimeAnimationScript = new RuntimeAnimationScript();
                this.RuntimeAnimationScriptMap.put(string13, runtimeAnimationScript);
            }
        } else if ("vehicleEngineRPM".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string14 = stringArray[0];
            string14 = string14.replace("vehicleEngineRPM", "");
            if (this.VehicleEngineRPMMap.containsKey(string14 = string14.trim())) {
                VehicleEngineRPM vehicleEngineRPM = this.VehicleEngineRPMMap.get(string14);
                vehicleEngineRPM.reset();
            } else {
                VehicleEngineRPM vehicleEngineRPM = new VehicleEngineRPM();
                this.VehicleEngineRPMMap.put(string14, vehicleEngineRPM);
            }
        }
    }

    private void CreateFromToken(String string) {
        String string2 = this.GetTokenType(string = string.trim());
        if (string2 == null) {
            return;
        }
        if ("imports".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String[] stringArray2 = stringArray[1].split(",");
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].trim().length() <= 0) continue;
                String string3 = stringArray2[i].trim();
                if (string3.equals(this.getName())) {
                    DebugLog.log("ERROR: module \"" + this.getName() + "\" imports itself");
                    continue;
                }
                this.Imports.add(string3);
            }
        } else if ("item".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string4 = stringArray[0];
            string4 = string4.replace("item", "");
            string4 = string4.trim();
            String[] stringArray3 = stringArray[1].split(",");
            Item item = this.ItemMap.get(string4);
            item.module = this;
            try {
                item.Load(string4, stringArray3);
            }
            catch (Exception exception) {
                DebugLog.log(exception);
            }
        } else if ("recipe".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string5 = stringArray[0];
            string5 = string5.replace("recipe", "");
            string5 = string5.trim();
            String[] stringArray4 = stringArray[1].split(",");
            Recipe recipe = new Recipe();
            this.RecipeMap.add(recipe);
            if (!this.RecipeByName.containsKey(string5)) {
                this.RecipeByName.put(string5, recipe);
            }
            if (string5.contains(".")) {
                this.RecipesWithDotInName.put(string5, recipe);
            }
            recipe.module = this;
            recipe.Load(string5, stringArray4);
        } else if ("uniquerecipe".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string6 = stringArray[0];
            string6 = string6.replace("uniquerecipe", "");
            string6 = string6.trim();
            String[] stringArray5 = stringArray[1].split(",");
            UniqueRecipe uniqueRecipe = new UniqueRecipe(string6);
            this.UniqueRecipeMap.add(uniqueRecipe);
            uniqueRecipe.module = this;
            uniqueRecipe.Load(string6, stringArray5);
        } else if ("evolvedrecipe".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string7 = stringArray[0];
            string7 = string7.replace("evolvedrecipe", "");
            string7 = string7.trim();
            String[] stringArray6 = stringArray[1].split(",");
            boolean bl = false;
            for (EvolvedRecipe evolvedRecipe : this.EvolvedRecipeMap) {
                if (!evolvedRecipe.name.equals(string7)) continue;
                evolvedRecipe.Load(string7, stringArray6);
                evolvedRecipe.module = this;
                bl = true;
            }
            if (!bl) {
                EvolvedRecipe evolvedRecipe = new EvolvedRecipe(string7);
                this.EvolvedRecipeMap.add(evolvedRecipe);
                evolvedRecipe.module = this;
                evolvedRecipe.Load(string7, stringArray6);
            }
        } else if ("fixing".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string8 = stringArray[0];
            string8 = string8.replace("fixing", "");
            string8 = string8.trim();
            String[] stringArray7 = stringArray[1].split(",");
            Fixing fixing = new Fixing();
            fixing.module = this;
            this.FixingMap.put(string8, fixing);
            fixing.Load(string8, stringArray7);
        } else if ("animationsMesh".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string9 = stringArray[0];
            string9 = string9.replace("animationsMesh", "");
            string9 = string9.trim();
            AnimationsMesh animationsMesh = this.AnimationsMeshMap.get(string9);
            animationsMesh.module = this;
            try {
                animationsMesh.Load(string9, string);
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        } else if ("mannequin".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string10 = stringArray[0];
            string10 = string10.replace("mannequin", "");
            string10 = string10.trim();
            MannequinScript mannequinScript = this.MannequinScriptMap.get(string10);
            mannequinScript.module = this;
            try {
                mannequinScript.Load(string10, string);
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        } else if ("multistagebuild".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string11 = stringArray[0];
            string11 = string11.replace("multistagebuild", "");
            string11 = string11.trim();
            String[] stringArray8 = stringArray[1].split(",");
            MultiStageBuilding.Stage stage = new MultiStageBuilding().new MultiStageBuilding.Stage();
            stage.Load(string11, stringArray8);
            MultiStageBuilding.addStage(stage);
        } else if ("model".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string12 = stringArray[0];
            string12 = string12.replace("model", "");
            string12 = string12.trim();
            ModelScript modelScript = this.ModelScriptMap.get(string12);
            modelScript.module = this;
            try {
                modelScript.Load(string12, string);
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        } else if ("sound".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string13 = stringArray[0];
            string13 = string13.replace("sound", "");
            string13 = string13.trim();
            GameSoundScript gameSoundScript = this.GameSoundMap.get(string13);
            gameSoundScript.module = this;
            try {
                gameSoundScript.Load(string13, string);
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        } else if ("soundTimeline".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string14 = stringArray[0];
            string14 = string14.replace("soundTimeline", "");
            string14 = string14.trim();
            SoundTimelineScript soundTimelineScript = this.SoundTimelineMap.get(string14);
            soundTimelineScript.module = this;
            try {
                soundTimelineScript.Load(string14, string);
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        } else if ("vehicle".equals(string2)) {
            String[] stringArray = string.split("[{}]");
            String string15 = stringArray[0];
            string15 = string15.replace("vehicle", "");
            string15 = string15.trim();
            VehicleScript vehicleScript = this.VehicleMap.get(string15);
            vehicleScript.module = this;
            try {
                vehicleScript.Load(string15, string);
                vehicleScript.Loaded();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        } else if (!"template".equals(string2)) {
            if ("animation".equals(string2)) {
                String[] stringArray = string.split("[{}]");
                String string16 = stringArray[0];
                string16 = string16.replace("animation", "");
                string16 = string16.trim();
                RuntimeAnimationScript runtimeAnimationScript = this.RuntimeAnimationScriptMap.get(string16);
                runtimeAnimationScript.module = this;
                try {
                    runtimeAnimationScript.Load(string16, string);
                }
                catch (Throwable throwable) {
                    ExceptionLogger.logException(throwable);
                }
            } else if ("vehicleEngineRPM".equals(string2)) {
                String[] stringArray = string.split("[{}]");
                String string17 = stringArray[0];
                string17 = string17.replace("vehicleEngineRPM", "");
                string17 = string17.trim();
                VehicleEngineRPM vehicleEngineRPM = this.VehicleEngineRPMMap.get(string17);
                vehicleEngineRPM.module = this;
                try {
                    vehicleEngineRPM.Load(string17, string);
                }
                catch (Throwable throwable) {
                    this.VehicleEngineRPMMap.remove(string17);
                    ExceptionLogger.logException(throwable);
                }
            } else {
                DebugLog.Script.warn("unknown script object \"%s\"", string2);
            }
        }
    }

    public void ParseScript(String string) {
        ArrayList<String> arrayList = ScriptParser.parseTokens(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            this.CreateFromToken(string2);
        }
    }

    public void ParseScriptPP(String string) {
        ArrayList<String> arrayList = ScriptParser.parseTokens(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            this.CreateFromTokenPP(string2);
        }
    }

    @Override
    public Item getItem(String string) {
        if (string.contains(".")) {
            return ScriptManager.instance.getItem(string);
        }
        if (!this.ItemMap.containsKey(string)) {
            for (int i = 0; i < this.Imports.size(); ++i) {
                String string2 = this.Imports.get(i);
                ScriptModule scriptModule = ScriptManager.instance.getModule(string2);
                Item item = scriptModule.getItem(string);
                if (item == null) continue;
                return item;
            }
            return null;
        }
        return this.ItemMap.get(string);
    }

    public ModelScript getModelScript(String string) {
        if (string.contains(".")) {
            return ScriptManager.instance.getModelScript(string);
        }
        ModelScript modelScript = this.ModelScriptMap.get(string);
        if (modelScript == null) {
            for (int i = 0; i < this.Imports.size(); ++i) {
                String string2 = this.Imports.get(i);
                ScriptModule scriptModule = ScriptManager.instance.getModule(string2);
                modelScript = scriptModule.getModelScript(string);
                if (modelScript == null) continue;
                return modelScript;
            }
            return null;
        }
        return modelScript;
    }

    @Override
    public Recipe getRecipe(String string) {
        if (string.contains(".") && !this.RecipesWithDotInName.containsKey(string)) {
            return ScriptManager.instance.getRecipe(string);
        }
        Recipe recipe = this.RecipeByName.get(string);
        if (recipe != null) {
            return recipe;
        }
        for (int i = 0; i < this.Imports.size(); ++i) {
            ScriptModule scriptModule = ScriptManager.instance.getModule(this.Imports.get(i));
            if (scriptModule == null || (recipe = scriptModule.getRecipe(string)) == null) continue;
            return recipe;
        }
        return null;
    }

    public VehicleScript getVehicle(String string) {
        if (string.contains(".")) {
            return ScriptManager.instance.getVehicle(string);
        }
        if (!this.VehicleMap.containsKey(string)) {
            for (int i = 0; i < this.Imports.size(); ++i) {
                VehicleScript vehicleScript = ScriptManager.instance.getModule(this.Imports.get(i)).getVehicle(string);
                if (vehicleScript == null) continue;
                return vehicleScript;
            }
            return null;
        }
        return this.VehicleMap.get(string);
    }

    public VehicleTemplate getVehicleTemplate(String string) {
        if (string.contains(".")) {
            return ScriptManager.instance.getVehicleTemplate(string);
        }
        if (!this.VehicleTemplateMap.containsKey(string)) {
            for (int i = 0; i < this.Imports.size(); ++i) {
                VehicleTemplate vehicleTemplate = ScriptManager.instance.getModule(this.Imports.get(i)).getVehicleTemplate(string);
                if (vehicleTemplate == null) continue;
                return vehicleTemplate;
            }
            return null;
        }
        return this.VehicleTemplateMap.get(string);
    }

    public VehicleEngineRPM getVehicleEngineRPM(String string) {
        if (string.contains(".")) {
            return ScriptManager.instance.getVehicleEngineRPM(string);
        }
        return this.VehicleEngineRPMMap.get(string);
    }

    public boolean CheckExitPoints() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void Reset() {
        this.ItemMap.clear();
        this.GameSoundMap.clear();
        this.GameSoundList.clear();
        this.AnimationsMeshMap.clear();
        this.MannequinScriptMap.clear();
        this.ModelScriptMap.clear();
        this.RuntimeAnimationScriptMap.clear();
        this.SoundTimelineMap.clear();
        this.VehicleMap.clear();
        this.VehicleTemplateMap.clear();
        this.VehicleEngineRPMMap.clear();
        this.RecipeMap.clear();
        this.RecipeByName.clear();
        this.RecipesWithDotInName.clear();
        this.EvolvedRecipeMap.clear();
        this.UniqueRecipeMap.clear();
        this.FixingMap.clear();
        this.Imports.clear();
    }

    public Item getSpecificItem(String string) {
        return this.ItemMap.get(string);
    }
}

