/*
 * Decompiled with CFR 0.152.
 */
package zombie.scripting.objects;

import zombie.audio.GameSound;
import zombie.audio.GameSoundClip;
import zombie.core.math.PZMath;
import zombie.scripting.ScriptParser;
import zombie.scripting.objects.BaseScriptObject;

public final class GameSoundScript
extends BaseScriptObject {
    public final GameSound gameSound = new GameSound();

    public void Load(String string, String string2) {
        Object object;
        this.gameSound.name = string;
        ScriptParser.Block block = ScriptParser.parse(string2);
        block = block.children.get(0);
        for (ScriptParser.Value blockElement : block.values) {
            object = blockElement.string.split("=");
            String string3 = object[0].trim();
            String string4 = object[1].trim();
            if ("category".equals(string3)) {
                this.gameSound.category = string4;
                continue;
            }
            if ("is3D".equals(string3)) {
                this.gameSound.is3D = Boolean.parseBoolean(string4);
                continue;
            }
            if ("loop".equals(string3)) {
                this.gameSound.loop = Boolean.parseBoolean(string4);
                continue;
            }
            if ("master".equals(string3)) {
                this.gameSound.master = GameSound.MasterVolume.valueOf(string4);
                continue;
            }
            if (!"maxInstancesPerEmitter".equals(string3)) continue;
            this.gameSound.maxInstancesPerEmitter = PZMath.tryParseInt(string4, -1);
        }
        for (ScriptParser.Block block2 : block.children) {
            if (!"clip".equals(block2.type)) continue;
            object = this.LoadClip(block2);
            this.gameSound.clips.add((GameSoundClip)object);
        }
    }

    private GameSoundClip LoadClip(ScriptParser.Block block) {
        GameSoundClip gameSoundClip = new GameSoundClip(this.gameSound);
        for (ScriptParser.Value value : block.values) {
            String[] stringArray = value.string.split("=");
            String string = stringArray[0].trim();
            String string2 = stringArray[1].trim();
            if ("distanceMax".equals(string)) {
                gameSoundClip.distanceMax = Integer.parseInt(string2);
                gameSoundClip.initFlags = (short)(gameSoundClip.initFlags | GameSoundClip.INIT_FLAG_DISTANCE_MAX);
                continue;
            }
            if ("distanceMin".equals(string)) {
                gameSoundClip.distanceMin = Integer.parseInt(string2);
                gameSoundClip.initFlags = (short)(gameSoundClip.initFlags | GameSoundClip.INIT_FLAG_DISTANCE_MIN);
                continue;
            }
            if ("event".equals(string)) {
                gameSoundClip.event = string2;
                continue;
            }
            if ("file".equals(string)) {
                gameSoundClip.file = string2;
                continue;
            }
            if ("pitch".equals(string)) {
                gameSoundClip.pitch = Float.parseFloat(string2);
                continue;
            }
            if ("volume".equals(string)) {
                gameSoundClip.volume = Float.parseFloat(string2);
                continue;
            }
            if ("reverbFactor".equals(string)) {
                gameSoundClip.reverbFactor = Float.parseFloat(string2);
                continue;
            }
            if (!"reverbMaxRange".equals(string)) continue;
            gameSoundClip.reverbMaxRange = Float.parseFloat(string2);
        }
        return gameSoundClip;
    }

    public void reset() {
        this.gameSound.reset();
    }
}

