/*
 * Decompiled with CFR 0.152.
 */
package zombie.scripting;

import java.util.ArrayList;

public final class ScriptParser {
    private static StringBuilder stringBuilder = new StringBuilder();

    public static int readBlock(String string, int n, Block block) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            BlockElement blockElement;
            if (string.charAt(n2) == '{') {
                blockElement = new Block();
                block.children.add((Block)blockElement);
                block.elements.add(blockElement);
                String string2 = string.substring(n, n2).trim();
                String[] stringArray = string2.split("\\s+");
                blockElement.type = stringArray[0];
                blockElement.id = stringArray.length > 1 ? stringArray[1] : null;
                n = n2 = ScriptParser.readBlock(string, n2 + 1, blockElement);
                continue;
            }
            if (string.charAt(n2) == '}') {
                return n2 + 1;
            }
            if (string.charAt(n2) != ',') continue;
            blockElement = new Value();
            ((Value)blockElement).string = string.substring(n, n2);
            block.values.add((Value)blockElement);
            block.elements.add(blockElement);
            n = n2 + 1;
        }
        return n2;
    }

    public static Block parse(String string) {
        Block block = new Block();
        ScriptParser.readBlock(string, 0, block);
        return block;
    }

    public static String stripComments(String string) {
        int n;
        stringBuilder.setLength(0);
        stringBuilder.append(string);
        int n2 = stringBuilder.lastIndexOf("*/");
        while (n2 != -1 && (n = stringBuilder.lastIndexOf("/*", n2 - 1)) != -1) {
            int n3 = stringBuilder.lastIndexOf("*/", n2 - 1);
            while (n3 > n) {
                int n4 = n;
                if ((n = stringBuilder.lastIndexOf("/*", n - 2)) == -1) break;
                n3 = stringBuilder.lastIndexOf("*/", n4 - 2);
            }
            if (n == -1) break;
            stringBuilder.replace(n, n2 + 2, "");
            n2 = stringBuilder.lastIndexOf("*/", n);
        }
        string = stringBuilder.toString();
        stringBuilder.setLength(0);
        return string;
    }

    public static ArrayList<String> parseTokens(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (string.indexOf("}", n2 + 1) == -1) break;
            do {
                n2 = string.indexOf("{", n2 + 1);
                if ((n3 = string.indexOf("}", n3 + 1)) < n2 && n3 != -1 || n2 == -1) {
                    n2 = n3;
                    --n;
                    continue;
                }
                n3 = n2;
                ++n;
            } while (n > 0);
            arrayList.add(string.substring(0, n2 + 1).trim());
            string = string.substring(n2 + 1);
        }
        if (string.trim().length() > 0) {
            arrayList.add(string.trim());
        }
        return arrayList;
    }

    public static class Block
    implements BlockElement {
        public String type;
        public String id;
        public final ArrayList<BlockElement> elements = new ArrayList();
        public final ArrayList<Value> values = new ArrayList();
        public final ArrayList<Block> children = new ArrayList();

        @Override
        public Block asBlock() {
            return this;
        }

        @Override
        public Value asValue() {
            return null;
        }

        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public void prettyPrint(int n, StringBuilder stringBuilder, String string) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append('\t');
            }
            stringBuilder.append(this.type);
            if (this.id != null) {
                stringBuilder.append(" ");
                stringBuilder.append(this.id);
            }
            stringBuilder.append(string);
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append('\t');
            }
            stringBuilder.append('{');
            stringBuilder.append(string);
            this.prettyPrintElements(n + 1, stringBuilder, string);
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append('\t');
            }
            stringBuilder.append('}');
            stringBuilder.append(string);
        }

        public void prettyPrintElements(int n, StringBuilder stringBuilder, String string) {
            BlockElement blockElement = null;
            for (BlockElement blockElement2 : this.elements) {
                if (blockElement2.asBlock() != null && blockElement != null) {
                    stringBuilder.append(string);
                }
                if (blockElement2.asValue() != null && blockElement instanceof Block) {
                    stringBuilder.append(string);
                }
                blockElement2.prettyPrint(n, stringBuilder, string);
                blockElement = blockElement2;
            }
        }

        public Block addBlock(String string, String string2) {
            Block block = new Block();
            block.type = string;
            block.id = string2;
            this.elements.add(block);
            this.children.add(block);
            return block;
        }

        public Block getBlock(String string, String string2) {
            for (Block block : this.children) {
                if (!block.type.equals(string) || (block.id == null || !block.id.equals(string2)) && (block.id != null || string2 != null)) continue;
                return block;
            }
            return null;
        }

        public Value getValue(String string) {
            for (Value value : this.values) {
                int n = value.string.indexOf(61);
                if (n <= 0 || !value.getKey().trim().equals(string)) continue;
                return value;
            }
            return null;
        }

        public void setValue(String string, String string2) {
            Value value = this.getValue(string);
            if (value == null) {
                this.addValue(string, string2);
            } else {
                value.string = string + " = " + string2;
            }
        }

        public Value addValue(String string, String string2) {
            Value value = new Value();
            value.string = string + " = " + string2;
            this.elements.add(value);
            this.values.add(value);
            return value;
        }

        public void moveValueAfter(String string, String string2) {
            Value value = this.getValue(string);
            Value value2 = this.getValue(string2);
            if (value == null || value2 == null) {
                return;
            }
            this.elements.remove(value);
            this.values.remove(value);
            this.elements.add(this.elements.indexOf(value2) + 1, value);
            this.values.add(this.values.indexOf(value2) + 1, value);
        }
    }

    public static class Value
    implements BlockElement {
        public String string;

        @Override
        public Block asBlock() {
            return null;
        }

        @Override
        public Value asValue() {
            return this;
        }

        @Override
        public void prettyPrint(int n, StringBuilder stringBuilder, String string) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append('\t');
            }
            stringBuilder.append(this.string.trim());
            stringBuilder.append(',');
            stringBuilder.append(string);
        }

        public String getKey() {
            int n = this.string.indexOf(61);
            return n == -1 ? this.string : this.string.substring(0, n);
        }

        public String getValue() {
            int n = this.string.indexOf(61);
            return n == -1 ? "" : this.string.substring(n + 1);
        }
    }

    public static interface BlockElement {
        public Block asBlock();

        public Value asValue();

        public void prettyPrint(int var1, StringBuilder var2, String var3);
    }
}

