/*
 * Decompiled with CFR 0.152.
 */
package zombie.savefile;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentLinkedQueue;
import zombie.GameWindow;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.savefile.PlayerDBHelper;

public final class ServerPlayerDB {
    private static ServerPlayerDB instance = null;
    private static boolean allow = false;
    private Connection conn = null;
    private ConcurrentLinkedQueue<NetworkCharacterData> CharactersToSave;

    public static void setAllow(boolean bl) {
        allow = bl;
    }

    public static boolean isAllow() {
        return allow;
    }

    public static synchronized ServerPlayerDB getInstance() {
        if (instance == null && allow) {
            instance = new ServerPlayerDB();
        }
        return instance;
    }

    public static boolean isAvailable() {
        return instance != null;
    }

    public ServerPlayerDB() {
        if (Core.getInstance().isNoSave()) {
            return;
        }
        this.create();
    }

    public void close() {
        instance = null;
        allow = false;
    }

    private void create() {
        this.conn = PlayerDBHelper.create();
        this.CharactersToSave = new ConcurrentLinkedQueue();
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = this.conn.getMetaData();
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = databaseMetaData.getColumns(null, null, "networkPlayers", "steamid");
            if (!resultSet.next()) {
                statement.executeUpdate("ALTER TABLE 'networkPlayers' ADD 'steamid' STRING NULL");
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void process() {
        if (!this.CharactersToSave.isEmpty()) {
            NetworkCharacterData networkCharacterData = this.CharactersToSave.poll();
            while (networkCharacterData != null) {
                this.serverUpdateNetworkCharacterInt(networkCharacterData);
                networkCharacterData = this.CharactersToSave.poll();
            }
        }
    }

    public void serverUpdateNetworkCharacter(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.CharactersToSave.add(new NetworkCharacterData(byteBuffer, udpConnection));
    }

    private void serverUpdateNetworkCharacterInt(NetworkCharacterData networkCharacterData) {
        if (networkCharacterData.playerIndex < 0 || networkCharacterData.playerIndex >= 4) {
            return;
        }
        if (this.conn == null) {
            return;
        }
        String string = GameServer.bCoop && SteamUtils.isSteamModeEnabled() ? "SELECT id FROM networkPlayers WHERE steamid=? AND world=? AND playerIndex=?" : "SELECT id FROM networkPlayers WHERE username=? AND world=? AND playerIndex=?";
        String string2 = "INSERT INTO networkPlayers(world,username,steamid, playerIndex,name,x,y,z,worldversion,isDead,data) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
        String string3 = "UPDATE networkPlayers SET x=?, y=?, z=?, worldversion = ?, isDead = ?, data = ?, name = ? WHERE id=?";
        try {
            PreparedStatement preparedStatement;
            block24: {
                preparedStatement = this.conn.prepareStatement(string);
                try {
                    if (GameServer.bCoop && SteamUtils.isSteamModeEnabled()) {
                        preparedStatement.setString(1, networkCharacterData.steamid);
                    } else {
                        preparedStatement.setString(1, networkCharacterData.username);
                    }
                    preparedStatement.setString(2, Core.GameSaveWorld);
                    preparedStatement.setInt(3, networkCharacterData.playerIndex);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block24;
                    int n = resultSet.getInt(1);
                    try (PreparedStatement preparedStatement2 = this.conn.prepareStatement(string3);){
                        preparedStatement2.setFloat(1, networkCharacterData.x);
                        preparedStatement2.setFloat(2, networkCharacterData.y);
                        preparedStatement2.setFloat(3, networkCharacterData.z);
                        preparedStatement2.setInt(4, networkCharacterData.worldVersion);
                        preparedStatement2.setBoolean(5, networkCharacterData.isDead);
                        preparedStatement2.setBytes(6, networkCharacterData.buffer);
                        preparedStatement2.setString(7, networkCharacterData.playerName);
                        preparedStatement2.setInt(8, n);
                        int n2 = preparedStatement2.executeUpdate();
                        this.conn.commit();
                    }
                    return;
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            preparedStatement = this.conn.prepareStatement(string2);
            try {
                preparedStatement.setString(1, Core.GameSaveWorld);
                preparedStatement.setString(2, networkCharacterData.username);
                preparedStatement.setString(3, networkCharacterData.steamid);
                preparedStatement.setInt(4, networkCharacterData.playerIndex);
                preparedStatement.setString(5, networkCharacterData.playerName);
                preparedStatement.setFloat(6, networkCharacterData.x);
                preparedStatement.setFloat(7, networkCharacterData.y);
                preparedStatement.setFloat(8, networkCharacterData.z);
                preparedStatement.setInt(9, networkCharacterData.worldVersion);
                preparedStatement.setBoolean(10, networkCharacterData.isDead);
                preparedStatement.setBytes(11, networkCharacterData.buffer);
                int n = preparedStatement.executeUpdate();
                this.conn.commit();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            PlayerDBHelper.rollback(this.conn);
        }
    }

    private void serverConvertNetworkCharacter(String string, String string2) {
        try {
            String string3 = "UPDATE networkPlayers SET steamid=? WHERE username=? AND world=? AND (steamid is null or steamid = '')";
            try (PreparedStatement preparedStatement = this.conn.prepareStatement(string3);){
                preparedStatement.setString(1, string2);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, Core.GameSaveWorld);
                int n = preparedStatement.executeUpdate();
                if (n > 0) {
                    DebugLog.General.warn("serverConvertNetworkCharacter: The steamid was set for the '" + string + "' for " + n + " players. ");
                }
                this.conn.commit();
            }
        }
        catch (SQLException sQLException) {
            ExceptionLogger.logException(sQLException);
        }
    }

    public void serverLoadNetworkCharacter(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        byte by = byteBuffer.get();
        if (by < 0 || by >= 4) {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.LoadPlayerProfile.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)0);
            byteBufferWriter.putInt(by);
            PacketTypes.PacketType.LoadPlayerProfile.send(udpConnection);
            return;
        }
        if (this.conn == null) {
            return;
        }
        if (GameServer.bCoop && SteamUtils.isSteamModeEnabled()) {
            this.serverConvertNetworkCharacter(udpConnection.username, udpConnection.idStr);
        }
        String string = GameServer.bCoop && SteamUtils.isSteamModeEnabled() ? "SELECT id, x, y, z, data, worldversion, isDead FROM networkPlayers WHERE steamid=? AND world=? AND playerIndex=?" : "SELECT id, x, y, z, data, worldversion, isDead FROM networkPlayers WHERE username=? AND world=? AND playerIndex=?";
        try (PreparedStatement preparedStatement = this.conn.prepareStatement(string);){
            if (GameServer.bCoop && SteamUtils.isSteamModeEnabled()) {
                preparedStatement.setString(1, udpConnection.idStr);
            } else {
                preparedStatement.setString(1, udpConnection.username);
            }
            preparedStatement.setString(2, Core.GameSaveWorld);
            preparedStatement.setInt(3, by);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                float f = resultSet.getFloat(2);
                float f2 = resultSet.getFloat(3);
                float f3 = resultSet.getFloat(4);
                byte[] byArray = resultSet.getBytes(5);
                int n2 = resultSet.getInt(6);
                boolean bl = resultSet.getBoolean(7);
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.LoadPlayerProfile.doPacket(byteBufferWriter);
                byteBufferWriter.putByte((byte)1);
                byteBufferWriter.putInt(by);
                byteBufferWriter.putFloat(f);
                byteBufferWriter.putFloat(f2);
                byteBufferWriter.putFloat(f3);
                byteBufferWriter.putInt(n2);
                byteBufferWriter.putByte((byte)(bl ? 1 : 0));
                byteBufferWriter.putInt(byArray.length);
                byteBufferWriter.bb.put(byArray);
                PacketTypes.PacketType.LoadPlayerProfile.send(udpConnection);
            } else {
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.LoadPlayerProfile.doPacket(byteBufferWriter);
                byteBufferWriter.putByte((byte)0);
                byteBufferWriter.putInt(by);
                PacketTypes.PacketType.LoadPlayerProfile.send(udpConnection);
            }
        }
        catch (SQLException sQLException) {
            ExceptionLogger.logException(sQLException);
        }
    }

    private static final class NetworkCharacterData {
        byte[] buffer;
        String username;
        String steamid;
        int playerIndex;
        String playerName;
        float x;
        float y;
        float z;
        boolean isDead;
        int worldVersion;

        public NetworkCharacterData(ByteBuffer byteBuffer, UdpConnection udpConnection) {
            this.playerIndex = byteBuffer.get();
            this.playerName = GameWindow.ReadStringUTF(byteBuffer);
            this.x = byteBuffer.getFloat();
            this.y = byteBuffer.getFloat();
            this.z = byteBuffer.getFloat();
            this.isDead = byteBuffer.get() == 1;
            this.worldVersion = byteBuffer.getInt();
            int n = byteBuffer.getInt();
            this.buffer = new byte[n];
            byteBuffer.get(this.buffer);
            this.steamid = GameServer.bCoop && SteamUtils.isSteamModeEnabled() ? udpConnection.idStr : "";
            this.username = udpConnection.username;
        }
    }
}

