/*
 * Decompiled with CFR 0.152.
 */
package zombie.savefile;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.util.glu.GLU;
import zombie.IndieGL;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.RenderSettings;
import zombie.core.sprite.SpriteRenderState;
import zombie.core.textures.MultiTextureFBO2;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.core.textures.TextureFBO;
import zombie.interfaces.ITexture;
import zombie.iso.IsoCamera;
import zombie.iso.IsoWorld;
import zombie.iso.PlayerCamera;
import zombie.iso.sprite.IsoSprite;
import zombie.ui.UIManager;

public final class SavefileThumbnail {
    private static final int WIDTH = 256;
    private static final int HEIGHT = 256;

    public static void create() {
        int n = -1;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            if (IsoPlayer.players[i] == null) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return;
        }
        SavefileThumbnail.create(n);
    }

    public static void create(int n) {
        Core core = Core.getInstance();
        MultiTextureFBO2 multiTextureFBO2 = core.OffscreenBuffer;
        float f = multiTextureFBO2.zoom[n];
        float f2 = multiTextureFBO2.targetZoom[n];
        SavefileThumbnail.setZoom(n, 1.0f, 1.0f);
        IsoCamera.cameras[n].center();
        SavefileThumbnail.renderWorld(n, true, true);
        SpriteRenderer.instance.drawGeneric(new TakeScreenShotDrawer(n));
        SavefileThumbnail.setZoom(n, f, f2);
        IsoCamera.cameras[n].center();
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null) continue;
            SavefileThumbnail.renderWorld(i, false, i == n);
        }
        core.RenderOffScreenBuffer();
        if (core.StartFrameUI()) {
            UIManager.render();
        }
        core.EndFrameUI();
    }

    private static void renderWorld(int n, boolean bl, boolean bl2) {
        IsoPlayer.setInstance(IsoPlayer.players[n]);
        IsoCamera.CamCharacter = IsoPlayer.players[n];
        IsoSprite.globalOffsetX = -1.0f;
        Core.getInstance().StartFrame(n, bl);
        if (bl2) {
            SpriteRenderer.instance.drawGeneric(new FixCameraDrawer(n));
        }
        IsoCamera.frameState.set(n);
        IndieGL.glDisable(2929);
        IsoWorld.instance.render();
        RenderSettings.getInstance().legacyPostRender(n);
        Core.getInstance().EndFrame(n);
    }

    private static void setZoom(int n, float f, float f2) {
        Core.getInstance().OffscreenBuffer.zoom[n] = f;
        Core.getInstance().OffscreenBuffer.targetZoom[n] = f2;
        IsoCamera.cameras[n].zoom = f;
        IsoCamera.cameras[n].OffscreenWidth = IsoCamera.getOffscreenWidth(n);
        IsoCamera.cameras[n].OffscreenHeight = IsoCamera.getOffscreenHeight(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createWithRenderShader(int n) {
        int n2 = 256;
        int n3 = 256;
        Texture texture = new Texture(n2, n3, 16);
        TextureFBO textureFBO = new TextureFBO(texture, false);
        GL11.glPushAttrib((int)1048575);
        try {
            textureFBO.startDrawing(true, false);
            GL11.glViewport((int)0, (int)0, (int)n2, (int)n3);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GLU.gluOrtho2D((float)0.0f, (float)n2, (float)n3, (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            Core core = Core.getInstance();
            core.RenderShader.Start();
            GL11.glDisable((int)3089);
            GL11.glDisable((int)2960);
            GL11.glDisable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2884);
            for (int i = 8; i > 1; --i) {
                GL13.glActiveTexture((int)(33984 + i - 1));
                GL11.glDisable((int)3553);
            }
            GL13.glActiveTexture((int)33984);
            GL11.glEnable((int)3553);
            ITexture iTexture = core.getOffscreenBuffer().getTexture();
            iTexture.bind();
            int n4 = IsoCamera.getScreenLeft(n) + IsoCamera.getScreenWidth(n) / 2 - n2 / 2;
            int n5 = IsoCamera.getScreenTop(n) + IsoCamera.getScreenHeight(n) / 2 - n3 / 2;
            int n6 = core.getOffscreenBuffer().getTexture().getWidthHW();
            int n7 = core.getOffscreenBuffer().getTexture().getHeightHW();
            float f = (float)n4 / (float)n6;
            float f2 = (float)(n4 + n2) / (float)n6;
            float f3 = (float)n5 / (float)n7;
            float f4 = (float)(n5 + n3) / (float)n7;
            GL11.glBegin((int)7);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTexCoord2f((float)f, (float)f4);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glTexCoord2f((float)f, (float)f3);
            GL11.glVertex2d((double)0.0, (double)n3);
            GL11.glTexCoord2f((float)f2, (float)f3);
            GL11.glVertex2d((double)n2, (double)n3);
            GL11.glTexCoord2f((float)f2, (float)f4);
            GL11.glVertex2d((double)n2, (double)0.0);
            GL11.glEnd();
            core.RenderShader.End();
            core.TakeScreenshot(0, 0, n2, n3, TextureFBO.getFuncs().GL_COLOR_ATTACHMENT0());
            textureFBO.endDrawing();
        }
        finally {
            textureFBO.destroy();
            GL11.glPopAttrib();
        }
    }

    private static final class TakeScreenShotDrawer
    extends TextureDraw.GenericDrawer {
        int m_playerIndex;

        TakeScreenShotDrawer(int n) {
            this.m_playerIndex = n;
        }

        @Override
        public void render() {
            Core core = Core.getInstance();
            MultiTextureFBO2 multiTextureFBO2 = core.OffscreenBuffer;
            if (multiTextureFBO2.Current == null) {
                Core.getInstance().TakeScreenshot(256, 256, 1029);
                return;
            }
            if (core.RenderShader == null) {
                Core.getInstance().getOffscreenBuffer().startDrawing(false, false);
                Core.getInstance().TakeScreenshot(256, 256, TextureFBO.getFuncs().GL_COLOR_ATTACHMENT0());
                Core.getInstance().getOffscreenBuffer().endDrawing();
                return;
            }
            SavefileThumbnail.createWithRenderShader(this.m_playerIndex);
        }
    }

    private static final class FixCameraDrawer
    extends TextureDraw.GenericDrawer {
        int m_playerIndex;
        float m_zoom;
        int m_offscreenWidth;
        int m_offscreenHeight;

        FixCameraDrawer(int n) {
            PlayerCamera playerCamera = IsoCamera.cameras[n];
            this.m_playerIndex = n;
            this.m_zoom = playerCamera.zoom;
            this.m_offscreenWidth = playerCamera.OffscreenWidth;
            this.m_offscreenHeight = playerCamera.OffscreenHeight;
        }

        @Override
        public void render() {
            SpriteRenderState spriteRenderState = SpriteRenderer.instance.getRenderingState();
            spriteRenderState.playerCamera[this.m_playerIndex].zoom = this.m_zoom;
            spriteRenderState.playerCamera[this.m_playerIndex].OffscreenWidth = this.m_offscreenWidth;
            spriteRenderState.playerCamera[this.m_playerIndex].OffscreenHeight = this.m_offscreenHeight;
            spriteRenderState.zoomLevel[this.m_playerIndex] = this.m_zoom;
        }
    }
}

