/*
 * Decompiled with CFR 0.152.
 */
package zombie.sandbox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import zombie.SandboxOptions;
import zombie.ZomboidFileSystem;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.gameStates.ChooseGameInfo;
import zombie.sandbox.CustomBooleanSandboxOption;
import zombie.sandbox.CustomDoubleSandboxOption;
import zombie.sandbox.CustomEnumSandboxOption;
import zombie.sandbox.CustomIntegerSandboxOption;
import zombie.sandbox.CustomSandboxOption;
import zombie.sandbox.CustomStringSandboxOption;
import zombie.scripting.ScriptParser;
import zombie.util.StringUtils;

public final class CustomSandboxOptions {
    private static final int VERSION1 = 1;
    private static final int VERSION = 1;
    public static final CustomSandboxOptions instance = new CustomSandboxOptions();
    private final ArrayList<CustomSandboxOption> m_options = new ArrayList();

    public void init() {
        ArrayList<String> arrayList = ZomboidFileSystem.instance.getModIDs();
        for (int i = 0; i < arrayList.size(); ++i) {
            File file;
            String string = arrayList.get(i);
            ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
            if (mod == null || !(file = new File(mod.getDir() + File.separator + "media" + File.separator + "sandbox-options.txt")).exists() || file.isDirectory()) continue;
            this.readFile(file.getAbsolutePath());
        }
    }

    public static void Reset() {
        CustomSandboxOptions.instance.m_options.clear();
    }

    public void initInstance(SandboxOptions sandboxOptions) {
        for (int i = 0; i < this.m_options.size(); ++i) {
            CustomSandboxOption customSandboxOption = this.m_options.get(i);
            sandboxOptions.newCustomOption(customSandboxOption);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean readFile(String string) {
        try (FileReader fileReader = new FileReader(string);){
            boolean bl;
            try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuilder.append(string2);
                    string2 = bufferedReader.readLine();
                }
                this.parse(stringBuilder.toString());
                bl = true;
            }
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return false;
        }
    }

    private void parse(String string) {
        string = ScriptParser.stripComments(string);
        ScriptParser.Block block = ScriptParser.parse(string);
        int n = -1;
        ScriptParser.Value value = block.getValue("VERSION");
        if (value != null) {
            n = PZMath.tryParseInt(value.getValue(), -1);
        }
        if (n < 1 || n > 1) {
            throw new RuntimeException("invalid or missing VERSION");
        }
        for (ScriptParser.Block block2 : block.children) {
            if (!block2.type.equalsIgnoreCase("option")) {
                throw new RuntimeException("unknown block type \"" + block2.type + "\"");
            }
            CustomSandboxOption customSandboxOption = this.parseOption(block2);
            if (customSandboxOption == null) {
                DebugLog.General.warn("failed to parse custom sandbox option \"%s\"", block2.id);
                continue;
            }
            this.m_options.add(customSandboxOption);
        }
    }

    private CustomSandboxOption parseOption(ScriptParser.Block block) {
        if (StringUtils.isNullOrWhitespace(block.id)) {
            DebugLog.General.warn("missing or empty option id");
            return null;
        }
        ScriptParser.Value value = block.getValue("type");
        if (value == null || StringUtils.isNullOrWhitespace(value.getValue())) {
            DebugLog.General.warn("missing or empty value \"type\"");
            return null;
        }
        switch (value.getValue().trim()) {
            case "boolean": {
                return CustomBooleanSandboxOption.parse(block);
            }
            case "double": {
                return CustomDoubleSandboxOption.parse(block);
            }
            case "enum": {
                return CustomEnumSandboxOption.parse(block);
            }
            case "integer": {
                return CustomIntegerSandboxOption.parse(block);
            }
            case "string": {
                return CustomStringSandboxOption.parse(block);
            }
        }
        DebugLog.General.warn("unknown option type \"%s\"", value.getValue().trim());
        return null;
    }
}

